/* French initialisation for the jQuery UI date picker plugin. */
/* Written by Keith Wood (kbwood{at}iinet.com.au),
			  Stéphane Nahmani (sholby@sholby.net),
			  Stéphane Raimbault <stephane.raimbault@gmail.com> */
jQuery(function($){
	$.datepicker.regional['cs'] = {
		closeText: "Zavřít",
		prevText: "&#x3C;Dříve",
		nextText: "Později&#x3E;",
		currentText: "Nyní",
		monthNames: [ "leden","únor","březen","duben","květen","červen",
			"červenec","srpen","září","říjen","listopad","prosinec" ],
		monthNamesShort: [ "led","úno","bře","dub","kvě","čer",
			"čvc","srp","zář","říj","lis","pro" ],
		dayNames: [ "neděle", "pondělí", "úterý", "středa", "čtvrtek", "pátek", "sobota" ],
		dayNamesShort: [ "ne", "po", "út", "st", "čt", "pá", "so" ],
		dayNamesMin: [ "ne","po","út","st","čt","pá","so" ],
		weekHeader: "Týd",
		dateFormat: "dd.mm.yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['de'] = {
		closeText: "Schließen",
		prevText: "&#x3C;Zurück",
		nextText: "Vor&#x3E;",
		currentText: "Heute",
		monthNames: ["Januar", "Februar", "März", "April", "Mai", "Juni",
			"Juli", "August", "September", "Oktober", "November", "Dezember"],
		monthNamesShort: ["Jan", "Feb", "Mär", "Apr", "Mai", "Jun",
			"Jul", "Aug", "Sep", "Okt", "Nov", "Dez"],
		dayNames: ["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"],
		dayNamesShort: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
		dayNamesMin: ["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"],
		weekHeader: "KW",
		dateFormat: "dd.mm.yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ""
	};
	$.datepicker.regional['el'] = {
		closeText: "Κλείσιμο",
		prevText: "Προηγούμενος",
		nextText: "Επόμενος",
		currentText: "Σήμερα",
		monthNames: [ "Ιανουάριος","Φεβρουάριος","Μάρτιος","Απρίλιος","Μάιος","Ιούνιος",
			"Ιούλιος","Αύγουστος","Σεπτέμβριος","Οκτώβριος","Νοέμβριος","Δεκέμβριος" ],
		monthNamesShort: [ "Ιαν","Φεβ","Μαρ","Απρ","Μαι","Ιουν",
			"Ιουλ","Αυγ","Σεπ","Οκτ","Νοε","Δεκ" ],
		dayNames: [ "Κυριακή","Δευτέρα","Τρίτη","Τετάρτη","Πέμπτη","Παρασκευή","Σάββατο" ],
		dayNamesShort: [ "Κυρ","Δευ","Τρι","Τετ","Πεμ","Παρ","Σαβ" ],
		dayNamesMin: [ "Κυ","Δε","Τρ","Τε","Πε","Πα","Σα" ],
		weekHeader: "Εβδ",
		dateFormat: "dd/mm/yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ""
	};
	$.datepicker.regional['en'] = {
		closeText: "Done",
		prevText: "Prev",
		nextText: "Next",
		currentText: "Today",
		monthNames: [ "January","February","March","April","May","June",
			"July","August","September","October","November","December" ],
		monthNamesShort: [ "Jan", "Feb", "Mar", "Apr", "May", "Jun",
			"Jul", "Aug", "Sep", "Oct", "Nov", "Dec" ],
		dayNames: [ "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" ],
		dayNamesShort: [ "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" ],
		dayNamesMin: [ "Su","Mo","Tu","We","Th","Fr","Sa" ],
		weekHeader: "Wk",
		dateFormat: "dd/mm/yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['es'] = {
		closeText: "Cerrar",
		prevText: "&#x3C;Ant",
		nextText: "Sig&#x3E;",
		currentText: "Hoy",
		monthNames: [ "enero","febrero","marzo","abril","mayo","junio",
			"julio","agosto","septiembre","octubre","noviembre","diciembre" ],
		monthNamesShort: [ "ene","feb","mar","abr","may","jun",
			"jul","ago","sep","oct","nov","dic" ],
		dayNames: [ "domingo","lunes","martes","miércoles","jueves","viernes","sábado" ],
		dayNamesShort: [ "dom","lun","mar","mié","jue","vie","sáb" ],
		dayNamesMin: [ "D","L","M","X","J","V","S" ],
		weekHeader: "Sm",
		dateFormat: "dd/mm/yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['fr'] = {
		closeText: 'Fermer',
		prevText: 'Précédent',
		nextText: 'Suivant',
		currentText: 'Aujourd\'hui',
		monthNames: ['janvier', 'février', 'mars', 'avril', 'mai', 'juin',
			'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre'],
		monthNamesShort: ['janv.', 'févr.', 'mars', 'avril', 'mai', 'juin',
			'juil.', 'août', 'sept.', 'oct.', 'nov.', 'déc.'],
		dayNames: ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi'],
		dayNamesShort: ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
		dayNamesMin: ['D','L','M','M','J','V','S'],
		weekHeader: 'Sem.',
		dateFormat: 'dd/mm/yy',
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['it'] = {
		closeText: "Chiudi",
		prevText: "&#x3C;Prec",
		nextText: "Succ&#x3E;",
		currentText: "Oggi",
		monthNames: [ "Gennaio","Febbraio","Marzo","Aprile","Maggio","Giugno",
			"Luglio","Agosto","Settembre","Ottobre","Novembre","Dicembre" ],
		monthNamesShort: [ "Gen","Feb","Mar","Apr","Mag","Giu",
			"Lug","Ago","Set","Ott","Nov","Dic" ],
		dayNames: [ "Domenica","Lunedì","Martedì","Mercoledì","Giovedì","Venerdì","Sabato" ],
		dayNamesShort: [ "Dom","Lun","Mar","Mer","Gio","Ven","Sab" ],
		dayNamesMin: [ "Do","Lu","Ma","Me","Gi","Ve","Sa" ],
		weekHeader: "Sm",
		dateFormat: "dd/mm/yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['pt'] = {
		closeText: "Fechar",
		prevText: "Anterior",
		nextText: "Seguinte",
		currentText: "Hoje",
		monthNames: [ "Janeiro","Fevereiro","Março","Abril","Maio","Junho",
			"Julho","Agosto","Setembro","Outubro","Novembro","Dezembro" ],
		monthNamesShort: [ "Jan","Fev","Mar","Abr","Mai","Jun",
			"Jul","Ago","Set","Out","Nov","Dez" ],
		dayNames: [
			"Domingo",
			"Segunda-feira",
			"Terça-feira",
			"Quarta-feira",
			"Quinta-feira",
			"Sexta-feira",
			"Sábado"
		],
		dayNamesShort: [ "Dom","Seg","Ter","Qua","Qui","Sex","Sáb" ],
		dayNamesMin: [ "Dom","Seg","Ter","Qua","Qui","Sex","Sáb" ],
		weekHeader: "Sem",
		dateFormat: "dd/mm/yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['ru'] = {
		closeText: "Закрыть",
		prevText: "&#x3C;Пред",
		nextText: "След&#x3E;",
		currentText: "Сегодня",
		monthNames: [ "Январь","Февраль","Март","Апрель","Май","Июнь",
			"Июль","Август","Сентябрь","Октябрь","Ноябрь","Декабрь" ],
		monthNamesShort: [ "Янв","Фев","Мар","Апр","Май","Июн",
			"Июл","Авг","Сен","Окт","Ноя","Дек" ],
		dayNames: [ "воскресенье","понедельник","вторник","среда","четверг","пятница","суббота" ],
		dayNamesShort: [ "вск","пнд","втр","срд","чтв","птн","сбт" ],
		dayNamesMin: [ "Вс","Пн","Вт","Ср","Чт","Пт","Сб" ],
		weekHeader: "Нед",
		dateFormat: "dd.mm.yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['sk'] = {
		closeText: "Zavrieť",
		prevText: "&#x3C;Predchádzajúci",
		nextText: "Nasledujúci&#x3E;",
		currentText: "Dnes",
		monthNames: [ "január","február","marec","apríl","máj","jún",
			"júl","august","september","október","november","december" ],
		monthNamesShort: [ "Jan","Feb","Mar","Apr","Máj","Jún",
			"Júl","Aug","Sep","Okt","Nov","Dec" ],
		dayNames: [ "nedeľa","pondelok","utorok","streda","štvrtok","piatok","sobota" ],
		dayNamesShort: [ "Ned","Pon","Uto","Str","Štv","Pia","Sob" ],
		dayNamesMin: [ "Ne","Po","Ut","St","Št","Pia","So" ],
		weekHeader: "Ty",
		dateFormat: "dd.mm.yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};
	$.datepicker.regional['sl'] = {
		closeText: "Zapri",
		prevText: "&#x3C;Prejšnji",
		nextText: "Naslednji&#x3E;",
		currentText: "Trenutni",
		monthNames: [ "Januar","Februar","Marec","April","Maj","Junij",
			"Julij","Avgust","September","Oktober","November","December" ],
		monthNamesShort: [ "Jan","Feb","Mar","Apr","Maj","Jun",
			"Jul","Avg","Sep","Okt","Nov","Dec" ],
		dayNames: [ "Nedelja","Ponedeljek","Torek","Sreda","Četrtek","Petek","Sobota" ],
		dayNamesShort: [ "Ned","Pon","Tor","Sre","Čet","Pet","Sob" ],
		dayNamesMin: [ "Ne","Po","To","Sr","Če","Pe","So" ],
		weekHeader: "Teden",
		dateFormat: "dd.mm.yy",
		firstDay: 1,
		isRTL: false,
		showMonthAfterYear: false,
		yearSuffix: ''
	};

	$.datepicker.setDefaults($.datepicker.regional['fr']);
});
