<?php

/**

 * 2007-2018 KU

 *

 * NOTICE OF LICENSE

 *

 * This source file is subject to the Academic Free License (AFL 3.0)

 * that is bundled with this package in the file LICENSE.txt.

 * It is also available through the world-wide-web at this URL:

 * http://opensource.org/licenses/afl-3.0.php

 * If you did not receive a copy of the license and are unable to

 * obtain it through the world-wide-web, please send an email

 * to license@prestashop.com so we can send you a copy immediately.

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer

 * versions in the future. If you wish to customize PrestaShop for your

 * needs please refer to http://www.prestashop.com for more information.

 *

 *  @author    Kevin UNFRICHT <contact@kevin-unfricht.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 *  International Registered Trademark & Property of PrestaShop SA

 */



require_once(dirname(__FILE__).'/../../autoload.php');



class AdminGTRMController extends AzcodeModuleAdminController

{

    public function __construct()

    {

        $this->type_context = Shop::getContext();

        $this->old_context = Context::getContext();

        $this->multishop_context = Shop::CONTEXT_ALL;

        $this->context = Context::getContext();

        $this->bootstrap = true;



        parent::__construct();

    }



    public function initContent()

    {

        $this->initTabModuleList();

        $this->initToolbar();

        $this->initPageHeaderToolbar();



        $this->content .= $this->renderForm();



        $this->context->smarty->assign(array(

            'content' => $this->content,

            'url_post' => self::$currentIndex.'&token='.$this->token,

            'show_page_header_toolbar' => $this->show_page_header_toolbar,

            'page_header_toolbar_title' => $this->page_header_toolbar_title,

            'page_header_toolbar_btn' => $this->page_header_toolbar_btn

        ));

    }



    public function initPageHeaderToolbar()

    {

        parent::initPageHeaderToolbar();

        $this->page_header_toolbar_btn['sample'] = array(

            'href' => $this->module->getPathUri().'files/sample_export.csv',

            'desc' => $this->l('Download a sample CSV file'),

            'icon' => 'process-icon-file'

        );

    }



    public function setMedia($isNewTheme = false)

    {

        parent::setMedia($isNewTheme);

        

        $this->addJS(_PS_MODULE_DIR_.'gtrmanager/views/js/papaparse.min.js');

        $this->addJS(_PS_MODULE_DIR_.'gtrmanager/views/js/back.js');

        $this->addCss(_PS_MODULE_DIR_.'gtrmanager/views/css/back.css');

    }



    public function postProcess()

    {

        if (Tools::isSubmit('submitExport')) {

            $this->processExportGrid();

        }



        if (Tools::isSubmit('submitImport')) {

            $this->processImportGrid();

        }



        if (Tools::isSubmit('submitBackup')) {

            $this->processBackup();

        }

    }



    public function renderForm()

    {

        $this->override_folder = true;

        $this->multiple_fieldsets = true;

        $carriers = Carrier::getCarriers(Context::getContext()->language->id, true, false, false, null, Carrier::ALL_CARRIERS);

        $this->tpl_form_vars['carriers_backup'] = array();

        foreach ($carriers as $carrier) {

            $this->tpl_form_vars['carriers_backup'][$carrier['id_reference']] = CarrierGTRM::getCarrierBackups((int)$carrier['id_reference']);

        }



        $this->tpl_form_vars['date_format'] = $this->context->language->date_format_full;



        // Import

        $this->fields_form[] = array(

            'form' => array(

                'legend' => array(

                    'title' => $this->l('Import a grid'),

                    'icon' => 'icon-download'

                ),

                'input' => array(

                    array(

                        'type' => 'file',

                        'col' => 6,

                        'label' => $this->l('CSV file to import'),

                        'name' => 'import',

                    ),

                    array(

                        'type' => 'select',

                        'label' => $this->l('Carrier concerned by the import'),

                        'name' => 'id_carrier',

                        'options' => array(

                            'query' => $carriers,

                            'id' => 'id_reference',

                            'name' => 'name'

                        )

                    ),

                    array(

                        'type' => 'select',

                        'label' => $this->l('Billing'),

                        'desc' => array(

                            $this->l('By default, the billing will be automatically selected based on what will be configured on the selected carrier'),

                        ),

                        'name' => 'shipping_method',

                        'options' => array(

                            'query' => array(

                                0 => array(

                                    'id' => Carrier::SHIPPING_METHOD_DEFAULT,

                                    'name' => $this->l('Automatic')

                                ),

                                1 => array(

                                    'id' => Carrier::SHIPPING_METHOD_PRICE,

                                    'name' => $this->l('Depending on the total price')

                                ),

                                2 => array(

                                    'id' => Carrier::SHIPPING_METHOD_WEIGHT,

                                    'name' => $this->l('Depending on the total weight')

                                )

                            ),

                            'id' => 'id',

                            'name' => 'name'

                        )

                    ),

                    array(

                        'type' => 'hidden',

                        'name' => 'data_import'

                    )

                ),

                'submit' => array(

                    'title' => $this->l('Import'),

                    'icon' => 'process-icon-download',

                    'name' => 'submitImport'

                )

            ),

        );

        // Export

        $this->fields_form[] = array(

            'form' => array(

                'legend' => array(

                    'title' => $this->l('Export a grid'),

                    'icon' => 'icon-upload'

                ),

                'input' => array(

                    array(

                        'type' => 'select',

                        'label' => $this->l('Carrier to export'),

                        'name' => 'id_carrier_export',

                        'options' => array(

                            'query' => $carriers,

                            'id' => 'id_reference',

                            'name' => 'name'

                        )

                    ),

                ),

                'submit' => array(

                    'title' => $this->l('Export'),

                    'icon' => 'process-icon-upload',

                    'name' => 'submitExport'

                )

            )

        );

        // Backup

        $this->fields_form[] = array(

            'form' => array(

                'legend' => array(

                    'title' => $this->l('Load a backup'),

                    'icon' => 'icon-save'

                ),

                'input' => array(

                    array(

                        'type' => 'select',

                        'label' => $this->l('Carrier to load'),

                        'name' => 'id_carrier_backup',

                        'options' => array(

                            'query' => $carriers,

                            'id' => 'id_reference',

                            'name' => 'name'

                        )

                    ),

                ),

                'submit' => array(

                    'title' => $this->l('Load backup'),

                    'icon' => 'process-icon-export',

                    'name' => 'submitBackup'

                )

            )

        );



        return parent::renderForm();

    }



    public function processBackup()

    {

        $backups = Tools::getValue('id_carrier_to_backup');

        $id_reference = (int)Tools::getValue('id_carrier_backup');



        if (empty($backups[$id_reference])) {

            return;

        }



        $carrier_to_backup = new CarrierCore((int)$backups[$id_reference]);



        if (!Validate::isLoadedObject($carrier_to_backup)) {

            return;

        }



        $current_carrier = Carrier::getCarrierByReference((int)$carrier_to_backup->id_reference);

        $current_carrier->deleted = true;

        $current_carrier->update();



        $carrier_to_backup->deleted = false;

        $carrier_to_backup->update();



        //Copy default carrier

        if (Configuration::get('PS_CARRIER_DEFAULT') == $current_carrier->id) {

            Configuration::updateValue('PS_CARRIER_DEFAULT', (int)$carrier_to_backup->id);

        }



        $this->confirmations[] = sprintf($this->l('%s grid has been successfully loaded !'), $carrier_to_backup->name);

    }



    public function processImportGrid()

    {

        $current_carrier = Carrier::getCarrierByReference((int)Tools::getValue('id_carrier'));

        if (!Validate::isLoadedObject($current_carrier)) {

            $this->errors[] = $this->l('Carrier is invalid.');

            return;

        }



        if (!$data_import = Tools::getValue('data_import')) {

            $this->errors[] = $this->l('Please upload a CSV file.');

            return;

        }



        $importer = new Importer(Tools::jsonDecode($data_import, true));



        if (!$importer->isValid()) {

            $this->errors[] = $this->l('CSV file is invalid. Check example below.');

            return;

        }



        /**

         * DUPLICATE CARRIER

         */

        $carrier = $current_carrier->duplicateObject();

        if (Validate::isLoadedObject($carrier)) {

            // Set flag deteled to true for historization

            $current_carrier->deleted = true;

            $current_carrier->update();



            // Fill the new carrier object

            $id_tax_group = Carrier::getIdTaxRulesGroupByIdCarrier((int)$current_carrier->id);

            if (Validate::isUnsignedInt($id_tax_group)) {

                $carrier->setTaxRulesGroup($id_tax_group);

            }

            $carrier->position = $current_carrier->position;

            $carrier->is_free = 0;

            $carrier->update();



            $this->updateAssoShop((int)$carrier->id);

            $this->duplicateLogo((int)$carrier->id, (int)$current_carrier->id);

            $this->changeGroups($carrier, $current_carrier->getGroups());



            //Copy default carrier

            if (Configuration::get('PS_CARRIER_DEFAULT') == $current_carrier->id) {

                Configuration::updateValue('PS_CARRIER_DEFAULT', (int)$carrier->id);

            }



            // Call of hooks

            Hook::exec('actionCarrierUpdate', array(

                'id_carrier' => (int)$current_carrier->id,

                'carrier' => $carrier

            ));



            /**

             * UPLOAD DATAS

             */

            if (!$this->changeZones($carrier, $importer)) {

                $this->errors[] = $this->l('An error occurred while saving carrier zones.');

            }



            if (!$this->processRanges($carrier, $importer)) {

                $this->errors[] = $this->l('An error occurred while saving carrier ranges.');

            }

        }



        if (!count($this->errors)) {

            // Update date_import

            $carrierGTRM = new CarrierGTRM((int)$carrier->id);

            $carrierGTRM->date_import = Date('Y-m-d H:i:s');

            $carrierGTRM->update();

            // Confirmation

            $this->confirmations[] = sprintf($this->l('%s grid has been successfully imported !'), $carrier->name);

        }

    }



    /**

     * Copy of duplicateLogo method

     * @see AdminCarrierWizardControllerCore

     */

    protected function duplicateLogo($new_id, $old_id)

    {

        $old_logo = _PS_SHIP_IMG_DIR_.'/'.(int)$old_id.'.jpg';

        if (file_exists($old_logo)) {

            copy($old_logo, _PS_SHIP_IMG_DIR_.'/'.(int)$new_id.'.jpg');

        }



        $old_tmp_logo = _PS_TMP_IMG_DIR_.'/carrier_mini_'.(int)$old_id.'.jpg';

        if (file_exists($old_tmp_logo)) {

            if (!isset($_FILES['logo'])) {

                copy($old_tmp_logo, _PS_TMP_IMG_DIR_.'/carrier_mini_'.$new_id.'.jpg');

            }

            unlink($old_tmp_logo);

        }

    }



    protected function changeGroups(Carrier $carrier, $current_groups)

    {

        if (!Validate::isLoadedObject($carrier)) {

            return false;

        }



        $groups = array();

        foreach ($current_groups as $group) {

            $groups[] = $group['id_group'];

        }



        return $carrier->setGroups($groups);

    }



    protected function changeZones(Carrier $carrier, Importer $importer)

    {

        if (!Validate::isLoadedObject($carrier)) {

            return false;

        }



        $return = true;



        foreach (array_keys($importer->getZones()) as $zone_name) {

            $zone = new Zone(Zone::getIdByName($zone_name));

            if (!Validate::isLoadedObject($zone)) {

                $zone->name = $zone_name;

                $zone->save();

            }



            $return &= $carrier->addZone((int)$zone->id);

        }



        return $return;

    }



    protected function processRanges(Carrier $carrier, Importer $importer)

    {

        if (!Validate::isLoadedObject($carrier)) {

            return false;

        }



        $return = true;



        $delimiters = $importer->getDelimiters();

        $zones = $importer->getZones();

        if (!$range_type = Tools::getValue('shipping_method')) {

            $range_type = $carrier->shipping_method;

        }



        foreach ($delimiters as $key => $delimiter) {

            /* RANGE */

            $range = $carrier->getRangeObject();

            $range->id_carrier = (int)$carrier->id;

            $range->delimiter1 = (float)$delimiter['delimiter1'];

            $range->delimiter2 = (float)$delimiter['delimiter2'];

            $range->save();

            /* PRICE LIST */

            $price_list = array();

            foreach ($zones as $zone_name => $data) {

                $zone = new Zone(Zone::getIdByName($zone_name));

                $price_list[] = array(

                    'id_range_price' => ((int)$range_type === Carrier::SHIPPING_METHOD_PRICE ? (int)$range->id : null),

                    'id_range_weight' => ((int)$range_type === Carrier::SHIPPING_METHOD_WEIGHT ? (int)$range->id : null),

                    'id_carrier' => (int)$carrier->id,

                    'id_zone' => (int)$zone->id,

                    'price' => isset($data[$key]) ? (float)$data[$key] : 0

                );

            }



            /* SAVE DELIVERY PRICE */

            $return &= (count($price_list) && $carrier->addDeliveryPrice($price_list, true));

        }

        return $return;

    }



    public function processExportGrid()

    {

        $carrier = !Tools::getValue('id_carrier_backup_export') ?

            Carrier::getCarrierByReference((int)Tools::getValue('id_carrier_export')) :

            new Carrier((int)Tools::getValue('id_carrier_backup_export'));



        if (Validate::isLoadedObject($carrier) && !$carrier->is_free) {

            $ranges_datas = $this->getRangesVars($carrier);

            $csv = new ParseCSV();

            $csv->output_delimiter = ';';

            $csv->encoding('UTF-8');

            $csv->output('export-'.$carrier->name.'-'.date('Ymd').'.csv', $this->convertRangesDatasToArray($ranges_datas));

        }



        $this->errors[] = $this->l('This carrier is not valid to export. Try again.');

    }



    /**

     * Part of code copied from getTplRangesVarsAndValues

     * @see AdminCarrierWizardControllerCore

     * @param Carrier $carrier

     * @return Array $export_vars

     */

    protected function getRangesVars(Carrier $carrier)

    {

        $export_vars = array('zones' => array());

        switch ($carrier->shipping_method) {

            case Carrier::SHIPPING_METHOD_PRICE:

                $export_vars['shipping_method'] = $this->l('price');

                break;

            default:

                $export_vars['shipping_method'] = $this->l('weight');

                break;

        }

        $carrier_zones = $carrier->getZones();

        $carrier_zones_ids = array();

        if (is_array($carrier_zones)) {

            foreach ($carrier_zones as $carrier_zone) {

                $carrier_zones_ids[] = $carrier_zone['id_zone'];

            }

        }



        $range_table = $carrier->getRangeTable();

        $shipping_method = $carrier->getShippingMethod();



        $zones = Zone::getZones(false);

        foreach ($zones as $zone) {

            if (Tools::getValue('zone_'.$zone['id_zone'], (in_array($zone['id_zone'], $carrier_zones_ids)))) {

                $export_vars['zones'][] = $zone;

            }

        }



        if ($shipping_method == Carrier::SHIPPING_METHOD_FREE) {

            $range_obj = $carrier->getRangeObject($carrier->shipping_method);

            $price_by_range = array();

        } else {

            $range_obj = $carrier->getRangeObject();

            $price_by_range = Carrier::getDeliveryPriceByRanges($range_table, (int)$carrier->id);

        }



        $export_vars['price_by_range'] = array();

        foreach ($price_by_range as $price) {

            $export_vars['price_by_range'][$price['id_'.$range_table]][$price['id_zone']] = $price['price'];

        }



        $tmp_range = $range_obj->getRanges((int)$carrier->id);

        $export_vars['ranges'] = array();

        if ($shipping_method != Carrier::SHIPPING_METHOD_FREE) {

            foreach ($tmp_range as $range) {

                $export_vars['ranges'][$range['id_'.$range_table]] = $range;

                $export_vars['ranges'][$range['id_'.$range_table]]['id_range'] = $range['id_'.$range_table];

            }

        }



        // init blank range

        if (!count($export_vars['ranges'])) {

            $export_vars['ranges'][] = array('id_range' => 0, 'delimiter1' => 0, 'delimiter2' => 0);

        }



        return $export_vars;

    }



    protected function convertRangesDatasToArray($ranges_datas)

    {

        // Initialisation

        $datas = array(

            0 => array(0 => '', 1 => sprintf($this->l('Will be applied when the %s is'), $ranges_datas['shipping_method']).' >='),

            1 => array(0 => $this->l('Zone'), 1 => sprintf($this->l('Will be applied when the %s is'), $ranges_datas['shipping_method']).' <')

        );

        // 1st line

        foreach ($ranges_datas['ranges'] as $range) {

            $datas[0][] = $range['delimiter1'];

            $datas[1][] = $range['delimiter2'];

        }

        // Per zone

        foreach ($ranges_datas['zones'] as $key => $zone) {

            $datas[$key + 2][] = $zone['name'];

            $datas[$key + 2][] = '';

            // Per range

            foreach ($ranges_datas['ranges'] as $id_range => $range) {

                if (isset($ranges_datas['price_by_range'][$id_range]) && isset($ranges_datas['price_by_range'][$id_range][$zone['id_zone']])) {

                    $datas[$key + 2][] = $ranges_datas['price_by_range'][$id_range][$zone['id_zone']];

                }

            }

        }

        return $datas;

    }

}

