<?php

/**

 * 2007-2018 KU

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade this module to newer

 * versions in the future.

 *

 *  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   Commercial license see license.txt

 *  Property of Kevin UNFRICHT - AZCODE

 */



class HelperTree extends Tree

{

    const DEFAULT_TEMPLATE = 'tree_items.tpl';

    const DEFAULT_NODE_FOLDER_TEMPLATE = 'tree_node_folder_radio.tpl';

    const DEFAULT_NODE_ITEM_TEMPLATE   = 'tree_node_item_radio.tpl';



    private $disabled_items;

    private $input_name;

    private $lang;

    private $selected_items;

    private $full_tree = false;

    private $shop;

    private $use_checkbox;

    private $useshop_restriction;

    private $children_only = false;



    public function __construct($id, $data = array(), $title = null, $lang = null, $useshop_restriction = true)

    {

        parent::__construct($id, $data);



        if (isset($title)) {

            $this->setTitle($title);

        }



        $this->setLang($lang);

        $this->setUseShopRestriction($useshop_restriction);

    }



    private function normalizeDirectory($directory)

    {

        $last = $directory[Tools::strlen($directory) - 1];



        if (in_array($last, array('/', '\\'))) {

            $directory[Tools::strlen($directory) - 1] = DIRECTORY_SEPARATOR;

            return $directory;

        }



        $directory .= DIRECTORY_SEPARATOR;

        return $directory;

    }



    public function setChildrenOnly($value)

    {

        $this->children_only = $value;

        return $this;

    }



    public function setFullTree($value)

    {

        $this->full_tree = $value;

        return $this;

    }



    public function getFullTree()

    {

        return $this->full_tree;

    }





    public function setDisabledItems($value)

    {

        $this->disabled_items = $value;

        return $this;

    }



    public function getDisabledItems()

    {

        return $this->disabled_items;

    }



    public function setInputName($value)

    {

        $this->input_name = $value;

        return $this;

    }



    public function getInputName()

    {

        if (!isset($this->input_name)) {

            $this->setInputName('itemBox');

        }



        return $this->input_name;

    }



    public function setLang($value)

    {

        $this->lang = $value;

        return $this;

    }



    public function getLang()

    {

        if (!isset($this->lang)) {

            $this->setLang($this->getContext()->employee->idlang);

        }



        return $this->lang;

    }



    public function getTemplateFile($template)

    {

        $path = $this->normalizeDirectory(dirname(__FILE__).'/../../views/templates/admin/helper/tree') . $template;

        if (file_exists($path)) {

            return $path;

        }



        return parent::getTemplateFile($template);

    }



    public function getNodeFolderTemplate()

    {

        if (!isset($this->_node_folder_template)) {

            $this->setNodeFolderTemplate(self::DEFAULT_NODE_FOLDER_TEMPLATE);

        }



        return $this->_node_folder_template;

    }



    public function getNodeItemTemplate()

    {

        if (!isset($this->_node_item_template)) {

            $this->setNodeItemTemplate(self::DEFAULT_NODE_ITEM_TEMPLATE);

        }



        return $this->_node_item_template;

    }



    public function setSelectedItems($value)

    {

        if (!is_array($value)) {

            throw new PrestaShopException('Selected categories value must be an array');

        }



        $this->selected_items = $value;

        return $this;

    }



    public function getSelectedItems()

    {

        if (!isset($this->selected_items)) {

            $this->selected_items = array();

        }



        return $this->selected_items;

    }



    public function setShop($value)

    {

        $this->shop = $value;

        return $this;

    }



    public function getShop()

    {

        if (!isset($this->shop)) {

            if (Tools::isSubmit('idshop')) {

                $this->setShop(new Shop(Tools::getValue('idshop')));

            } elseif ($this->getContext()->shop->id) {

                $this->setShop(new Shop($this->getContext()->shop->id));

            } elseif (!Shop::isFeatureActive()) {

                $this->setShop(new Shop(Configuration::get('PSshop_DEFAULT')));

            } else {

                $this->setShop(new Shop(0));

            }

        }



        return $this->shop;

    }



    public function getTemplate()

    {

        if (!isset($this->_template)) {

            $this->setTemplate(self::DEFAULT_TEMPLATE);

        }



        return $this->_template;

    }



    public function setUseCheckBox($value)

    {

        $this->use_checkbox = (bool)$value;

        return $this;

    }



    public function setUseShopRestriction($value)

    {

        $this->useshop_restriction = (bool)$value;

        return $this;

    }



    public function useCheckBox()

    {

        return (isset($this->use_checkbox) && $this->use_checkbox);

    }



    public function useShopRestriction()

    {

        return (isset($this->useshop_restriction) && $this->useshop_restriction);

    }



    public function render($data = null)

    {

        if (!isset($data)) {

            $data = $this->getData();

        }



        if (isset($this->disabled_items)

            && !empty($this->disabled_items)) {

            $this->disableItems($data, $this->getDisabledItems());

        }



        if (isset($this->selected_items)

            && !empty($this->selected_items)) {

            $this->getSelectedChildNumbers($data, $this->getSelectedItems());

        }



        $collapse_all = new TreeToolbarLink(

            'Collapse All',

            '#',

            '$(\'#'.$this->getId().'\').tree(\'collapseAll\');$(\'#collapse-all-'

            .$this->getId().'\').hide();$(\'#expand-all-'

            .$this->getId().'\').show(); return false;',

            'icon-collapse-alt'

        );

        $collapse_all->setAttribute('id', 'collapse-all-'.$this->getId());

        $expand_all = new TreeToolbarLink(

            'Expand All',

            '#',

            '$(\'#'.$this->getId().'\').tree(\'expandAll\');$(\'#collapse-all-'

            .$this->getId().'\').show();$(\'#expand-all-'

            .$this->getId().'\').hide(); return false;',

            'icon-expand-alt'

        );

        $expand_all->setAttribute('id', 'expand-all-'.$this->getId());

        $this->addAction($collapse_all);

        $this->addAction($expand_all);



        if ($this->useCheckBox()) {

            $check_all = new TreeToolbarLink(

                'Check All',

                '#',

                'checkAllAssociatedItems($(\'#'.$this->getId().'\')); return false;',

                'icon-check-sign'

            );

            $check_all->setAttribute('id', 'check-all-'.$this->getId());

            $uncheck_all = new TreeToolbarLink(

                'Uncheck All',

                '#',

                'uncheckAllAssociatedItems($(\'#'.$this->getId().'\')); return false;',

                'icon-check-empty'

            );

            $uncheck_all->setAttribute('id', 'uncheck-all-'.$this->getId());

            $this->addAction($check_all);

            $this->addAction($uncheck_all);

            $this->setNodeFolderTemplate('tree_node_folder_checkbox.tpl');

            $this->setNodeItemTemplate('tree_node_item_checkbox.tpl');

            $this->setAttribute('use_checkbox', $this->useCheckBox());

        }



        $this->setAttribute('selected_items', $this->getSelectedItems());

        $this->getContext()->smarty->assign('token', Tools::getAdminTokenLite('AdminProducts'));

        return parent::render($data);

    }



    /* Override */

    public function renderNodes($data = null)

    {

        if (!isset($data)) {

            $data = $this->getData();

        }



        if (!is_array($data) && !$data instanceof Traversable) {

            throw new PrestaShopException('Data value must be an traversable array');

        }



        $html = '';

        foreach ($data as $item) {

            if (array_key_exists('children', $item)

                && !empty($item['children'])) {

                $html .= $this->getContext()->smarty->createTemplate(

                    $this->getTemplateFile($this->getNodeFolderTemplate()),

                    $this->getContext()->smarty

                )->assign(array(

                    'input_name' => $this->getInputName(),

                    'children' => $this->renderNodes($item['children']),

                    'node'     => $item

                ))->fetch();

            } else {

                $html .= $this->getContext()->smarty->createTemplate(

                    $this->getTemplateFile($this->getNodeItemTemplate()),

                    $this->getContext()->smarty

                )->assign(array(

                    'input_name' => $this->getInputName(),

                    'node' => $item

                ))->fetch();

            }

        }



        return $html;

    }



    private function disableItems(&$items, $disabled_items = null)

    {

        foreach ($items as &$item) {

            if (!isset($disabled_items) || in_array($item['id'], $disabled_items)) {

                $item['disabled'] = true;

                if (array_key_exists('children', $item) && is_array($item['children'])) {

                    $this->disableItems($item['children']);

                }

            } elseif (array_key_exists('children', $item) && is_array($item['children'])) {

                $this->disableItems($item['children'], $disabled_items);

            }

        }

    }



    private function getSelectedChildNumbers(&$items, $selected, &$parent = null)

    {

        $selected_childs = 0;



        foreach ($items as &$item) {

            if (isset($parent) && in_array($item['id'], $selected)) {

                $selected_childs++;

            }



            if (isset($item['children']) && !empty($item['children'])) {

                $selected_childs += $this->getSelectedChildNumbers($item['children'], $selected, $item);

            }

        }



        if (!isset($parent['selected_childs'])) {

            $parent['selected_childs'] = 0;

        }



        $parent['selected_childs'] = $selected_childs;

        return $selected_childs;

    }

}

