<?php

/**

 * 2007-2018 KU

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade this module to newer

 * versions in the future.

 *

 *  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   Commercial license see license.txt

 *  Property of Kevin UNFRICHT - AZCODE

 */



if (!class_exists('AzcodeTools')) {

    class AzcodeTools extends Tools

    {

        const MAX_PRECISION = 9;



        /**

         * Le tableau est bien remplit

         * @param type $array

         * @return boolean

         */

        public static function isFillArray($array)

        {

            return ($array && is_array($array) && count($array));

        }



        /**

         * Retourne un taux en pourcentage

         * @param float $rate

         * @return float

         */

        public static function rateToPercent($rate)

        {

            return (float)$rate * 100;

        }



        /**

         * Retourne un pourcentage en taux

         * @param float $percent

         * @return float

         */

        public static function percentToRate($percent)

        {

            return (float)$percent / 100;

        }



        /**

         * Normalize un flottant sur Prestashop

         * car Validate::isPrice n'accepte pas des flottant avec

         * + de 9 chiffres derrière la virgule

         * @see ValidateCore::isPrice()

         * @param real $float

         * @return real

         */

        public static function normalizeFloat($float)

        {

            if (!is_float($float)) {

                return 0.00;

            }

            return Tools::ps_round((float)$float, self::MAX_PRECISION);

        }

    }

}

