<?php

/**

 * 2007-2018 KU

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade this module to newer

 * versions in the future.

 *

 *  @author    Kevin UNFRICHT <unfricht.kevin@hotmail.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   Commercial license see license.txt

 *  Property of Kevin UNFRICHT - AZCODE

 */



if (!class_exists('AzcodeModuleAdminController')) {

    class AzcodeModuleAdminController extends ModuleAdminController

    {

        public function __construct()

        {

            parent::__construct();

        }



        public function setMedia($isNewTheme = false)

        {

            parent::setMedia($isNewTheme);

            $this->addCss($this->module->getLocalPath().'/views/css/AzcodeModuleAdmin.css');

        }



        public function initPageHeaderToolbar()

        {

            parent::initPageHeaderToolbar();

            $this->page_header_toolbar_btn['module'] = array(

                'href' => $this->module->getConfigureUrl(),

                'desc' => $this->l('Configure'),

                'icon' =>  'process-icon-modules-list',

                'target' => '_blank'

            );

            $this->page_header_toolbar_btn['documentation'] = array(

                'href' => $this->module->getDocumentationUrl(),

                'desc' => $this->l('Documentation'),

                'icon' =>  'icon-file-pdf-o',

                'target' => '_blank'

            );

            $this->page_header_toolbar_btn['faq'] = array(

                'href' => $this->module->getFaqUrl(),

                'desc' => $this->l('FAQ'),

                'icon' =>  'process-icon-help',

                'target' => '_blank'

            );

            $this->page_header_toolbar_btn['bug'] = array(

                'href' => 'https://addons.prestashop.com/en/write-to-developper?id_product='

                .(int)$this->module->getAddonsIdProduct(),

                'desc' => $this->l('Report a bug'),

                'icon' =>  'icon-bug',

                'target' => '_blank'

            );

            $this->page_header_toolbar_btn['rating'] = array(

                'href' => 'http://addons.prestashop.com/fr/ratings.php',

                'desc' => $this->l('Rate us'),

                'icon' =>  'icon-star',

                'target' => '_blank'

            );

        }

    }

}

