<?php

/**

 * 2007-2018 KU

 *

 * NOTICE OF LICENSE

 *

 * This source file is subject to the Academic Free License (AFL 3.0)

 * that is bundled with this package in the file LICENSE.txt.

 * It is also available through the world-wide-web at this URL:

 * http://opensource.org/licenses/afl-3.0.php

 * If you did not receive a copy of the license and are unable to

 * obtain it through the world-wide-web, please send an email

 * to license@prestashop.com so we can send you a copy immediately.

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer

 * versions in the future. If you wish to customize PrestaShop for your

 * needs please refer to http://www.prestashop.com for more information.

 *

 *  @author    Kevin UNFRICHT <contact@kevin-unfricht.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 *  International Registered Trademark & Property of PrestaShop SA

 */



class Importer

{



    protected $data;

    protected $delimiters = array();

    protected $zones = array();



    public function __construct($data)

    {

        $this->data = $data = $this->clean($data);

        $this->setDelimiters($data);

        $this->setZones($data);

    }



    protected function setDelimiters(&$data)

    {

        if (empty($data[0]) || empty($data[1])) {

            return;

        }



        $data_delimiter1 = $this->cleanDelimitersData($data[0]);

        $data_delimiter2 = $this->cleanDelimitersData($data[1]);



        if (count($data_delimiter1) <> count($data_delimiter2)) {

            return;

        }



        foreach ($data_delimiter1 as $k => $delimiter) {

            $this->delimiters[] = array(

                'delimiter1' => (float)$delimiter,

                'delimiter2' => (float)$data_delimiter2[$k]

            );

        }



        unset($data[0]);

        unset($data[1]);

    }



    protected function cleanDelimitersData($delimiters)

    {

        foreach ($delimiters as $k => $delimiter) {

            $delimiter = str_replace(',', '.', $delimiter);

            if (!is_numeric($delimiter)) {

                unset($delimiters[$k]);

            }

        }



        return $delimiters;

    }



    protected function setZones($data)

    {

        foreach ($data as $zone_data) {

            $zone = $zone_data[0];

            unset($zone_data[0]);

            $this->zones[$zone] = array();

            foreach ($zone_data as $delimiter_value) {

                $this->zones[$zone][] = (float)str_replace(',', '.', $delimiter_value);

            }

        }

    }



    public function getData()

    {

        return $this->data;

    }



    public function getDelimiters()

    {

        return $this->delimiters;

    }



    public function getZones()

    {

        return $this->zones;

    }



    public function clean($data)

    {

        foreach ($data as $x => $datas) {

            if (empty($datas)) {

                unset($data[$x]);

            }



            foreach ($datas as $y => $cell) {

                if (empty($cell)) {

                    unset($data[$x][$y]);

                }

            }

        }



        return $data;

    }



    public function isValid()

    {

        $count_delimiters = count($this->getDelimiters());

        foreach ($this->getZones() as $zone) {

            if (count($zone) <> $count_delimiters) {

                return false;

            }

        }



        return true;

    }

}

