<?php

/**

 * 2007-2018 KU

 *

 * NOTICE OF LICENSE

 *

 * This source file is subject to the Academic Free License (AFL 3.0)

 * that is bundled with this package in the file LICENSE.txt.

 * It is also available through the world-wide-web at this URL:

 * http://opensource.org/licenses/afl-3.0.php

 * If you did not receive a copy of the license and are unable to

 * obtain it through the world-wide-web, please send an email

 * to license@prestashop.com so we can send you a copy immediately.

 *

 * DISCLAIMER

 *

 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer

 * versions in the future. If you wish to customize PrestaShop for your

 * needs please refer to http://www.prestashop.com for more information.

 *

 *  @author    Kevin UNFRICHT <contact@kevin-unfricht.fr>

 *  @copyright 2007-2018 Kevin UNFRICHT

 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 *  International Registered Trademark & Property of PrestaShop SA

 */



class CarrierGTRM extends Carrier

{



    public $date_import;



    public static $definition = array(

        'table' => 'carrier',

        'primary' => 'id_carrier',

        'multilang' => true,

        'multilang_shop' => true,

        'fields' => array(

            /* Classic fields */

            'id_reference' =>            array('type' => self::TYPE_INT),

            'name' =>                    array('type' => self::TYPE_STRING, 'validate' => 'isCarrierName', 'required' => true, 'size' => 64),

            'active' =>                array('type' => self::TYPE_BOOL, 'validate' => 'isBool', 'required' => true),

            'is_free' =>                array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            'url' =>                    array('type' => self::TYPE_STRING, 'validate' => 'isAbsoluteUrl'),

            'shipping_handling' =>        array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            'shipping_external' =>        array('type' => self::TYPE_BOOL),

            'range_behavior' =>        array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            'shipping_method' =>        array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),

            'max_width' =>                array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),

            'max_height' =>            array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),

            'max_depth' =>                array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),

            'max_weight' =>            array('type' => self::TYPE_FLOAT, 'validate' => 'isFloat'),

            'grade' =>                    array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt', 'size' => 1),

            'external_module_name' =>    array('type' => self::TYPE_STRING, 'size' => 64),

            'is_module' =>                array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            'need_range' =>            array('type' => self::TYPE_BOOL),

            'position' =>                array('type' => self::TYPE_INT),

            'deleted' =>                array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),

            'date_import' =>            array('type' => self::TYPE_DATE),

            /* Lang fields */

            'delay' =>                    array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'required' => true, 'size' => 128),

        ),

    );



    /**

     * Get all backups available for a carrier reference

     * @param Int $id_reference

     * @return Array $results

     */

    public static function getCarrierBackups($id_reference)

    {

        $sql = 'SELECT `id_carrier`, `date_import` FROM `'._DB_PREFIX_.'carrier`'

            .' WHERE `date_import` IS NOT NULL AND `date_import` <> "0000-00-00 00:00:00"'

            .' AND `id_reference` = '.(int)$id_reference.' ORDER BY `date_import` DESC';

        return Db::getInstance()->executeS($sql);

    }

}

