<?php


class Ec_Scan_Ean13 extends Module {

    private $_html = '';
    

    
    public function __construct() {
        $this->name = 'ec_scan_ean13';
        $this->tab = 'administration';
        $this->version = '1.1.1';
        $this->need_instance = 0;
        $this->author = 'Ether Création';
        $this->bootstrap = true;
        $this->module_key = 'c399de783f549aade1a273ccc4e4c71a';
        //$this->_tabIncrement = array();

        parent::__construct();
        
        $this->displayName = $this->l('Ec Scan Ean13');
        $this->description = $this->l('Manage your stock by ean13 scanning : inventory, incrementation and decrementation.');
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall this module?');
    }

    public function getContent() {
        
        if (isset($this->context))
                $this->context->controller->addJS(($this->_path).'js/ec_scan_ean13.js');
        else
                Tools::addJS(($this->_path).'js/ec_scan_ean13.js?');
        
        if(Tools::isSubmit('submitIncrement') || Tools::isSubmit('submitWarehouse') || Tools::isSubmit('submitDecrement') || Tools::isSubmit('submitInventory') || Tools::isSubmit('submitCart'))
        {
            if ($this->_postValidation())
            {
                $this->_postProcess();
            }
        }
        elseif(Tools::isSubmit('clearTabIncrement') || Tools::isSubmit('clearTabDecrement') || Tools::isSubmit('clearTabInventory'))
        {
            $this->clearTab();
        }
        elseif(Tools::isSubmit('exportTabIncrement') || Tools::isSubmit('exportTabDecrement') || Tools::isSubmit('exportTabInventory'))
        {
            $this->_html .= $this->exportTab();
        }
        elseif(Tools::isSubmit('decrementInventoryCount') || Tools::isSubmit('IncrementInventoryCount'))
        {
            $this->inventoryCountDecrement();
        }
        elseif(Tools::isSubmit('applyCount'))
        {
            $this->updateStock(Tools::getValue('ean13apply'));
        }
        elseif(Tools::isSubmit('applyAllCount'))
        {
            $this->updateAllStock();
        }
        elseif(Tools::isSubmit('finishCount'))
        {
            $this->finishStockCount();
        }
        
        if(Tools::isSubmit('increment') || Tools::isSubmit('submitIncrement') || Tools::isSubmit('clearTabIncrement') || Tools::isSubmit('exportTabIncrement'))
        {
            $this->_html .= $this->incrementPage();
            $this->_html .= $this->renderTabIncrement();
            $this->_html .= $this->goBack();
        }
        elseif(Tools::isSubmit('decrement') || Tools::isSubmit('submitDecrement') || Tools::isSubmit('clearTabDecrement') || Tools::isSubmit('exportTabDecrement'))
        {
            $this->_html .= $this->decrementPage();
            $this->_html .= $this->renderTabDecrement();
            $this->_html .= $this->goBack();
        }
        elseif(Tools::isSubmit('inventory') || Tools::isSubmit('submitInventory') || Tools::isSubmit('clearTabInventory') || Tools::isSubmit('exportTabInventory') || Tools::isSubmit('decrementInventoryCount') || Tools::isSubmit('IncrementInventoryCount') || Tools::isSubmit('applyCount') || Tools::isSubmit('applyAllCount') || Tools::isSubmit('finishCount'))
        {
            $this->_html .= $this->inventoryPage();
            $this->_html .= $this->renderTabInventory();
            $this->_html .= $this->renderExportInventory();
            $this->_html .= $this->goBack();
        }
        else
        {
            $this->_html .= $this->homePage();
        }
        
        return $this->_html;
    }
    public function goBack()
    {
        $html = '';
        if (!version_compare(_PS_VERSION_, '1.6', '>='))
        {
            $html .='</br><a class="button" title="Come back" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'">
                    '.$this->l('Come back').'
                    </a>';
        }     
                
        return $html;
    }
    
    private function _postValidation()
    {
            $errors = array();

            if (Tools::isSubmit('submitIncrement') || Tools::isSubmit('submitDecrement') || Tools::isSubmit('submitInventory'))
            {
                
                if(Tools::strlen(Tools::getValue('ean13')) != 13)
                {
                    $errors[] = $this->l('Invalid ean, there isn\'t 13 caracters');
                }
                elseif(Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'product_attribute` WHERE ean13="'.pSQL(Tools::getValue('ean13')).'"') == 0
                        && Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'product` WHERE ean13="'.pSQL(Tools::getValue('ean13')).'"') == 0)
                {
                            $errors[] = $this->l('Inexistant ean');
                }
            } 
            if (count($errors))
            {
                    $this->_html .= $this->displayError(implode('<br />', $errors));
                    return false;
            }
            return true;
    }

	private function _postProcess()
	{
		$errors = array();


		if (Tools::isSubmit('submitIncrement') || Tools::isSubmit('submitDecrement'))
		{
			if(Tools::isSubmit('submitIncrement'))  
            {
                $crement = 1;
                $mvt_reason = 1;
            }
            else 
            {
                $crement = -1;
                $mvt_reason = 2;
            }

            $context = Context::getContext();
            $id_shop = $context->shop->id;
            $ean13 = Tools::getValue('ean13');
            $id_lang = $this->context->language->id;
            $nomAtt = '';
            if ($infoPtAtt = Db::getInstance()->getRow('SELECT id_product_attribute, id_product FROM `'._DB_PREFIX_.'product_attribute` WHERE ean13='.$ean13))
            {
                $id_product = $infoPtAtt['id_product'];
                $id_product_attribute = $infoPtAtt['id_product_attribute'];
                $tab_id_att = Db::getInstance()->ExecuteS('SELECT id_attribute FROM `'._DB_PREFIX_.'product_attribute_combination` WHERE id_product_attribute = '.$id_product_attribute);
                foreach($tab_id_att as $id_att)
                    $nomAtt .= Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'attribute_lang` '
                        .'WHERE id_attribute = '.$id_att['id_attribute'].' AND id_lang = '.$id_lang).' ';  
            }
            else
            {
                $id_product = Db::getInstance()->getValue('SELECT id_product FROM `'._DB_PREFIX_.'product` WHERE ean13='.$ean13);
                $id_product_attribute = 0;
            }
            $nomPdt = Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'product_lang` '
                    . 'WHERE id_product = '.$id_product.' AND id_shop = '.$id_shop.' AND id_lang = '.$id_lang);
            $referencePdt = Db::getInstance()->getValue('SELECT reference FROM `'._DB_PREFIX_.'product` '
                    . 'WHERE id_product = '.$id_product);
            
            if(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1')
            {
                $warehouse = new Warehouse(Configuration::get('EC_SCAN_WAREHOUSE'));
                $price = Db::getInstance()->getValue('SELECT wholesale_price FROM `'._DB_PREFIX_.'product` WHERE id_product = '.$id_product);
                if($id_product_attribute != 0)
                {
                    $price_tmp = Db::getInstance()->getValue('SELECT wholesale_price FROM `'._DB_PREFIX_.'product_attribute` WHERE id_product_attribute = '.$id_product_attribute);
                    if((float)$price_tmp != 0)
                        $price = $price_tmp;
                }
                $stock_manager = StockManagerFactory::getManager();
                if($crement == 1)
                {
                    if(!$stock_manager->addProduct($id_product, $id_product_attribute, $warehouse, $crement, $mvt_reason, $price))
                    {
                        $this->_html .= $this->displayError($this->l('An error occurred. No stock was added.'));
                        return;
                    }
                    else
                        StockAvailable::synchronize($id_product); 
                } 
                else
                {
                    $crement = 1;
                    if(!$stock_manager->removeProduct($id_product, $id_product_attribute, $warehouse, $crement, $mvt_reason, $price))
                    {
                        $this->_html .= $this->displayError($this->l('It is not possible to remove the specified quantity. No stock was removed.'));
                        return;
                    }  
                    else
                        StockAvailable::synchronize($id_product);
                        
                }
                $stock = Db::getInstance()->getValue('SELECT physical_quantity FROM `'._DB_PREFIX_.'stock` '
                . 'WHERE id_product = '.$id_product.' AND id_product_attribute = '.$id_product_attribute.' AND id_warehouse = '.Configuration::get('EC_SCAN_WAREHOUSE'));
                if($stock == '')
                    {
                        $warehouse = new Warehouse(Configuration::get('EC_SCAN_WAREHOUSE'));
                        $stock_manager = StockManagerFactory::getManager();
                        
                        $stock_manager->addProduct($id_product, $id_product_attribute, $warehouse, 0, 1, $price);
                        $stock = 0;
                    }  
            }
            else
            {
                StockAvailable::updateQuantity($id_product,$id_product_attribute,$crement,$id_shop);
                $stock = Db::getInstance()->getValue('SELECT quantity FROM `'._DB_PREFIX_.'stock_available` '
                . 'WHERE id_product = '.$id_product.' AND id_product_attribute = '.$id_product_attribute.' AND id_shop = '.$id_shop);
            }
                
            $this->checkEanStock($ean13, $stock);

            $this->_html .= $this->displayConfirmation($this->l('The stock have been updated, it is ').''.$stock.''.$this->l(' for the product ').''.$nomPdt.' '.$nomAtt.', ean '.$ean13);
            if(Tools::isSubmit('submitIncrement'))
            {
                if(Db::getInstance()->getValue('SELECT namePdt FROM `'._DB_PREFIX_.'ec_scan_ean13_increment` WHERE ean13="'.$ean13.'"'))
                    Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_increment` SET increment = increment+1, stock = '.$stock.' WHERE ean13="'.$ean13.'"');
                else
                    Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'ec_scan_ean13_increment` VALUES ("'.$id_product.'", "'.$referencePdt.'", "'.$nomPdt.'", "'.$nomAtt.'", "'.$ean13.'", 1, '.$stock.')');
            }
            else 
            {
                if(Db::getInstance()->getValue('SELECT namePdt FROM `'._DB_PREFIX_.'ec_scan_ean13_decrement` WHERE ean13="'.$ean13.'"'))
                    Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_decrement` SET decrement = decrement-1, stock = '.$stock.' WHERE ean13="'.$ean13.'"');
                else
                    Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'ec_scan_ean13_decrement` VALUES ("'.$id_product.'", "'.$referencePdt.'", "'.$nomPdt.'", "'.$nomAtt.'", "'.$ean13.'", -1, '.$stock.')');
            } 
        } 
        elseif(Tools::isSubmit('submitInventory'))
        {
            $context = Context::getContext();
            $id_shop = $context->shop->id;
            $ean13 = Tools::getValue('ean13');
            $id_lang = $this->context->language->id;
            $nomAtt = '';
            
            if ($infoPtAtt = Db::getInstance()->getRow('SELECT id_product_attribute, id_product FROM `'._DB_PREFIX_.'product_attribute` WHERE ean13='.$ean13))
            {
                $id_product = $infoPtAtt['id_product'];
                $id_product_attribute = $infoPtAtt['id_product_attribute'];
                $tab_id_att = Db::getInstance()->ExecuteS('SELECT id_attribute FROM `'._DB_PREFIX_.'product_attribute_combination` WHERE id_product_attribute = '.$id_product_attribute);
                foreach($tab_id_att as $id_att)
                    $nomAtt .= Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'attribute_lang` '
                        .'WHERE id_attribute = '.$id_att['id_attribute'].' AND id_lang = '.$id_lang).' '; 
            }
            else
            {
                $id_product = Db::getInstance()->getValue('SELECT id_product FROM `'._DB_PREFIX_.'product` WHERE ean13='.$ean13);
                $id_product_attribute = 0;
            }
            $nomPdt = Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'product_lang` '
                    . 'WHERE id_product = '.$id_product.' AND id_shop = '.$id_shop.' AND id_lang = '.$id_lang);
            $referencePdt = Db::getInstance()->getValue('SELECT reference FROM `'._DB_PREFIX_.'product` '
                    . 'WHERE id_product = '.$id_product);
            
            if(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1')
            {
                $stock = Db::getInstance()->getValue('SELECT physical_quantity FROM `'._DB_PREFIX_.'stock` '
                . 'WHERE id_product = '.$id_product.' AND id_product_attribute = '.$id_product_attribute.' AND id_warehouse = '.Configuration::get('EC_SCAN_WAREHOUSE'));
                if($stock == '')
                {
                    $warehouse = new Warehouse(Configuration::get('EC_SCAN_WAREHOUSE'));
                    $stock_manager = StockManagerFactory::getManager();
                    $price = Db::getInstance()->getValue('SELECT wholesale_price FROM `'._DB_PREFIX_.'product` WHERE id_product = '.$id_product);
                    if($id_product_attribute != 0)
                    {
                        $price_tmp = Db::getInstance()->getValue('SELECT wholesale_price FROM `'._DB_PREFIX_.'product_attribute` WHERE id_product_attribute = '.$id_product_attribute);
                        if((float)$price_tmp != 0)
                            $price = $price_tmp;
                    }
                    $stock_manager->addProduct($id_product, $id_product_attribute, $warehouse, 0, 1, $price);
                    $stock = 0;
                }
                
            }   
            else
                $stock = Db::getInstance()->getValue('SELECT quantity FROM `'._DB_PREFIX_.'stock_available` '
                . 'WHERE id_product = '.$id_product.' AND id_product_attribute = '.$id_product_attribute.' AND id_shop = '.$id_shop);

            $this->_html .= $this->displayConfirmation($this->l('The inventory have been update for the product ').''.$nomPdt.' '.$nomAtt.', ean '.$ean13);
            
            if(Db::getInstance()->getValue('SELECT COUNT(*) FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory` WHERE ean13="'.$ean13.'"') == 1)
                Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_inventory` SET count = count+1, stock = '.$stock.' WHERE ean13="'.$ean13.'"');
            else
                Db::getInstance()->Execute('INSERT INTO `'._DB_PREFIX_.'ec_scan_ean13_inventory` VALUES ("'.$id_product.'", "'.$referencePdt.'", "'.$nomPdt.'", "'.$nomAtt.'", "'.$ean13.'", 1, '.$stock.')');

        }
        elseif(Tools::isSubmit('submitWarehouse'))
        {
            Configuration::updateValue('EC_SCAN_WAREHOUSE', Tools::getValue('warehouse'));
            $this->clearTabAll();
        }
                
		if (count($errors))
			$this->_html .= $this->displayError(implode('<br />', $errors));
                
	}
    
    
    public function incrementPage(){
        $fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Increment Stock'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'text',
                                                'id' => 'ean13',
						'label' => $this->l('Enter the EAN13 to increment stock : '),
						'name' => 'ean13',
						'lang' => false,
					),
					
				),
                                
                                'buttons' => array(
                                        'newBlock' => array(
                                            'title' => $this->l('Come back'),
                                            'href' => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
                                            'class' => 'pull-left',
                                            'icon' => 'process-icon-cancel'
                                        )
                                ),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);


		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$this->fields_form = array();
		$helper->module = $this;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitIncrement';
                $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&increment&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'base_url' => $this->context->shop->getBaseURL(),
            'fields_value' => array('ean13' => '')
		);

		$helper->override_folder = '/';

		return $helper->generateForm(array($fields_form));
	
        }
        
    public function decrementPage(){
        $fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Decrement Stock'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'text',
                                                'id' => 'ean13',
						'label' => $this->l('Enter the EAN13 to decrement stock: '),
						'name' => 'ean13',
						'lang' => false,
					),
				),            
                'buttons' => array(
                    'newBlock' => array(
                        'title' => $this->l('Come back'),
                        'href' => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
                        'class' => 'pull-left',
                        'icon' => 'process-icon-cancel'
                    )
                ),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);


		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$this->fields_form = array();
		$helper->module = $this;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitDecrement';
		//$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&increment&tab_module='.$this->tab.'&module_name='.$this->name;
                $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&decrement&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'base_url' => $this->context->shop->getBaseURL(),
            'fields_value' => array('ean13' => '')
		);

		$helper->override_folder = '/';

		return $helper->generateForm(array($fields_form));
        }
        
    public function inventoryPage(){
        $fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Stock Invetory'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'text',
                        'id' => 'ean13',
						'label' => $this->l('Enter the EAN13 to increment stock count: '),
						'name' => 'ean13',
						'lang' => false,
					),
					
				),
                'buttons' => array(
                    'newBlock' => array(
                        'title' => $this->l('Come back'),
                        'href' => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
                        'class' => 'pull-left',
                        'icon' => 'process-icon-cancel'
                    )
                ),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);


		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$this->fields_form = array();
		$helper->module = $this;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitInventory';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&inventory&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'base_url' => $this->context->shop->getBaseURL(),
            'fields_value' => array('ean13' => '')
		);
		$helper->override_folder = '/';
		return $helper->generateForm(array($fields_form));
  }
        
        
    public function homePage(){
        if (version_compare(_PS_VERSION_, '1.6', '>='))
        {
            $html = '<div id="fieldset_0" class="panel">
                                    <div class="panel-heading">
                                            <i class="icon-cogs"></i> '.$this->l('Scan ean13').'
                                    </div>
                                <p>'.$this->l('Decrement stock : ').'
                                    <div class="btn-group-action">
                                            <a class="edit btn btn-default" title="Decrement" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&decrement">
                                                '.$this->l('Decrement').'
                                            </a>

                                    </div></p>
                                <p>'.$this->l('Increment stock : ').'
                                    <div class="btn-group-action">
                                            <a class="edit btn btn-default" title="Increment" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&increment">
                                                '.$this->l('Increment').'
                                            </a>

                                    </div></p>
                                <p>'.$this->l('Make an inventory : ').'
                                    <div class="btn-group-action">
                                            <a class="edit btn btn-default" title="Inventory" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&inventory">
                                                '.$this->l('Inventory').'
                                            </a>
                                    </div></p>
                            
                    </div>';  
        }
        else
        {
            $html = '</br><fieldset id="fieldset_0">
                        <legend>'.$this->l('Scan ean13').'</legend>
                            <p>'.$this->l('Decrement stock : ').'
                                <div class="btn-group-action">
                                        <a class="button" title="Decrement" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&decrement">
                                            '.$this->l('Decrement').'
                                        </a>
                                    
                                </div></br></p>
                            <p>'.$this->l('Increment stock : ').'
                                <div class="btn-group-action">
                                        <a class="button" title="Increment" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&increment">
                                            '.$this->l('Increment').'
                                        </a>
                                </div></br></p>
                            <p>'.$this->l('Make an inventory : ').'
                                <div class="btn-group-action">
                                        <a class="button" title="Inventory" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&inventory">
                                            '.$this->l('Inventory').'
                                        </a>
                                </div></br></p>
                </div>';
        }
        if(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1')
            {
                $select = array();
                $warehouses = Db::getInstance()->ExecuteS('SELECT id_warehouse, name FROM `'._DB_PREFIX_.'warehouse` WHERE deleted = 0');
                foreach($warehouses as $warehouse){
                    array_push($select, array(
        			'id_warehouse' => $warehouse['id_warehouse'],
        			'name' => $warehouse['name']
        			));
                }
                
                $fields_form = array(
        			'form' => array(
        				'legend' => array(
        					'title' => $this->l('Warehouse'),
        					'icon' => 'icon-cogs'
        				),
        				'input' => array(
        					array(
        						'type' => 'select',
        						'label' => $this->l('Select a warehouse'),
        						'name' => 'warehouse',
                                'options' => array(
        							'query' => $select,
        							'id' => 'id_warehouse',
        							'name' => 'name'
        						)
        					)
        				),
        				'submit' => array(
        					'title' => $this->l('Save'),
        				)
        			),
        		);
        		$helper = new HelperForm();
        		$helper->show_toolbar = false;
        		$helper->table = $this->table;
        		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        		$this->fields_form = array();
        		$helper->module = $this;
        		$helper->identifier = $this->identifier;
        		$helper->submit_action = 'submitWarehouse';
                $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        		$helper->token = Tools::getAdminTokenLite('AdminModules');
        		$helper->tpl_vars = array(
        			'base_url' => $this->context->shop->getBaseURL(),
                    'fields_value' => array('warehouse' => Configuration::get('EC_SCAN_WAREHOUSE'))
        		);
        		$helper->override_folder = '/';
        		$html .= $helper->generateForm(array($fields_form));
            }
        
        return $html;
    }
    
    public function renderTabIncrement(){
        $html = '';
        $tabIncrement = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'ec_scan_ean13_increment`');
        if (version_compare(_PS_VERSION_, '1.6', '>='))
        {
            $html .= '<div id="fieldset_0" class="panel">
                        <div class="panel-heading">
                                <i class="icon-cogs"></i> '.$this->l('Last stock movement').'
                        </div>
                         <div class="table-responsive clearfix">
                                    <table class="table" cellspacing="0" cellpadding="0">
                                    <thead>
                                        <tr class="nodrag nodrop">
                                            <th class="title_box">
                                                '.$this->l('ID').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Reference').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Name').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Attrubute').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('EAN13').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Increment').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Actual stock').'
                                            </th>

                                    </thead>

                                    <tbody>';

                    foreach ($tabIncrement as $row)
                    {
                        $html .= '<tr>'
                                . '<td class="title_box">'.$row['id_product'].'</td>'
                                . '<td class="title_box">'.$row['reference'].'</td>'
                                . '<td class="title_box">'.$row['namePdt'].'</td>'
                                . '<td class="title_box">'.$row['nameAtt'].'</td>'
                                . '<td class="title_box">'.$row['ean13'].'</td>'
                                . '<td class="title_box">+'.$row['increment'].'</td>'
                                . '<td class="title_box">'.$row['stock'].'</td>' 
                                . '</tr>';
                    }

                    $html .= '</tbody>
                            </table></div>
                             <div class="panel-footer">
                                <a class="btn btn-default pull-right" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&exportTabIncrement">
                                    <i class="process-icon-save"></i>
                                    '.$this->l('Export CSV').'
                                </a>
                                <a class="btn btn-default pull-left" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&clearTabIncrement">
                                    <i class="process-icon-cancel"></i>
                                    '.$this->l('Clear table').'
                                </a>
                             </div>
                            </div>';
        }
        else
        {
            $html .= '</br><fieldset id="fieldset_0">
                        <legend>'.$this->l('Last stock movement').'</legend>
                         <div class="table-responsive clearfix">
                                    <table class="table" cellspacing="0" cellpadding="0">
                                    <thead>
                                        <tr class="nodrag nodrop">
                                            <th class="title_box">
                                                '.$this->l('ID').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Reference').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Name').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Attrubute').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('EAN13').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Increment').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Actual stock').'
                                            </th>

                                    </thead>

                                    <tbody>';

                    foreach ($tabIncrement as $row)
                    {
                        $html .= '<tr>'
                                . '<td class="title_box">'.$row['id_product'].'</td>'
                                . '<td class="title_box">'.$row['reference'].'</td>'
                                . '<td class="title_box">'.$row['namePdt'].'</td>'
                                . '<td class="title_box">'.$row['nameAtt'].'</td>'
                                . '<td class="title_box">'.$row['ean13'].'</td>'
                                . '<td class="title_box">+'.$row['increment'].'</td>'
                                . '<td class="title_box">'.$row['stock'].'</td>' 
                                . '</tr>';
                    }

                    $html .= '</tbody>
                            </table></div></br></br>
                             <div class="panel-footer">
                                <a class="button" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&exportTabIncrement">
                                    <i class="process-icon-save"></i>
                                    '.$this->l('Export CSV').'
                                </a>
                                <a class="button" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&clearTabIncrement">
                                    <i class="process-icon-cancel"></i>
                                    '.$this->l('Clear table').'
                                </a>
                             </div>
                            </fieldset>';
        }
        return $html;
        
    }
    public function renderTabDecrement(){
        $html = '';
        $tabDecrement = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'ec_scan_ean13_decrement`');
        if (version_compare(_PS_VERSION_, '1.6', '>='))
        {
            $html .= '<div id="fieldset_0" class="panel">
                        <div class="panel-heading">
                                <i class="icon-cogs"></i> '.$this->l('Last stock movement').'
                        </div>
                         <div class="table-responsive clearfix">
                                    <table class="table" cellspacing="0" cellpadding="0">
                                    <thead>
                                        <tr class="nodrag nodrop">
                                            <th class="title_box">
                                                '.$this->l('ID').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Reference').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Name').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Attrubute').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('EAN13').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Decrement').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Actual stock').'
                                            </th>

                                    </thead>

                                    <tbody>';

                    foreach ($tabDecrement as $row)
                    {
                        $html .= '<tr>'
                                . '<td class="title_box">'.$row['id_product'].'</td>'
                                . '<td class="title_box">'.$row['reference'].'</td>'
                                . '<td class="title_box">'.$row['namePdt'].'</td>'
                                . '<td class="title_box">'.$row['nameAtt'].'</td>'
                                . '<td class="title_box">'.$row['ean13'].'</td>'
                                . '<td class="title_box">'.$row['decrement'].'</td>'
                                . '<td class="title_box">'.$row['stock'].'</td>' 
                                . '</tr>';
                    }

                    $html .= '</tbody>
                            </table></div>
                             <div class="panel-footer">
                                <a id="update_btn" rel="'.$this->l('Are you sure to update all actual stock with count? Just for scanned product').'" class="btn btn-default pull-right" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&exportTabDecrement">
                                    <i class="process-icon-save"></i>
                                    '.$this->l('Export CSV').'
                                </a>
                                <a id="finish_btn" rel="'.$this->l('Are you sure you want to finish the inventory? All stock product not scanned  will be set to 0').'" class="btn btn-default pull-left" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&clearTabDecrement">
                                    <i class="process-icon-cancel"></i>
                                    '.$this->l('Clear table').'
                                </a>
                             </div>
                            </div>';
        }
        else
        {
            $html .= '</br><fieldset id="fieldset_0">
                        <legend>'.$this->l('Last stock movement').'</legend>
                         <div class="table-responsive clearfix">
                                    <table class="table" cellspacing="0" cellpadding="0">
                                    <thead>
                                        <tr class="nodrag nodrop">
                                            <th class="title_box">
                                                '.$this->l('ID').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Reference').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Name').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Attrubute').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('EAN13').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Decrement').'
                                            </th>
                                            <th class="title_box">
                                                '.$this->l('Actual stock').'
                                            </th>

                                    </thead>

                                    <tbody>';

                    foreach ($tabDecrement as $row)
                    {
                        $html .= '<tr>'
                                . '<td class="title_box">'.$row['id_product'].'</td>'
                                . '<td class="title_box">'.$row['reference'].'</td>'
                                . '<td class="title_box">'.$row['namePdt'].'</td>'
                                . '<td class="title_box">'.$row['nameAtt'].'</td>'
                                . '<td class="title_box">'.$row['ean13'].'</td>'
                                . '<td class="title_box">'.$row['decrement'].'</td>'
                                . '<td class="title_box">'.$row['stock'].'</td>' 
                                . '</tr>';
                    }

                    $html .= '</tbody>
                            </table></div></br></br>
                             <div class="panel-footer">
                                <a class="button" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&exportTabDecrement">
                                    <i class="process-icon-save"></i>
                                    '.$this->l('Export CSV').'
                                </a>
                                <a class="button" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&clearTabDecrement">
                                    <i class="process-icon-cancel"></i>
                                    '.$this->l('Clear table').'
                                </a>
                             </div>
                            </fieldset>';
        }
        return $html; 
    }
    
    public function renderTabInventory(){
        $html = '';
        $tabInventory = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory`');
        if (version_compare(_PS_VERSION_, '1.6', '>='))
        {
            $html .= '<div id="fieldset_0" class="panel">
                        <div class="panel-heading">
                                <i class="icon-cogs"></i> '.$this->l('Actual count').'
                        </div>
                        <div class="table-responsive clearfix">
                            <table class="table" cellspacing="0" cellpadding="0">
                                <thead>
                                    <tr class="nodrag nodrop">
                                        <th class="title_box">
                                            '.$this->l('ID').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Reference').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Name').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Attrubute').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('EAN13').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Count').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Actual stock').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Decrement stock count').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Increment stock count').'
                                        </th>
                                        <th class="title_box">
                                            '.$this->l('Update actual stock with count').'
                                        </th>
                                </thead>
                                    <tbody>';
                foreach ($tabInventory as $row)
                {
                    $applyCount = '';
                    if($row['count'] != $row['stock'])
                    {
                        $applyCount = '<a class="edit btn btn-default" href="'
                                . ''.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&applyCount&ean13apply='.$row['ean13'].'" title="Update stock">'.$this->l('Update stock').'</a>';
                    }
                    $html .= '<tr>'
                                . '<td class="title_box">'.$row['id_product'].'</td>'
                                . '<td class="title_box">'.$row['reference'].'</td>'
                                . '<td class="title_box">'.$row['namePdt'].'</td>'
                                . '<td class="title_box">'.$row['nameAtt'].'</td>'
                                . '<td class="title_box">'.$row['ean13'].'</td>'
                                . '<td class="title_box">'.$row['count'].'</td>'
                                . '<td class="title_box">'.$row['stock'].'</td>'
                                . '<td class="title_box"><a class="edit btn btn-default" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&decrementInventoryCount&ean13decr='.$row['ean13'].'" title="Decrement count">'.$this->l('Count -1').'</a></td>' 
                                 . '<td class="title_box"><a class="edit btn btn-default" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&IncrementInventoryCount&ean13incr='.$row['ean13'].'" title="Increment count">'.$this->l('Count +1').'</a></td>'         
                            . '<td class="title_box">'.$applyCount.'</td>'
                            . '</tr>';
                }
                $html .=            '</tbody>
                            </table>
                          </br>
                          <a id="update_btn" rel="'.$this->l('Are you sure to update all actual stock with count? Just for scanned product').'" class="edit btn btn-default" href="'
                          . ''.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&applyAllCount" title="Update All stock">'.$this->l('Update all actual stock with count').'</a>
                          </br></br>
                          <a id="finish_btn" rel="'.$this->l('Are you sure you want to finish the inventory? All stock product not scanned  will be set to 0').'" class="edit btn btn-default" href="'
                          . ''.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&finishCount" title="Finish stock count">'.$this->l('Finish stock count').'</a>
                          </div>
                        </div>';
        }
        else
        {
            $html .= '</br><fieldset id="fieldset_0">
                        <legend>'.$this->l('Actual count').'</legend>
                    <div class="table-responsive clearfix">
                        <table class="table" cellspacing="0" cellpadding="0">
                            <thead>
                                <tr class="nodrag nodrop">
                                    <th class="title_box">
                                        '.$this->l('ID').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Reference').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Name').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Attrubute').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('EAN13').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Count').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Actual stock').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Decrement stock count').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Increment stock count').'
                                    </th>
                                    <th class="title_box">
                                        '.$this->l('Update actual stock with count').'
                                    </th>
                            </thead>
                                <tbody>';
            foreach ($tabInventory as $row)
            {
                $applyCount = '';
                if($row['count'] != $row['stock'])
                {
                    $applyCount = '<a class="button" href="'
                            . ''.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&applyCount&ean13apply='.$row['ean13'].'" title="Update stock">'.$this->l('Update stock').'</a>';
                }
                $html .= '<tr>'
                            . '<td class="title_box">'.$row['id_product'].'</td>'
                            . '<td class="title_box">'.$row['reference'].'</td>'
                            . '<td class="title_box">'.$row['namePdt'].'</td>'
                            . '<td class="title_box">'.$row['nameAtt'].'</td>'
                            . '<td class="title_box">'.$row['ean13'].'</td>'
                            . '<td class="title_box">'.$row['count'].'</td>'
                            . '<td class="title_box">'.$row['stock'].'</td>'
                            . '<td class="title_box"><a class="button" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&decrementInventoryCount&ean13decr='.$row['ean13'].'" title="Decrement count">'.$this->l('Count -1').'</a></td>' 
                             . '<td class="title_box"><a class="button" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&IncrementInventoryCount&ean13incr='.$row['ean13'].'" title="Increment count">'.$this->l('Count +1').'</a></td>'         
                        . '<td class="title_box">'.$applyCount.'</td>'
                        . '</tr>';
            }
            $html .=            '</tbody>
                        </table>
                        </br>
                          <a id="update_btn" class="edit btn btn-default" href="'
                          . ''.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&applyAllCount" title="Update All stock">'.$this->l('Update all stock').'</a>
                          </br></br>
                          <a id="finish_btn" class="edit btn btn-default" href="'
                          . ''.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&finishCount" title="Finish stock count">'.$this->l('Finish stock count').'</a>
                      </div>
                      </br></br>
                             <div class="panel-footer">
                                <a class="button" href="'.AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&clearTabInventory">
                                    <i class="process-icon-cancel"></i>
                                    '.$this->l('Clear table').'
                                </a>
                             </div>
                    </fieldset></br>';
        }
    
        return $html; 
    }
    
    public function renderExportInventory()
    {
        $fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Export options'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'radio',
                                                'id' => 'product',
						'label' => $this->l('Export product : '),
						'name' => 'product',
                                                'required' => true,
                                                'class' => 't',
                                                'br' => true,
                                                'values' => array(
                                                    array(
                                                    'id' => '0',
                                                    'value' => 0,
                                                    'label' => $this->l('Only scan products')
                                                    ),
                                                    array(
                                                    'id' => '1',
                                                    'value' => 1,
                                                    'label' => $this->l('Complete catalog')
                                                    )
                                                )   
					),
                                        array(
						'type' => 'radio',
                                                'id' => 'difference',
						'label' => $this->l('Difference : '),
						'name' => 'difference',
						'required' => true,
                                                'class' => 't',
                                                'br' => true,
                                                'values' => array(
                                                    array(
                                                    'id' => '0',
                                                    'value' => 0,
                                                    'label' => $this->l('Only products with stock differences')
                                                    ),
                                                    array(
                                                    'id' => '1',
                                                    'value' => 1,
                                                    'label' => $this->l('All products')
                                                    )
                                                )   
					),

					
				),
                                
                                'buttons' => array(
                                        'newBlock' => array(
                                            'title' => $this->l('Clear table'),
                                            'href' => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&clearTabInventory',
                                            'class' => 'pull-left',
                                            'icon' => 'process-icon-cancel'
                                        )
                                ),
				'submit' => array(
					'title' => $this->l('Export CSV'),
				)
			),
		);


		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table = $this->table;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$this->fields_form = array();
		$helper->module = $this;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'exportTabInventory';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', true).'&configure='.$this->name.'&inventory&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'base_url' => $this->context->shop->getBaseURL(),
            'fields_value' => array( 'product' => 1,
									'difference' => 1 )
		);

		$helper->override_folder = '/';

		return $helper->generateForm(array($fields_form));
        }
    
    
    
    public function clearTab()
    {
        if(Tools::isSubmit('clearTabIncrement'))
        {
            Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'ec_scan_ean13_increment`');
        }
        elseif(Tools::isSubmit('clearTabDecrement'))
        {
            Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'ec_scan_ean13_decrement`');
        }
        elseif(Tools::isSubmit('clearTabInventory'))
        {
            Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory`');
        }
    }
    
    public function clearTabAll()
    {
        Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'ec_scan_ean13_increment`');
        Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'ec_scan_ean13_decrement`');
        Db::getInstance()->Execute('DELETE FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory`');
    }

    public function exportTab()
    {
        if(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1')
        {
            $warehouse = Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'warehouse` WHERE id_warehouse = '.Configuration::get('EC_SCAN_WAREHOUSE')).';';
        }
        else
            $warehouse = '';
        if(Tools::isSubmit('exportTabIncrement'))
        {
            $tab = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'ec_scan_ean13_increment`');
            $fichier=fopen('../modules/ec_scan_ean13/export/export_increment.csv','w');
            $txt = 'id_product;reference;product_name;product_attribute;ean13;crement;stock;'.(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1'?'warehouse;':'').PHP_EOL;
            foreach ($tab as $row) {
                $txt .= $row['id_product'].';'.$row['reference'].';'.$row['namePdt'].';'.$row['nameAtt'].';'.$row['ean13'].';'.$row['increment'].';'.$row['stock'].';'.$warehouse.''.PHP_EOL;
            }
            fwrite($fichier,$txt);
            fclose($fichier);

            $fichier = '../modules/ec_scan_ean13/export/export_increment.csv'; 
        }
        elseif(Tools::isSubmit('exportTabDecrement'))
        {
            $txt = 'id_product;reference;product_name;product_attribute;ean13;crement;stock;'.(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1'?'warehouse;':'').PHP_EOL;
            $tab = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'ec_scan_ean13_decrement`');
            $fichier=fopen('../modules/ec_scan_ean13/export/export_decrement.csv','w');
            foreach ($tab as $row) {
                $txt .= $row['id_product'].';'.$row['reference'].';'.$row['namePdt'].';'.$row['nameAtt'].';'.$row['ean13'].';'.$row['decrement'].';'.$row['stock'].';'.$warehouse.''.PHP_EOL;
            }
            fwrite($fichier,$txt);
            fclose($fichier);
            $fichier = '../modules/ec_scan_ean13/export/export_decrement.csv'; 
        }
        elseif(Tools::isSubmit('exportTabInventory'))
        {
            $txt = 'id_product;reference;product_name;product_attribute;ean13;count;stock;'.(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1'?'warehouse;':'').PHP_EOL;
            $tab = Db::getInstance()->ExecuteS('SELECT * FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory`');
            $fichier=fopen('../modules/ec_scan_ean13/export/export_inventory.csv','w');
            if(tools::getValue('difference') == 0)
            {
                foreach ($tab as $row)
                {
                    if($row['count'] != $row['stock'])
                    {
                        $txt .= $row['id_product'].';'.$row['reference'].';'.$row['namePdt'].';'.$row['nameAtt'].';'.$row['ean13'].';'.$row['count'].';'.$row['stock'].';'.$warehouse.''.PHP_EOL;
                    }
                }
            }
            else
            {
                foreach ($tab as $row)
                {
                    $txt .= $row['id_product'].';'.$row['reference'].';'.$row['namePdt'].';'.$row['nameAtt'].';'.$row['ean13'].';'.$row['count'].';'.$row['stock'].';'.$warehouse.''.PHP_EOL;
                }
            }
            if(tools::getValue('product') ==  1)
            {
                $tabEanAtt = Db::getInstance()->executeS('SELECT ean13 FROM `'._DB_PREFIX_.'product_attribute` WHERE LENGTH(ean13) = 13');
                $tabEanPdt = Db::getInstance()->executeS('SELECT ean13 FROM `'._DB_PREFIX_.'product` WHERE LENGTH(ean13) = 13');
                $context = Context::getContext();
                $id_shop = $context->shop->id;
                $id_lang = $this->context->language->id;
                $tabean = array();
                foreach ($tab as $row2)
                    $tabean[] = $row2['ean13'];
                    
                $tabeanatt = array();
                
                foreach ($tabEanAtt as $row3)
                    $tabeanatt[] = $row3['ean13'];

                foreach($tabEanAtt as $eanAtt)
                {
                    if(!in_array($eanAtt['ean13'], $tabean))
                    {
                        $infoPtAtt = Db::getInstance()->getRow('SELECT id_product_attribute, id_product FROM `'._DB_PREFIX_.'product_attribute` WHERE ean13='.$eanAtt['ean13']);
                        $nomAtt = '';
                        $tab_id_att = Db::getInstance()->ExecuteS('SELECT id_attribute FROM `'._DB_PREFIX_.'product_attribute_combination` WHERE id_product_attribute = '.$infoPtAtt['id_product_attribute']);
                        foreach($tab_id_att as $id_att)
                            $nomAtt .= Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'attribute_lang` '
                                .'WHERE id_attribute = '.$id_att['id_attribute'].' AND id_lang = '.$id_lang).' '; 
                        
                        if(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1')
                        {
                            $stock = Db::getInstance()->getValue('SELECT physical_quantity FROM `'._DB_PREFIX_.'stock` '
                                . 'WHERE id_product = '.$infoPtAtt['id_product'].' AND id_product_attribute = '.$infoPtAtt['id_product_attribute'].' AND id_warehouse = '.Configuration::get('EC_SCAN_WAREHOUSE'));
                            if($stock == '')
                                $stock = 0;
                        }   
                        else
                            $stock = Db::getInstance()->getValue('SELECT quantity FROM `'._DB_PREFIX_.'stock_available` '
                                . 'WHERE id_product = '.$infoPtAtt['id_product'].' AND id_product_attribute = '.$infoPtAtt['id_product_attribute'].' AND id_shop = '.$id_shop);
                        $nomPdt = Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'product_lang` '
                        . 'WHERE id_product = '.$infoPtAtt['id_product'].' AND id_shop = '.$id_shop.' AND id_lang = '.$id_lang);
                        $refPdt = Db::getInstance()->getValue('SELECT reference FROM `'._DB_PREFIX_.'product` '
                        . 'WHERE id_product = '.$infoPtAtt['id_product']);
                        $txt .= $infoPtAtt['id_product'].';'.$refPdt.';'.$nomPdt.';'.$nomAtt.';'.$eanAtt['ean13'].';0;'.$stock.';'.$warehouse.''.PHP_EOL;
                    } 

                }
                foreach($tabEanPdt as $eanPdt)
                {
                    if(!in_array($eanPdt['ean13'], $tabean))
                    {
                        if(!in_array($eanPdt['ean13'], $tabeanatt))
                        {
                            $infoPtAtt = Db::getInstance()->getRow('SELECT id_product FROM `'._DB_PREFIX_.'product` WHERE ean13='.$eanPdt['ean13']);
                            if(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1')
                            {
                                $stock = Db::getInstance()->getValue('SELECT physical_quantity FROM `'._DB_PREFIX_.'stock` '
                                . 'WHERE id_product = '.$infoPtAtt['id_product'].' AND id_product_attribute = 0 AND id_warehouse = '.Configuration::get('EC_SCAN_WAREHOUSE'));
                                if($stock == '')
                                    $stock = 0;
                            }
                            else
                                $stock = Db::getInstance()->getValue('SELECT quantity FROM `'._DB_PREFIX_.'stock_available` '
                                . 'WHERE id_product = '.$infoPtAtt['id_product'].' AND id_product_attribute = 0 AND id_shop = '.$id_shop);
                            $nomPdt = Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'product_lang` '
                            . 'WHERE id_product = '.$infoPtAtt['id_product'].' AND id_shop = '.$id_shop.' AND id_lang = '.$id_lang);
                            $refPdt = Db::getInstance()->getValue('SELECT reference FROM `'._DB_PREFIX_.'product` '
                            . 'WHERE id_product = '.$infoPtAtt['id_product']);
                            $txt .= $infoPtAtt['id_product'].';'.$refPdt.';'.$nomPdt.';;'.$eanPdt['ean13'].';0;'.$stock.';'.$warehouse.''.PHP_EOL;
                        }
                    } 
                }
            }
            fwrite($fichier,$txt);
            fclose($fichier);
            $fichier = '../modules/ec_scan_ean13/export/export_inventory.csv'; 
            
        }
        $fichier_taille = filesize($fichier);
        header("Content-disposition: attachment; filename=$fichier");
        header("Content-Type: application/force-download");
        header("Content-Transfer-Encoding: application/octet-stream");
        header("Content-Length: $fichier_taille");
        header("Pragma: no-cache");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0, public");
        header("Expires: 0");
        readfile($fichier);
    }
    
    public function inventoryCountDecrement()
    {
        if(Tools::isSubmit('decrementInventoryCount')) 
        {
            if(Db::getInstance()->getValue('SELECT count FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory` WHERE ean13="'.Tools::getValue('ean13decr').'"') > 0)
            {
                Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_inventory` SET count = count-1 WHERE ean13="'.Tools::getValue('ean13decr').'"');
                $this->_html .= $this->displayConfirmation($this->l('Count updated'));
            } 
            else
                $this->_html .= $this->displayError($this->l('Unauthorized negative count.'));
        }
        elseif(Tools::isSubmit('IncrementInventoryCount'))
        {
            Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_inventory` SET count = count+1 WHERE ean13="'.Tools::getValue('ean13incr').'"');
            $this->_html .= $this->displayConfirmation($this->l('Count updated'));
        }
    }
    
    public function finishStockCount()
    {

        $tab_ean13_attribute = Db::getInstance()->ExecuteS('SELECT ean13 FROM `'._DB_PREFIX_.'product_attribute`');
        $tab_ean13_inventory = Db::getInstance()->ExecuteS('SELECT ean13 FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory`');
        foreach($tab_ean13_attribute as $ean13_attribute)
        {
            if($ean13_attribute['ean13'] != '' && $ean13_attribute['ean13'] != 0)
            {
                $update = true;
                foreach($tab_ean13_inventory as $ean13_inventory)
                {
                    if($ean13_attribute['ean13'] == $ean13_inventory['ean13'])
                        $update = false;
                }
                if($update == true)
                    $this->updateStock($ean13_attribute['ean13'],1);
            }
        }

        $tab_ean13_product = Db::getInstance()->ExecuteS('SELECT ean13, id_product FROM `'._DB_PREFIX_.'product`');
        $tab_ean13_inventory = Db::getInstance()->ExecuteS('SELECT ean13 FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory`');
        foreach($tab_ean13_product as $ean13_product)
        {
            if($ean13_product['ean13'] != '' && $ean13_product['ean13'] != 0)
            {
                if(Db::getInstance()->getValue('SELECT COUNT(id_product) FROM `'._DB_PREFIX_.'product_attribute` WHERE id_product = '.$ean13_product['id_product']) == 0)
                {
                    
                    $update = true;
                    foreach($tab_ean13_inventory as $ean13_inventory)
                    {
                        if($ean13_product['ean13'] == $ean13_inventory['ean13'])
                            $update = false;
                    }
                    if($update == true)
                        $this->updateStock($ean13_product['ean13'],1);
                }
            }
                
            
        }
    }
    
    public function updateAllStock()
    {
        $tab_update = Db::getInstance()->ExecuteS('SELECT ean13 FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory` WHERE count != stock');
        foreach($tab_update as $update)
            $this->updateStock($update['ean13']);
    }
    
    
    public function updateStock($ean13, $finish = 0)
    {
        
        $context = Context::getContext();
        $id_shop = $context->shop->id;
        
        $id_lang = $this->context->language->id;
        $nomAtt = '';
        $count = 0;
        if($finish == 0)
            $count = Db::getInstance()->getValue('SELECT count FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory` WHERE ean13='.$ean13);
        
        if ($infoPtAtt = Db::getInstance()->getRow('SELECT id_product_attribute, id_product FROM `'._DB_PREFIX_.'product_attribute` WHERE ean13='.$ean13))
        {
            $id_product = $infoPtAtt['id_product'];
            $id_product_attribute = $infoPtAtt['id_product_attribute'];
            $tab_id_att = Db::getInstance()->ExecuteS('SELECT id_attribute FROM `'._DB_PREFIX_.'product_attribute_combination` WHERE id_product_attribute = '.$id_product_attribute);
            foreach($tab_id_att as $id_att)
                $nomAtt .= Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'attribute_lang` '
                    .'WHERE id_attribute = '.$id_att['id_attribute'].' AND id_lang = '.$id_lang).' ';  
        }
        else
        {
            $id_product = Db::getInstance()->getValue('SELECT id_product FROM `'._DB_PREFIX_.'product` WHERE ean13='.$ean13);
            $id_product_attribute = 0;
        }
        $nomPdt = Db::getInstance()->getValue('SELECT name FROM `'._DB_PREFIX_.'product_lang` '
                . 'WHERE id_product = '.$id_product.' AND id_shop = '.$id_shop.' AND id_lang = '.$id_lang);
    
        if(Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT') == '1')
        {
            $stock = Db::getInstance()->getValue('SELECT physical_quantity FROM `'._DB_PREFIX_.'stock` '
                . 'WHERE id_product = '.$id_product.' AND id_product_attribute = '.$id_product_attribute.' AND id_warehouse = '.Configuration::get('EC_SCAN_WAREHOUSE'));  
            //$price = Db::getInstance()->getValue('SELECT price_te FROM `'._DB_PREFIX_.'stock` WHERE id_product = '.$id_product.' AND id_product_attribute = '.$id_product_attribute.'  AND id_warehouse = '.Configuration::get('EC_SCAN_WAREHOUSE'));
            $price = Db::getInstance()->getValue('SELECT wholesale_price FROM `'._DB_PREFIX_.'product` WHERE id_product = '.$id_product);
            if($id_product_attribute != 0)
            {
                $price_tmp = Db::getInstance()->getValue('SELECT wholesale_price FROM `'._DB_PREFIX_.'product_attribute` WHERE id_product_attribute = '.$id_product_attribute);
                if((float)$price_tmp != 0)
                    $price = $price_tmp;
            }
            $warehouse = new Warehouse(Configuration::get('EC_SCAN_WAREHOUSE'));
            $stock_manager = StockManagerFactory::getManager();
            if($stock == '')
            {
                
                $stock = 0;
            } 
            $newStock = $count - $stock;
            
            if($newStock > 0)
            {
                if(!$stock_manager->addProduct($id_product, $id_product_attribute, $warehouse, $newStock, 4, $price))
                {
                    $this->_html .= $this->displayError($this->l('An error occurred. No stock was added for the product id :'.$id_product));
                    return;
                }
                else
                    StockAvailable::synchronize($id_product); 
            }
            else
            {
                if(!$stock_manager->removeProduct($id_product, $id_product_attribute, $warehouse, abs($newStock), 4, $price))
                {
                    $this->_html .= $this->displayError($this->l('An error occurred. No stock was removed for the product id :'.$id_product));
                    return;
                }
                else
                    StockAvailable::synchronize($id_product); 
            }
        }
        else
        {
            $stock = Db::getInstance()->getValue('SELECT quantity FROM `'._DB_PREFIX_.'stock_available` '
            . 'WHERE id_product = '.$id_product.' AND id_product_attribute = '.$id_product_attribute.' AND id_shop = '.$id_shop);
            $newStock = $count - $stock;
            StockAvailable::updateQuantity($id_product,$id_product_attribute,$newStock,$id_shop);
        }
        $this->checkEanStock($ean13, $count);
            


        Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_inventory` SET stock = '.$count.' WHERE ean13="'.$ean13.'"');

        $this->_html .= $this->displayConfirmation($this->l('The stock have been updated, it is ').''.$count.''.$this->l(' for the product ').''.$nomPdt.' '.$nomAtt.', ean '.$ean13);
        
        
    }
    
    public function checkEanStock($ean13, $stock)
    {
        if(Db::getInstance()->getValue('SELECT stock FROM `'._DB_PREFIX_.'ec_scan_ean13_increment` '
                . 'WHERE ean13 = '.$ean13) != $stock)
        {
            Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_increment` SET stock = '.$stock.' WHERE ean13="'.$ean13.'"');
        }
        if(Db::getInstance()->getValue('SELECT stock FROM `'._DB_PREFIX_.'ec_scan_ean13_decrement` '
                . 'WHERE ean13 = '.$ean13) != $stock)
        {
            Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_decrement` SET stock = '.$stock.' WHERE ean13="'.$ean13.'"');
        }
        if(Db::getInstance()->getValue('SELECT stock FROM `'._DB_PREFIX_.'ec_scan_ean13_inventory` '
                . 'WHERE ean13 = '.$ean13) != $stock)
        {
            Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'ec_scan_ean13_inventory` SET stock = '.$stock.' WHERE ean13="'.$ean13.'"');
        }
                
    }    
    
    public function install() {
        if (parent::install())
        {
                /* Creates tables*/
                Configuration::updateValue('EC_SCAN_WAREHOUSE', '1');
                $res = $this->createTables();
                return (bool)$res;
        }
        return false;        
    }

    public function uninstall() {
        if (parent::uninstall())
        {
                $res = $this->deleteTables();
                return (bool)$res;
        }
        return false;
    }

    protected function createTables()
	{

		$res = (bool)Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'ec_scan_ean13_increment` (
				`id_product` int(10) NOT NULL,
                `reference` varchar(125) NOT NULL,
                `namePdt` varchar(125) NOT NULL,
				`nameAtt` varchar(100) NOT NULL,
                `ean13` varchar(15) NOT NULL,
                `increment` int(10) NOT NULL,
                `stock` int(10) NOT NULL,
				PRIMARY KEY (`namePdt`, `nameAtt`, `ean13`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');
                
                $res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'ec_scan_ean13_decrement` (
				`id_product` int(10) NOT NULL,
                `reference` varchar(125) NOT NULL,
                `namePdt` varchar(125) NOT NULL,
				`nameAtt` varchar(100) NOT NULL,
                `ean13` varchar(15) NOT NULL,
                `decrement` int(10) NOT NULL,
                `stock` int(10) NOT NULL,
				PRIMARY KEY (`namePdt`, `nameAtt`, `ean13`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');
                
                $res &= Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'ec_scan_ean13_inventory` (
				`id_product` int(10) NOT NULL,
                `reference` varchar(125) NOT NULL,
                `namePdt` varchar(125) NOT NULL,
				`nameAtt` varchar(100) NOT NULL,
                `ean13` varchar(15) NOT NULL,
                `count` int(10) NOT NULL,
                `stock` int(10) NOT NULL,
				PRIMARY KEY (`namePdt`, `nameAtt`, `ean13`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;
		');



		return $res;
	}

	/**
	 * deletes tables
	 */
	protected function deleteTables()
	{
             
		return Db::getInstance()->execute('
			DROP TABLE IF EXISTS `'._DB_PREFIX_.'ec_scan_ean13_inventory`, `'._DB_PREFIX_.'ec_scan_ean13_decrement`, `'._DB_PREFIX_.'ec_scan_ean13_increment`;
		');
	}
}
