<?php
/**
 * EasyUpdate module
 *
 * @category Prestashop
 * @category Module
 * @author Samdha <contact@samdha.net>
 * @copyright Samdha
 * @license commercial license see license.txt
 * @author logo Oxygen Team http://www.oxygen-icons.org/
 * @license logo http://www.gnu.org/copyleft/gpl.html GPLv3
 * @version 2.4
**/
@ini_set('display_errors', 'on');
@set_time_limit(600);
// Suppress DateTime warnings http://www.php.net/manual/fr/function.date-default-timezone-get.php#104052
date_default_timezone_set(@date_default_timezone_get());

if (!defined('DS'))
	define('DS', DIRECTORY_SEPARATOR);

// For PHP < 5.2.0
if( !function_exists('error_get_last') ) {
    set_error_handler(
        create_function(
            '$errno,$errstr,$errfile,$errline,$errcontext',
            '
                global $__error_get_last_retval__;
                $__error_get_last_retval__ = array(
                    \'type\'        => $errno,
                    \'message\'        => $errstr,
                    \'file\'        => $errfile,
                    \'line\'        => $errline
                );
                return false;
            '
        )
    );
    function error_get_last() {
        global $__error_get_last_retval__;
        if( !isset($__error_get_last_retval__) ) {
            return null;
        }
        return $__error_get_last_retval__;
    }
}

// from wordpress
// For PHP < 5.2.0
if ( !function_exists('json_encode') ) {
	function json_encode( $string ) {
		require_once( dirname(__FILE__).DS.'classes'.DS.'class-json.php' );
		$wp_json = new Services_JSON();
		return $wp_json->encodeUnsafe( $string );
	}
}


$moduleDir = dirname(__FILE__);
require(dirname(__FILE__).DS.'classes'.DS.'updateStep.php');
/**
 * start
 * downloadPrestashop
 * extractPrestashop -> error -> deleteTmp2 
 * listFilesToBackup
 * backupFiles
 * backupDatabase
 * replaceFiles
 * executeScript
 * deleteTmp
 * 
 **/
$step = isset($_GET['nextStep'])?$_GET['nextStep']:-1;
switch ($step) {
    case 'start' : // create config file
        require($moduleDir.'/../../config/config.inc.php');
        include_once(_PS_ROOT_DIR_.DS.'init.php');
        if (isset($_GET['back_up']))
		{
			if($_GET['back_up'] == 'true')
			{
				Configuration::updateValue('EC_DB_BP','yes');
			}
			else
			{
				Configuration::updateValue('EC_DB_BP','no');
			}
		}

		updateTools::init($moduleDir);
		updateTools::log_message("main\tStarting update process");
		updateTools::log_message("main\tCurrent version : "._PS_VERSION_);
		updateTools::log_message("main\tArchive to install : ".base64_decode(Tools::getValue('url')));
		
        if (($module = Module::getInstanceByName('easyupdate')) &&
            ($module->active))
            $result = $module->writeConfigFile('downloadPrestashop');
        else
            die();
        break;
    case 'preRestore' : // create config file
        require($moduleDir.'/../../config/config.inc.php');
        include_once(_PS_ROOT_DIR_.DS.'init.php');
		
		updateTools::init($moduleDir);
		updateTools::log_message("main\tStarting restore process");
		updateTools::log_message("main\tCurrent version : "._PS_VERSION_);
        
        if (($module = Module::getInstanceByName('easyupdate')) &&
            ($module->active))
            $result = $module->writeConfigFile('preRestoreDatabase');
        else
            die();
        break;
    case 'preDeleteBackup' : // create config file
        require($moduleDir.'/../../config/config.inc.php');
        include_once(_PS_ROOT_DIR_.DS.'init.php');
		
		updateTools::init($moduleDir);
		updateTools::log_message("main\tStarting delete backup process");
		updateTools::log_message("main\tCurrent version : "._PS_VERSION_);
        
        if (($module = Module::getInstanceByName('easyupdate')) &&
            ($module->active))
            $result = $module->writeConfigFile('deleteBackup');
        else
            die();
        break;

    default :
	    require ($moduleDir.DS.'config.php');
    	$update_step = new updateStep($moduleDir);
    	if (method_exists($update_step, $step))
    		$result = call_user_func(array($update_step, $step));
    	else {
			$result = array();
			$result['nextStep'] = 'error';
			$result['error'] = -1;
			$result['information'] = updateTools::l('Step unknow : ').$step;
    	}
    	break;
}

updateTools::close_log();
updateIO::closeFTP();
if (updateTools::detect_apache_mod('mod_evasive')) sleep(1);
echo json_encode($result);
die();
?>