/**
* 2014 Dejavu Arts S.L.
*
* NOTICE OF LICENSE
*
* This source file is subject to the copyright.
*
* DISCLAIMER
*
* Do not edit or add to this file.
*
* @author    Dejavu Arts S.L. <desarrollo@dejavu.es>
* @site www.dejavu.es
* @copyright Copyright (c) 2014 Dejavu Arts S.L.
*   @license   Copyright. All Rights Reserved
*/

;(function ($) {
	if ($.type($.dejavu) === 'undefined')
	{
		$.dejavu = {};
	}
	
	$.dejavu.upProductQuantityClick = function(e) {
		
		e.preventDefault();
		var url = link;
		url += '&task=updateProductCartQuantity'; 
		url += '&id_product='+ $(this).data('id');
		url += '&id_product_attribute='+ $(this).data('ipa');
		url += '&quantity=1';
		//console.log(url);
		window.location = url;
	};

	$.dejavu.downProductQuantityClick = function(e) {
		e.preventDefault();
		
		var url = link;
		url += '&task=updateProductCartQuantity'; 
		url += '&id_product='+ $(this).data('id');
		url += '&id_product_attribute='+ $(this).data('ipa');
		url += '&quantity=-1';
		//console.log(url);
		window.location = url;
	};

	$.dejavu.applyProductDiscountClick = function (e) {	
		e.preventDefault();
		var discount = $(this).prev().val();
		
		discount = discount.replace(' ', '').replace(',', '.');
		
		var url = link;
		url += '&task=applyDiscount'; 
		url += '&id_product='+ $(this).prev().data('id');
		url += '&id_product_attribute='+ $(this).prev().data('ipa');
		url += '&discount='+ discount;
		//console.log(url);
		window.location = url;
	};
	
	$.dejavu.removeProductClick = function(e){
		e.preventDefault();
		
		var url = link;
		url += '&task=updateProductCartQuantity'; 
		url += '&id_product='+ $(this).data('id');
		url += '&id_product_attribute='+ $(this).data('ipa');
		url += '&quantity=0';
		//console.log(url);
		window.location = url;
	};
	
	$(function (){		
		if (!id_order)
		{
			$('.djvoc_remove')
				.button({
					icons: {
						primary: "ui-icon-trash"
					},
					text: false
				})
				.click($.dejavu.removeProductClick);
			
			$('.djvoc_upProductQuantity')
				.click($.dejavu.upProductQuantityClick);
				
			$('.djvoc_downProductQuantity')
				.click($.dejavu.downProductQuantityClick);
				
			$('.djvoc_applyProductDiscountButton')
				.button()
				.click($.dejavu.applyProductDiscountClick);
		}
		else
		{		
			$('.djvoc_applyDiscountButton').remove();
			$('.djvoc_upProductQuantity').remove();
			$('.djvoc_downProductQuantity').remove();
			$('.djvoc_remove').remove();
		}
	});			
})(jQuery);