<div id="menudiv-profiles"  class="tabItem {$profiles.selected_tab} panel form-horizontal" {if (empty($profiles.selected_tab))}style="display:none;"{/if}>
    <br />
    <input type="hidden" id="xsd_path" value="{$profiles.xsd_path}" />
    <input type="hidden" id="xsd_operations_url" value="{$profiles.xsd_operations_url}" />
    <input type="hidden" id="xsd_ajax_error" value="{$profiles.xsd_ajax_error}" />

    <div class="margin-form col-lg-offset-3">
        <div style="font-size:1.2em;line-height:140%;" class="amz-info-level-info {if $psIs16}alert alert-info{/if}">
            <ul>
                <li>{l s='Profiles are used for products creation mode. Please setup one profile per Amazon category set.' mod='amazon'}</li>
                <li>{l s='The valid values are described in the Amazon file templates. You could find template at this URL:' mod='amazon'}</li>
                <li><a href="{$profiles.templates_url}" target="_blank">{$profiles.templates_url}</a></li>
            </ul>
        </div>
    </div>
            
    {if $psIs16}<div class="form-group">{/if}
    <label class="control-label col-lg-3">{l s='Profiles Configuration' mod='amazon'}</label>
    <div class="margin-form col-lg-offset-9" class="profiles">
        <div id="profile-add">
            <span class="profile-add-img"><img src="{$profiles.images_url}add.png" /></span>
            <span class="profile-add">{l s='Add a profile to the list' mod='amazon'}</span>        
        </div>
        <div class="error" id="ajax-error" style="display:none;margin-top:10px"></div>
    </div>
    {if $psIs16}</div>{/if}
    <br /><br />  
    
    <!-- Container to receive the new profiles -->
    <div id="profile-container" class=""></div>

    <!-- stored profiles -->
    <div id="profile-items">
        {foreach from=$profiles.config key=profile_key item=profile}

            {if ! $profile.master}
                <!-- profile header -->
                <div class="profile-header form-group" id="profile-header-{$profile.profile_id}">
                    <br />
                    <label class="profile-obj-title col-lg-3" style="color:navy">{$profile.name}</label>
                    <div class="margin-form col-lg-9">
                        <table {if $psIs16}width="90%"{/if}>
                            <tr>
                                <td>
                                    <span class="type">{$profile.type}</span>
                                </td>
                                <td align="center" width="50px">
                                    <img src="{$profiles.images_url}cross.png"  class="profile-del-img" alt="{l s='Delete' mod='amazon'}" rel="{$profile.profile_id}" />
                                </td>
                                <td align="center" width="50px">
                                    <img src="{$profiles.images_url}edit.png" class="profile-edit-img" alt="{l s='Edit' mod='amazon'}" rel="{$profile.profile_id}" />
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
                <!-- eof profile header -->
            {/if}

            <!-- div profile -->
            <div id="{$profile.profile_div_id}" class="{$profile.profile_class} form-group">
                {if $profile.master}
                    <span class="profile-del">{l s='Remove this profile from the list' mod='amazon'}<img src="{$profiles.images_url}cross.png" class="profile-del-img2" /></span>
                    {if $psIs16}<h2>{else}<h3>{/if}{l s='New Profile' mod='amazon'}{if $psIs16}</h2>{else}</h3>{/if}
                    <br />
                    <label class="profile-obj-title col-lg-3" style="color:green">{l s='Profile Name' mod='amazon'}</label>
                    <div class="margin-form col-lg-9">
                        <input type="text" name="profiles[name][_key_]" style="width:200px" value="{$profile.name}" />

                        <p class="profile-help">{l s='Please give a friendly name to remind this profile' mod='amazon'}
                    </div>

                {else}
                    <input type="hidden" name="profiles[name][_key_]" value="{$profile.name}" />
                {/if}

                <!-- Universe Selector -->
                <label class="profile-obj-title col-lg-3">{l s='Category Name' mod='amazon'}</label>
                <div class="margin-form col-lg-9">
                    <select name="profiles[universe][_key_]" class="profile-universe" style="width:250px; display: inline;" />
                    <option value=""></option>            
                    {foreach from=$profile.universes key=universe_key item=universe}
                        <option value="{$universe_key}" {if $universe.selected}selected{/if}>{$universe.name}</option>
                    {/foreach}
                    </select><span class="amz-required">*</span>
                    <p class="profile-help">
                        {l s='Choose the main universe for this profile.' mod='amazon'}<br />
                        {l s='Do not forget to click on the save button at the bottom right of the page !' mod='amazon'}<br />

                        {if $profiles.categories_english}
                            <br />
                            <span style="color:navy">
                                {l s='For an improved scalability, the categorization is in english. You can use a translator for a best understanding.' mod='amazon'}<br />
                                {l s='By this way, you are insured to get fresh datas and effective categories all the time. ' mod='amazon'}
                            </span>
                        {/if}
                    </p>

                    <span class="xsd-load" style="display:none;"><img src="{$profiles.images_url}small-loader.gif" />&nbsp;&nbsp;<b>{l s='Loading data from Amazon' mod='amazon'}</b></span>
                    <span class="fetch-result"></span>
                </div>
                <!-- eof Universe Selector -->    

                <!-- Product Type Selector -->
                <label class="profile-obj-title col-lg-3">{l s='Product Type' mod='amazon'}</label>
                <div class="margin-form col-lg-9">
                    <select name="profiles[product_type][_key_]" class="product_type" style="width:400px; display: inline;">
                        <option value="{$profile.product_type}" selected="selected">{$profile.product_type}</option>
                    </select>
                    <span class="amz-required">*</span>&nbsp;&nbsp;
                    <img src="{$profiles.images_url}refresh_static.png" class="type_reload" rel="{$profiles.images_url}refresh.png" />
                    <p class="profile-help">{l s='Please select the main category for this profile' mod='amazon'}</p>
                </div>
                <div class="cleaner"></div>
                <!-- eof Product Type Selector -->

                <!-- Extra Fields and Specifics Fields -->
                <label class="profile-obj-title col-lg-3">{l s='Specifics Fields' mod='amazon'}</label>
                <div class="margin-form col-lg-9">
                    <div class="mandatory_fields">
                        {$profile.specifics}
                    </div>
                    <p class="profile-help"><span class="extra-required">*</span>&nbsp;&nbsp;{l s='Please fill the mandatory fields for this profile' mod='amazon'}</p>
                </div>
                <div class="cleaner"></div>
                <!-- eof Extra Fields and Specifics Fields -->

                {if $profile.associations}
                    <!-- associations size/color -->
                    <div id="associations">
                        <label class="profile-obj-title control-label col-lg-3" style="color:grey">{l s='Association for' mod='amazon'}</label>  
                        <div class="margin-form col-lg-9">
                            {l s='Size' mod='amazon'}:&nbsp;
                            <select name="profiles[field_size][_key_]" value="" style="width: 100px; display: inline;">
                                <option value="0">{l s='Choose' mod='amazon'}</option>
                                {foreach from=$profile.field_size key=id_attribute_group item=attribute}
                                    <option value="{$id_attribute_group}" {if $attribute.selected}selected{/if}>{$attribute.name}</option>
                                {/foreach}
                            </select>&nbsp;&nbsp;&nbsp;

                            {l s='Color' mod='amazon'}:&nbsp;
                            <select name="profiles[field_color][_key_]" value="" style="width: 100px; display: inline;">
                                <option value="0">{l s='Choose' mod='amazon'}</option>
                                {foreach from=$profile.field_color key=id_attribute_group item=attribute}
                                    <option value="{$id_attribute_group}" {if $attribute.selected}selected{/if}>{$attribute.name}</option>
                                {/foreach}                                
                            </select>
                            <p class="profile-help">
                                {l s='Please select the field which will be associated with color and size fields' mod='amazon'}
                            </p>
                        </div>
                    </div>
                {else}
                    <input type="hidden" name="profiles[field_size][_key_]" value="0" />
                    <input type="hidden" name="profiles[field_color][_key_]" value="0" />
                    <!-- associations -->
                {/if}

                {if $profiles.expert_mode}
                    <hr style="width:30%" />
                    <div class="profiles-code-exempt">
                        <!-- EAN exemption -->
                        <label class="profile-obj-title control-label col-lg-3 profile-code-exemption-l">{l s='Code Exemption' mod='amazon'}</label>
                        <div class="margin-form col-lg-9">
                            <span style="font-size:1.1em;color:black;">{l s='Use EAN/UPC exemption for this profile' mod='amazon'}</span><br />
                            <select name="profiles[code_exemption][_key_]" style="width:200px;">
                                <option value="{$profiles.exemptions.none}" {if $profile.code_exemption == $profiles.exemptions.none}selected{/if}></option>
                                <option value="{$profiles.exemptions.compatibility}" {if $profile.code_exemption == $profiles.exemptions.compatibility}selected{/if} style="display:none"></option>
                                <option value="{$profiles.exemptions.model_number}" {if $profile.code_exemption == $profiles.exemptions.model_number}selected{/if}>Model Number</option>
                                <option value="{$profiles.exemptions.model_name}" {if $profile.code_exemption == $profiles.exemptions.model_name}selected{/if}>Model Name</option>
                                <option value="{$profiles.exemptions.mfr_part_number}" {if $profile.code_exemption == $profiles.exemptions.mfr_part_number}selected{/if}>Manufacturer Part Number</option>
                                <option value="{$profiles.exemptions.catalog_number}" {if $profile.code_exemption == $profiles.exemptions.catalog_number}selected{/if}>Catalog Number</option>
                                <option value="{$profiles.exemptions.generic}" {if $profile.code_exemption == $profiles.exemptions.generic}selected{/if}>Generic</option>
                            </select>
                            <input name="profiles[code_exemption_options][_key_][private_label]" type="checkbox" value="1" {if $profile.code_exemption_options.private_label}checked{/if} />&nbsp;&nbsp;<span style="font-size:0.9em;color:black;">{l s='Private Label' mod='amazon'}</span>
                        </div>
                    </div>
                    <hr style="width:30%" />
                {else}
                    <input name="profiles[code_exemption][_key_]" type="hidden" value="0" />
                    <!-- eof exemption -->
                {/if}

                {if $profiles.expert_mode}
                    <label class="profile-obj-title control-label col-lg-3">{l s='SKU as Supplier Reference' mod='amazon'}</label>
                    <div class="margin-form col-lg-9">
                        <span style="position:relative;">
                            <input name="profiles[sku_as_supplier_reference][_key_]" type="checkbox" value="1" {if $profile.sku_as_supplier_reference}checked{/if} />&nbsp;&nbsp;<span style="font-size:1.1em;color:black;">{l s='Send the Reference/SKU as the Supplier Reference' mod='amazon'}</span>
                            <input name="profiles[sku_as_sup_ref_unconditionnaly][_key_]" type="checkbox" value="1" {if $profile.sku_as_sup_ref_unconditionnaly}checked{/if} />&nbsp;&nbsp;<span style="font-size:0.9em;color:black;">{l s='Unconditionnaly' mod='amazon'}</span>
                        </span>
                    </div><br />  
                    <hr style="width:30%" />
                {else}
                    <input name="profiles[sku_as_supplier_reference][_key_]" type="hidden" value="0" />
                    <input name="profiles[sku_as_sup_ref_unconditionnaly][_key_]" type="hidden" value="0" />
                    <!-- eof exemption -->
                {/if}   

                <!-- Recommended Browse Nodes
                // https://catalog-mapper-fr.amazon.fr/catm/classifier/ProductClassifier.amzn
                // https://sellercentral.amazon.fr/gp/help/help-page.html/ref=pt_200956770_cont_scsearch?ie=UTF8&itemID=200956770
                // Browse Node ID                
                -->
                <div style="clear:both">
                    <label class="profile-obj-title control-label col-lg-3">{l s='Recommended Browse Node' mod='amazon'}</label>
                    <div class="margin-form col-lg-9">
                        {foreach from=$profile.browse_nodes key=id_lang item=browse_node}
                        <div class="profile-browse-node">
                        <input type="text" name="profiles[browsenode_{$id_lang}][_key_]" style="width:100px; display: inline;margin:3px;" value="{$browse_node.value}" />
                            <img src="{$browse_node.flag}" alt="{$browse_node.language}" class="browse-lang-img" />&nbsp;
                            <span class="browse-lang-txt">{$browse_node.language}</span>
                        </div>
                        {/foreach}
                        <p class="profile-help">{l s='Amazon Browse Node ID' mod='amazon'}&nbsp; - &nbsp;
                            {l s='You can use the product classifier to get browse node IDs' mod='amazon'}:<br />
                            <a href="{$profile.classifier_url}" target="_blank" >{$profile.classifier_url}</a><br />
                            <strong style="color:orange">{l s='This option is mandatory for Canada, Europe, Japan' mod='amazon'}</strong><br />
                        </p>
                    </div>
                </div>
                <!-- eof Recommended Browse Nodes -->

                {if ($profiles.amazon_us || $profiles.amazon_in)}
                <!-- Item Type for USA -->
                <label class="profile-obj-title control-label col-lg-3">{l s='Item Type' mod='amazon'}</label>
                <div class="margin-form col-lg-9">
                    <input type="text" name="profiles[item_type][_key_]" style="width:180px; display: inline;" value="{$profile.item_type}" />
                    <img src="{$profiles.images_url}geo_flags/us.jpg" alt="USA" class="browse-lang-img" />
                    <img src="{$profiles.images_url}geo_flags/in.jpg" alt="India" class="browse-lang-img" />&nbsp;
                    <span class="browse-lang-txt">{l s='U.S.A. / India Only' mod='amazon'}</span><br />
                    
                    <p class="profile-help">{l s='Item Type' mod='amazon'}&nbsp; - &nbsp;
                        {l s='You can use the product classifier to get the item type' mod='amazon'}:<br />
                        <a href="https://catalog-mapper-na.amazon.com/catm/classifier/ProductClassifier.amzn" target="_blank" >https://catalog-mapper-na.amazon.com/catm/classifier/ProductClassifier.amzn</a><br />
                        <strong style="color:orange">{l s='This option is mandatory only for U.S.A. and could be mandatory for India' mod='amazon'}</strong><br />
                    </p>
                </div>  
                {/if}
                <hr style="width:30%" />
                <!-- Price Formula -->
                <!-- DEPRECATED
                <label class="profile-obj-title control-label col-lg-3">{l s='Price Formula' mod='amazon'}</label>
                <div class="margin-form col-lg-9">
                        <input type="text" name="profiles[formula][_key_]" style="width:200px" value="{$profile.formula}" />
                        <p class="profile-help">
                            {l s='Apply a specific price formula for selected categories which will override the main setting (Default Price Formula)' mod='amazon'}<br />
                            {l s='This formula could be a price a value or math (multiply, divide, addition, subtraction, percentages)' mod='amazon'}<br />
                                {l s="Use the @ symbol as price reference (eg: @ + 10 % mean you'll add 10 % to the initial price)" mod='amazon'}<br />
                            {l s='If you specify nothing, the main setting will be applied.' mod='amazon'}
                        </p>
                </div>
                -->
                <!-- eof Price Formula -->
                
                <label class="profile-obj-title control-label col-lg-3">{l s='Price Rule' mod='amazon'}</label>
                <div class="margin-form col-lg-9">
                    <select name="profiles[price_rule][_key_][type]" class="price-rule-type" value="" style="display: inline; max-width:150px;vertical-align: top;" />
                        <option value="percent" {if ($profile.price_rule.type == 'percent')}selected{/if}>{l s='Percentage' mod='amazon'}</option> 
                        {if isset($profile.price_rule.currency_sign)}
                        <option value="value" {if ($profile.price_rule.type == 'value')}selected{/if}>{l s='Value' mod='amazon'}</option> 
                        {/if}
                    </select>
                    &nbsp;&nbsp;
                    <div id="default-price-rule-{$id_lang}" class="default-price-rule" style="display: inline-block;">
                        {foreach from=$profile.price_rule.rule.from key=index item=value}
                            <div class="price-rule">
                                <input type="text" name="profiles[price_rule][_key_][rule][from][]" rel="from" style="width:50px" value="{$profile.price_rule.rule.from[$index]}" />&nbsp;&nbsp;{$profile.price_rule.currency_sign}
                                <span>
                                &nbsp;&nbsp;<img src="{$settings.images_url}slash.png" class="price-rule-slash" alt="" />&nbsp;&nbsp;
                                </span>
                                <input type="text" name="profiles[price_rule][_key_][rule][to][]" rel="to" style="width:50px" value="{$profile.price_rule.rule.to[$index]}" />&nbsp;&nbsp;{$profile.price_rule.currency_sign}
                                <span>
                                &nbsp;&nbsp;<img src="{$settings.images_url}next.png" class="price-rule-next" alt="" />&nbsp;&nbsp;
                                </span>                
                                <select name="profiles[price_rule][_key_][rule][percent][]" rel="percent" style="width:100px;{if ($profile.price_rule.type != 'percent')}display:none;{/if}" />
                                    <option></option> 
                                    {section name=price_rule_percent loop=99} 
                                    <option value="{$smarty.section.price_rule_percent.iteration}" {if $profile.price_rule.rule.percent[$index] == $smarty.section.price_rule_percent.iteration}selected{/if}>{$smarty.section.price_rule_percent.iteration} &#37;</option>  
                                    {/section}
                                    <option disabled>--</option> 
                                    {section name=price_rule_percent loop=99} 
                                    <option value="-{$smarty.section.price_rule_percent.iteration}" {if $profile.price_rule.rule.percent[$index] == ($smarty.section.price_rule_percent.iteration * -1)}selected{/if}>-{$smarty.section.price_rule_percent.iteration} &#37;</option>  
                                    {/section}                            
                                </select>
                                {if isset($profile.price_rule.currency_sign)}
                                    <select name="profiles[price_rule][_key_][rule][value][]" rel="value" style="width:100px;{if ($profile.price_rule.type != 'value')}display:none;{/if}" />
                                        <option></option> 
                                        {section name=price_rule_value loop=99} 
                                        <option value="{$smarty.section.price_rule_value.iteration}" {if $profile.price_rule.rule.value[$index] == $smarty.section.price_rule_value.iteration}selected{/if}>{$smarty.section.price_rule_value.iteration} {$profile.price_rule.currency_sign}</option>  
                                        {/section}
                                        <option disabled>--</option> 
                                        {section name=price_rule_value loop=99} 
                                        <option value="-{$smarty.section.price_rule_value.iteration}" {if $profile.price_rule.rule.value[$index] == ($smarty.section.price_rule_value.iteration * -1)}selected{/if}>-{$smarty.section.price_rule_value.iteration} {$profile.price_rule.currency_sign}</option>  
                                        {/section}
                                    </select>
                                {/if}
                                <span class="price-rule-add" {if $index > 0}style="display:none;"{/if}><img src="{$settings.images_url}plus.png"  alt="{l s='Add a rule' mod='amazon'}" /></span>
                                <span class="price-rule-remove" {if $index == 0}style="display:none;"{/if}><img src="{$settings.images_url}minus.png"  alt="{l s='Remove a rule' mod='amazon'}" /></span>
                            </div>
                        {/foreach}
                    </div>
                    <div style="clear:both">&nbsp;</div>
                    <p>{l s='You should configure a price rule in value or percentage for one or several prices ranges.' mod='amazon'}</p>
                </div>
     
                <hr style="width:30%" />
                <!-- Shipping Delay / Latency -->
                {if $profiles.expert_mode}
                    <label class="profile-obj-title control-label col-lg-3">{l s='Latency' mod='amazon'}</label>
                    <div class="margin-form col-lg-9">
                            <input type="text" name="profiles[latency][_key_]" style="width:40px" value="{$profile.latency}" />
                            <p class="profile-help">
                                {l s='Latency delay in days before this product will be shipped (ie: preparation time, your own delay before shipment)' mod='amazon'}<br />
                                {l s='It will be the default delay and could be override by another delay on the product sheet' mod='amazon'}<br />
                            </p>
                    </div>
                <!-- eof Shipping Delay / Latency -->
                {else}
                    <input name="profiles[latency][_key_]" type="hidden" value="0" />
                {/if}                  
                
                {if !$psIs16}<hr style="width:30%" />{/if}
            </div>
            <!-- eof div profile -->

        {/foreach}
    </div><!-- eof div profile items -->

    {$profiles.validation}
</div>