<?php

/**
 * Description of AmazonXmlParse
 *
 * @author Erick Turcios
 */
include 'Node.php';

class AmazonXmlParse {
    private $referenceTag="Product";    
    private $tagsForParsing = array("CompetitivePricing","SalesRankings","LowestOfferListings");
    private $tagsAsArray = array( "LowestOfferListings", "Weight", "ns2:Weight");
    private $parsedInstance = array();
    
    public function __construct(SimpleXMLElement $simpleXmlElement, $newReferenceTag=null, $newTagsForParsing=null) {
        
        if($newReferenceTag != null):
            $this->referenceTag = $newReferenceTag;
        endif;
        if($newTagsForParsing!=null):
            $this->tagsForParsing=$newTagsForParsing;
        endif;
        $xmlFile = dom_import_simplexml($simpleXmlElement)->ownerDocument;
        $productsArray=array();
        
        $parents = $xmlFile->getElementsByTagName($this->referenceTag);
        
        //get parents elements
        foreach($parents as $p):
            $parentName = $p->nodeName;
            $instance = new stdClass();
            $instance->$parentName=new stdClass();
            $instance->$parentName = $this->getElementAttributes($p, new stdClass());
            
            //looks for every defined tag
            foreach($this->tagsForParsing as $target):            
                
                $result = $p->getElementsByTagName($target);
                
                if($result->length > 0):
                    $instance->$parentName->$target=new stdClass();
                endif;
                
                foreach($result as $element): 
                    if(!Node::hasNoData($element->nodeName)):
                        $name = $element->nodeName;                    
                        if(in_array($name, $this->tagsAsArray)):
                            $array = array();
                        
                            if(isset($instance->$parentName->$target->$name)):
                                $array=$instance->$parentName->$target->$name;
                            else:
                                $instance->$parentName->$target->$name = array();
                            endif;                            
                            
                            $array[] = $this->getElementInstance($element, true);                                                
                            $instance->$parentName->$target->$name= $array;                            
                        else:
                            echo "entra aqui";
                           $instance->$parentName->$target->$name = $this->getElementInstance($element, false);                                                
                        endif;
                    endif;
                endforeach;
            endforeach;
            $productsArray[] = $instance;
        endforeach;
        
        $this->parsedInstance =  $productsArray;
    }
    
    private function getElementInstance(DOMElement $element, $asArray=false){
        //$elementInstance = new stdClass();
        $elementInstance = $this->getElementAttributes($element,new stdClass());
        $array = array();
        $arraysFound=array();
        
        foreach($element->childNodes as $child):
            $childName = $child->nodeName;
            if(!Node::hasNoData($childName) && $asArray):                
                if(!in_array($childName, $arraysFound)):
                    $arraysFound[] = $childName;
                endif;
                
                if(in_array($childName, $this->tagsAsArray)):
                    $array[$childName][] = $this->getElementInstance($element, true);                                                
                else:
                    $array[$childName][] = $this->getElementInstance($element, false);                                                
                endif;
            else:
                if(!Node::hasNoData($childName)):
                     if(in_array($childName, $this->tagsAsArray)):
                         $elementInstance->$childName = $this->getElementInstance($child, true);
                     else:
                         $elementInstance->$childName = $this->getElementInstance($child, false);
                     endif;
                elseif(trim($child->textContent) != ""):
                    $elementInstance->value=$child->nodeValue;
                endif;
            endif;
        endforeach;
        
        foreach($arraysFound as $r):
            $elementInstance->$r = $array[$r];
        endforeach;
        
        return $elementInstance;
    }
    
    private function getElementAttributes(DOMElement $element, stdClass $instance){                
        if(!$element->hasAttributes()):
            return $instance;
        endif;
        
        $instance->attr = array();
        
        foreach ($element->attributes as $attr):
          $attrName = $attr->nodeName;
          $attrValue = $attr->nodeValue;
          $instance->attr[$attrName] = $attrValue;
        endforeach;
        
        return $instance;
    }
    
    public function getParsedInstance(){
        return $this->parsedInstance;
    }
    
    public static function getSingleTagValues(SimpleXMLElement $simpleXmlElement, $searchedTags, $baseTag=null){
        $values=array();
        $parent = $baseTag;
        
        if($parent == null):
            foreach($searchedTags as $searchedTag):
                if($searchedTag==null):
                    return $values;
                else:
                    //convert simple xml to DOM
                    $xmlFile = dom_import_simplexml($simpleXmlElement)->ownerDocument;
                    $nodes = $xmlFile->getElementsByTagName($searchedTag);
                    foreach($nodes as $node):
                        
                        $i=count($values);
                        $values[] = array();
                        if(trim($node->textContent) != ""):
                           $values[$i]['value'] = $node->textContent;
                        endif;
                        
                        if($node->hasAttributes()):
                            
                            $values[$i]['attr'] = array();
                             foreach ($node->attributes as $attr):
                               $attrName = $attr->nodeName;
                               $attrValue = $attr->nodeValue;
                               $values[$i]['attr'][$attrName] = $attrValue;
                             endforeach;
                        endif;
                    endforeach;
                endif;
             endforeach;            
        else:            
            
            //convert simple xml to DOM
            $xmlFile = dom_import_simplexml($simpleXmlElement)->ownerDocument;                
            $parents = $xmlFile->getElementsByTagName($parent);

            foreach($parents as $p):                
                
                $parentValues = array();
                foreach($searchedTags as $searchedTag):
                    $nodes = $p->getElementsByTagName($searchedTag);
                    foreach($nodes as $node):
                        $i=count($parentValues);
                        
                        if(trim($node->textContent) != ""):
                           $parentValues[$i]['value'] = $node->textContent;
                        endif;
                        
                        
                        if($node->hasAttributes()):
                            
                            $parentValues[$i]['attr'] = array();
                             foreach ($node->attributes as $attr):
                               $attrName = $attr->nodeName;
                               $attrValue = $attr->nodeValue;
                               $parentValues[$i]['attr'][$attrName] = $attrValue;
                             endforeach;
                        endif;
                    endforeach;                        
                endforeach;
                $values[] = $parentValues;

            endforeach;
        endif;
        return $values;
    }
    
}

//-----------------------------------------------------------------------------------//
//------------------------------------------DEMO-------------------------------------//
//-----------------------------------------------------------------------------------//
/*
//$files = array("GetLowestOfferListingsForSKU.xml","GetCompetitivePricingForSKU - 1.xml","GetCompetitivePricingForSKU - 2.xml", "xmlOut.xml");
//$files = array("GetLowestOfferListingsForSKU.xml");
$files = array("out.xml");
//$p = new AmazonXmlParse(simplexml_load_file('xml/out.xml'));
$xml = simplexml_load_file('xml/xml3.out.xml');
print("<pre>".print_r(AmazonXmlParse::getSingleTagValues($xml, array("ASIN","Weight"),"Product"), true)."</pre>");

die;
foreach($files as $file):
    echo "<h1>".$file." - Static Function</h1>";
    $xml = simplexml_load_file('xml/'.$file);
    //using static function
    $c = AmazonXmlParse::getSingleTagValues($xml, array("ASIN","Weight"),"Product"); //
    print("<pre>".print_r($c, true)."</pre>");
    
    //echo "<h1>".$file." Class Instance</h1>";
    //$d = new AmazonXmlParse($xml, null, array("ASIN", "Weight"));
    //print("<pre>".print_r($d->getParsedInstance(), true)."</pre>");
endforeach;


*/  
?>