<?php

/**
 * Description of AmazonHTML
 *
 * @author Erick Turcios
 */
//require_once(_PS_MODULE_DIR_ . 'Amazon/validate/AmazonXSD.php'); //gets code for Amazon XML Schemas
require_once(dirname(__FILE__).'/AmazonXSD.php');

class AmazonHTML {
    
    private static $xsdUrl="https://images-na.ssl-images-amazon.com/images/G/01/rainier/help/xsd/release_1_9/";
    
    private static $attributes =  array( 'type'=>'type',
                                        'mandatory'=>'mandatory',
                                        'limit'=>'limit',
                                        'maxDigits'=>'maxDigits',
                                        'maxLength'=>'maxLength',
                                        'minLength'=>'minLength',
                                        'pattern'=>'pattern',
                                        'minValue'=>'minValue',
                                        'maxValue'=>'maxValue',
                                        'allowedValues'=>'allowedValues',
                                        'value'=>'value',
                                        'attr'=>'attr'
                                      );    
    
    public static function getXsdUrl(){
        return self::$xsdUrl;
        //return $_SERVER['SERVER_NAME']."/prestashop/modules/Amazon/xsd/";
    }
    
    public static function getAttrUsed(){
        return self::$attributes;
    }
    
    public static function isAttrUsed($key){
        return array_key_exists($key, self::$attributes);
    }
    
    public static function getUniverseFile($product=null){
        if($product==null):
            return "";
        endif;
        return self::getXsdUrl().$product.'.xsd';        
    }
    
    public static function getProductsCategories($selected=null) {
        $_element='';             
        try{
            $categories= AmazonXSD::getCategories();
            
            sort($categories, SORT_NATURAL | SORT_FLAG_CASE);
            
            foreach($categories as $cat):
               //$displayName = preg_replace('/(?<!\ )[A-Z]/', ' $0', $cat);
               $displayName = self::getName($cat);
               $_element .= '<option value="' . $cat . '" ' . ($selected == $cat ? 'selected="selected"' : '') . '>' . $displayName . '</option>' ;
            endforeach;
        } catch(Exception $e){
            echo $e->getMessage();
            $_element='';
        }
        
        return $_element;
    }
    
    //Gets HTML FORM for mandatory Fields 
    public static function getMandatoryFields($selected){
        $productFactory = new AmazonXSD($selected.'.xsd');            
        $productInstance = $productFactory->getInstance();
        $arr = get_object_vars($productInstance);        
        $html= self::getFieldsHTML($arr,true, null,1);
        //$html= self::getFieldsHTML($arr,false, null,1);
        return $html;
    }
    
    private static function getFieldsHTML(array $arr, $mandatoryOnly=false, $name=null, $level=1, $listLevel=-1){        
        $fields="";        
        $containerId = '\'item-cont-'.$name.'\'';
        $hasChildren = self::hasChildren($arr);
        $top="";
        $middle="";
        $bottom=""; 
        $paddingLeft="";
        $classItem =' class="expander" ';
        $jsItem = ' onclick="javascript:fShowHide('.$containerId.')" ';
        $elementList=false;
        
        if($level<3):
            $paddingLeft = "padding-left:250px;";
        else:
            $paddingLeft = "padding-left:7px;";
        endif;
        if($hasChildren): 
            if($name!=null):                
                $top .= '<div style="text-align:left; '.$paddingLeft.' padding-bottom:4px; padding-top:4px;" >';
                
                //Product Types are listed as SELECT
                 /*
                if($name=="ProductType"):
                    $classItem="";
                    $jsItem = ' onclick="javascript:fShowHide('.$containerId.')" ';
                    $elementList=true;
                endif;                */
                $top .= '  <div style="color:#585a69;text-shadow:0 1px 0#fff; width:100%; float:none; margin-bottom:4px; cursor:pointer; text-align:left;" '.$jsItem.$classItem.' ><b>' . self::getName($name) .'</b></div>';
                $top .= '  <div style="padding-top:4px; margin-bottom:7px; display:none;" id='.$containerId .'>';
                
            endif;
            
            foreach($arr as $key=>$child):
                
                if($child instanceof stdClass):
                    $child = get_object_vars($child);
                endif; 
                
                if($mandatoryOnly && $level==1 &&$key!="ProductData"):
                    if($child['mandatory']!="true"):
                        continue;
                    endif;
                elseif ($key=="ProductData"):
                    
                    $continueNext=true;
                
                    foreach($child as $productData):
                        if(!$continueNext):
                            break;
                        endif;
                        
                        if($productData instanceof stdClass):
                            $productData = get_object_vars($productData);
                            //print("<pre>".print_r($productData,true)."</pre>");
                        endif;
                        
                        if(isset($productData['mandatory']) && $productData['mandatory']="true"){
                            $continueNext=false;
                        }
                        
                    endforeach;
                    
                    if($continueNext):
                        continue;
                    endif;
                endif;
                                    
                if(is_array($child)):
                    if($elementList):
                        $middle .= self::getFieldsHTML($child, false, $key, $level+1, $level+1);
                    else:
                        $middle .= self::getFieldsHTML($child, false, $key, $level+1);
                    endif;
                    
                endif;
            endforeach;            
            
            if($name!=null):
                $bottom .= '</div>'; //expander div                
                $bottom .= '</div>';
            endif;
            $fields .= $top.$middle.$bottom;
        else:
            //It's an Element ( has no children)            
            $fields .= self::getElementHTML($name, $arr, $mandatoryOnly, $level);
        endif;
        
        return $fields;
    }
    
    private static function getObjectArr(stdClass $obj, $mandatoryOnly=false, $name=null, $level=1){
        $arr = get_object_vars($obj);        
        return self::getFieldsHTML($arr, $mandatoryOnly, $name, $level);
        
    }
    
    private static function getElementHTML($name, $arr, $mandatoryOnly, $level=1){
        $html = '<div class="element-container">';
        $style="";
        if(isset($level) && $level<3):
            $style = "profile-obj-title";
        elseif(isset($level)):
            $style = ' style="width:100%; text-align:left; margin-bottom:5px;" ';
        endif;
        
        $label = '<label '.$style.'>' . self::getName($name) . '</label>';
        $attr = ' id="'.$name.'" name="'.$name.'" ';        
        
        if(self::isAttrUsed($name)):
            return "";
        endif;
        
        $defaultValue="";
        $select=null;
        $bool=false;
        //$class = "";
        
        foreach($arr as $key=>$val):
            
            switch ($key):
                 case 'mandatory': 
                                   if(isset($val)&&$val=="true"):
                                        $attr.=' required="required" ';
                                   endif;
                                   break;
                 case 'maxLength': if(isset($val)&&$val!=null): 
                                       $attr.=' maxLength="'.$val.'" '; 
                                   endif; 
                                   break;
                 case 'minLength': 
                                   if(isset($val)&&$val!=null): 
                                       $attr.=' minLength="'.$val.'" '; 
                                   endif; 
                                   break;
                 case 'minValue': 
                                   if(isset($val)&&$val!=null): 
                                       $attr.=' min="'.$val.'"'; 
                                   endif; 
                                   break;
                 case 'maxValue': 
                                   if(isset($val)&&$val!=null): 
                                       $attr.=' max="'.$val.'"'; 
                                   endif; 
                                   break;
                 case 'allowedValues' : if(isset($val)&&count($val)>0): 
                                            $select=$val; 
                                        else: 
                                            $select=null; 
                                            $attr.=' type="text" '; 
                                        endif;
                                        break;
                 case 'value' : 
                                if(isset($val)&&$val!=null): 
                                    $defaultValue=$val ; 
                                endif; 
                                break;
                 case 'type': 
                              if(isset($val)&&$val=='boolean'):
                                  $bool=true;
                              endif;
                              break;
            endswitch;
        endforeach;
        
        if(count($select)>0 && is_array($select)):
            $html .= $label;
            $html .= ' <select '.$attr.'  style="width:300px;" class="profile-item-data" value="" >' ;
            
            foreach($select as $opt):
               $html .= ' <option value="'.$opt.'" ' . ($defaultValue == $opt ? 'selected="selected"' : '') . '>'.self::getName($opt).'</option>' ;                  
            endforeach;
            
            $html .= ' </select> ';
        elseif($bool):
            if($level<2):
                $html .= '<label class="profile-obj-title"></label>';
            endif;
            
            $html .= ' <input type="checkbox" '.$attr.'  style="width:50px;" class="profile-item-data" value="' . $defaultValue . '" /><b>'.self::getName($name).'</b><br/>' ;         
        else:
            $html .= $label;
            $html .= '<input type="text" '.$attr.'  style="width:300px;" class="profile-item-data" " value="' . $defaultValue . '" />';
        endif;        
        $html.='<div style="height:1em;"></div></div>';
        
        return $html;
    }
    
    //checks if the array is of an element, or if it's a parent Element
    private static function hasChildren(array $arr){        
        if(count($arr)==0):
            return false;
        endif;
        
        foreach($arr as $key=>$val):
            //if Key is different than keys used, it means this array contains child elements
            if(!self::isAttrUsed($key)):
                return true;
            endif;
        endforeach;
        
        return false;
    }
    
    public static function getName($str){
        return trim(str_replace("_"," ",preg_replace('/(?<!\ )[A-Z]/', ' $0', $str)));
    }
}

?>