$(document).ready(function() {

    // load CSS
    //
    $('head').append("<link>");
    css = $("head").children(":last");
    css.attr({
        rel: "stylesheet",
        type: "text/css",
        href: $('#css_file').val()
    });
    $('.hint').slideDown();

    if (!$('input[name="amazon_lang"]:checked').length)
        $('input[name="amazon_lang"]:first').attr('checked', 'checked');

    $('li[id^="menu-"]').click(function() {
        result = $(this).attr('id').match('^(.*)-(.*)$');
        tab = result[2];

        $('input[name=selected_tab]').val(tab);

        if (!$(this).hasClass('selected'))
        {
            $('li[id^="menu-"]').removeClass('selected active');
            $(this).addClass('selected active');
            $('div[id^="menudiv-"]').hide();
            $('div[id^="menudiv-' + tab + '"]').show();
        }
    });

    $('#amazon-informations-result').html('<img src="' + $('#img_loader').val() + '" alt="" style="margin-left:50%" />');
    $('#amazon-informations-result').fadeIn();

    // Display Informations
    //
    $.ajax({
        type: 'POST',
        url: $('#report_url').val(),
        data: $('#countrySelector').serialize() + '&' + $('#amazonParams').serialize() + '&action=display-statistics' + '&rand=' + new Date().valueOf(),
        success: function(data) {
            $('#amazon-informations-result').hide();
            $('#statistics-set-result').html(data);
            $('#statistics-set').slideDown();
        }
    });

    $('#submit-report-display').click(function() {


        pAjax = new Object();
        pAjax.type = 'POST';
        pAjax.url = $('#report_url').val();
        pAjax.data = $('#countrySelector').serialize() + '&' + $('#amazonParams').serialize() + '&action=submission-report&rand=' + new Date().valueOf() ;
        
        $('#wait-report').show();
        $('#submission-results').html('').hide();

        $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            data: pAjax.data,
            success: function(data) {
                $('#wait-report').hide();
                $('#report-set').slideDown();
                $('#submission-results').html(data).show();
            },
            error: function(data) {
                $('#wait-report').hide();
                $('#report-set').hide();
                ManageAjaxError(pAjax, data, $('#amazon-report-error')) ;
            }
        });
        return(false);

    });



    // Check checkbox if label is clicked
    $('.amz-options tr td span').click(function() {
        if ($(this).prev('input'))
            $(this).prev().trigger('click');
    });

    function ManageAjaxError(aCall, data, outdiv)
    {
        if (window.console)
        {
            console.log('Ajax Error') ;
            console.log(aCall) ;
            console.log(data) ;
        }
        outdiv.show().html( $('#serror').val() ) ;

        if (data.output)
            outdiv.append('<br />' + data.output);

        if (data.responseText)
            outdiv.append('<br />' + data.responseText);
        
        outdiv.append('<hr />') ;
        outdiv.append( $('#sdebug').val() + ':  ') ; 
        
        outdiv.append('<form method="' + aCall.type + '" action="' + aCall.url + '?debug=1&' + aCall.data + '" target="_blank">' +
                      '<input type="submit" class="button" id="send-debug" value="Execute in Debug Mode" /></form>') ;
    }
    
    $('#submit-synchronize, #submit-synchronize-verify').click(function() {
        if (!$('input[name="amazon_lang"]').is(':checked'))
        {
            alert($('#msg_lang').val());
            return(false);
        }
        params = '';

        if ($(this).attr('id') == 'submit-synchronize-verify')
        {
            params = '&action=update-verify';
        }
        else
        {
            params = '&action=update';
        }
        $('#amazon-synchronize-error').html('').hide() ;
        $('#amazon-synchronize-result').html('').fadeIn();
        $('#amazon-synchronize-result').html('<img src="' + $('#img_loader').val() + '" alt="" style="margin-left:50%" />');

        pAjax = new Object();
        pAjax.type = 'POST';
        pAjax.url = $('#update_url').val();
        pAjax.data = $('#countrySelector').serialize() + '&' + $('#amazonParams').serialize() + '&' + $('#amazonSyncOptions').serialize() + params + '&rand=' + new Date().valueOf() ;
        
        $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            data: pAjax.data,
            success: function(data) {
                $('#amazon-synchronize-result').html(data);
            },
            error: function(data) {
                $('#amazon-synchronize-result').hide();
                
                ManageAjaxError(pAjax, data, $('#amazon-synchronize-error')) ;
            }                      
        });

        return(false);

    });


    $('#submit-creation, #submit-creation-verify').click(function() {
        if (!$('input[name="amazon_lang"]').is(':checked'))
        {
            alert($('#msg_lang').val());
            return(false);
        }
        params = '';

        if ($(this).attr('id') == 'submit-creation-verify')
        {
            params = '&action=create-verify';
        }
        else
        {
            params = '&action=create-export';
        }
        $('#amazon-creation-error').html('').hide()
        $('#amazon-creation-result').html('').fadeIn();
        $('#amazon-creation-result').html('<img src="' + $('#img_loader').val() + '" alt="" style="margin-left:50%" />');

        pAjax = new Object();
        pAjax.type = 'POST';
        pAjax.url = $('#update_url').val();
        pAjax.data = $('#countrySelector').serialize() + '&' + $('#amazonParams').serialize() + '&' + $('#amazonCreateOptions').serialize() + params + '&rand=' + new Date().valueOf() ;
        
        $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            data: pAjax.data,
            success: function(data) {
                $('#amazon-creation-result').html(data);
            },
            error: function(data) {
                $('#amazon-creation-result').hide();
                
                ManageAjaxError(pAjax, data, $('#amazon-creation-error')) ;
            }
        });

        return(false);

    });

    $('#submit-delete, #submit-delete-verify').click(function() {
        if (!$('input[name="amazon_lang"]').is(':checked'))
        {
            alert($('#msg_lang').val());
            return(false);
        }
        params = '';

        if ($(this).attr('id') == 'submit-delete-verify')
        {
            params = '&action=delete-verify';
        }
        else
        {
            params = '&action=delete-export';
        }
        $('#amazon-delete-result').html('');
        $('#amazon-delete-result').fadeIn();
        $('#amazon-delete-result').html('<img src="' + $('#img_loader').val() + '" alt="" style="margin-left:50%" />');

        pAjax = new Object();
        pAjax.type = 'POST';
        pAjax.url = $('#update_url').val();
        pAjax.data = $('#countrySelector').serialize() + '&' + $('#amazonParams').serialize() + '&' + $('#amazonDeleteOptions').serialize() + params + '&rand=' + new Date().valueOf();
    
        $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            data: pAjax.data,
            success: function(data) {
                $('#amazon-delete-result').html(data);
            },
            error: function(data) {
                $('#amazon-delete-result').hide();
                
                ManageAjaxError(pAjax, data, $('#amazon-delete-error')) ;
            }
        });
        return(false);

    });

});

