 $(document).ready(function() {

    // PS 1.4 or 1.5
    if ( $('#product').length )
    {
        var product_form = $('#product') ;
    }
    else
    {
        var product_form = $('#product_form') ;
    }

    // With PS 1.2 - 1.3 we have an old release of jQuery and doesn't have .live() or .on() !
    function waitForAmazonScript()
    {
      window.setTimeout(function() {
        if ( $('input[id^="amazon-strategies-"]:first').length )
        {
            if ( window.console )
                console.log('Init Amazon Strategies') ;
            initStrategies() ;
        }  
        else waitForAmazonScript();
      }, 1000);
      if ( window.console )
        console.log("Waiting Amazon Script...");
    }
    waitForAmazonScript() ;


    function initStrategies()
    {
        $('html').append('<div id="product_bid"></div>') ;
        
        var PS15 = parseInt($('input[name=ps15]:first').val()) ;
        
        if ( window.console )
            console.log('Prestashop 1.5: ' + (PS15 ? 'Yes' : 'No')) ;

        var amazon_logo = $('input[name="amazon_logo"]:first').val() ;
        var amazon_comb_loader = $('input[name="amazon_comb_loader"]:first').val() ; 
        
        function OpenStrategyCombinationWindow(obj)
        {
            loader = $(obj).children('.amz-comb-loader') ;
            logo   = $(obj).children('.amz-comb-logo') ;

            $.ajax({
                type: 'POST',
                url: $('#amazon-product-bid-url').val(),
                data: product_form.attr('action') + '&combination_reference=' + $(obj).attr('rel') + '&rand=' + new Date().valueOf(),
                beforeSend:
                    function(data) {
                        logo.hide(); 
                        loader.show(); 
                    },
                success: function(data) {
                        $('#product_bid').html(data) ;
                        loader.hide();
                        logo.show(); 
                        AmazonInitStrategies() ;
                    }
            });                    
        }

        if ( PS15 )
        {
            //
            $('.productTabs .tab .tab-row:nth-child(6)').click(function(e) {
                 if ( console.log )   
                     console.log('click'); // If the tab is already selected, we emulate the click                
                $(this).unbind(e); // unbind itself   
                $(this).trigger('ajaxComplete') ;
            });
            
            $('.productTabs .tab .tab-row:nth-child(6)').ajaxComplete(function(e) {
                if ( $('#product-tab-content-Combinations .table_grid') ) 
                {
                    table = '#product-tab-content-Combinations .table_grid .table' ;
                    
                    if ( window.console )
                        console.log('Create Amazon table items - step 1') ;

                    if ( ! $(table).length )   return(false) ;
                    
                    $(table + ' thead tr th:last').after('<th>&nbsp;</th>') ;

                    if ( ! $('.amazon_combination').length )
                    {
                        if ( ! $(table + ' tbody tr').length )  return(false) ;

                        if ( window.console )
                            console.log('Create Amazon table items - step 2') ;
                        
                        $(this).unbind(e); // unbind itself   
                        
                        $.each($(table + ' tbody tr'), function() {

                            reference = $(this).children('td:eq(4)').html().trim() ;
                            ean = $(this).children('td:eq(5)').html().trim() ;
                            upc = $(this).children('td:eq(6)').html().trim() ;
                            
                            if ( ! reference || ! (! ean || ! upc) )
                                content = '<td>&nbsp;</td>' ;
                            else 
                            {
                                if ( window.console ) 
                                    console.log('Adding Strategy Button for: ' + reference) ;
                                content = '<td class="amazon_combination" rel="' + reference + '"><img src="' + amazon_logo + '" class="amz-comb-logo" /><img src="' + amazon_comb_loader + '" class="amz-comb-loader" /></td>' ;
                            }
                            $(this).children('td:last').after(content) ;
                        }) ;
                        $('.amazon_combination').click(function() {
                            OpenStrategyCombinationWindow(this) ;
                        });
                    }
                }
            });
        }
        else
        {
            if ( window.console )
                console.log('Adding Amazon strategies icons') ;
            
            $('#step4').ajaxComplete(function(e) { 
                $('#step4').unbind(e) ;    

                $('.table:nth-child(2) tbody tr:first th:last').after('<th>&nbsp;&nbsp;&nbsp;&nbsp;</th>') ;

                if ( ! $('.amazon_combination').length )
                $.each($('.table:nth-child(2) tbody tr:not(:first):not(:last)'), function() {
                    reference = $(this).children('td:eq(3)').html().trim() ;
                    ean = $(this).children('td:eq(4)').html().trim() ;
                    upc = $(this).children('td:eq(5)').html().trim() ;

                    if ( ! reference || ! (! ean || ! upc) )  
                        content = '<td>&nbsp;</td>' ;
                    else 
                        content = '<td class="amazon_combination" rel="' + reference + '"><img src="' + amazon_logo + '" class="amz-comb-logo" /><img src="' + amazon_comb_loader + '" class="amz-comb-loader" /></td>' ;

                    $(this).children('td:last').after(content) ;
                }) ;

                $('.amazon_combination').click(function() {
                    OpenStrategyCombinationWindow(this) ;
                });                   
            });
                           
        }


        // Click from main product form
        //
        $('input[id^="amazon-strategies-"]').click(function() {

          $.ajax({
              type: 'POST',
              url: $('#amazon-product-bid-url').val(),
              data: product_form.attr('action') + '&selected_tab=' + $('input[name="selected_tab"]').val() + '&rand=' + new Date().valueOf(),
              beforeSend:
                function(data) {
                    $('.amz-small-loader').show(); 
                   },
              success: function(data) {
                    $('#product_bid').html(data) ;
                    $('.amz-small-loader').hide() ; 
                    AmazonInitStrategies() ;
                  }
          });

          return(false) ;
        }) ;

        $('input[id^="amazon-reset-st-"]').click(function() {
            if ( ! confirm( $('#amz-text-strategy-reinit').val() ) )  return(false);

            $.ajax({
              type: 'POST',
              url: $('#amazon-product-json-url').val(),
              data: $('form[name=product]').attr('action') + '&action=reinit-strategies&rand=' + new Date().valueOf() + '&callback=?',
              beforeSend:
                function(data) {
                    $('#extra-text-loader').show() ;
                    $('#result-amz').html('').hide()
                   },
              success: function(data) {
                    $('#extra-text-loader').hide() ;
                    $('#result-amz').html(data).show()
                  }
           });

          return(false) ;
        }) ;

        function AmazonInitStrategies()
        {
          $('#amazon-overlay').show() ;
          $('#amazon-window').show().fadeIn() ;

          $('#awindow-closeX').click(function() {

             $('#amazon-window').html('');
             $('#amazon-overlay').hide() ;
             $('#amazon-window').fadeOut();

          });

          $('#freeze-price').click(function() {
            if ( $(this).attr('checked') == true )
            {
              min = parseFloat($('#amz-cur').val()) ;
              max = parseFloat($('#amz-cur').val()) ;
              $('#amz-min').val( min.toFixed(2) ) ;
              $('#amz-max').val( max.toFixed(2) ) ;

              $('#amz-min').css('background-color', 'grey') ;
              $('#amz-min').css('color', 'white') ;
              $('#amz-min').css('font-weight', 'bold') ;

              $('#amz-max').css('background-color', 'grey') ;
              $('#amz-max').css('color', 'white') ;
              $('#amz-max').css('font-weight', 'bold') ;

              $('#amz-min').attr('disabled', true) ;
              $('#amz-max').attr('disabled', true) ;
            }
            else
            {
              $('#amz-min').css('background-color', 'white') ;
              $('#amz-min').css('color', 'black') ;
              $('#amz-min').css('font-weight', 'normal') ;

              $('#amz-max').css('background-color', 'white') ;
              $('#amz-max').css('color', 'black') ;
              $('#amz-max').css('font-weight', 'normal') ;

              $('#amz-min').attr('disabled', false) ;
              $('#amz-max').attr('disabled', false) ;
            }
          });

          $('#suggested-price').click(function() {


            if ( $(this).attr('checked') == true )
            {
              suggested = parseFloat( $('input[name=suggested]').val() ) ;

              $('#amz-cur').val( suggested.toFixed(2) ) ;
              $('#amz-cur').css('background-color', 'green') ;
              $('#amz-cur').css('color', 'white') ;
              $('#amz-cur').css('font-weight', 'bold') ;
            }
            else
            {
              $('#amz-cur').css('background-color', 'white') ;
              $('#amz-cur').css('color', 'black') ;
              $('#amz-cur').css('font-weight', 'normal') ;
            }

          });

          function updateStragegy(update)
          {
                    if ( update == 2)
                    {
                      params = '&delete=1' ;

                      if ( ! confirm('Are you sure to want to delete this Strategy ?') )
                        return(false) ;
                    }
                    else if ( update == true )
                      params = '&update=1' ;
                    else
                      params = '' ;

                    $.ajax({
                        type: 'POST',
                        url: $('#amazon-product-bid-upd-url').val(),
                        data: $('form[name=update-amazon-bid]').serialize() + '&' + $('.amazon-details input').serialize() + params + '&rand=' + new Date().valueOf() + '&callback=?',
                        dataType:'json',
                        timeout:20000,
                        beforeSend:
                            function(data) {
                                $('#amz-loader').fadeIn()
                             },
                        success: function(data) {
                              min = parseFloat(data.min),
                              max = parseFloat(data.max),
                              cur = parseFloat(data.cur),
                              gap = parseFloat(data.gap),
                              ship = parseFloat(data.ship),

                              $('#amz-min').val(min.toFixed(2)),
                              $('#amz-max').val(max.toFixed(2)),
                              $('#amz-cur').val(cur.toFixed(2)),
                              $('#amz-gap').val(gap),

                              $('#amz-dis-min').html(min.toFixed(2)),
                              $('#amz-dis-max').html(max.toFixed(2)),
                              $('#amz-dis-ship').html(ship.toFixed(2)),

                              $('#amz-loader').fadeOut()
                            },
                       error: function(data) {
                            $('#amz-loader').html('Unknown Error')
                           }
                    });
                    return(false) ;
          }

          $('#wozapi-img').click(function()
          {
              window.open('http://www.wozapi.com', '_blank');
              return(false) ;
          });
          
          $('#update-online').click(function()
          {
              updateStragegy(true) ;
              return(false) ;
          });

          $('#view-online').click(function()
          {
              window.open( $('#view-online').attr('rel') ) ;
              return(false) ;
          });


          $('#amz-delete').click(function()
          {
              updateStragegy(2) ; // 2 delete
              return(false) ;
          });

          // on Load
          updateStragegy(false) ;

          $('input[name=amazon_lang]').click(function() {
              lang = $(this).val() ;
              path = $('input[name=path]').val() ;

              $('#amazon-window').html('<br />&nbsp;&nbsp;<img id="loader" src="' + path + 'images/loading.gif" alt="" />');
              $.ajax({
                  type: 'POST',
                  url: $('#amazon-product-bid-url').val(),
                  data: product_form.attr('action') +'&combination_reference=' + $(this).attr('rel')  + '&id_lang=' + id_lang + '&amazon_lang=' + lang + '&rand=' + new Date().valueOf(),
                  success: function(data) {
                        $('#product_bid').html(data),
                        AmazonInitStrategies() ;
                      }
              });
              return(false) ;

          });
          $('#pic').click(function()
          {
              window.open('http://www.wozapi.com', '_blank') ;
          });  
        }
    }
 }) ;

