$(document).ready(function() {
return ;
    $('input[name=amazon_lang]').each(function(){

        pAjax = new Object() ;
        pAjax.url = $('#automaton_url').val() ;
        pAjax.type = 'POST' ;
        pAjax.data_type = 'jsonp' ;
        pAjax.data = '' ;    

        if ( window.console )
            console.log(pAjax) ;
        
        amazon_id_lang = $(this).val() ;
          
        AutomatonStart(pAjax, amazon_id_lang) ;  
        
        DiscoverWizardStart(pAjax, amazon_id_lang) ;  
    }); 
    
    function DiscoverWizardStart(pAjax, amazon_id_lang)
    {
        $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            dataType: pAjax.data_type,
            data:  pAjax.data + '&action=discover-wizard&amazon_lang=' + amazon_id_lang,
            success: function(data) {
                    if ( window.console )
                        console.log(data) ;
                    
                    if ( typeof(data.process) === 'object' )
                    {
                        DisplayDiscoverWizard(pAjax, amazon_id_lang, data.process)
                    }
                }
        });         
    }  
    function DisplayDiscoverWizard(pAjax, amazon_id_lang, processData)
    {
        console.log('DisplayDiscoverWizard') ;
        console.log(processData) ;
        target = 'amazon-automaton-creation-' + amazon_id_lang ;

        if ( processData.resubmitTimer )
            setTimeout(function(){DiscoverWizardStart(pAjax, amazon_id_lang)}, parseInt(processData.resubmitTimer) * 1000);        
        
        if ( ! processData.message ) return(false) ;
        
        if ( ! $('#' + target).length )
            $('#amazon-automaton-creation-model').clone().appendTo( $('#amazon-automaton-creation') ).attr('id', target).show() ;
        
        $('#' + target + ' .amz-info-flag').html( processData.flag ) ;
        $('#' + target + ' .amz-info-marketplace').html( processData.marketplace ) ;
        $('#' + target + ' .amz-info-title').html( processData.title ) ;
        $('#' + target + ' .amz-info-message').html( processData.message ) ;
        $('#' + target + ' div span.amz-info-loader').hide() ;
    }    
    
    function AutomatonStart(pAjax, amazon_id_lang)
    {
        $.ajax({
            type: pAjax.type,
            url: pAjax.url,
            dataType: pAjax.data_type,
            data:  pAjax.data + '&amazon_lang=' + amazon_id_lang,
            success: function(data) {
                    if ( window.console )
                        console.log(data) ;
                    
                    if ( typeof(data.process) == 'object' )
                    {
                        DisplayAutomatonProcessStart(pAjax, amazon_id_lang, data.process)
                    }
                }
        });         
    }

    function DisplayAutomatonProcessStart(pAjax, amazon_id_lang, processData)
    {
        console.log('DisplayAutomatonProcess') ;
        console.log(processData) ;
        target = 'amazon-automaton-report-' + amazon_id_lang ;
        
        if ( ! $('#' + target).length )
            $('#amazon-automaton-report-model').clone().appendTo( $('#amazon-automaton-report') ).attr('id', target).show() ;
        
        $('#' + target + ' .amz-info-flag').html( processData.flag ) ;
        $('#' + target + ' .amz-info-marketplace').html( processData.marketplace ) ;
        $('#' + target + ' .amz-info-title').html( processData.title ) ;
        $('#' + target + ' .amz-info-message').html( processData.message ) ;
        
        if ( parseInt(processData.loader) )
            $('#' + target + ' div span.amz-info-loader').show() ;
        else
            $('#' + target + ' div span.amz-info-loader').hide() ;
        
        if ( processData.resubmitTimer )
            setTimeout(function(){AutomatonStart(pAjax, amazon_id_lang)}, parseInt(processData.resubmitTimer) * 1000);
    }
   
   
});