/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: contact@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: 
 *                  contact@common-services.com
 * ...........................................................................
 * @package    XXXXXXXXX
 * @copyright  Copyright(c) 2010-2013 S.A.R.L S.M.C - http://www.common-services.com
 * @author     debuss-a
 * @license    Commercial license
 * Contact by Email :  alexandre@common-services.com
 */

$(document).ready(function() {
    
    $('input[name="submit"], button[name="submit"]').show();
    
    $('#amazon_form').submit(function() {
        $('.profile-create').each(function(ind, val) {
            var elements = $(this).find('input, select');

            $(elements).each(function() {
                var name = $(this).attr('name');
                $(this).attr('name', name.replace('_key_', ind));
            });
        
        $('input[rel^=categoryBox]:checked').attr('name', 'categoryBox[]');
        
        $('select[rel^=profile2category] option:selected').parent().each(function() {
            $(this).attr('name', $(this).attr('rel')) ;
        });
        
        return (true);
        });
    });

    $('#profile-add').click(function() {

        var cloned = $('#master-profile').clone().removeAttr('id').removeClass('master-profile').addClass('profile').prependTo('#profile-container').slideDown('slow');
        cloned.find('.profile-del-img2').click(function() {
          $(this).parent().parent().slideUp('slow').remove();
         }) ;

        cloned.find('.profile-universe').change(function() {
            selectUniverse($(this));
        });
        // price rules
        cloned.find('.price-rule-type').change(function()
        {
            var type = $(this).val();
            if (type !== 'percent' && type !== 'value')
                return(false);
            $(this).parent().find('select[rel="percent"], select[rel="value"]').hide();
            $(this).parent().find('select[rel="' + type + '"]').show();
        });
        cloned.find('.price-rule-add').click(function()
        {
            var source_i = $(this).parent();
            var dest_i = $(this).parent().parent();

            var from_val = Number(dest_i.find('input[rel=from]:last').val());
            var to_val = Number(dest_i.find('input[rel=to]:last').val());

            dest_i.find('input[rel=from]:last,input[rel=to]:last').removeClass('required');

            if (!dest_i.find('input[rel=from]:last').val().length || !parseInt(from_val))
                from_val = null;

            if (!dest_i.find('input[rel=to]:last').val().length || !parseInt(to_val))
                to_val = null;

            if (parseInt(from_val) && parseInt(to_val) && from_val > to_val)
            {
                dest_i.find('input[rel=from]:last').val('');
                from_val = null;
            }

            if (!to_val || !from_val)
            {
                if (from_val === null)
                    dest_i.find('input[rel=from]:last').addClass('required');
                if (to_val === null)
                    dest_i.find('input[rel=to]:last').addClass('required');
                return(false);
            }
            var cloned2 = source_i.clone().appendTo(dest_i);
            cloned2.find('input').val('');
            cloned2.find('input[rel=from]').val(parseInt(to_val + 1));

            cloned2.find('.price-rule-add, .price-rule-remove').toggle();
            cloned2.find('.price-rule-remove').
                    click(function()
                    {
                        $(this).parent().remove();
                    });
        });
        cloned.find('.price-rule-remove').click(function()
        {
            $(this).parent().remove();
        });
    });
    $('.profile-universe').change(function() {
            selectUniverse( $(this) );
    });

    $('.type_reload').click(function() {
         universe = $(this).parent().parent().find('.profile-universe').change() ;
    });

    if ( $.isFunction( $(document).live ) )
    {
        $('.type_reload').live('click', function() {
                universe = $(this).parent().parent().find('.profile-universe').change() ;
        });        
    }
    else
    {
        $('.type_reload').click(function() {
                universe = $(this).parent().parent().find('.profile-universe').change() ;
        });                
    }

    $('.profile-del-img').click(function() {
      profile_id = $(this).attr('rel') ;
      $('#profile-' + profile_id).slideUp('slow').remove();
      $('#profile-header-' + profile_id).slideUp('slow').remove();
     }) ;
     
    $('.profile-edit-img').click(function() {
      profile_id = $(this).attr('rel') ;
      $('#profile-' + profile_id).slideToggle('slow');
     }) ;     


    // Fetch XSD
    //
    function selectUniverse(obj)
    {
        loader = $(obj).parent().find('.xsd-load') ;
        loader.show() ;

        result          = $(obj).parent().find('.fetch-result') ;
        selected        = $(obj).val() ;
        product_type    = $(obj).parent().parent().find('.product_type') ;
        mandatory_fields = $(obj).parent().parent().find('.mandatory_fields') ;

        if ( selected == 'Jewelry' )
                $('#associations').hide() ;
        else    $('#associations').show() ;
        
        $.ajax({
            type: 'POST',
            url: $('#xsd_operations_url').val(),
            data: '&action=fetch&path=' + $('#xsd_path').val() + '&selected=' + selected + '&rand=' + new Date().valueOf() + '&callback=?',
            beforeProcess: function(data) {

            },
            success: function(result) {
                loader.hide() ;
                mandatory_fields.html('');
                product_type.html(result).unbind('change').change(function(obj)
                {
                    changeProductType( obj, product_type, selected ) ;
                })               
            },
            error: function(result) {
                 loader.hide() ;
                 $('#ajax-error').html( $('#xsd_ajax_error').val() ).show() ;
                }
        }) ;
    }

    function changeProductType( obj, product_type, selected )
    {
        mandatory_fields = $(product_type).parent().parent().find('.mandatory_fields') ;

        profile = $(product_type).parent().parent().find('input[name^="profiles[name]"]').val() ;
        mandatory_fields = $(product_type).parent().parent().find('.mandatory_fields') ;
        loader = $(product_type).parent().parent().find('.xsd-load') ;
        loader.show() ;

        $.ajax({
            type: 'POST',
            url: $('#xsd_operations_url').val() + '&callback=?',
            dataType: 'json',
            data: '&action=extrafields&path=' + $('#xsd_path').val() + '&profile=' + profile + '&selected=' + $(product_type).val() + '&universe=' + selected + '&rand=' + new Date().valueOf(),
            beforeProcess: function(data) {
              $(mandatory_fields).html('');
            },
            success: function(result) {
                if (window.console)
                 console.log(result) ;
                loader.hide() ;
                if ( result.errors )
                {
                    $('#ajax-error').html( $('#xsd_ajax_error').val() + '<br />' + data.errors ).show() ;
                }
                mandatory_fields.html(result.fields) ;
                onChangeProductType() ;
            },
            error: function(result) {
                 loader.hide() ;
                 $('#ajax-error').html( $('#xsd_ajax_error').val() ).show() ;
                }
        }) ;
    }

    function onChangeProductType()
    {
        $('.variant').change(function()
        {
          changeVariant($(this)) ;      
        }) ;
    }
    function changeVariant(obj)
    {
        selected_variant = obj.val() ;

        $('.variant-items[rel!="' + selected_variant + '"]').hide() ;
        $('.variant-items[rel="' + selected_variant + '"]').show() ;        
    }
    $('.variant').change(function()
    {
        changeVariant($(this)) ;
    }) ;
        
    
});