<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.strategies.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class AmazonToWozapi extends Amazon
{
    private $_debug;

    function __construct()
    {
        parent::__construct();

        $this->export = $this->path . 'export/' ;
        $this->delimiter = ';' ;
        
        $this->fileout = $this->export . 'wozapi.csv.gz' ;
        $this->fileoutmd5 = $this->export . 'wozapi.info.txt' ;
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }
    
    public function Dispatch()
    {
        $token = Tools::getValue('wozapi_token');
        
        // Security Check
        //
        if ( $token != Amazon::configurationGet('AMAZON_WOZAPI_TOKEN') )
            die( Tools::displayError( $this->l('Wrong Token')) ) ;
        
        if ( ! Amazon::configurationGet('AMAZON_WOZAPI') ) 
            die( Tools::displayError( $this->l('Wozapi support is not active !'))) ;
        
        switch (Tools::getValue('action'))
        {
            case 'export' :
                $this->Export();
                break;
            case 'verify' :
                $this->Verify();
                break;            
            case 'download' :
                $this->Upload();
                break;            
            case 'acknowledge' :
                $this->Acknowledge();
                break;             
            default:
                die( Tools::displayError( $this->l('Missing input parameter')) ) ;
                break;            
        }
    }

    public function Check() 
    {
        if ( ! is_dir($this->export) )
        {
            if ( ! mkdir($this->export, 0777) )
            {
                printf('%s/%d: %s - %s', basename(__FILE__), __LINE__, $this->l('Failed to create directory'), $this->export) ;
                return(false) ;
            }
        }
        if ( ! is_writable($this->export) )
        {
            @chmod($this->export, 0777) ;
            
            if ( ! is_writable($this->export) )
            {
                printf('%s/%d: %s - %s', basename(__FILE__), __LINE__, $this->l('Unwriteable directory'), $this->export) ;
                return(false) ;
            }
        }  
        $content = 'deny from all' . "\n" ;
        
        if ( file_put_contents($this->export . '.htaccess', $content) === false )
        {
            printf('%s/%d: %s - %s', basename(__FILE__), __LINE__, $this->l('Failed to write to the directory'), $this->export) ;
            return(false) ;
        }  
        return(true) ;
    }

    public function Acknowledge()
    {
        if ( ! ($country = Tools::getValue('country')) ) die ;
        
        $country = strtolower(substr($country, 0, 2)) ;
        
        if ( ! $country )   die ;
        
        $acknowledges = Amazon::configurationGet('AMAZON_WOZAPI_ACKNOWLEDGE') ;
        
        if ( $acknowledges === false )
            $acknowledges = array() ;
        else
            $acknowledges = @unserialize($acknowledges) ;

        if ( ! is_array($acknowledges))
            $acknowledges = array() ;

        $acknowledges[$country] = time() ;
        
        Amazon::configurationUpdateValue('AMAZON_WOZAPI_ACKNOWLEDGE', serialize($acknowledges)) ;
        
        die;
    }
    public function Verify()
    {
        // Allow temporarly cross scripting 
        header('Access-Control-Allow-Origin: *');
        
        if ( file_exists($this->fileoutmd5) && file_exists($this->fileout) )
        {
            $content = file_get_contents($this->fileoutmd5) ; 
            
            if ( ! $content )
                    die( Tools::displayError( sprintf('%s/%d: %s', basename(__FILE__), __LINE__, $this->l('Failed to open file'))) ) ;

            $items = explode(';', $content) ;

            if ( ! isset($items[1]) )    die( Tools::displayError( sprintf('%s/%d: %s', basename(__FILE__), __LINE__, $this->l('Unknown Error'))) ) ;
            
            printf('%s - %s - %d %s - %s %s', $this->l('A file was found and is ready to be sent'), basename($this->fileout), $items[2], $this->l('lines'), $this->l('generated on'), $items[0]) ;
        }  
        else
        {
            printf('%s', $this->l('No file were found but it could be generated')) ;
        }
        exit ;
    }
    
    public function Export()
    {
        // http://localhost/prestashop1531/modules/amazon/functions/wozapi.php?amazon_token=757b40415c88e18adcd000de274b95a0
        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->_debug = intval($debugMode) ? true : false;
        
        if ( Tools::getValue('debug') )
            $this->_debug = true ;
        
        $pass = true ;
        
        if ( $this->_debug )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);            
        } 
        $id_shop = 1 ;
        $id_warehouse = null ;
        
        // Shop Configuration (PS 1.5)
        // 
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $id_shop = (int) Amazon::configurationGet('AMAZON_SHOP');
            $id_warehouse = (int) Amazon::configurationGet('AMAZON_WAREHOUSE');

            if (!$id_shop)
                $id_shop = 1;
        }        
        //
        //  Amazon Marketplace Settings
        //
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $conditionMap = array_flip(unserialize(base64_decode(Amazon::configurationGet('AMAZON_CONDITION_MAP'))));
        $specials = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_SPECIALS')))) ? true : false;
        $useTax = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_TAXES')))) ? true : false;
        
        $formulas = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PRICE_FORMULA')));
        $price_rules = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PRICE_RULE')));
        
        // Init Product Options
        // 
        Amazon_Product::populateProductOptions() ;
        
        // FBA 
        // 
        $FBA = (bool)Amazon::configurationGet('AMAZON_FBA') ;

        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_FBA_PRICE_FORMULA'))) ;

        if ( ! empty($params) || $params != '@' && $FBA )
                $fbaFormula = $params ;
        else $fbaFormula = null ;        
        
        if ( ! $this->Check() ) die ;
        
        $csvh = gzopen($this->fileout, 'w');
        
        $strategies = Amazon_Strategy::getStrategies() ;
        $count = 0 ;

        if ( is_array($strategies) && count($strategies) )
        {
            foreach($strategies as $strategy)
            {
                if (! isset($marketPlaceRegion[$strategy['id_lang']]) )   continue ;

                // Do not export master product if it has children/combinations
                if ( ! $strategy['id_product_attribute'] && $strategy['has_attributes'] )
                    continue ;

                $id_lang = (int)$strategy['id_lang'] ;

                // Apply Mappings
                $strategy['id_lang'] = $marketPlaceRegion[$id_lang] ;
                $strategy['condition'] = !empty($strategy['condition']) && isset($conditionMap[$strategy['condition']]) && !empty($conditionMap[$strategy['condition']]) ? $conditionMap[$strategy['condition']] : 'New';

                $newPrice = null ;

                // This product doesn't have actual price
                // That could be because it doesn't have a strategy, 
                // Calcultating the current price in the shop
                if ( ! $strategy['actual_price'] )
                {
                    $product = new Product($strategy['id_product'], false, $id_lang) ;
                    $stdPrice = $product->getPrice($useTax, ($strategy['id_product_attribute'] ? (int)$strategy['id_product_attribute'] : null), 6, NULL, false, ! $product->on_sale && $specials) ;
                    $newPrice = $stdPrice ;

                    if ( $price_rules )
                        $newPrice = Amazon_Tools::PriceRule($stdPrice, $price_rules[$id_lang]);
                    elseif ( isset($formulas[$id_lang]) && ! empty($formulas[$id_lang]) )
                        $newPrice = Amazon_Tools::Formula($stdPrice, $formulas[$id_lang]);

                }
                else
                {
                    $newPrice = (float)$strategy['actual_price'] ;
                }

                // handle free or zero shipping
                if ( $strategy['shipping'] === NULL )
                    $strategy['shipping'] = '' ;
                elseif ( $strategy['shipping'] == 0 )
                    $strategy['shipping'] = '0' ;

                // Product Options
                $options = Amazon_Product::getProductOptions($strategy['id_product'], $id_lang);

                // Price Override
                if ( ! empty($options['price']) && (float)$options['price'] )
                {
                    $newPrice = (float)$options['price'] ;
                }

                // FBA
                $fba = (bool)$options['fba'] ;

                if ( $FBA && $fba )
                {
                    // FBA Value Added 
                    if ( (float)$options['fba_value'] > 0 )
                    {
                        $FBAvalue = (float)$options['fba_value'] ;

                        if ( $strategy['minimum_price'] )       $strategy['minimum_price'] += $FBAvalue ;
                        if ( $strategy['target_price'] )        $strategy['target_price'] += $FBAvalue ;
                        $newPrice += $FBAvalue ;
                    }
                    // FBA Formula
                    elseif ( $fbaFormula )
                    {
                        $newPrice = Amazon_Tools::Formula($newPrice, $fbaFormula);
                        if ( $strategy['minimum_price'] )   $strategy['minimum_price'] = Amazon_Tools::Formula($strategy['minimum_price'], $fbaFormula);
                        if ( $strategy['target_price'] )    $strategy['target_price'] = Amazon_Tools::Formula($strategy['target_price'], $fbaFormula);
                    }

                    // No shipping on FBA products 
                    $strategy['shipping'] = '' ;
                }                 
                else
                {
                    if (version_compare(_PS_VERSION_, '1.5', '<'))
                    {
                        $productQuantity = Product::getQuantity($strategy['id_product'], $strategy['id_product_attribute']);
                    }
                    else
                    {
                        $productQuantity = Product::getRealQuantity($strategy['id_product'], $strategy['id_product_attribute'], $id_warehouse, $id_shop);
                    }                  
                    if ( ! $productQuantity )
                        continue ;                
                }
                $strategy['actual_price'] = (float)$newPrice ;

                // Unused Fields
                unset($strategy['disable']) ; // Always false !
                unset($strategy['id_product']) ;
                unset($strategy['id_product_attribute']) ;
                unset($strategy['has_attributes']) ;

                fputcsv($csvh, $strategy, $this->delimiter) ;
                $count++ ;
            }
        }
                    
        gzseek($csvh, 0) ;
        gzclose($csvh) ;

        $filemd5 = md5_file($this->fileout) ; 
        $filemd5_string = date('c') . ';' . $filemd5 . ';' . $count ;

        $pass = file_put_contents($this->fileoutmd5, $filemd5_string) && $pass ;
        
        if ( $pass )
        {
            Amazon::configurationUpdateValue('AMAZON_WOZAPI_UPDATED', date('Y-m-d H:i:s')) ;
                     
            printf('%s: %s - md5: %s - records: %d', date('c'), $this->l('The file were successfuly created'), $filemd5, $count) ;
        }
        else
        {
            printf('%s: %s - md5: %s - records: %d', date('c'), $this->l('Unexpected error while creating the file'), $filemd5, $count) ;
            exit ;
        }
    }
    
    public function Upload()
    {
        if ( ! file_exists($this->fileout) )
            die( Tools::displayError($this->l('No file to upload were found, exiting...'))) ;
        
        if ( ! file_exists($this->fileoutmd5) )
            die( Tools::displayError($this->l('No checksum file to upload were found, exiting...'))) ;        
        
        if ( Tools::getValue('md5') )
                $filename = $this->fileoutmd5 ;
        else    $filename = $this->fileout ;

        if ( Tools::getValue('wozaping') )
        {
            Amazon::configurationUpdateValue('AMAZON_WOZAPI_PING', date('Y-m-d H:i:s')) ;
        }
        
        ob_start() ;
        ob_get_clean() ;
        
        header("Cache-Control: no-cache, must-revalidate");
        header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
        header("Content-Type: application/force-download");
        header('Content-Disposition: attachment; filename="'.basename($filename).'"');
        
        echo file_get_contents($filename);
        exit ;
    }

}

$amazonToWozapi = new AmazonToWozapi();
$amazonToWozapi->Dispatch();
?>