<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
/*
  Warning in Prestashop >= 1.3.6 - 1.4
  @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
  Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
 */
if (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'localhost')
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../amazon.php');

require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.order.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.carrier.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

class Amazon_BulkMode extends Amazon
{
    function __construct()
    {
        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->_debug = intval($debugMode) ? true : (bool) Tools::getValue('debug');

        if (Tools::getValue('debug'))
            $this->_debug = true;

        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }
        parent::__construct();
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    function BulkUpdate()
    {
        global $cookie, $cart, $argv;

        $cr = "<br />\n"; // carriage return

        $tokens = Tools::getValue('cron_token');
        $amazon_lang = Tools::getValue('lang');
        $europe = intval(Tools::getValue('europe'));

        $id_lang = Language::getIdByIso($amazon_lang);

        if (!Amazon_Tools::checkToken($tokens, $id_lang, $europe))
            die('Wrong Token');

        if (!$amazon_lang)
        {
            echo $this->l('No selected language, nothing to do...');
            die;
        }
        $debug = $this->_debug;

        // Orders States
        //
        $preparation_state = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PREPARATION_STATE')));
        $sent_state = unserialize(base64_decode(Amazon::configurationGet('AMAZON_SENT_STATE')));
        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));

        $amazon_carriers = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CARRIER_DEFAULT')));

        // Regions
        //
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $marketLang2Region = array_flip($marketPlaceRegion);

        $id_lang_list = '';

        // Making id_lang_list to select orders
        //
        if ($europe)
        {
            foreach (Amazon_Tools::languages() as $language)
            {
                if (!isset($actives[$language['id_lang']]) || !$actives[$language['id_lang']])
                    continue;
                if (!Amazon_Tools::isUnifiedAccount($marketPlaceRegion[$language['id_lang']]))
                    continue;

                $id_lang_list .= $language['id_lang'] . ',';
            }
            $id_lang_list = rtrim($id_lang_list, ',');
        }
        else
        {
            if (!isset($marketLang2Region[$amazon_lang]))
                die('No selected language, nothing to do...');

            $id_lang_list = $marketLang2Region[$amazon_lang];
        }

        $id_lang = Language::getIdByIso($amazon_lang);

        // Fetch Orders
        if (!($orders = Amazon_Order::getMarketplaceOrdersStatesByIdLang($id_lang_list, $sent_state)))
        {
            printf($this->l('No Orders - exiting normally') . $cr);
            exit;
        }

        $order_list = array();
        $carrier_codes = array();
        $carrier_names = array();
        $shipping_number_list = array();
        $unknown_carriers = array();

        if ($debug)
            printf('Orders: %s' . $cr, nl2br(print_r($orders, true)));

        foreach ($orders as $order)
        {
            $id_lang = $order['id_lang'];

            if (!($amazonCarrier = Amazon_Carrier::getAmazonCarrierById($order['id_carrier'], $id_lang, $debug)))
            {
                if (!isset($unknown_carriers[$id_lang]))
                    $unknown_carriers[$id_lang] = array();
                $unknown_carriers[$id_lang][$order['id_carrier']] = $order['id_carrier'];
                continue;
            }

            if (!$amazonCarrier)
            {
                if ($debug)
                    printf('%s:%d %s %d (%d)' . $cr, basename(__FILE__), __LINE__, $this->l('Skipping order - Empty carrier for order #'), $order['id_order'], $id_lang);
                continue;
            }

            // Building array for Amazon API
            //
            $order_list[] = $order['mp_order_id'];
            $ps_order_list[] = $order['id_order'];
            $shipping_number_list[] = $order['shipping_number'];

            // If it is a listed carrier, send carrier code, else, send carrier name
            //
            if (Amazon_Carrier::isCarrierCode($amazonCarrier))
            {
                $carrier_codes[] = $amazonCarrier;
                $carrier_names[] = null;
            }
            else
            {
                $carrier_codes[] = null;
                $carrier_names[] = $amazonCarrier;
            }

            if ($debug)
                printf('Order: %s Carrier: %s Shipping Number: %s' . $cr, $order['mp_order_id'], $amazonCarrier, $order['shipping_number']);
        }

        if (count($unknown_carriers))
        {
            foreach ($unknown_carriers as $id_lang => $unknown_carrier)
                foreach ($unknown_carrier as $key => $id_carrier)
                {
                    $carrier = new Carrier($id_carrier);
                    $missingCarrier = isset($carrier->name) ? $carrier->name : $id_carrier;
                    printf('%s:%d %s %s (%s) - %d' . $cr, basename(__FILE__), __LINE__, $this->l('Carrier not found, please configure your carriers associations for:'), $missingCarrier, Language::getIsoById($id_lang), $id_carrier);
                }
        }

        if (!count($order_list))
        {
            if ($debug)
                printf($this->l('No Orders - exiting normally') . $cr);
            exit;
        }
        else
        {
            if ($debug)
                printf($this->l('%s Orders') . $cr, count($order_list));
        }



        // Init Amazon
        //
        $platform = Amazon_Tools::selectPlatform($id_lang, $debug);

        if ($debug)
            echo print_r($platform['auth'], true) . print_r($platform['params'], true) . print_r($platform['platforms'], true);

        $pass = true;

        if (!($amazonApi = new Amazon_WebService($platform['auth'], $platform['params'], null, $debug)))
        {
            echo $this->l('Unable to login') . $cr;
            $pass = false;
        }

        if ($pass)
        {
            // Submitting Orders
            //
            if (!($result = $amazonApi->confirmMultipleOrders($order_list, $carrier_codes, $carrier_names, $shipping_number_list)))
            {
                printf($this->l('Unable to send data to Amazon') . $cr);
            }

            if (isset($result->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId))
            {
                foreach ($ps_order_list as $id_order)
                {
                    Amazon_Order::updateMarketplaceStatus($id_order, Amazon_Order::Checked);
                }
                printf('%s %s', $this->l('Data sucessfully submitted, FeedSubmissionId: '), $result->SubmitFeedResult->FeedSubmissionInfo->FeedSubmissionId);
            }
            else
            {
                printf('Amazon Returns: %s' . $cr, print_r($result, true));
            }
        }
    }

}

$amazonBulkMode = new Amazon_BulkMode;
$amazonBulkMode->BulkUpdate();
?>