<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
/*
  Warning in Prestashop >= 1.3.6 - 1.4
  @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
  Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
    #require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
    #@require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../amazon.php');

require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');

class Amazon_ProductReport extends Amazon
{

    private $_debug = false;
    private $_europe;

    function __construct()
    {
        parent::__construct();

        if ((int) Tools::getValue('id_lang'))
            $this->id_lang = (int) Tools::getValue('id_lang');
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    public function displayStatistics()
    {
        $html = null;
        $stats = Amazon_Product::marketplaceCountProducts();
        $wozapi = (int) Amazon::configurationGet('AMAZON_WOZAPI');
        $dateWS = Amazon::configurationGet('AMAZON_LAST_UPDATED_' . $this->id_lang);
        $dateCron = Amazon::configurationGet('AMAZON_LAST_CRON_UPDATED_' . $this->id_lang);

        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));

        $html .= '
            <p>
                <b> ' . $this->l('Statistics') . '</b>: ' . sprintf($this->l('There is %d synchronizable products and %d combinations in %d languages'), $stats['products'], $stats['attributes'], count($actives)) . '
                <br /><br />
                <b>' . $this->l('Latest Updates') . '</b>:
                    
                <table style="width:100%">
                <tr style="font-style:italic"><td width="40%">' . $this->l('Action') . '</td><td>' . $this->l('Cron Update') . '</td><td></td><td>' . $this->l('Normal Update') . '</td></tr>';

        $count = 0;
        if ($actives)
            foreach (array_keys($actives) as $selected_lang)
            {
                $region = Amazon_Tools::idToDomain($selected_lang);

                $dateWS = Amazon::configurationGet('AMAZON_LAST_UPDATED_' . $selected_lang);
                $dateCron = Amazon::configurationGet('AMAZON_LAST_CRON_UPDATED_' . $selected_lang);

                if ($dateWS)
                {
                    $strWS = Amazon_Tools::displayDate($dateWS, $this->id_lang, true);
                }
                else
                    $strWS = $this->l('Never');

                if ($dateCron)
                    $strCron = Amazon_Tools::displayDate($dateCron, $this->id_lang, true);
                else
                    $strCron = $this->l('Never');

                $count++;

                $html .= '<tr><td>Amazon.' . $region . '</td><td>' . $strCron . '</td><td style="width:40px"></td><td>' . $strWS . '</td></tr>';
            }

        // Display Wozapi Exchanges
        //
        if ($wozapi)
        {
            $dateCron = Amazon::configurationGet('AMAZON_WOZAPI_UPDATED');

            // Last strategies file export
            //
            if ($dateCron)
                $strCron = Amazon_Tools::displayDate($dateCron, $this->id_lang, true);
            else
                $strCron = $this->l('Never');

            $html .= '<tr><td>' . $this->l('Strategies') . '</td><td>' . $strCron . '</td><td style="width:40px"></td><td>-</td></tr>';

            // Last Wozapi Access
            //
            $dateCron = Amazon::configurationGet('AMAZON_WOZAPI_PING');

            if ($dateCron)
                $strCron = Amazon_Tools::displayDate($dateCron, $this->id_lang, true);
            else
                $strCron = $this->l('Never');

            $html .= '<tr><td>' . $this->l('Wozapi') . '</td><td>' . $strCron . '</td><td style="width:40px"></td><td>-</td></tr>';
        }

        $html .= '
                </table>';

        if (!$count)
        {
            $html .= '<span style="color:brown;font-weight:bold;">' . $this->l('No recorded updates') . '</span>';
        }

        echo $html;
    }

    function DoIt()
    {
        global $cookie, $cart;
        ob_start();

        $id_lang = intval(Tools::getValue('amazon_lang'));

        $callback = Tools::getValue('callback');
        $action = strval(Tools::getValue('action'));
        $cr = "<br />\n";

        $this->_debug = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));

        if (Tools::getValue('debug'))
            $this->_debug = true;

        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }
        // Init
        //
    $amazon = Amazon_Tools::selectPlatforms($id_lang, $this->_debug);


        if ($this->_debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        if (!($this->_amazonApi = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $this->_debug)))
        {
            echo $this->l('Unable to login') . $cr;
            die;
        }

        switch ($action)
        {
            case 'display-statistics' :
                $this->displayStatistics();
                break;

            case 'submission-report' :
                $html = '';
                $pass = false;
                $submissions = unserialize(base64_decode(Amazon::configurationGet('AMAZON_LAST_SUBMISSIONS')));


                // Product Submission Report
                //
            if (isset($submissions[$id_lang]['products']) && intval($submissions[$id_lang]['products']))
                {
                    $response = $this->_amazonApi->getFeedSubmissionResult($submissions[$id_lang]['products']);

                    if ($response !== false && $response !== null)
                    {
                        $html .= $this->displayGetFeedSubmissionResult($response, sprintf('%s - %s: %s', $this->l('Product Feed'), $this->l('ID'), $submissions[$id_lang]['products']));
                        $pass = true;
                    }
                }

                // Inventory Submission Report
                //
            if (isset($submissions[$id_lang]['inventory']) && intval($submissions[$id_lang]['inventory']))
                {
                    $response = $this->_amazonApi->getFeedSubmissionResult($submissions[$id_lang]['inventory']);

                    if ($response !== false && $response !== null)
                    {
                        $html .= $this->displayGetFeedSubmissionResult($response, sprintf('%s - %s: %s', $this->l('Inventory Feed'), $this->l('ID'), $submissions[$id_lang]['inventory']));
                        $pass = true;
                    }
                }

                // Prices Submission Report
                //
            if (isset($submissions[$id_lang]['prices']) && intval($submissions[$id_lang]['prices']))
                {
                    $response = $this->_amazonApi->getFeedSubmissionResult($submissions[$id_lang]['prices']);

                    if ($response !== false && $response !== null)
                    {
                        $html .= $this->displayGetFeedSubmissionResult($response, sprintf('%s - %s: %s', $this->l('Prices Feed'), $this->l('ID'), $submissions[$id_lang]['prices']));
                        $pass = true;
                    }
                }

                // Override Submission Report
                //
            if (isset($submissions[$id_lang]['overrides']) && intval($submissions[$id_lang]['overrides']))
                {
                    $response = $this->_amazonApi->getFeedSubmissionResult($submissions[$id_lang]['overrides']);

                    if ($response !== false && $response !== null)
                    {
                        $html .= $this->displayGetFeedSubmissionResult($response, sprintf('%s - %s: %s', $this->l('Overrides Feed'), $this->l('ID'), $submissions[$id_lang]['overrides']));
                        $pass = true;
                    }
                }

                // Images Submission Report
                //
            if (isset($submissions[$id_lang]['images']) && intval($submissions[$id_lang]['images']))
                {
                    $response = $this->_amazonApi->getFeedSubmissionResult($submissions[$id_lang]['images']);

                    if ($response !== false && $response !== null)
                    {
                        $html .= $this->displayGetFeedSubmissionResult($response, sprintf('%s - %s: %s', $this->l('Images Feed'), $this->l('ID'), $submissions[$id_lang]['images']));
                        $pass = true;
                    }
                }

                // Relationship Submission Report
                //
            if (isset($submissions[$id_lang]['relations']) && intval($submissions[$id_lang]['relations']))
                {
                    $response = $this->_amazonApi->getFeedSubmissionResult($submissions[$id_lang]['relations']);

                    if ($response !== false && $response !== null)
                    {
                        $html .= $this->displayGetFeedSubmissionResult($response, sprintf('%s - %s: %s', $this->l('Relationship Feed'), $this->l('ID'), $submissions[$id_lang]['relations']));
                        $pass = true;
                    }
                }

                // Debug Messages
                //
            if (!$pass)
                    echo $this->l('No available reports') . $cr;

                $output = '<div class="report-debug-div">';
                $output .= ob_get_clean();
                $output .= '</div>';

                echo $html;

                echo $output;

                break;
        }
    }

    private function displayGetFeedSubmissionResult($obj, $title)
    {
        $html = '';
        $errors = '';


        if (isset($obj->Message->ProcessingReport->Result->ResultCode) && ($obj->Message->ProcessingReport->Result->ResultCode == 'Warning' || $obj->Message->ProcessingReport->Result->ResultCode == 'Error'))
        {
            if (is_object($obj->Message->ProcessingReport->Result))
                foreach ($obj->Message->ProcessingReport->Result as $result)
                {
                    if (isset($result->AdditionalInfo->SKU))
                        $additionnal_information = sprintf('SKU: %s - ', $result->AdditionalInfo->SKU);
                    else
                        $additionnal_information = '';

                    $errors .= nl2br(sprintf('Error %d: %s%s' . "\n\n", $result->ResultMessageCode, $additionnal_information, $result->ResultDescription));
                }
            else
            {
                if (isset($result->AdditionalInfo->SKU))
                    $additionnal_information = sprintf('SKU: %s - ', $result->AdditionalInfo->SKU);
                else
                    $additionnal_information = '';

                $errors .= nl2br(sprintf('Error %d: %s%s' . "\n\n", $obj->Message->ProcessingReport->Result->ResultMessageCode, $additionnal_information, $obj->Message->ProcessingReport->Result->ResultDescription));
            }
        }
        elseif (isset($obj->Message->ProcessingReport->StatusCode) && $obj->Message->ProcessingReport->StatusCode == 'Complete')
        {
            $errors = '';
        }
        else
        {
            $errors .= nl2br(print_r($obj, true));
        }

        $html .= '
              <span class="submission-result-title">' . $title . '</span><br />';

        if (isset($obj->Message) && isset($obj->Message->ProcessingReport->ProcessingSummary))
        {
            $summary = $obj->Message->ProcessingReport->ProcessingSummary;

            $html .= '
              <table class="submission-results-table">
                  <thead>
                      <tr>
                          <th>' . $this->l('Entry') . '</th>
                          <th>' . $this->l('Result') . '</th>
                      </tr>
                  </thead>
                  <tbody>
                     <tr>
                          <td  class="col1">' . $this->l('Entries Processed') . '</td>
                          <td style="font-weight:bold;">' . strval($summary->MessagesProcessed) . '</td>
                     <tr>
                     </tr>
                          <td  class="col1">' . $this->l('Entries Successful') . '</td>
                          <td style="color:#1D910F;font-weight:bold;">' . strval($summary->MessagesSuccessful) . '</td>
                     <tr>
                     </tr>
                          <td class="col1">' . $this->l('Entries with Error') . '</td>
                          <td style="color:#FD0000;font-weight:bold;">' . strval($summary->MessagesWithError) . '</td>
                     <tr>
                     </tr>
                          <td class="col1">' . $this->l('Entries with Warning') . '</td>
                          <td style="color:#FFA300;font-weight:bold;">' . strval($summary->MessagesWithWarning) . '</td>
                     </tr>
                     </tr>
                          <td class="col1">' . $this->l('Messages Logs') . '</td>
                          <td>' . $errors . '</td>
                     </tr>
                  </tbody>
              </table>
              ';
        }
        /*
          SimpleXMLElement Object
          (
          [Error] => SimpleXMLElement Object
          (
          [Type] => Sender
          [Code] => FeedProcessingResultNotReady
          [Message] => Feed Submission Result is not ready for Feed Submission Id: 3899441890
          [Detail] => SimpleXMLElement Object
          (
          )
         */
        elseif (isset($obj->Error))
        {
            $error = $obj->Error->Message;

            $html .= '
              <table class="submission-results-table">
                  <thead>
                      <tr>
                          <th>' . $this->l('Entry') . '</th>
                          <th>' . $this->l('Result') . '</th>
                      </tr>
                  </thead>
                     </tr>
                          <td class="col1">' . $this->l('Error') . '</td>
                          <td style="color:#FFA300;font-weight:bold;">' . strval($obj->Error->Code) . '</td>
                     </tr>
                  </body>
                     </tr>
                          <td class="col1">' . $this->l('Messages Logs') . '</td>
                          <td>' . $error . '</td>
                     </tr>
                  </tbody>
              </table>';
        }
        else
        {
            $html .= nl2br(print_r($obj, true));
        }
        $html .= '<br /><hr /><br />';

        return($html);
    }

}

$apr = new Amazon_ProductReport();

$apr->DoIt();