<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

/*
  Warning in Prestashop >= 1.3.6 - 1.4
  @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
  Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
 */

if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    
    if ( version_compare(_PS_VERSION_,'1.5','<') )
        require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    
    if ( version_compare(_PS_VERSION_,'1.5','<') )
        @require_once(dirname(__FILE__) . '/../../../init.php') ;
}

require_once(dirname(__FILE__) . '/../amazon.php');

require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.tag.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');


require_once(_PS_MODULE_DIR_ . 'amazon/validate/Node.php'); 
require_once(_PS_MODULE_DIR_ . 'amazon/validate/XmlDataType.php'); 
require_once(_PS_MODULE_DIR_ . 'amazon/validate/XmlRestriction.php'); 
require_once(_PS_MODULE_DIR_ . 'amazon/validate/AmazonXSD.php'); //gets code for Amazon XML Schemas
require_once(_PS_MODULE_DIR_ . 'amazon/validate/AmazonValidator.php'); 
require_once(_PS_MODULE_DIR_ . 'amazon/validate/Tools.php'); 

@set_time_limit(7200) ;

class Amazon_ExportProducts extends Amazon
{
    const WARNING = 1 ;
    const ERROR = 2 ;
    
    private $_amazonApi = array();
    private $_debug = false;
    
    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $this->id_lang) );
    }

    function errorOutput($message, $level = false)
    {
        global $params ;
        
        if ( $level == self::WARNING )
            $color = 'brown' ;
        elseif ( $level == self::ERROR )
            $color = 'red' ;
        else
            $color = 'black' ; 
        if ( $level && ! $params->cronMode ) 
            echo '<span style="color:brown;font-weight:bold;">' ;
        
        print $message ;
        
        if ( $level && ! $params->cronMode ) 
            echo '</span><br />' ;
    }
    
    function DoIt()
    {
        global $params ;

        //
        // Cron Mode
        //
        if (Tools::getValue('cron'))
        {
            $lang = Tools::getValue('lang');
            $tokens = Tools::getValue('cron_token');

            $cr = "<br />\n"; // carriage return

            echo $this->l('Starting Update in WS API/Cron Mode') . ' - ' . date('Y-m-d H:i:s') . $cr;

            // Regions
            //
            $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));    
            $marketLang2Region = array_flip($marketPlaceRegion) ;

            if ( ! isset($marketLang2Region[$lang]) || ! $marketLang2Region[$lang] )
                die($this->l('No selected language, nothing to do...')) ;    

            $id_lang = $marketLang2Region[$lang] ;

            $importDate = Amazon::configurationGet('AMAZON_LAST_CRON_UPDATED_' . $id_lang);

            $cronMode = true;
            $sendToAmazon = true;
        }
        //
        // Web Mode
        //
        else
        {
            $cr = "<br />\n"; // carriage return

            $importDate = Tools::getValue('importDate');

            echo $this->l("Starting Update in WS API/Web Mode") . ' - ' . date('Y-m-d H:i:s') ; 
            if ( $importDate ) 
                    echo ' - ' . $importDate . $cr;
            else    echo $cr ;

            $id_lang = intval(Tools::getValue('amazon_lang'));

            $tokens = Tools::getValue('amazon_token');

            $lastUpdated = Amazon::configurationGet('AMAZON_LAST_UPDATED_' . $id_lang);

            if (!intval($id_lang))
            {
                echo $this->l('No selected language, nothing to do...');
                die;
            }
            $cronMode = false;
            $sendToAmazon = false;
        }

        //
        //                
        // Global Parameters
        //
        $params = new Params($id_lang);
        $params->cronMode = $cronMode;
        $params->sendToAmazon = $sendToAmazon;
        $params->extendedDatas = intval(Tools::getValue('extended-datas')) ? true : false;
        $params->relationShipsOnly = intval(Tools::getValue('relations-only')) ? true : false;
        $params->xmlOnly = intval(Tools::getValue('xml-only')) ? true : false;
        $params->action = Tools::getValue('action');
       
        // Options 
        //
        if ( $params->relationShipsOnly )   $params->create = true ;

        // Attributes
        // 
        $Attributes = Attribute::getAttributes($params->id_lang);

        // Security Check
        //
        if (!Amazon_Tools::checkToken($tokens, $id_lang))
            die('Wrong Token');

        // Init
        //
        $params->platform = Amazon_Tools::selectPlatform($params->id_lang, $params->debug);

        $params->toCurrency = new Currency(Currency::getIdByIsoCode($params->platform['params']['Currency']));
        $params->fromCurrency = new Currency((int) (Amazon::configurationGet('PS_CURRENCY_DEFAULT')));

        if ( version_compare(_PS_VERSION_,'1.5','<') )
        {
            global $cart, $cookie ;
            $cart->id_currency = $cookie->id_currency = $params->fromCurrency->id ;
        }
        else
        {
            $controller = new FrontController();
            $controller->init();     
            
            $this->context = Context::getContext();
            $this->context->currency = new Currency(Configuration::get('PS_CURRENCY_DEFAULT')) ;            
        }
        
        if ($params->debug)
            echo nl2br(print_r($params->platform['auth'], true) . print_r($params->platform['params'], true) . print_r($params->platform['platforms'], true));

        $params->marketplaceID = $params->platform['auth']['MarketplaceID'] ;
        $params->merchantID = $params->platform['auth']['MerchantID'] ;
        $params->fullfillmentCenterId = Amazon_Tools::marketplaceIdToFullfillmentCenterId($params->platform['auth']['MarketplaceID']) ;
        
        if (!($this->_amazonApi = new Amazon_WebService($params->platform['auth'], $params->platform['params'], null, $params->debug)))
        {
            echo $this->l('Unable to login') . $cr;
            die;
        }

        // Wozapi Check
        //
        $wozapiAcknowledge = Amazon::configurationGet('AMAZON_WOZAPI_ACKNOWLEDGE') ;
        $wozapiAcknowledge = @unserialize($wozapiAcknowledge) ;
        
        if ( ! isset($wozapiAcknowledge[$params->platform['params']['Country']]))
            $wozapiAcknowledge = false ;
        else
            $wozapiAcknowledge = $wozapiAcknowledge[$params->platform['params']['Country']] ;
            
        $wozapiTimeOut = time() - 86400 ; // 1 day
        
        if ( $params->wozapi && $wozapiAcknowledge === false )
        {
            print($this->l('Wozapi never reached us, it is not considered as active at this time.') . $cr) ;            
            $params->wozapi = false ;
        }
        elseif ( $params->wozapi && $wozapiAcknowledge < $wozapiTimeOut )
        {
            print($this->l('Wozapi didn\'t reach us since more than 1 day, it is not considered as active anymore...') . $cr) ;
            $params->wozapi = false ;
        }
        
        // Amazon Throtlling Management
        // 
        $this->_amazonApi->setTimerReadHandler('Configuration', 'get', 'AMAZON_API_TIMER');
        $this->_amazonApi->setTimerWriteHandler('Configuration', 'updateValue', 'AMAZON_API_TIMER');

        /*
         * Obsolete : 2013-04-15
        if (defined('AMAZON_TRADER') && AMAZON_TRADER)
            require_once(dirname(__FILE__) . '/../classes/amazon.strategies.class.php');
        */
        
        if ( Tools::getValue('entire-catalog') )
            $params->entireCatalog = true ;
        
        if ($params->bruteForce)
        {
            $params->sendActives = false ;
            echo "Operating in brute force mode !<br />\n";
        }
        if (!$params->categories || !count($params->categories))
        {
            echo $this->l('Categories Settings not saved yet, nothing to do...') . $cr;
            die;
        }

        $params->syncBothMode = false;

        switch ($params->synchField)
        {
            case 'ean13' :
                $ps_code = 'ean13';
                $az_code = 'EAN';
                break;
            case 'upc' :
                $ps_code = 'upc';
                $az_code = 'UPC';
                break;
            case 'reference' :
                $ps_code = 'reference';
                $az_code = 'SKU';
                break;
            case 'both' :
                $params->syncBothMode = true;
                break;
        }
        
        if ($params->debug)
            if ($params->syncBothMode == true)
                printf($this->l('Synchronizing field are Prestashop: UPC/EAN (both)') . $cr);
            else
                printf($this->l('Synchronizing field are Prestashop: %s / Amazon: %s') . $cr, $ps_code, $az_code);

        // Synch with ASIN
        //
        if ($params->debug && $params->asinHasPriority)
            printf($this->l('But ASIN has the priority !') . $cr);

        $productsUpdate = array();
        $productsDelete = array();
        $u = 0;
        $d = 0;
        $duplicate = 0;
        $skipped = 0;
        $history = array();
        $Relationship = array();
        $parsedXSD = array() ;
        $synchProductsIds = array() ;
        
        switch ($params->action)
        {
            case 'update' :
                $params->sendToAmazon = true;
                break;
            case 'update-verify' :
                $params->sendToAmazon = false;
                break;            
            case 'create-verify' :
                $params->sendToAmazon = false;
                break;
            case 'create-export' :
                $params->sendToAmazon = true;                
                break;
            case 'delete-verify' :
                if ( (bool)Tools::getValue('delete-confirm') )
                {
                    $params->deleteProducts = true ;
                    $params->deleteConfirmed = true ;
                    $params->sendToAmazon = false;                
                }
                else
                {
                    $params->deleteProducts = true ;
                    $params->deleteConfirmed = false ;
                    $params->sendToAmazon = false;
                }
                break;
            case 'delete-export' :
                if ( (bool)Tools::getValue('delete-confirm') )
                {
                    $params->deleteProducts = true ;
                    $params->deleteConfirmed = true ;
                    $params->sendToAmazon = true;                
                }
                else
                {
                    $params->deleteProducts = true ;
                    $params->sendToAmazon = false;
                }
                break;            
            default :
                $params->sendToAmazon = false;
                break;
        }

        // Add customer customized PHP export file
        // Usefull to add PHP rules for particular cases
        //
        $params->customizedPhp = sprintf('%s/../custom/%s.products.php', dirname(__FILE__), $params->merchantID) ;
        
        if ( file_exists($params->customizedPhp) )
        {
            $params->customizedCall = true ;
        }
        
        // Creation Mode
        //
        if ( $params->create )
        {
            if ( $params->debug)
                printf('%s:%d - ' . $this->l('Starting in creation mode'). $cr, basename(__FILE__), __LINE__);                
        
            if ( Tools::getValue('limit') )
                $params->limit = (int)Tools::getValue('limit') ;            
            
            $this->_amazonApi->setOperationMode(Amazon_WebService::OPERATIONS_CREATE); 
            
            // Force Send Title & Description on Creation
            // 
            $params->extendedDatas = true ;
        
            if ( ! is_array($params->profile2category) || ! max($params->profile2category) )
            {
                $this->errorOutput($this->l('For creation mode you must configure or select at least one profile'), self::ERROR) ;
                die; 
            }
        }

        //  Products Update
        //
        $i = 0;

        // Envoi global ou mode brute 
        //
    
        if ($params->bruteForce || $params->entireCatalog)
        {
            // Clear Action Table 
            //
            if ( ! $params->create && $params->sendToAmazon )
                Amazon_Product::marketplaceActionReset($params->id_lang);

            $p = Amazon_Product::marketplaceGetAllProducts($params->id_lang, $params->sendActives, $params->dateSince);
        }
        else
        {
            if ( $params->deleteProducts )
                $p = Amazon_Product::marketplaceActionList($params->id_lang, Amazon::Remove, $params->limit);
            elseif ( $params->create )
                $p = Amazon_Product::marketplaceActionList($params->id_lang, Amazon::Add, $params->limit);
            else
                $p = Amazon_Product::marketplaceActionList($params->id_lang, null, $params->limit);
        }

        if ($p)
        foreach ($p as $key => $val)
        {
            // Action for this Product
            //
            $action = isset($val['action']) ? $val['action'] : Amazon::Add;

            $id_product = intval($val['id_product']);
            
            // Product
            //
            $details = new Product($id_product, false, $params->id_lang);

            // For product removal
            //
            if (!Validate::isLoadedObject($details))
            {    
                $details = new Product();
                $details->id = $id_product ;
            }
            
            // Both Synch Mode (EAN/UPC)
            //
            if ($params->syncBothMode)
            {
                $az_code = 'EAN';
                $ps_code = 'ean13';   
                
                if (isset($details->ean13) && !empty($details->ean13))
                {
                    $az_code = 'EAN';
                    $ps_code = 'ean13';
                }
                elseif (isset($details->upc) && !empty($details->upc))
                {
                    $az_code = 'UPC';
                    $ps_code = 'upc';
                }
            }

            // Profiles
            //
            $productData = NULL;
            $manufacturer = NULL;

            $profile_name = null;
            $profile_id = null;

            $variant = false ;

            $p_product_type = null ;
            $p_name = null ;
            $p_universe = null ;
            $p_formula = null ;
            $p_product_type = null ;
            $p_browsenode = null ;
            $p_field_size = null ;
            $p_field_color = null ;
            $p_parameters = null ;
            $p_category = null ;
            $p_extra = null ;
            $p_code_exemption = null ;
            $p_sku_as_supplier_reference = null ;
            $p_sku_as_sup_ref_unconditionnaly = null ;
            $p_item_type = null ;
            $p_price_rules = null ;
            $skip = false ;

            $parsedXSD = array() ;

            // switch to the right category
            $id_category = Amazon_Product::marketplaceGetCategory($id_product) ;

            if ( isset($params->profile2category[$id_category]) )
            {
                if ( in_array($id_category, $params->categories) )
                {
                    $profile_name = $params->profile2category[$id_category];
                    $profile_id = false;

                    if ( $params->profile['name'] )
                        foreach ($params->profile['name'] as $profile_id => $profile)
                            if ($profile == $profile_name)
                                break;

                    if ($profile_id !== false && ! empty($profile_name) )
                    {
                        if ($params->debug)
                            printf('Using profile [%s] ID: %s' . $cr, $profile_name, $profile_id);
                    }
                    elseif ( $params->create ) $skip = true ;    
                }
                else
                {
                    if ($params->debug)
                        printf('Profil is not in profiles list [%s] id: %s' . $cr, $profile_name, $profile_id);                        
                    if ( $params->create ) $skip = true ;
                }
                                
            }
            elseif ( $params->create ) 
                $skip = true ;
            
            if ( $profile_name && is_numeric($profile_id) )
            {
                if ($params->debug)
                    printf('Using profile : %s' . $cr, $profile_name);
                
                $p_product_type = $params->profile['product_type'][$profile_id];
                $p_name = $params->profile['name'][$profile_id];
                $p_universe = $params->profile['universe'][$profile_id];
                $p_formula = isset($params->profile['formula'][$profile_id]) ? $params->profile['formula'][$profile_id] : null ;
                $p_product_type = $params->profile['product_type'][$profile_id];
                $p_browsenode = isset($params->profile['browsenode_' . $params->id_lang][$profile_id]) ? $params->profile['browsenode_' . $params->id_lang][$profile_id] : null ;
                $p_field_size = $params->profile['field_size'][$profile_id];
                $p_field_color = $params->profile['field_color'][$profile_id];
                $p_parameters = $params->profile['parameters'][$profile_id];
                $p_category = $params->profile['category'][$profile_id];
                $p_code_exemption = isset($params->profile['code_exemption'][$profile_id]) && $params->profile['code_exemption'][$profile_id] ? $params->profile['code_exemption'][$profile_id] : false ;
                $p_code_exemption_options = isset($params->profile['code_exemption_options'][$profile_id]) && (is_array($params->profile['code_exemption_options'][$profile_id]) || is_numeric($params->profile['code_exemption_options'][$profile_id]) ) ? $params->profile['code_exemption_options'][$profile_id] : false ;
                $p_sku_as_supplier_reference = isset($params->profile['sku_as_supplier_reference'][$profile_id]) && $params->profile['sku_as_supplier_reference'][$profile_id] ? true : false ;
                $p_sku_as_sup_ref_unconditionnaly = isset($params->profile['sku_as_sup_ref_unconditionnaly'][$profile_id]) && $params->profile['sku_as_sup_ref_unconditionnaly'][$profile_id] ? true : false ;
                $p_item_type = isset($params->profile['item_type'][$profile_id]) ? $params->profile['item_type'][$profile_id] : null ;
                $p_price_rules = isset($params->profile['price_rule'][$profile_id]) && (int)$params->profile['price_rule'][$profile_id] ? $params->profile['price_rule'][$profile_id] : null ;
            }    

            if ($params->create && $profile_name)
            {                
                // Load XSD into an array - will be used to parse sort the XML as defined in the XSD
                //
                $xsdStructure = array();

                if ( $p_category && ! isset($parsedXSD[$p_category]) )
                {
                    try
                    {
                        $productFactory = new AmazonXSD($p_category.'.xsd');
                        $productInstance = $productFactory->getInstance();
                    }
                    catch(Exception $e)
                    {
                        die($this->l('Amazon XSD Exception :') . $e->getMessage()) ;
                    }  
                    
                    $p_parameters['xsd'] = $parsedXSD[$p_category] = $productFactory->getInstanceElementsArray($xsdStructure, $productInstance->ProductData); 

                    if ($params->debug)
                        printf('Creation mode: parsing XSD for category : %s' . $cr, $p_category);

                }
                elseif ( $p_category && isset($parsedXSD[$p_category]) )
                {
                    $p_parameters['xsd'] = $parsedXSD[$p_category] ;
                    
                    if ($params->debug)
                        printf('Creation mode: using parsed XSD for category : %s' . $cr, $p_category);                    
                }
                else
                {
                    printf('Unable to parse XSD definitions for profile %s' . $cr, $profile_name) ;
                    continue ;
                }

                if ( isset($params->profile['extra'][$profile_name]) )
                     $p_extra = $params->profile['extra'][$profile_name] ;
                else $p_extra = null ;
                
                if (!$p_product_type)
                {
                    if ($params->debug)
                        printf('Skipped: product has no product type - %s' . $cr, $id_product);                    
                    $skip = true ;
                }
            }
            elseif ( $params->create && ! $profile_name )
            {
                $category = new Category($id_category) ;
                $this->errorOutput(sprintf($this->l('Your category "%s" doesn\'t have a selected profile. For creation mode, you must select a profile.'), $category->name[$id_lang]), self::ERROR) ;
                continue ;
            }
            elseif ($params->create) $skip = true ;
            
            if ( $skip ) // mode creation - we filter the product which not have a profile
            {
                if ($params->debug)
                    printf('Skipped: product has no or wrong profile - %s' . $cr, $id_product);
                continue ;
            }
            
            $manufacturer = null ;

            
            // Fields required for product sheet creation
            //
            if ( $details->id_manufacturer )
            {
                if ( in_array($details->id_manufacturer, $params->excludedManufacturers) )
                {
                    if ($params->debug)
                        printf('Skipped: product is in manufacturers exclude list - %s' . $cr, $details->id_manufacturer);
                    continue ;
                }
                $manufacturer = Manufacturer::getNameById($details->id_manufacturer);
            }
            
            if ( $details->id_supplier )
            {
                if ( in_array($details->id_supplier, $params->excludedSuppliers) )
                {
                    if ($params->debug)
                        printf('Skipped: product is in suppliers exclude list - %s' . $cr, $details->id_supplier);
                    continue ;
                }                
            }
                    
                    
            // Product Combinations
            //
            if (version_compare(_PS_VERSION_, '1.5', '<'))
                $combinations = $details->getAttributeCombinaisons($params->id_lang);
            else
                $combinations = $details->getAttributeCombinations($params->id_lang);

            if (isset($val['sku']) && !empty($val['sku']))
                $reference = $val['sku'];
            else
                $reference = $details->reference;

            if (!isset($combinations) or !is_array($combinations) or empty($combinations))
                $combinations = array(0 => array(
                        'reference'            => $reference,
                        'price'                => 0,
                        'quantity'             => isset($details->quantity) ? $details->quantity : 0,
                        $ps_code               => isset($details->$ps_code) &&  $details->$ps_code ? $details->$ps_code : '',
                        'id_product_attribute' => 0,
                        'default_on'           => 0
                        ));

            $group_details = array();
            $color = $size = null;
            
            asort($combinations) ;
            
            // Grouping Combinations
            //
            foreach ($combinations as $combination)
            {
                $id_product_attribute = $combination['id_product_attribute'];

                if (! isset($group_details[$id_product_attribute]))
                    $group_details[$id_product_attribute] = array();
                $group_details[$id_product_attribute]['reference'] = $combination['reference'];

                // Attributes
                //
                $id_attribute_group = isset($combination['id_attribute_group']) ? $combination['id_attribute_group'] : null;
                $id_attribute = isset($combination['id_attribute']) ? $combination['id_attribute'] : null;

                if ( !isset($group_details[$id_product_attribute]['attribute_name']) )
                    $group_details[$id_product_attribute]['attribute_name'] = null ;
                
                if ( isset($combination['attribute_name']) && ! empty($combination['attribute_name']) )
                    $group_details[$id_product_attribute]['attribute_name'] .= sprintf('%s, ', $combination['attribute_name']) ;

                $group_details[$id_product_attribute]['quantity'] = $combination['quantity'];
                $group_details[$id_product_attribute]['default_on'] = $combination['default_on'];

                // Synch Field (EAN, UPC, SKU ...)
                //
                $group_details[$id_product_attribute][$ps_code] = $combination[$ps_code];

                // Attributes Values (Color, Size)...
                //
                if (isset($params->mapping_right[$params->id_lang][$id_attribute_group]) && is_array($params->mapping_right[$params->id_lang][$id_attribute_group]) && $params->create)
                {
                    if ($id_attribute_group == $p_field_color)
                    {
                        foreach ($Attributes as $attribute)
                            if ($attribute['id_attribute_group'] == $id_attribute_group && $attribute['id_attribute'] == $id_attribute)
                                $color = $attribute['name'];
                            
                        if ( ($index = array_search($id_attribute, $params->mapping_left[$params->id_lang][$id_attribute_group])) !== FALSE )
                        {
                            $group_details[$id_product_attribute]['ColorMap'] = trim($params->mapping_right[$params->id_lang][$id_attribute_group][$index]) ;
                            $group_details[$id_product_attribute]['Color'] = trim($color) ;
                        }
                    }
                    elseif ($id_attribute_group == $p_field_size)
                    {
                        foreach ($Attributes as $attribute)
                            if ($attribute['id_attribute_group'] == $id_attribute_group && $attribute['id_attribute'] == $id_attribute)
                                $size = $attribute['name'];

                        if ( ($index = array_search($id_attribute, $params->mapping_left[$params->id_lang][$id_attribute_group])) !== FALSE )
                        {
                            $group_details[$id_product_attribute]['SizeMap'] = trim($params->mapping_right[$params->id_lang][$id_attribute_group][$index]) ;
                            $group_details[$id_product_attribute]['Size'] = trim($size) ;
                        }                            
                    }
                    else
                    {
                        $index = array_search($id_attribute, $params->mapping_left[$params->id_lang][$id_attribute_group]) ;
                        $group_details[$id_product_attribute]['mapped_attributes'][$id_attribute_group] = trim($params->mapping_right[$params->id_lang][$id_attribute_group][$index]) ;
                    }
                }
            }
            $masterProduct = 0;
            $productIndex = 0 ;
            
            $details->name_attributes = null ;
                        
            // Export Combinations or Products Alone
            //
            foreach ($group_details as $id_product_attribute => $combination)
            {
                if ($params->debug)
                    echo nl2br(print_r($combination, true));

                if ( $id_product_attribute && ! $productIndex )
                        $masterProduct = 1 ;
                else    $masterProduct = 0 ;
                
                $productIndex++ ;

                if ( isset($combination['reference']) && ! empty($combination['reference']) && $az_code && $combination[$ps_code] )
                    printf($cr . '%s - ID: %d/%d - SKU: %s - %s: %s' . $cr, $details->name, $id_product, $id_product_attribute, isset($combination['reference']) ? $combination['reference'] : '#?#', $az_code, isset($combination[$ps_code]) && ! empty($combination[$ps_code]) ? $combination[$ps_code] : '#?#') ;
                
                if ( isset($combination['reference']) && ! empty($combination['reference']) && isset($history[ $combination['reference'] ]) )
                {
                    $this->errorOutput( sprintf($this->l('Duplicate entry for product %s(%d/%d) - Previously used by: %s - This is not allowed - Product skipped...'), $combination['reference'], $id_product, $id_product_attribute, $history[ $combination['reference'] ]), self::WARNING ) ;
                    $productIndex-- ;
                    $skipped++;
                    continue ;
                }
                $history[ $combination['reference'] ] = sprintf('%d/%d', $details->id, $id_product_attribute) ;
           
                if (empty($combination['reference']) && $ps_code != 'reference')
                {
                    if ( $params->debug )
                        printf( '%s:%s - ', basename(__FILE__), __LINE__);
                    $this->errorOutput(sprintf( $this->l('Skipping Product ID: %d/%d - Has No Reference'), $details->id, $id_product_attribute), self::WARNING) ;
                    
                    $productIndex-- ;
                    $skipped++;
                    continue;
                }

                if ( empty($combination[$ps_code]) && !$params->asinOverride && $action != Amazon::Remove && $ps_code != 'reference' && ! $p_code_exemption && ! $masterProduct )
                {
                    if ( $params->debug )
                        printf( '%s:%s - ', basename(__FILE__), __LINE__);
                    $this->errorOutput(sprintf( $this->l('Skipping Product ID: %d/%d - Has No %s'), $details->id, $id_product_attribute, strtoupper($ps_code)), self::WARNING) ;
                    
                    $productIndex-- ;
                    $skipped++;
                    continue;
                }    
                
                if ( $params->synchField != 'reference' && ! $p_code_exemption )
                {
                    $EAN_UPC = isset($combination[$ps_code]) && ! empty($combination[$ps_code]) ? $combination[$ps_code] :
                               (isset($details->$ps_code) && ! empty($details->$ps_code) ? $details->$ps_code : null) ;
                    
                    $EAN_UPC = trim($EAN_UPC) ;
                    
                    if ( ! $EAN_UPC )
                    {
                        if ($params->debug && $action != Amazon::Remove)
                            $this->errorOutput(sprintf('Skipping product %s which has no %s', $id_product, $ps_code), self::WARNING);
                        $productIndex-- ;
                        $skipped++;
                        continue ;
                    }

                    // Check if the code is a "reserved for local use" code.
                    //
                    if ( Amazon_Tools::EAN_UPC_isPrivate($EAN_UPC) )
                    {
                        $this->errorOutput( sprintf($this->l('Inconsistency for product %s(%d/%d) - Product code %s(%s) is reserved for local use - Skipping product'), $combination['reference'], $id_product, $id_product_attribute, $ps_code, $EAN_UPC), self::ERROR ) ;
                        $productIndex-- ;
                        $skipped++ ;
                        continue ;                        
                    }
                    
                    // Check EAN/UPC consistency
                    //
                    if ( ! Amazon_Tools::EAN_UPC_Check($EAN_UPC) )
                    {
                        $this->errorOutput(sprintf($this->l('Inconsistency for product %s(%d/%d) - Product code %s(%s) seems to be wrong - Skipping product'), $combination['reference'], $id_product, $id_product_attribute, $ps_code, $EAN_UPC), self::ERROR);
                        $productIndex-- ;
                        $skipped++ ;
                        continue ;                        
                    }
                           
                }

                if (isset($combination['attribute_name']) )
                    $details->name_attributes = $combination['attribute_name'] ;
                    
                if (version_compare(_PS_VERSION_, '1.5', '>='))
                    $quantity = Product::getRealQuantity($details->id, $id_product_attribute ? $id_product_attribute : null, $params->id_warehouse, $params->id_shop);
                else
                    $quantity = Product::getQuantity($details->id, $id_product_attribute ? $id_product_attribute : null);

                $productData = null ;
                $removeTagForParent = array() ;
                $productDataAttr = array() ;                
               
                // Handling Special Cases for Product Sheet Creation
                //
                if ( $params->create )
                {
                    if ( isset($p_parameters['Parentage']) )
                            $variant = true ;
                    else    $variant = false ;
                    
                    if ($params->debug)
                        $this->errorOutput(sprintf('Creation mode: using main category: %s product has variant: %s', $p_universe, $variant ? 'Yes' : 'No'), self::WARNING);
              
                    switch ($p_universe)
                    {
                        case 'Jewelry' :
                            $productData = array();
                            $productData['ProductType'] = $p_product_type;
                            $productData['Definition'] = $p_universe;
                            break ;
                            
                        case 'ProductClothing' :
                        case 'ClothingAccessories' :
                        case 'Shoes' :
                                
                            $productData = array();
                            $productData['ClothingType'] = $p_product_type;
                            $productData['Definition'] = $p_universe;

                            if ( $variant )
                            {
                              if (isset($combination['Color']) && isset($combination['Size']))
                              {
                                  $productData['Variation'] = true;

                                  $productData['Parentage'] = 'child';
                                  $productData['VariationTheme'] = 'SizeColor';

                                  $productData['Color'] = $combination['Color'];
                                  $productData['ColorMap'] = $combination['ColorMap'];

                                  $productData['Size'] = $combination['Size'];
                                  $productData['SizeMap'] = $combination['SizeMap'];
                              }
                              elseif (isset($combination['Color']))
                              {
                                  $productData['Variation'] = true;

                                  $productData['Parentage'] = 'child';
                                  $productData['VariationTheme'] = 'Color';

                                  $productData['Color'] = $combination['Color'];
                                  $productData['ColorMap'] = $combination['ColorMap'];
                              }
                              elseif (isset($combination['Size']))
                              {
                                  $productData['Variation'] = true;

                                  $productData['Parentage'] = 'child';
                                  $productData['VariationTheme'] = 'Size';

                                  $productData['Size'] = $combination['Size'];
                                  $productData['SizeMap'] = $combination['SizeMap'];
                              }
                            }
                            $removeTagForParent[] = 'Size' ;
                            $removeTagForParent[] = 'Color' ;
                            $removeTagForParent[] = 'ColorMap' ;
                            $removeTagForParent[] = 'SizeMap' ;
                            
                            if ( (isset($combination['Size']) && ! $productData['Size']) && (isset($combination['Color']) && ! $productData['Color']) )
                            {
                                $this->errorOutput(sprintf($this->l('Unable to export Combination/Variant %d/%d - Field Mapping is maybe missing - Skipping product') . $cr, $details->id, $id_product_attribute), self::WARNING);
                                $productData['Variation'] = false ;
                            }                              

                            if ($params->debug)
                                echo 'productData: ' . nl2br(print_r($productData, true)) ;
                            break;
                        default:
                            $productData = array();
                            
                            if ( $p_universe == 'CE' )
                            {
                                $productData['ProductType'] = 'ConsumerElectronics';
                                $productData['Definition'] = $p_universe;
                                $productData['ProductSubtype'] = $p_product_type;
                            }
                            else
                            {
                                $productData['ProductType'] = $p_product_type;
                                $productData['Definition'] = $p_universe;
                            }

                            if ( $variant )
                            {
                              if (isset($combination['Color']) && isset($combination['Size']))
                              {
                                  $productData['Variation'] = true;

                                  $productData['Parentage'] = 'child';
                                  
                                  if ( $p_universe == 'Sports' )
                                      $productData['VariationTheme'] = 'ColorSize';
                                  elseif ( in_array($p_universe, array('HomeImprovment')) )
                                      $productData['VariationTheme'] = 'Color-Size';
                                  elseif ( in_array($p_universe, array('AutoAccessory', 'Baby', 'Beauty', 'CE', 'Health', 'Home', 'HomeImprovment', 'SWVG', 'ToysBaby', 'WineAndAlcohol')) )
                                      $productData['VariationTheme'] = 'Size-Color';
                                  else
                                      $productData['VariationTheme'] = 'SizeColor';
                                  
                                  $productData['ColorMap'] = $combination['ColorMap'];
                                  $productData['SizeMap'] = $combination['SizeMap'];    
                                  
                                  // Baby > Baby Products Exception
                                  if ( in_array($p_universe, array('Baby')) && in_array($p_product_type, array('BabyProducts')) )
                                  {
                                    $colorIndex = 'ColorName' ;
                                    $sizeIndex  = 'SizeName' ;
                                  }
                                  else
                                  {
                                    $colorIndex = 'Color' ;                                          
                                    $sizeIndex  = 'Size' ;
                                  }

                                  $productData[$colorIndex] = $combination['Color'];
                                  $productData[$sizeIndex]  = $combination['Size'];
                              }
                              elseif (isset($combination['Color']))
                              {
                                  $productData['Variation'] = true;

                                  $productData['Parentage'] = 'child';
                                  $productData['VariationTheme'] = 'Color';

                                  $productData['ColorMap'] = $combination['ColorMap'];
                                  
                                  // Baby > Baby Products Exception
                                  if ( in_array($p_universe, array('Baby')) && in_array($p_product_type, array('BabyProducts')) )
                                    $colorIndex = 'ColorName' ;
                                  else
                                    $colorIndex = 'Color' ;
                                  
                                  $productData[$colorIndex] = $combination['Color'];
                              }
                              elseif (isset($combination['Size']))
                              {
                                  $productData['Variation'] = true;

                                  $productData['Parentage'] = 'child';
                                  $productData['VariationTheme'] = 'Size';

                                  $productData['SizeMap'] = $combination['SizeMap'];
                                  
                                  // Baby > Baby Products Exception
                                  if ( in_array($p_universe, array('Baby')) && in_array($p_product_type, array('BabyProducts')) )
                                    $sizeIndex = 'SizeName' ;
                                  else
                                    $sizeIndex = 'Size' ;
                                  
                                  $productData[$sizeIndex] = $combination['Size'];
                              }
                              
                              if ( (isset($combination['Size']) && ! $productData[$sizeIndex]) && (isset($combination['Color']) && ! $productData[$colorIndex]) )
                              {
                                  $this->errorOutput(sprintf($this->l('Unable to export Combination/Variant %d/%d - Field Mapping is maybe missing - Skipping product') . $cr, $details->id, $id_product_attribute), self::WARNING);
                                  $productData['Variation'] = false ;
                              }                              
                            }
                            $removeTagForParent[] = 'ColorMap' ;
                            $removeTagForParent[] = 'SizeMap' ;
                            
                            if ( isset($sizeIndex) )
                                $removeTagForParent[] = $sizeIndex ;
                            if ( isset($colorIndex) )
                                $removeTagForParent[] = $colorIndex ;
                            
                            if ($params->debug)
                                echo 'productData: ' . nl2br(print_r($productData, true)) ;
                            break;
                    }
                    
                
                    // Incomplete Item
                    //
                    if ( $variant && isset($productData['Variation']) && $productData['Variation'] === false )
                    {
                        $productIndex-- ;
                        continue ;
                    }
                    // Extra Fields - cf xsd_operations.php
                    //
                    if ( $p_extra )
                    {
                        foreach($p_extra['field'] as $name => $value)
                        {
                            $value = null ;

                            // This is a standard required field
                            //
                            if ( isset($p_extra['field'][$name]) && $p_extra['field'][$name] )
                            {
                                // Already sets - eg: Color
                                if ( isset($productData[$name]) )   continue ;
                                
                                $value = $p_extra['field'][$name] ;
                            } 
             
                            // This is a specific variant (eg: Jewelry) description
                            //
                            if ( isset($p_extra['variant']) && isset($p_extra['field']['variant']) && ! empty($p_extra['field']['variant'])  )
                            {
                                $profile_variant_name = $p_extra['field']['variant'] ;
                                $profile_variants = $p_extra['variant'][$profile_variant_name] ;

                                if ( $variant )
                                {
                                    $productData['Variation'] = true;
                                    $productData['Parentage'] = 'child';
                                    $productData['VariationTheme'] = $profile_variant_name ;
                                }                                
                                
                                // Associating Variant(Amazon) and Combination(Prestashop)
                                //
                                foreach($profile_variants as $tagName => $psAttribute)
                                {
                                    $value = null ;

                                    if ( isset($combination['mapped_attributes'][$psAttribute]) )
                                        $value = trim($combination['mapped_attributes'][$psAttribute]) ;                                    
                                    
                                    if ( ! $value )   continue ;
                                    
                                    // Found a mapped value for this tag
                                    //
                                    $productData[$tagName] = $value ;
                                    
                                    $removeTagForParent[] = $tagName ;
                                    
                                    // Found an Amazon tag's attribute for this value
                                    //
                                    if ( isset($p_extra['attributes'][$tagName]) && isset($p_extra['attributes'][$profile_variant_name][$tagName]) && $p_extra['attributes'][$profile_variant_name][$tagName] )
                                        $productDataAttr[$tagName] = $p_extra['attributes'][$profile_variant_name][$tagName] ; 
                                }
                            }

                            // This is a feature/characteristic
                            //
                            if ( isset($p_extra['characteristic'][$name]) && isset($p_extra['field'][$name]) && ($p_extra['field'][$name] || isset($p_extra['required'][$name])) )
                            {
                                // Already sets - eg: Color
                                if ( isset($productData[$name]) )   continue ;
                                
                                if ( isset($p_extra['required'][$name]) )
                                        $id_feature = (int)$p_extra['characteristic'][$name] ;
                                else
                                        $id_feature = (int)$p_extra['field'][$name] ;
                                
                                // Lookup For Features
                                //
                                $features = $details->getFeatures() ;
                                $feature  = null ;
                                $id_feature_value = null ;
                                
                                if ( intval($id_feature) && $features )
                                    foreach($features as $feature)
                                        if ( $id_feature == $feature['id_feature'] )
                                                foreach(FeatureValue::getFeatureValueLang($feature['id_feature_value']) as $feature_value)
                                                    if ( $feature['id_feature_value'] == $feature_value['id_feature_value'] && $feature_value['id_lang'] == $id_lang )
                                                    {
                                                        $value = $feature_value['value'] ;
                                                        $id_feature_value = $feature['id_feature_value'] ;
                                                        break ;
                                                    }

                                // Matched Feature
                                //
                                if ( $features && $id_feature_value && $value )
                                {
                                    // Mapped Value

                                    if ( isset($params->features_mapping_right[$id_lang][$id_feature]) )
                                    {
                                        $index = array_search($id_feature_value, $params->features_mapping_left[$id_lang][$id_feature]) ;

                                        if ( $index !== false && $index !== null )
                                            $value = $params->features_mapping_right[$id_lang][$id_feature][$index] ;
                                    }
                                    $productData[$name] = $value ;
                                }
                                
                                // Found an Amazon tag's attribute for this value
                                //
                                if ( isset($p_extra['characteristic'][$name]) && is_array($p_extra['characteristic'][$name]) && $p_extra['characteristic'][$name] )
                                    $productDataAttr[$name] = $p_extra['characteristic'][$name] ; 

                                if ( isset($p_extra['required'][$name]) && (! isset($productData[$name]) || empty($p_extra['required'][$name])) && ! $value )
                                {
                                    $this->errorOutput(sprintf($this->l('Inconsistency for product %d/%d - %s is a required field'), $details->id, $id_product_attribute, $name), self::WARNING);
                                }
                            }  
                            
                            // This is a standard extra field with attributes
                            //
                            if ( isset($p_extra['attributes'][$name]) && ! isset($productData[$name]) )
                            {
                                $productData[$name] = $value ;
                                $productDataAttr[$name] = $p_extra['attributes'][$name] ; 
                            }
                            elseif ( $value && ! isset($productData[$name]) )
                            {
                                $productData[$name] = $value ;
                            }
                        }
                    }

                    // IMPORTANT !                    
                    $productData['Parameters'] = $p_parameters;
                    $productData['Attributes'] = $productDataAttr;

                    
                    if ( isset($p_code_exemption_options['private_label']) && (int)$p_code_exemption_options['private_label'] )
                    {
                        $productData['RegisteredParameter'] = 'PrivateLabel' ;
                    }
                    elseif ( $p_code_exemption == Amazon::EXEMPTION_COMPATIBILITY )
                    {
                        // 2013-03-23 - Added : EAN/UPC Exemption support for products outside Jewelry and Handycraft
                        $productData['RegisteredParameter'] = 'PrivateLabel' ;
                    }
                    
                    
                    if ( $p_code_exemption )
                    {
                        $productTag = isset($productData['ClothingType']) ? 'ClassificationData' : 'ProductType' ; 
                        
                        if ( $p_universe == 'ProductClothing' )
                            $p_universe = 'Clothing' ; 
                    }
                    
                    switch($p_code_exemption)
                    {
                        case Amazon::EXEMPTION_MODEL_NUMBER :
                            $productData['Parameters']['ModelNumber'] = array($p_universe, $productTag, 'ModelNumber') ; 
                            $productData['ModelNumber'] = $combination['reference'] ;
                            break ;
                        case Amazon::EXEMPTION_MODEL_NAME :
                            $productData['Parameters']['ModelName'] = array($p_universe, $productTag, 'ModelName') ; 
                            $productData['ModelName'] = $combination['reference'] ;
                            break ;
                        case Amazon::EXEMPTION_MFR_PART_NUMBER :
                            $productData['MfrPartNumber'] = $combination['reference'] ;
                            break ;
                        case Amazon::EXEMPTION_CATALOG_NUMBER :
                            $productData['MerchantCatalogNumber']  = $combination['reference'] ;
                            break ;
                        case Amazon::EXEMPTION_GENERIC :
                            // Only Private Label is forced and sent
                            $p_code_exemption_options['private_label'] = true ;
                            break ;
                    }                    
                    
                    // 2013-03-29 - Added : AutoAccessory / ItemPackageQuantity - this is required i don't know why ?
                    //
                    if ( $p_universe == 'AutoAccessory' && ! isset($productData['ItemPackageQuantity']) )
                    {
                        $productData['ItemPackageQuantity'] = 1 ;
                    }
                    // 2013-06-14 - Added : Industrial / NumberOfItems - this is required.
                    //
                    elseif ( $p_universe == 'Industrial' && ! isset($productData['NumberOfItems']) )
                    {
                        $productData['NumberOfItems'] = 1 ;
                    }

                    // The goal is the first combination is the parent and the subsequent the childrens
                    //
                    if ( $variant )
                    {
                      if ( empty($details->reference) )
                      {
                            $this->errorOutput(sprintf($this->l('Inconsistency for product %d/%d - Is a Combination/Variant and has no Master Reference - Skipping product'), $details->id, $id_product_attribute), self::WARNING);
                            $skipped++ ;
                            continue ;
                      }
                      if (isset($productData['Variation']) && $productData['Variation'] && !isset($Relationship[$details->reference]))
                      {
                          // Adding children to the relationships - first child
                          $Relationship[$details->reference] = array() ;
                          $Relationship[$details->reference]['parent'] = $details->reference;
                          $Relationship[$details->reference]['children'] = array();
                          $Relationship[$details->reference]['children'][] = $combination['reference'];
                      }
                      elseif ( isset($productData['Variation']) && $productData['Variation'])
                      {
                          // Adding children to the relationships - children
                          $Relationship[$details->reference]['children'][] = $combination['reference'];
                      }
                    }
                }

                // Execute external custom PHP code
                //
                if ( $params->customizedCall )
                {
                    if ( $params->debug)
                        printf('%s:%d - Executing external PHP customized call: %s'. $cr, basename(__FILE__), __LINE__, basename($params->customizedPhp));                    
                    
                    if ( $params->create )
                    {
                        include($params->customizedPhp) ;
                    }
                }
                
                // Send Images
                //
                if ($params->images)
                {
                    if ( ($_SERVER['HTTP_HOST'] == 'localhost' || $_SERVER['HTTP_HOST'] == '127.0.0.1') && ! $params->xmlOnly )
                    {
                        $this->errorOutput(sprintf('Warning : %s' . "$cr", $this->l('Unable to send images from localhost')));
                        $params->images = NULL;
                    }        
                    else
                    {
                        $productData['ProductImage'] = array();
                        $imageIndex = 1 ;

                        foreach (Amazon_Tools::getProductImages($id_product, $id_product_attribute, $id_lang) as $image)
                        {        
                            $productData['ProductImage'][] = $params->images_url . $image;
                            if ( $imageIndex++ > 8 )
                                break ;
                        }

                        if ($productData['ProductImage'])
                            if ($this->_debug)
                                printf('Products Images: %s' . $cr, print_r($productData['ProductImage'], true));
                    }
                }
                
                // Per Category / Formula
                //
                if (!empty($p_formula))
                    $selected_formula = $p_formula;
                elseif ( !empty($params->formula) )
                    $selected_formula = $params->formula;
                else
                    $selected_formula = null ;

                // Get price only if the product is not to be removed from Amazon
                if ( Validate::isLoadedObject($details) )
                {                
                    // Price Formula (see Admin > Module > Amazon)
                    //
                    $stdPrice = $details->getPrice($params->useTax, ($id_product_attribute ? $id_product_attribute : null), 6, NULL, false, ! $details->on_sale && $params->specials) ;
                  
                    // Price Filter
                    // 
                    if ( $params->priceFilter && isset($params->priceFilter['gt']) && (int)$params->priceFilter['gt'] && (float)$stdPrice > (float)$params->priceFilter['gt'] )
                    {
                        $this->errorOutput(sprintf($this->l('Skipping filtered product: price %.2f > %.2f'), $stdPrice, $params->priceFilter['gt']), self::WARNING);
                        continue ;                    
                    }
                    elseif ( $params->priceFilter && isset($params->priceFilter['lt']) && (int)$params->priceFilter['lt'] && (float)$stdPrice < (float)$params->priceFilter['lt'] )
                    {
                        $this->errorOutput(sprintf($this->l('Skipping filtered product: price %.2f < %.2f'), $stdPrice, $params->priceFilter['lt']), self::WARNING);
                        continue ;                    
                    }
                                        
                    if ( $p_price_rules )
                    {
                        $newPrice = Amazon_Tools::PriceRule($stdPrice, $p_price_rules);
                    }
                    elseif ( $params->priceRules )
                    {
                        $newPrice = Amazon_Tools::PriceRule($stdPrice, $params->priceRules);
                    }
                    elseif ( $selected_formula )
                    {
                        $newPrice = Amazon_Tools::Formula($stdPrice, $selected_formula);
                    }               

                    $sales = array() ;

                    // Apply Sales for PS > 1.4
                    //
                    if ( version_compare(_PS_VERSION_, '1.4', '>=') && $params->specials )
                    {
                        if ( version_compare(_PS_VERSION_, '1.5', '>=') )
                        {
                            $id_group = Configuration::get('PS_CUSTOMER_GROUP') ;
                        }
                        else
                        {
                            $id_group = (int)_PS_DEFAULT_CUSTOMER_GROUP_ ;
                        }

                        $specificPrice = SpecificPrice::getSpecificPrice($id_product, $params->id_shop, $params->fromCurrency->id, (int)Amazon::configurationGet('PS_COUNTRY_DEFAULT'), $id_group, 1, $id_product_attribute) ;

                        // Sales
                        //
                        if ( $details->on_sale && $specificPrice && isset($specificPrice['reduction_type']) && isset($specificPrice['from']) && isset($specificPrice['to']) && intval($specificPrice['from']) && intval($specificPrice['to']) )
                        {
                            // ISO 8601
                            $dateStart    = date('c', strtotime($specificPrice['from'])) ;
                            $dateEnd      = date('c', strtotime($specificPrice['to'])) ;

                            $salePrice    = $details->getPrice($params->useTax, ($id_product_attribute ? $id_product_attribute : null), 6, NULL, false, $params->specials) ; 

                            if ( $params->specialsApplyRules )
                            {
                                if ( $p_price_rules )
                                {
                                    $salePrice = Amazon_Tools::PriceRule($salePrice, $p_price_rules);
                                }
                                elseif ( $params->priceRules )
                                {
                                    $salePrice = Amazon_Tools::PriceRule($salePrice, $params->priceRules);
                                }                                
                            }                            
                        
                            if ($params->fromCurrency->iso_code != $params->toCurrency->iso_code)                
                                $salePrice = Tools::convertPrice($salePrice, $params->toCurrency);          

                            $salePrice = Amazon_Tools::CallBack($salePrice, $params->callback) ;

                            printf('%s : %s - %s : %s %s %s %s' . $cr, $this->l('Apply Sale Price'), $dateStart, $dateEnd, $this->l('Old Price'), Tools::displayPrice($stdPrice),  $this->l('Sale Price'), $salePrice);                          

                            $sales['dateStart']   = $dateStart ;
                            $sales['dateEnd']     = $dateEnd ;
                            $sales['salePrice']   = $salePrice ;
                        }
                    }
                    if ($params->debug)
                        printf('Apply formula - price : %s was : %s' . $cr, Tools::displayPrice($newPrice), Tools::displayPrice($stdPrice));
                }
                else
                {
                    $stdPrice = $newPrice = null ;
                }
                
                // Override Price with Price/Strategy (Option)
                //
                /* Obsolete : 2013-04-15
                if (defined('AMAZON_TRADER') && AMAZON_TRADER)
                {
                    $strategy = new Amazon_Strategy($combination['reference'], true, $params->id_lang);

                    if ($strategy->lookup())
                        if (($stratege = $strategy->get()))
                            $newPrice = Amazon_Tools::Formula($stratege['actual_price'], $selected_formula);
                }
                */
                // Product Options
                //
                $options = Amazon_Product::getProductOptions($id_product, $params->id_lang);

                $disabled = $options['disable'] ? true : false;
                $force = $options['force'] ? true : false;
                $text = $options['text'];
                $latency = intval($options['latency']);
                $shipping = $options['shipping'];
                $shipping_type = intval($options['shipping_type']);
                $nopexport = $options['nopexport'] ? $options['nopexport'] : $params->stockOnly;
                $noqexport = $options['noqexport'] ? $options['noqexport'] : $params->pricesOnly ;
                $bulletPoints = array() ;
                
                // Bullet Points (2013-08-19)
                if ( isset($options['bullet_point1']) )
                    foreach( array('bullet_point1', 'bullet_point2', 'bullet_point3', 'bullet_point4', 'bullet_point5') as $bullet_item )
                    {
                        if ( ! isset($options[$bullet_item]) || empty($options[$bullet_item]) )     continue ;
                        
                        $bulletPoints[] = mb_substr(Amazon_Tools::encodeText($options[$bullet_item], $params->safeEncoding), 0, Amazon::LENGTH_BULLET_POINT) ;
                    }
                
                if ( $params->FBA )
                        $fba = $options['fba'] ? true : false ;
                else    $fba = false ;
                
                if ( $params->wozapi && ! $params->create )
                {
                    // Uncomment to do not export prices on products updates 
                    if ($params->debug)
                        printf('Wozapi is active. Price is not exported' . $cr) ;
                    
                    // in case of an FBA product, we send the price (for cases of product switching from MFN > FBA)
                    if ( ! ($fba && $options['fba_value']) ) 
                        $nopexport = true ; 
                }
                
                // Synchronizing by ASIN (ASIN override)
                //
                if ($params->asinHasPriority && isset($options['asin1']) && !empty($options['asin1']))
                    $params->asinOverride = true;
                else
                    $params->asinOverride = false;

                if ($params->debug && $params->asinOverride)
                    printf('Using ASIN override mode' . $cr);

                if ( ! empty($options['price']) && (float)$options['price'] )
                {
                    $newPrice = (float)$options['price'] ;
                    
                    if ($params->debug)
                        printf('Price Override: %.02f' . $cr, $newPrice);     
                }
                
                // Using Fulfilment By Amazon
                //
                if ( $params->FBA && $fba )
                {
                    $beforeFBAPrice = $newPrice ;
                    
                    if ( $params->debug )
                        printf('Using FBA' . $cr);     
                    
                    // FBA Value Added 
                    if ( (float)$options['fba_value'] > 0 )
                    {
                        if ($params->debug)
                            printf('FBA Value Added: %.02f' . $cr, (float)$options['fba_value']);    
                        
                        $newPrice += (float)$options['fba_value'] ;
                        
                    }
                    // FBA Formula
                    elseif ( $params->fbaFormula )
                    {
                        if ( $params->debug )
                            printf('Apply FBA Formula: %s' . $cr, $params->fbaFormula);
                        
                        $newPrice = Amazon_Tools::Formula($newPrice, $params->fbaFormula);
                    }
                }
               

                // Convert to platform currency
                //
                if ($params->fromCurrency->iso_code != $params->toCurrency->iso_code)
                {
                    $oldPrice = $newPrice;
                    $newPrice = Tools::convertPrice($newPrice, $params->toCurrency);

                    if ($params->debug)
                        printf('Convert from currency: %s to currency: %s - price is: %s and was %s' . $cr, $params->fromCurrency->iso_code, $params->toCurrency->iso_code, $newPrice, $oldPrice);
                }

                // Price CallBack (see Admin > Module > Amazon)
                //
                $newPrice = Amazon_Tools::CallBack($newPrice, $params->callback);

                // Out of Stock policies
                //
                if ($quantity < $params->outOfStock && isset($details->out_of_stock) && !Product::isAvailableWhenOutOfStock($details->out_of_stock) && !$force)
                {
                    $quantity = 0;
                }
                elseif ($quantity < $params->outOfStock && !$force)
                {
                    $quantity = 0;
                }
                elseif ($force)
                {
                    $quantity = 999;
                }

                if (!$details->active )
                {
                    $quantity = 0;
                }

                if ( ! $params->deleteProducts && ! $params->authorizeToDelete && ! $params->bruteForce && ! $params->create && $params->entireCatalog && (! $quantity || !$details->active || $disabled) ) 
                {
                    if ( ! $quantity )
                        printf($this->l('Skipped out of stock product'). $cr);
                    elseif ( ! $details->active)
                        printf($this->l('Skipped inactive product'). $cr) ;
                    elseif ( $disabled )
                        printf($this->l('Skipped disabled product'). $cr) ;
                    $productIndex-- ;
                    $skipped++ ;
                    continue ;                        
                }
                $delete = false ;
                
                if ( (! $params->create) && $params->authorizeToDelete && ($quantity == 0 || !$details->active)  )
                    $delete = true ;
                
                if ( (! $params->create) && ($action == Amazon::Update || $action == Amazon::Add || $action == Amazon::Remove) && $params->authorizeToDelete && ($disabled || !$details->active) )
                    $delete = true ;

                if ( $action == Amazon::Remove && $params->deleteConfirmed )
                    $delete = true ;
                
                if ( $disabled && ($params->bruteForce || $params->entireCatalog) && $params->authorizeToDelete )
                {
                    $delete = true ;
                }
                elseif ( $disabled )
                {
                    printf($this->l('Skipped disabled product'). $cr) ;
                    $productIndex-- ;
                    $skipped++ ;                    
                }
                    
                if ( ! $params->create && $params->deleteProducts && ($quantity == 0 && ($combination[$ps_code] || $params->asinOverride) ) || $delete)
                {
                    $productsDelete[$d]['SKU'] = $combination['reference'];

                    if (!isset($productsDelete[$d]['SKU']) || empty($productsDelete[$d]['SKU']))
                    {
                        if ($params->debug)
                            printf('Skipping : %d - Has No SKU !' . "$cr", $details->id_product);
                        $skipped++;
                        continue;
                    }

                    if ($params->asinOverride)
                    {
                        $productsDelete[$d]['ProductIDType'] = 'ASIN';
                        $productsDelete[$d]['ProductIDCode'] = trim($options['asin1']);
                    }
                    elseif ($ps_code != 'reference')
                    {
                        $productsDelete[$d]['ProductIDType'] = $az_code;
                        $productsDelete[$d]['ProductIDCode'] = trim($combination[$ps_code]);
                    }
                    if ( $delete )
                        $reason = 'Deleted';
                    else
                        $reason = 'OutOfStock';

                    printf('Delete() : %s %s %s - %s' . "$cr", isset($productsDelete[$d]['ProductIDType']) ? $productsDelete[$d]['ProductIDType'] : '', isset($productsDelete[$d]['ProductIDCode']) ? $productsDelete[$d]['ProductIDCode'] : '-', $productsDelete[$d]['SKU'], $reason);

                    $productIndex-- ;
                    $synchProductsIds[] = $id_product ;
                    $d++;
                }
                elseif ($action == Amazon::Update || $action == Amazon::Add)
                {
                    $productsUpdate[$u]['SKU'] = trim($combination['reference']);

                    if (!isset($productsUpdate[$u]['SKU']) || empty($productsUpdate[$u]['SKU']))
                    {
                        if ($params->debug)
                            printf('Skipping : %d - Has No SKU !' . "$cr", $details->id_product);
                        $skipped++;
                        continue;
                    }

                    // If this is a new product, quantity = 0 and deleteProducts is sets to On (configuration)
                    // Do not export the product to delete it the next time !
                    //
                    if ($action == Amazon::Add && $params->authorizeToDelete && !$quantity && ! $params->create)
                    {
                        if ($params->debug)
                            printf('Skipping : %d - Has a quantity of 0 and deleteProducts is sets to on' . "$cr", $details->id_product);
                        $skipped++;
                        continue;
                    }

                    if ($params->asinOverride)
                    {
                        $productsUpdate[$u]['ProductIDType'] = 'ASIN';
                        $productsUpdate[$u]['ProductIDCode'] = trim($options['asin1']);
                    }
                    elseif ($ps_code != 'reference')
                    {
                        $productsUpdate[$u]['ProductIDType'] = $az_code;
                        $productsUpdate[$u]['ProductIDCode'] = trim($combination[$ps_code]);
                    }
                    $productCondition = isset($details->condition) && !empty($details->condition) && isset($params->conditionMap[$details->condition]) && !empty($params->conditionMap[$details->condition]) ? $params->conditionMap[$details->condition] : 'New';

                    $productsUpdate[$u]['ConditionType'] = $productCondition;
                    $productsUpdate[$u]['ConditionNote'] = $text;
                    $productsUpdate[$u]['Quantity'] = $quantity;
                    $productsUpdate[$u]['Price'] = $newPrice;
                    $productsUpdate[$u]['NoPriceExport'] = $nopexport ? true : false;
                    $productsUpdate[$u]['NoQtyExport'] = $noqexport ? true : false;
                    $productsUpdate[$u]['Sales'] = $sales ;
                   
                    // Product Sheet Elements
                    //
                    if ($params->extendedDatas)
                    {
                        if (!isset($productsUpdate[$u]['ProductDescription']))
                            $productsUpdate[$u]['ProductDescription'] = array();

                        $master_name = trim(mb_substr($details->name, 0, Amazon::LENGTH_TITLE));

                        if ( isset($productData['MerchantCatalogNumber']))
                            $productsUpdate[$u]['ProductDescription']['MerchantCatalogNumber'] = $productData['MerchantCatalogNumber'] ;
                        
                        if ( isset($details->name_attributes) && ! empty($details->name_attributes) && $id_product_attribute )
                                $standard_name = trim(mb_substr(sprintf('%s - %s', $details->name, rtrim($details->name_attributes, ', ')), 0, Amazon::LENGTH_TITLE));
                        else    $standard_name = $master_name ;
                        
                        switch($params->titleFormat)
                        {
                            case Amazon::FormatManufacturerTitle :
                                if ( ! $manufacturer )
                                {
                                    $name = $standard_name ;
                                    break ;
                                }
                                $master_name = trim(mb_substr(sprintf('%s - %s', $manufacturer, $details->name), 0, Amazon::LENGTH_TITLE));
                                
                                if ( isset($details->name_attributes) && ! empty($details->name_attributes) && $id_product_attribute )
                                        $name = trim(mb_substr(sprintf('%s - %s - %s', $manufacturer, $details->name, rtrim($details->name_attributes, ', ')), 0, Amazon::LENGTH_TITLE));
                                else    $name = $master_name ;                                
                                break ;
                                
                            case Amazon::FormatManufacturerTitleReference :
                                if ( ! $manufacturer )
                                {
                                    $name = $standard_name ;
                                    break ;
                                }
                                $master_name = trim(mb_substr(sprintf('%s - %s - %s', $manufacturer, $details->name, trim($details->reference)), 0, Amazon::LENGTH_TITLE - 1));  
                                
                                if ( isset($details->name_attributes) && ! empty($details->name_attributes) && $id_product_attribute )
                                        $name = trim(mb_substr(sprintf('%s - %s - %s - %s', $manufacturer, $details->name, trim($details->reference), rtrim($details->name_attributes, ', ')), 0, Amazon::LENGTH_TITLE));
                                else    $name = $master_name ;                              
                                break ;                                
                            default :
                                $name = $standard_name ;
                                break ;                                
                        }
                        $productsUpdate[$u]['ProductDescription']['Title'] = Amazon_Tools::encodeText(trim($name), $params->safeEncoding) ;

                        // 2014-02-27 : Added > Concat Description Short and Long
                        //
                        switch($params->descriptionField)
                        {
                            case Amazon::FieldDescriptionShort : 
                                $description = $details->{Amazon::FieldDescriptionShort} ;
                                break; 
                            
                            case Amazon::FieldDescriptionBoth :
                                
                                if ( strlen($details->{Amazon::FieldDescriptionLong}) && strlen($details->{Amazon::FieldDescriptionShort}) )
                                {
                                    $description  = $details->{Amazon::FieldDescriptionShort} ;
                                    $description .= '<br /><br />' ;
                                    $description .= $details->{Amazon::FieldDescriptionLong} ;
                                }
                                elseif ( strlen($details->{Amazon::FieldDescriptionLong}) )
                                {
                                    $description = $details->{Amazon::FieldDescriptionLong} ;
                                }
                                else
                                {
                                    $description = $details->{Amazon::FieldDescriptionShort} ;
                                }
                                break; 
                            
                            default :
                                $description = $details->{Amazon::FieldDescriptionLong} ;
                                break; 
                        }
                        
                        if ( $params->sendHTMLDescriptions )
                            $description = trim($description) ;
                        else
                            $description = Amazon_Tools::strip_html(trim($description)) ;

                        $productsUpdate[$u]['ProductDescription']['Description'] = mb_substr(Amazon_Tools::encodeText(trim($description), $params->safeEncoding), 0, Amazon::LENGTH_DESCRIPTION) ;
                        $productsUpdate[$u]['ProductDescription']['BulletPoint'] = $bulletPoints ;
                    }
                    
                    // Send Images
                    //
                    if ( $params->images && $productData['ProductImage'] )
                    {
                        if (!isset($productsUpdate[$u]['ProductData']))
                            $productsUpdate[$u]['ProductData'] = array();

                        $productsUpdate[$u]['ProductData'] = $productData;
                    }

                    // Product Sheet Creation
                    //
                    if ( $profile_name && $params->extendedDatas )
                    {
                        if (!isset($productsUpdate[$u]['ProductDescription']))
                            $productsUpdate[$u]['ProductDescription'] = array();
                        
                        if ($manufacturer)
                            $productsUpdate[$u]['ProductDescription']['Manufacturer'] = $manufacturer;
                        else
                            $this->errorOutput(sprintf( $this->l('Skipping : %d - Item creation might be skipped - Brand is not set') . "$cr", $details->id));
                            
                        // In most cases it is same than manufacturer
                        if ($manufacturer)
                            $productsUpdate[$u]['ProductDescription']['Brand'] = $manufacturer;
                   
                        if ($productData)
                        {
                            if (!isset($productsUpdate[$u]['ProductData']))
                                $productsUpdate[$u]['ProductData'] = array();

                            $productsUpdate[$u]['ProductData'] = $productData;
                        }
                                             
                        // 2013/03/16
                        // Arnaud Lempereur / Amazon France said:
                        // MfrPartNumber is not mandatory
                        // 2013/03/22
                        // Arnaud Lempereur / Amazon France said: MfrPartNumber is only mandatory for Office > PaperProducts
                        // 2013/03/29
                        // Arnaud Lempereur / Amazon France said: MfrPartNumber is mandatory also for Auto Accessory
                        //

                        if ( ! isset($productData['MfrPartNumber']) && in_array($p_product_type, AmazonXSD::$requireMfrPartNumber) )
                        {
                            if ( version_compare(_PS_VERSION_,'1.5','>=') )
                                $supplier_reference = ProductSupplier::getProductSupplierReference($id_product, $id_product_attribute, $details->id_supplier) ;
                            else
                                $supplier_reference = $details->supplier_reference ;

                            if ( empty($supplier_reference) )
                                $p_sku_as_supplier_reference = true ;
                            else
                                $productsUpdate[$u]['ProductDescription']['MfrPartNumber'] = $supplier_reference ;
                        }
                        elseif ( isset($productData['MfrPartNumber']) )  // GCID from Custom File
                        {
                            $productsUpdate[$u]['ProductDescription']['MfrPartNumber'] = $productData['MfrPartNumber'] ;
                        }
                        
                        if ( $p_sku_as_supplier_reference && $p_sku_as_sup_ref_unconditionnaly )
                            $productsUpdate[$u]['ProductDescription']['MfrPartNumber'] = $combination['reference'] ;
                        elseif ( $p_sku_as_supplier_reference && empty($details->supplier_reference)  )
                            $productsUpdate[$u]['ProductDescription']['MfrPartNumber'] = $combination['reference'] ;
                        elseif ( $p_sku_as_supplier_reference && ! empty($details->supplier_reference)  )
                            $productsUpdate[$u]['ProductDescription']['MfrPartNumber'] = $details->supplier_reference ;
                        
                        // Fill Item Type for U.S. or BrowseNode for Europe - 2014/03/13
                        //
                        if ( (Amazon_Tools::isUSMarketplaceId($params->marketplaceID) || Amazon_Tools::isINMarketplaceId($params->marketplaceID)) && ! empty($p_item_type) )
                        {
                            $productsUpdate[$u]['ProductDescription']['ItemType'] = $p_item_type ;
                        }
                        elseif ( !empty($p_browsenode) )
                        {
                            $productsUpdate[$u]['ProductDescription']['RecommendedBrowseNode'] = $p_browsenode ;
                        }
                        
                        // Product Tag
                        //
                        $productsUpdate[$u]['ProductDescription']['SearchTerms'] = Amazon_Tag::getMarketplaceTags($details, $id_lang) ;
                        
                        // Product Weight
                        //
                        $value  = number_format((float)$details->weight, 2) ;
                        
                        if ( $params->weightUnit && (float)$value )
                            switch(strtoupper($params->weightUnit))
                            {
                                case 'GR' : 
                                case 'KG' : 
                                case 'OZ' : 
                                case 'LB' : 
                                case 'MG' : 
                                    $unit   = $params->weightUnit ;
                                    $productsUpdate[$u]['ProductDescription']['PackageWeight'] = $value ;
                                    $productsUpdate[$u]['ProductDescription']['PackageWeightUnit'] = $unit ;
                                    
                                    // Note: maybe we have to add handling weight/packing weight to this value
                                    $productsUpdate[$u]['ProductDescription']['ShippingWeight'] = $value ;
                                    $productsUpdate[$u]['ProductDescription']['ShippingWeightUnit'] = $unit ;                                    
                                    break ;
                                // case another one : change the value to a known amz value
                                default :
                                    $this->errorOutput(sprintf( $this->l('Warning : %d - Amazon couldn\'t match this weight unit: %s for product: %d') . "$cr", $u, $params->weightUnit, $details->id));
                                    break ;
                            }
                    }
                        
                    // Shipping Override
                    //
                    if ($shipping !== NULL && is_numeric($shipping))
                    {
                        $productsUpdate[$u]['ShippingPrice'] = $shipping;
                        $productsUpdate[$u]['ShippingType'] = $shipping_type == 2 ? $params->shippingOverrideExps : $params->shippingOverrideStds;
                        $shipping_text = sprintf('- ' . $this->l('Overriding Shipping Fees: %s'), $shipping);
                    }
                    elseif ($shipping === NULL)
                    {
                        $productsUpdate[$u]['ShippingPrice'] = '';
                        $productsUpdate[$u]['ShippingType'] = $shipping_type == 2 ? $params->shippingOverrideExps : $params->shippingOverrideStds;
                        
                        if ($params->debug)
                            $shipping_text = sprintf('- ' . $this->l('Overriding Shipping Fees: void'), $shipping);
                        else
                            $shipping_text = '' ;
                    }
                    else
                        $shipping_text = NULL;
           
                    if ( $params->FBA && $fba )
                            $fba_text = '- ' . $this->l('FBA') ;
                    else    $fba_text = '' ;
                    
                    // Options
                    //
                    if ($latency)
                        $productsUpdate[$u]['FulfillmentLatency'] = $latency;
                    
                    if ( $fba )
                        $productsUpdate[$u]['FBA'] = $params->fullfillmentCenterId ;
                 
                    $actionType = $profile_name && $params->create ? $this->l('Create') : $this->l('Update') ;
                    
                    if ($params->asinOverride)
                    {
                        $actionIdType = 'ASIN';
                        $actionIdCode = trim($options['asin1']);
                    }
                    else
                    {
                        $actionIdType = isset($productsUpdate[$u]['ProductIDType']) ? $productsUpdate[$u]['ProductIDType'] : null ;
                        $actionIdCode = isset($productsUpdate[$u]['ProductIDCode']) ? $productsUpdate[$u]['ProductIDCode'] : null ;
                    }
                    
                    printf('%s: %s %s %s - ' .  $this->l('Qty') . ': %s - ' .  $this->l('Price') . ': %s %s ' .  $this->l('was') . ' %s %s %s' . "$cr", $actionType, $actionIdType, $actionIdCode, $productsUpdate[$u]['SKU'], isset($productsUpdate[$u]['Quantity']) ? $productsUpdate[$u]['Quantity'] : 'n/a', $params->toCurrency->iso_code, $newPrice, Tools::displayPrice($stdPrice), $fba_text, $shipping_text);
                    
                    // Create the master product for Variations
                    // NOTE : isset($productData['Variation']) && $productData['Variation'] added on 2013/05/15 - do not create parent/child relation if there is not variation data
                    if ( $params->create && $masterProduct && $variant && $productIndex == 1 && isset($productData['Variation']) && $productData['Variation'] )
                    {
                        $firstProduct = $productsUpdate[$u];

                        $productsUpdate[$u]['SKU'] = $details->reference;
                        $productsUpdate[$u]['ProductData']['Parentage'] = 'parent';
                        $productsUpdate[$u]['ProductDescription']['Title'] = $master_name ;

                        // Unset unwanted tags for parent
                        //
                        foreach($removeTagForParent as $tagName)
                            unset($productsUpdate[$u]['ProductData'][$tagName]) ;
                        
                        foreach(array('ConditionType', 'ConditionNote', 'Quantity', 'Price', 'ShippingPrice', 'ShippingType', 'ProductIDType', 'ProductIDCode') as $tagName)
                            unset($productsUpdate[$u][$tagName]) ;
                        
                        // Do not export quantity and price for parent
                        $productsUpdate[$u]['NoPriceExport'] = true;
                        $productsUpdate[$u]['NoQtyExport'] = true;

                        $u++;

                        $productsUpdate[$u] = $firstProduct;
                    }
                    $synchProductsIds[] = $id_product ;
                    $u++;
                }
            }
            $i++;
        }
        echo $cr ;
        
        // Action For Acknowledge
        if ( $params->create )
            $action = Amazon::Add ; 
        elseif( $params->deleteProducts )
            $action = Amazon::Remove ;
        else 
            $action = Amazon::Update ;

        // For customer debug purpose
        // 
        if ( $params->xmlOnly )
        {
            $params->sendToAmazon = true ;
            $this->_amazonApi->MWS_Action = Amazon_WebService::MWS_DO_NOT_SEND ;
            $this->_amazonApi->displayXML = true ;
        }
        
        if (!count($productsUpdate))
        {
            printf($this->l('No products to send on Amazon') . $cr);
        }
        else
        {
            if ($params->debug && isset($productsUpdate))
            {
                $productDebug = $productsUpdate ;
                unset($productDebug['ProductData']) ;
                
                echo nl2br(print_r($productDebug, true));
            }
            if ($params->sendToAmazon)
            {
                if ( $params->relationShipsOnly )
                {
                    printf($this->l('Updating relationships only - %s items') . $cr, count($productsUpdate));

                    if (!$datas = $this->_amazonApi->updateRelationships($Relationship))
                    {
                        if ( ! $params->xmlOnly )
                        {
                            echo '<span style="width:100%;display:inline-block;background-color:yellow;color:red;">';
                            printf('%s/%s: ' . $this->l('Error : query failed (%s)' . $cr), basename(__FILE__), __LINE__, print_r($datas, true));
                            echo '</span>';
                        }
                    }                    
                }
                else
                {
                    if ( $params->delete )
                        printf($this->l('%s products to delete on Amazon') . $cr, count($productsUpdate));
                    elseif ( $params->create )
                        printf($this->l('%s products to create on Amazon') . $cr, count($productsUpdate));
                    else
                        printf($this->l('%s products to synchronize with Amazon') . $cr, count($productsUpdate));

                    // Operation Override
                    if ( $params->delete )
                        $this->_amazonApi->setOperationMode( Amazon_WebService::OPERATIONS_DELETE ) ;
                        
                    if (!$datas = $this->_amazonApi->updateProducts($productsUpdate, $Relationship))
                    {
                        if ( ! $params->xmlOnly )
                        {
                            echo '<span style="width:100%;display:inline-block;background-color:yellow;color:red;">';
                            printf('%s/%s: ' . $this->l('Error : query failed (%s)' . $cr), basename(__FILE__), __LINE__, print_r($datas, true));
                            echo '</span>';
                        }
                    }
                }
                if ($params->debug)
                    echo nl2br(print_r($datas));

                $mwsSuccess = true ;

                if (isset($datas['products']) && intval($datas['products']))
                {
                    $mwsSuccess = $mwsSuccess && true;
                    printf($this->l('Products Feed - Submission ID: %s') . $cr, $datas['products']);
                }
                else
                    $mwsSuccess = $mwsSuccess && false;

                if (isset($datas['inventory']) && intval($datas['inventory']))
                {
                    printf($this->l('Inventory Feed - Submission ID: %s') . $cr, $datas['inventory']);
                }
                else $mwsSuccess = $mwsSuccess && false ;

                if (isset($datas['prices']) && intval($datas['prices']))
                {
                    printf($this->l('Price Feed - Submission ID: %s') . $cr, $datas['prices']);
                }
  
                if (isset($datas['overrides']) && intval($datas['overrides']))
                {
                    printf($this->l('Overrides Feed - Submission ID: %s') . $cr, $datas['overrides']);
                }

                if (isset($datas['images']) && intval($datas['images']))
                {
                    printf($this->l('Images Feed - Submission ID: %s') . $cr, $datas['images']);
                }

                if (isset($datas['relations']) && intval($datas['relations']))
                {
                    printf($this->l('Relationship Feed - Submission ID: %s') . $cr, $datas['relations']);
                }

                // We sucessfully exports to Amazon
                //
                if ($mwsSuccess === true)
                {
                    printf($this->l('Products was successfully submitted to Amazon...') . $cr);

                    // Update Marketplace Product Action Table
                    //
                    if ( ! $params->xmlOnly && is_array($synchProductsIds) && count($synchProductsIds) )
                    {
                        Amazon_Product::marketplaceActionAcknowledgde($action, $params->id_lang, $synchProductsIds, $dateAcknowledgde = $params->currentDate);
                    }

                    // Save for report
                    //
                    $submissions = unserialize(base64_decode(Amazon::configurationGet('AMAZON_LAST_SUBMISSIONS')));
                    $submissions[$params->id_lang] = $datas;

                    Amazon::configurationUpdateValue('AMAZON_LAST_SUBMISSIONS', base64_encode(serialize($submissions)));
                }
                else
                    printf($this->l('Products: Nothing to Update !') . $cr);
            }
            else
            {
                printf($this->l('%s products to synchronize with Amazon') . $cr, count($productsUpdate));
            }
        }

        if (!count($productsDelete))
        {
            printf($this->l('No products to delete') . $cr);
        }
        elseif ($params->deleteProducts || $params->authorizeToDelete)
        {
            if ($params->debug)
                echo nl2br(print_r($productsDelete, true));

            if ($params->sendToAmazon)
            {
                if (!($datas = $this->_amazonApi->deleteProducts($productsDelete)))
                {
                    if ( ! $params->xmlOnly )
                    {
                        printf($this->l('%s/%s: ' . 'Error : query failed (%s)' . $cr), basename(__FILE__), __LINE__, print_r($datas));
                    }
                }
                else
                {
                    // Update Marketplace Product Action Table
                    //
                    if ( ! $params->xmlOnly && is_array($synchProductsIds) && count($synchProductsIds) )
                    {
                        Amazon_Product::marketplaceActionAcknowledgde($action, $params->id_lang, $synchProductsIds, $dateAcknowledgde = $params->currentDate);
                    }                    
                    printf($this->l('%s deleted products') . $cr, count($productsDelete));
                }
                
            }
            else
            {
                printf($this->l('%s products to delete on Amazon') . $cr, count($productsDelete));
            }
        }

        if ($skipped)
        {
            printf($this->l('%d skipped products') . $cr, $skipped);
        }
        

        if (!$i)
        {
            printf($this->l('No products to export !') . $cr);
        }
        elseif ( $params->sendToAmazon && ! $params->xmlOnly && ! $params->deleteProducts )
        {
            printf($this->l('%s products sent') . $cr, count($productsUpdate));
        }
        if ( isset($duplicate) && $duplicate ) 
            printf($this->l('%s duplicate products') . $cr, $duplicate);
            
        if ( count($productsUpdate) || count($productsDelete) && $params->sendToAmazon )
        {
            if ($params->cronMode)
                Amazon::configurationUpdateValue('AMAZON_LAST_CRON_UPDATED_' . $params->id_lang, $params->currentDate);
            else
                Amazon::configurationUpdateValue('AMAZON_LAST_UPDATED_' . $params->id_lang, $params->currentDate);
        }
    }

}

class Params extends Amazon_ExportProducts
{

    protected $debug;
    protected $outOfStock;
    protected $formula;
    protected $fbaFormula;
    protected $FBA ;
    protected $callback;
    protected $synchField;
    protected $specials;
    protected $useTax;
    protected $conditionMap;
    protected $shippingOverrideStds;
    protected $shippingOverrideExps;
    protected $deleteProducts;
    protected $authorizeToDelete;
    protected $stockOnly;
    protected $pricesOnly;
    protected $asinHasPriority;
    public $categories;
    public $cronMode = false;
    public $extendedDatas = false;
    public $sendHTMLDescriptions = false ;
    public $relationShipsOnly = false;
    public $entireCatalog = false ;
    public $xmlOnly = false;
    public $sendActives = true;
    public $action;
    public $limit = false; 
    public $syncBothMode = false;
    public $sendToAmazon = false;
    public $deleteConfirmed = false;
    public $id_lang;
    public $platform;
    public $toCurrency;
    public $fromCurrency;
    protected $currentDate;
    protected $profile;
    protected $profile2category;
    public $images;
    protected $create;
    protected $mapping_left;
    protected $mapping_right;
    protected $dateSince;
    protected $weightUnit;
    protected $descriptionField ;
    public $asinOverride = false ;
    protected $customizedCall = false ;
    protected $customizedPhp = null ;
    protected $fullfillmentCenterId ;
    protected $marketplaceID ;
    protected $merchantID ;
    protected $id_shop ;
    protected $id_warehouse = null ;
    protected $excludedManufacturers = array() ;
    protected $excludedSuppliers = array() ;
    protected $priceFilter = array() ;
    
    protected $wozapi = false ;

    public function __construct($id_lang)
    {
        $this->id_lang = $id_lang;

        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->debug = intval($params) ? true : false;
        
        if ( Tools::getValue('debug') )
            $this->debug = true ;
        
        if ( $this->debug )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);            
        } 
        
        // Stock
        //
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_OUT_OF_STOCK')));
        $this->outOfStock = $params[$id_lang];

        // Price Formula & Callback
        //
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PRICE_FORMULA')));
        $this->formula = $params[$id_lang];
        
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PRICE_CALLBACK')));
        $this->callback = $params[$id_lang];

        // Price Rules (Replaces Formula)
        //
        $params = unserialize(base64_decode(Configuration::get('AMAZON_PRICE_RULE')));
        $this->priceRules = isset($params[$id_lang]) && is_array($params[$id_lang]) && isset($params[$id_lang]['type'])  && isset($params[$id_lang]['rule']) && is_array($params[$id_lang]['rule']) ? $params[$id_lang] : null ;        
        
        $this->CategoriesFormulas = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES_FORMULA')));

        // Field used for synchronisation - EAN / UPC / SKU and why not ISBN ...
        //
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_FIELD')));
        $this->synchField = $params[$id_lang];

        // Use Reduc / specials price
        //
        $this->specials = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_SPECIALS')))) ? true : false;
        $this->specialsApplyRules = (bool)Amazon::configurationGet('AMAZON_SPECIALS_APPLY_RULES') ;
        $this->useTax = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_TAXES')))) ? true : false;

        // State / Condition
        //
        $this->conditionMap = array_flip(unserialize(base64_decode(Amazon::configurationGet('AMAZON_CONDITION_MAP'))));

        // Shipping Overrides
        //
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_SHIPPING_OVERRIDES_STD')));
        $this->shippingOverrideStds = isset($params[$id_lang]) ? $params[$id_lang] : '';

        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_SHIPPING_OVERRIDES_EXP')));
        $this->shippingOverrideExps = isset($params[$id_lang]) ? $params[$id_lang] : '';

        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DELETE_PRODUCTS')));
        $this->authorizeToDelete = intval($params) ? true : false;

        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_STOCK_ONLY')));
        $this->stockOnly = intval($params) ? true : false;

        $params = Amazon::configurationGet('AMAZON_PRICES_ONLY');
        $this->pricesOnly = intval($params) ? true : false;
        
        // Title Formatage
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_TITLE_FORMAT')));
        $this->titleFormat = $params ;
        
        // Brute Force, as as named !
        //
        $this->bruteForce = unserialize(base64_decode(Amazon::configurationGet('AMAZON_BRUTE_FORCE')));
        
        // Saved Categories
        //
        $this->categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES')));

        // Profiles
        //
        $this->profile = Amazon::loadProfiles() ;
        $this->profile2category = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PROFILES_CATEGORIES')));

        // ASIN
        //
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_USE_ASIN')));
        $this->asinHasPriority = isset($params[$id_lang]) && intval($params[$id_lang]) ? true : false;

        $this->currentDate = date('Y-m-d H:i:s');

        $this->images = intval(Tools::getValue('images'));
        $this->create = intval(Tools::getValue('create'));
        $this->delete = intval(Tools::getValue('delete-xml'));

        // Absolute URL to images
        //
        $baseurl = 'http://' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8') . __PS_BASE_URI__;
        $this->images_url = $baseurl . 'img/p/';

        // Attributes Mapping (Color, Size..)
        // 
        $this->mapping_left = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ATTRIBUTES_MAPPING_L')));
        $this->mapping_right = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ATTRIBUTES_MAPPING_R')));

        // Attributes Mapping (Color, Size..)
        // 
        $this->features_mapping_left = unserialize(base64_decode(Amazon::configurationGet('AMAZON_FEATURES_MAPPING_L')));
        $this->features_mapping_right = unserialize(base64_decode(Amazon::configurationGet('AMAZON_FEATURES_MAPPING_R')));
        
        $this->dateSince = Tools::getValue('since') ;
        
        $this->weightUnit = strtoupper(preg_replace('/[^A-Za-z]/', '', Amazon::configurationGet('PS_WEIGHT_UNIT'))) ;
        
        $params = Amazon::configurationGet('AMAZON_DESCRIPTION_FIELD') ;
        $this->descriptionField = $params ? $params : Amazon::FieldDescriptionLong ;
        
        // Shop (PS 1.5)
        //
        $this->id_shop = (int)Amazon::configurationGet('AMAZON_SHOP') ;
        $this->id_shop = $this->id_shop ? $this->id_shop : 1 ;
        
        $this->id_warehouse = (int)Amazon::configurationGet('AMAZON_WAREHOUSE') ;
        
        // FBA 
        $params = Amazon::configurationGet('AMAZON_FBA') ;
        $this->FBA = (bool)$params ;
        
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_FBA_PRICE_FORMULA'))) ;
        
        if ( ! empty($params) || $params != '@' && $this->FBA )
             $this->fbaFormula = $params ;
        else $this->fbaFormula = null ;
        
        // Wozapi
        $params = (int)Amazon::configurationGet('AMAZON_WOZAPI') ? true : false ; 
        $this->wozapi = $params ;
        
        // HTML Descriptions (2013/04/23)
        $this->sendHTMLDescriptions = (bool)Amazon::configurationGet('AMAZON_HTML_DESCRIPTIONS') ;
        
        // Exclude Manufacturers & Suppliers (2013/08/17)
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_EXCLUDED_MANUFACTURERS'))) ;
        $this->excludedManufacturers = is_array($params) && count($params) ? $params : array() ;
        
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_EXCLUDED_SUPPLIERS'))) ;
        $this->excludedSuppliers = is_array($params) && count($params) ? $params : array() ;        
        
        $params = unserialize(base64_decode(Configuration::get('AMAZON_PRICE_FILTER'))) ;
        $this->priceFilter = is_array($params) && count($params) ? $params : array() ;            
        
        $params = Amazon::configurationGet('AMAZON_SAFE_ENCODING') ;
        $this->safeEncoding = $params ? true : false ;
    }

}

$amazonExportProduct = new Amazon_ExportProducts;
$amazonExportProduct->DoIt();

?>