<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
/*
  Warning in Prestashop >= 1.3.6 - 1.4
  @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
  Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
 */
if (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'localhost')
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../amazon.php');

require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.order.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

class Amazon_ProductOptionsJSON extends Amazon
{
    const cr = "<br />\n";

    private $auth;
    private $debug;
    private $region;

    function __construct()
    {
        parent::__construct();

        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->debug = intval($debugMode) ? true : false;

        if (Tools::getValue('debug'))
            $this->_debug = true;

        if ($this->debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }
        if ( $this->strategies )
            require_once(dirname(__FILE__) . '/../classes/amazon.strategies.class.php');
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    public function InitAmazon($id_lang)
    {
        // Amazon Europe overidding
        //
        $amazonEurope = unserialize(base64_decode(Amazon::configurationGet('AMAZON_EUROPE')));
        $marketPlaceMaster = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MASTER')));
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));

        // Acc�s API Amazon
        //
        $merchantIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MERCHANT_ID')));
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));
        $awsKeyIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_AWS_KEY_ID')));
        $awsSecretKeys = unserialize(base64_decode(Amazon::configurationGet('AMAZON_SECRET_KEY')));

        $amazonCurrency = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CURRENCY')));

        // Currencies
        //
        $currencies = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CURRENCY')));

        $this->platforms = array();

        if (intval($amazonEurope))
        {
            foreach ($marketPlaceRegion as $language_id => $region)
            {
                // Identify the Master Marketplace
                //
                if ($marketPlaceMaster == $marketPlaceRegion[$language_id])
                {
                    $mp_id_lang = $language_id;   // Default Platform - Language

                    $merchantId = trim($merchantIds[$language_id]);
                    $marketPlaceId = trim($marketPlaceIds[$language_id]);
                    $awsKeyId = trim($awsKeyIds[$language_id]);
                    $awsSecretKey = trim($awsSecretKeys[$language_id]);

                    $this->auth = array(
                        'MerchantID' => $merchantId,
                        'MarketplaceID' => $marketPlaceId,
                        'AWSAccessKeyID' => $awsKeyId,
                        'SecretKey' => $awsSecretKey
                    );
                }
                $this->params[$currencies[$language_id]] = array();
                $this->params[$currencies[$language_id]]['Currency'] = $amazonCurrency[$language_id];
                $this->params[$currencies[$language_id]]['Country'] = $marketPlaceMaster;

                $this->platforms[$currencies[$language_id]][] = $marketPlaceIds[$language_id];
            }

            if (!isset($mp_id_lang))
                die($this->l('Amazon Europe : missing Master Platform configuration'));
        }
        else
        {
            $merchantId = trim($merchantIds[$id_lang]);
            $marketPlaceId = trim($marketPlaceIds[$id_lang]);
            $awsKeyId = trim($awsKeyIds[$id_lang]);
            $awsSecretKey = trim($awsSecretKeys[$id_lang]);

            $this->auth = array(
                'MerchantID' => $merchantId,
                'MarketplaceID' => $marketPlaceId,
                'AWSAccessKeyID' => $awsKeyId,
                'SecretKey' => $awsSecretKey
                    );
            $this->platforms = array();
            $this->platforms[$currencies[$id_lang]][] = $marketPlaceIds[$id_lang];

            $this->params[$currencies[$id_lang]]['Currency'] = $amazonCurrency[$id_lang];
            $this->params[$currencies[$id_lang]]['Country'] = $marketPlaceRegion[$id_lang];
        }
        $this->region = $this->params[$currencies[$id_lang]];
    }

    public function doIt()
    {
        if (!Amazon_Tools::checkToken(Tools::getValue('amazon_token')))
        {
            die(Tools::displayError($this->l('Wrong Token')));
        }

        $callback = Tools::getValue('callback');
        $langs = Tools::getValue('amazon_option_lang');
        $id_product = Tools::getValue('id_product');

        $product = new Product($id_product);
        $id_category = $product->id_category_default ? $product->id_category_default : null;
        $id_manufacturer = $product->id_manufacturer ? $product->id_manufacturer : null;
        $id_supplier = $product->id_supplier ? $product->id_supplier : null;

        switch (Tools::getValue('action'))
        {
            case 'set' : // Set Product Opton
                $pass = true;

                foreach ($langs as $key => $val)
                {

                    $id_lang = intval($val);
                    $disable = Tools::getValue('amz-disable-' . intval($id_lang)) ? 1 : 0;
                    $force = Tools::getValue('amz-force-' . intval($id_lang)) ? 1 : 0;
                    $price = Tools::getValue('amz-price-' . intval($id_lang));
                    $text = Tools::getValue('amz-text-' . intval($id_lang));
                    $nopexport = Tools::getValue('amz-nopexport-' . intval($id_lang));
                    $noqexport = Tools::getValue('amz-noqexport-' . intval($id_lang));
                    $fba = Tools::getValue('amz-fba-' . intval($id_lang));
                    $fba_value = Tools::getValue('amz-fbavalue-' . intval($id_lang));
                    $latency = Tools::getValue('amz-latency-' . intval($id_lang));
                    $asin1 = Tools::getValue('amz-asin-' . intval($id_lang));
                    $asin2 = Tools::getValue('amz-asin-2-' . intval($id_lang));
                    $asin3 = Tools::getValue('amz-asin-3-' . intval($id_lang));
                    $shipping = Tools::getValue('amz-shipping-' . intval($id_lang));
                    $shipping_type = Tools::getValue('amz-overridetype-' . intval($id_lang));
                    $bullet_points = Tools::getValue('amz-bulletpoint-' . intval($id_lang));

                    $bullet_point1 = isset($bullet_points[0]) && !empty($bullet_points[0]) ? substr($bullet_points[0], 0, 2000) : null;
                    $bullet_point2 = isset($bullet_points[1]) && !empty($bullet_points[1]) ? substr($bullet_points[1], 0, 2000) : null;
                    $bullet_point3 = isset($bullet_points[2]) && !empty($bullet_points[2]) ? substr($bullet_points[2], 0, 2000) : null;
                    $bullet_point4 = isset($bullet_points[3]) && !empty($bullet_points[3]) ? substr($bullet_points[3], 0, 2000) : null;
                    $bullet_point5 = isset($bullet_points[4]) && !empty($bullet_points[3]) ? substr($bullet_points[4], 0, 2000) : null;

                    // Same action for all languages
                    $action = Tools::getValue('amz-action-' . intval($id_lang));
                    $action = in_array($action, array(Amazon::Add, Amazon::Remove, Amazon::Update)) ? $action : Amazon::Update;

                    $options = array('force' => $force, 'nopexport' => $nopexport, 'noqexport' => $noqexport, 'fba' => $fba, 'fba_value' => $fba_value, 'latency' => $latency,
                        'disable' => $disable, 'price' => $price, 'asin1' => $asin1, 'asin2' => $asin2, 'asin3' => $asin3, 'text' => $text,
                        'bullet_point1' => $bullet_point1, 'bullet_point2' => $bullet_point2, 'bullet_point3' => $bullet_point3, 'bullet_point4' => $bullet_point4, 'bullet_point5' => $bullet_point5,
                        'shipping' => $shipping, 'shipping_type' => $shipping_type);

                    if (!Amazon_Product::setProductOptions($id_product, $id_lang, $options))
                        $pass = false;
                }
                if ( ! Amazon_Product::marketplaceActionSet($action, $id_product) )
                        $pass = false ;
                break;

            case 'propagate-action-cat' :
                $pass = true;

                if (!$id_category)
                {
                    $pass = false;
                    break;
                }
                $action = null;
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);

                    $action = Tools::getValue('amz-action-' . intval($id_lang));
                    $action = in_array($action, array(Amazon::Add, Amazon::Remove, Amazon::Update)) ? $action : Amazon::Update;

                    break; // once ok
                }
                if ($action)
                    if (!Amazon_Product::propagateProductActionToCategory($id_product, $id_category, pSQL($action)))
                        $pass = false;
                break;

            case 'propagate-action-shop' :
                $pass = true;
                $action = null;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $action = Tools::getValue('amz-action-' . intval($id_lang));
                    $action = in_array($action, array(Amazon::Add, Amazon::Remove, Amazon::Update)) ? $action : Amazon::Update;

                    break;
                }

                if ($action)
                    if (!Amazon_Product::propagateProductActionToShop($id_product, pSQL($action)))
                        $pass = false;
                break;

            case 'propagate-action-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    echo $this->l('Unable to save parameters...');
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $action = Tools::getValue('amz-action-' . intval($id_lang));
                    $action = in_array($action, array(Amazon::Add, Amazon::Remove, Amazon::Update)) ? $action : Amazon::Update;

                    break;
                }

                if ($action)
                    if (!Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, $action))
                        $pass = false;
                break;

            case 'propagate-action-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $action = Tools::getValue('amz-action-' . intval($id_lang));
                    $action = in_array($action, array(Amazon::Add, Amazon::Remove, Amazon::Update)) ? $action : Amazon::Update;

                    break;
                }
                if ($action)
                    if (!Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, $action))
                        $pass = false;
                break;


            case 'propagate-text-cat' :
                $pass = true;

                if (!$id_category)
                {
                    echo $this->l('Unable to save parameters...');
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $text = Tools::getValue('amz-text-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'text', $text))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-text-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $text = Tools::getValue('amz-text-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'text', $text))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-text-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $text = Tools::getValue('amz-text-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'text', $text))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            case 'propagate-text-shop' :
                $pass = true;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $text = Tools::getValue('amz-text-' . intval($id_lang));

                    $options = array('text' => $text);

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'text', pSQL($text)))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToShop($id_product, Amazon::Update);
                break;


            case 'propagate-bulletpoint-cat' :
                $pass = true;

                if (!$id_category)
                {
                    echo $this->l('Unable to save parameters...');
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);

                    $bullet_points = Tools::getValue('amz-bulletpoint-' . intval($id_lang));

                    $bullet_point1 = isset($bullet_points[0]) && !empty($bullet_points[0]) ? substr($bullet_points[0], 0, 2000) : null;
                    $bullet_point2 = isset($bullet_points[1]) && !empty($bullet_points[1]) ? substr($bullet_points[1], 0, 2000) : null;
                    $bullet_point3 = isset($bullet_points[2]) && !empty($bullet_points[2]) ? substr($bullet_points[2], 0, 2000) : null;
                    $bullet_point4 = isset($bullet_points[3]) && !empty($bullet_points[3]) ? substr($bullet_points[3], 0, 2000) : null;
                    $bullet_point5 = isset($bullet_points[4]) && !empty($bullet_points[3]) ? substr($bullet_points[4], 0, 2000) : null;

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'bullet_point1', $bullet_point1))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'bullet_point2', $bullet_point2))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'bullet_point3', $bullet_point3))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'bullet_point4', $bullet_point4))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'bullet_point5', $bullet_point5))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-bulletpoint-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);

                    $bullet_points = Tools::getValue('amz-bulletpoint-' . intval($id_lang));

                    $bullet_point1 = isset($bullet_points[0]) && !empty($bullet_points[0]) ? substr($bullet_points[0], 0, 2000) : null;
                    $bullet_point2 = isset($bullet_points[1]) && !empty($bullet_points[1]) ? substr($bullet_points[1], 0, 2000) : null;
                    $bullet_point3 = isset($bullet_points[2]) && !empty($bullet_points[2]) ? substr($bullet_points[2], 0, 2000) : null;
                    $bullet_point4 = isset($bullet_points[3]) && !empty($bullet_points[3]) ? substr($bullet_points[3], 0, 2000) : null;
                    $bullet_point5 = isset($bullet_points[4]) && !empty($bullet_points[3]) ? substr($bullet_points[4], 0, 2000) : null;

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'bullet_point1', $bullet_point1))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'bullet_point2', $bullet_point2))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'bullet_point3', $bullet_point3))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'bullet_point4', $bullet_point4))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'bullet_point5', $bullet_point5))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-bulletpoint-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);

                    $bullet_points = Tools::getValue('amz-bulletpoint-' . intval($id_lang));

                    $bullet_point1 = isset($bullet_points[0]) && !empty($bullet_points[0]) ? substr($bullet_points[0], 0, 2000) : null;
                    $bullet_point2 = isset($bullet_points[1]) && !empty($bullet_points[1]) ? substr($bullet_points[1], 0, 2000) : null;
                    $bullet_point3 = isset($bullet_points[2]) && !empty($bullet_points[2]) ? substr($bullet_points[2], 0, 2000) : null;
                    $bullet_point4 = isset($bullet_points[3]) && !empty($bullet_points[3]) ? substr($bullet_points[3], 0, 2000) : null;
                    $bullet_point5 = isset($bullet_points[4]) && !empty($bullet_points[3]) ? substr($bullet_points[4], 0, 2000) : null;

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'bullet_point1', $bullet_point1))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'bullet_point2', $bullet_point2))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'bullet_point3', $bullet_point3))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'bullet_point4', $bullet_point4))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'bullet_point5', $bullet_point5))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            case 'propagate-bulletpoint-shop' :
                $pass = true;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);

                    $bullet_points = Tools::getValue('amz-bulletpoint-' . intval($id_lang));

                    $bullet_point1 = isset($bullet_points[0]) && !empty($bullet_points[0]) ? substr($bullet_points[0], 0, 2000) : null;
                    $bullet_point2 = isset($bullet_points[1]) && !empty($bullet_points[1]) ? substr($bullet_points[1], 0, 2000) : null;
                    $bullet_point3 = isset($bullet_points[2]) && !empty($bullet_points[2]) ? substr($bullet_points[2], 0, 2000) : null;
                    $bullet_point4 = isset($bullet_points[3]) && !empty($bullet_points[3]) ? substr($bullet_points[3], 0, 2000) : null;
                    $bullet_point5 = isset($bullet_points[4]) && !empty($bullet_points[3]) ? substr($bullet_points[4], 0, 2000) : null;

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'bullet_point1', $bullet_point1))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'bullet_point2', $bullet_point2))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'bullet_point3', $bullet_point3))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'bullet_point4', $bullet_point4))
                        $pass = false;
                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'bullet_point5', $bullet_point5))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToShop($id_product, Amazon::Update);
                break;

            case 'propagate-fba-cat' :
                $pass = true;

                if (!$id_category)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fba = Tools::getValue('amz-fba-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'fba', $fba))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-fba-shop' :
                $pass = true;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fba = Tools::getValue('amz-fba-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'fba', $fba))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToShop($id_product, Amazon::Update);
                break;

            case 'propagate-fba-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    echo $this->l('Unable to save parameters...');
                    die;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fba = (int) Tools::getValue('amz-fba-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'fba', $fba))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-fba-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fba = (int) Tools::getValue('amz-fba-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'fba', $fba))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            case 'propagate-fbavalue-cat' :
                $pass = true;

                if (!$id_category)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fba_value = Tools::getValue('amz-fbavalue-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'fba_value', $fba_value))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-fbavalue-shop' :
                $pass = true;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fba_value = Tools::getValue('amz-fbavalue-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'fba_value', $fba_value))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToShop($id_product, Amazon::Update);
                break;

            case 'propagate-fbavalue-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fbavalue = (int) Tools::getValue('amz-fbavalue-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'fba_value', $fbavalue))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-fbavalue-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    echo $this->l('Unable to save parameters...');
                    die;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $fbavalue = (int) Tools::getValue('amz-fbavalue-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'fba_value', $fbavalue))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            case 'propagate-latency-cat' :
                $pass = true;

                if (!$id_category)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $latency = (int) Tools::getValue('amz-latency-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'latency', $latency))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-latency-shop' :
                $pass = true;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $latency = (int) Tools::getValue('amz-latency-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'latency', $latency))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToShop($id_product, Amazon::Update);
                break;

            case 'propagate-latency-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    echo $this->l('Unable to save parameters...');
                    die;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $latency = (int) Tools::getValue('amz-latency-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'latency', $latency))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-latency-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $latency = (int) Tools::getValue('amz-latency-' . intval($id_lang));

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'latency', $latency))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            case 'propagate-shipping-cat' :
                $pass = true;

                if (!$id_category)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $shipping = Tools::getValue('amz-shipping-' . intval($id_lang));
                    $shipping_type = intval(Tools::getValue('amz-overridetype-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'shipping', (is_numeric($shipping) ? floatval($shipping) : NULL)))
                        $pass = false;

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'shipping_type', $shipping_type))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-shipping-shop' :
                $pass = true;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $shipping = Tools::getValue('amz-shipping-' . intval($id_lang));
                    $shipping_type = intval(Tools::getValue('amz-overridetype-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'shipping', (is_numeric($shipping) ? floatval($shipping) : NULL)))
                        $pass = false;

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'shipping_type', $shipping_type))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToShop($id_product, Amazon::Update);
                break;

            case 'propagate-shipping-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    echo $this->l('Unable to save parameters...');
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $shipping = Tools::getValue('amz-shipping-' . intval($id_lang));
                    $shipping_type = intval(Tools::getValue('amz-overridetype-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'shipping', (is_numeric($shipping) ? floatval($shipping) : NULL)))
                        $pass = false;

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'shipping_type', $shipping_type))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-shipping-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $shipping = Tools::getValue('amz-shipping-' . intval($id_lang));
                    $shipping_type = intval(Tools::getValue('amz-overridetype-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'shipping', (is_numeric($shipping) ? floatval($shipping) : NULL)))
                        $pass = false;

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'shipping_type', $shipping_type))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            case 'propagate-disable-cat' :
                $pass = true;

                if (!$id_category)
                {
                    echo $this->l('Unable to save parameters...');
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $disable = intval(Tools::getValue('amz-disable-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'disable', $disable))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-disable-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $disable = intval(Tools::getValue('amz-disable-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'disable', $disable))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-disable-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $disable = intval(Tools::getValue('amz-disable-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'disable', $disable))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            // Force
            //
          case 'propagate-force-cat' : // Propagate product option force
                $pass = true;

                if (!$id_category)
                {
                    echo $this->l('Unable to save parameters...');
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $force = intval(Tools::getValue('amz-force-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToCategory($id_product, $id_lang, $id_category, 'force', $force))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToCategory($id_product, $id_category, Amazon::Update);
                break;

            case 'propagate-force-shop' :
                $pass = true;

                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $force = intval(Tools::getValue('amz-force-' . intval($id_lang)));

                    $options = array('force' => $force);

                    if (!Amazon_Product::propagateProductOptionToShop($id_product, $id_lang, 'force', $force))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToShop($id_product, Amazon::Update);
                break;

            case 'propagate-force-manufacturer' :
                $pass = true;

                if (!$id_manufacturer)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $force = intval(Tools::getValue('amz-force-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, 'force', $force))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToManufacturer($id_product, $id_manufacturer, Amazon::Update);
                break;

            case 'propagate-force-supplier' :
                $pass = true;

                if (!$id_supplier)
                {
                    $pass = false;
                    break;
                }
                foreach ($langs as $key => $val)
                {
                    $id_lang = intval($val);
                    $force = intval(Tools::getValue('amz-force-' . intval($id_lang)));

                    if (!Amazon_Product::propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, 'force', $force))
                        $pass = false;
                }
                Amazon_Product::propagateProductActionToSupplier($id_product, $id_supplier, Amazon::Update);
                break;

            case 'reinit-strategies' :
                if (defined('AMAZON_TRADER') && AMAZON_TRADER)
                    $pass = Amazon_Strategy::reInit();
                break;

            case 'ean2asin' :
                $id_lang = Tools::getValue('id_lang');
                $pass = true;
                $errors = null;
                $output = null;
                $asin = '';

                ob_start();
                $this->InitAmazon($id_lang);

                if (!($amazonApi = new Amazon_WebService($this->auth, $this->region, false, $this->debug)))
                {
                    echo $n->l('Unable to login') . $cr;
                    die;
                }

                if ($lookup = Tools::getValue('ean13'))
                {
                    $result = $amazonApi->getASIN($lookup);

                    if (isset($result[0]) && !empty($result[0]))
                    {
                        echo $this->l('ASIN sucessfully fetched') . self::cr;
                        $asin = $result[0];
                    }
                }
                elseif ($lookup = intval(Tools::getValue('upc')))
                {
                    $result = $amazonApi->getASIN($lookup);

                    if (isset($result[0]) && !empty($result[0]))
                    {
                        echo $this->l('ASIN sucessfully fetched') . self::cr;
                        $asin = $result[0];
                    }
                }

                if (!$asin)
                {
                    echo sprintf('%s %s %s', $this->l('Unable to fetch ASIN for'), $lookup, self::cr);
                    $pass = false;
                }
                $output = ob_get_clean();


                $json = json_encode(array('output' => $output, 'error' => !$pass, 'asin' => $asin));

                echo Tools::getValue('callback') . '(' . $json . ')';
                die;
                break;

            default :
                $pass = false;
                break;
        }
        if ($pass)
            echo $this->l('Parameters successfully saved');
        else
            echo $this->l('Unable to save parameters...');
    }

}

$apoJSON = new Amazon_ProductOptionsJSON();
$apoJSON->doIt();
?>