<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

/*
  Warning in Prestashop >= 1.3.6 - 1.4
  @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
  Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
 */
if (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'localhost')
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.order.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.strategies.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class Product_Bid_Update extends Module
{

    function __construct()
    {
        parent::__construct();

        $this->id_lang = (int) Tools::getValue('id_lang');
        $this->amazon_lang = (int) Tools::getValue('amazon_lang');

        if (!$this->id_lang)
            die(Tools::displayError('No selected lang, exiting...'));

        if (!$this->amazon_lang)
            die(Tools::displayError('No selected amazon lang, exiting...'));
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    function DoIt()
    {
        if (!Amazon_Tools::checkToken(Tools::getValue('amazon_token')))
        {
            die(Tools::displayError($this->l('Wrong Token')));
        }

        ob_start();
        $id_lang = $this->amazon_lang;

        if (!$id_lang)
            die;

        $cr = "<br />\n";

        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));
        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));

        // Use Reduc / specials price
        //
        $specials = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_SPECIALS')))) ? true : false;
        $useTax = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_TAXES')))) ? true : false;

        $id_product = intval(Tools::getValue('id_product'));
        $id_product_attribute = intval(Tools::getValue('id_product_attribute'));
        $ref_product = strval(Tools::getValue('ref_product'));
        $min = floatval(Tools::getValue('min'));
        $max = floatval(Tools::getValue('max'));
        $cur = floatval(Tools::getValue('cur'));
        $ASIN = Tools::getValue('ASIN');
        $update = floatval(Tools::getValue('update'));
        $delete = floatval(Tools::getValue('delete'));
        $shipping = Tools::getValue('shipping_price');
        $callback = strval(Tools::getValue('callback'));
        $freeze = intval(Tools::getValue('freeze'));
        $europe = intval(Tools::getValue('strategy-europe'));
        $initial_price = floatval(Tools::getValue('initial_price'));
        $gap = floatval(Tools::getValue('gap'));

        if (!$cur && $update)
            die($this->l('Fatal Error : Price not set !'));

        $strategy = new Amazon_Strategy($ref_product, true, $id_lang);

        $strategy->setIdProductAttribute($id_product_attribute);
        $strategy->setASIN($ASIN);

        $normalPrice = $strategy->getPrice($useTax, $id_product_attribute, 6, NULL, false, $specials);

        // Price Formula & Callback
        //
        $formula = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PRICE_FORMULA')));
        $formula = $formula[$id_lang];

        // Price Formula (see Admin > Module > Amazon)
        //
        $normalPrice = Amazon_Tools::Formula($normalPrice, $formula);

        // Options
        $options = $strategy->getProductOptions($strategy->id, $id_lang);

        // Price Override
        if (!empty($options['price']) && (float) $options['price'])
        {
            $normalPrice = (float) $options['price'];
        }

        if ($delete)
        {
            $pass = $strategy->erase();

            $min = $max = $cur = $initial_price;
        }
        elseif ($update)
        {
            if ($freeze) // Frozen Price
            {
                $min = $max = $cur;
            }

            if (!$min && !$max && $cur)
                if ($cur > $normalPrice + $shipping)
                    $min = $max = $cur;
                else
                    $min = $max = $normalPrice;

            if (!$min && $cur > $normalPrice + $shipping)
            {
                $min = $cur;
            }
            elseif (!$min)
            {
                $min = $normalPrice;
            }

            if (!$max && $cur > $normalPrice + $shipping)
            {
                $max = $cur;
            }
            elseif (!$max)
            {
                $max = $normalPrice;
            }

            if ($min > $cur)
                $min = $cur;

            if (!is_numeric($gap) || $gap < 0)
                $gap = 0.5;

            $pass = true;

            if (!$strategy->lookup()) // pas de strategie existante
            {
                $pass = $strategy->create($cur, $min, $max, $gap);

                if (!$pass)
                    die(printf('%s: ' . $this->l('Error : query failed (%s)' . $cr), __LINE__, print_r($pass)));
            }
            else
            {
                $pass = $strategy->adjust($cur, $min, $max, $gap);

                if (!$pass)
                    die(printf('%s: ' . $this->l('Error : query failed (%s)' . $cr), __LINE__, print_r($pass)));
            }

            if ($europe)
            {
                foreach ($marketPlaceIds as $selected_lang => $marketplaceId)
                {
                    if (!(isset($actives[$selected_lang]) && intval($actives[$selected_lang])))
                        continue;

                    if ($selected_lang == $id_lang)
                        continue;

                    if (isset($marketPlaceIds[$selected_lang]) && Amazon_Tools::isEuropeMarketplaceId($marketPlaceIds[$selected_lang]))
                    {
                        $strategy->duplicate($selected_lang);
                    }
                }
            }
        }

        if (!$result = $strategy->get())
        {
            $cur = $min = $max = $normalPrice;
            $isNew = true;
        }
        else  // strategie existante
        {
            $cur = $initial_price;
            $min = $result['minimum_price'];
            $max = $result['target_price'];
            $gap = $result['gap'];
            $isNew = false;
        }
        $pass = true;

        $msg = ob_get_contents();
        ob_clean();

        $data = array(
            'result' => intval($pass),
            'min' => floatval($min),
            'max' => floatval($max),
            'cur' => floatval($cur),
            'gap' => floatval($gap),
            'ship' => floatval($shipping),
            'msg' => $msg
                );
        ob_clean();
        echo $callback . '(' . json_encode($data) . ')';
    }

}

$update = new Product_Bid_Update();
$update->DoIt();
?>