<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.smartmarseille.com)
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@smartmarseille.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

### TODO : port content to smarty 

/*
  Warning in Prestashop >= 1.3.6 - 1.4
  @ to prevent notice in Tools class in E_STRICT | E_ALL mode :
  Notice: Undefined index:  HTTP_HOST in /classes/Tools.php on line 71
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}

require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.order.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.strategies.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

require_once(dirname(__FILE__) . '/../classes/amazon.concurrentinfo.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class Product_Bid extends Amazon
{
    private $debug;

    public $amazon_lang ;
    
    function __construct()
    {
        parent::__construct() ;

        if (Tools::getValue('amazon_lang'))
        {
            $this->amazon_lang = Tools::getValue('amazon_lang');
        }
        else
            $this->amazon_lang = $this->id_lang ;
    }

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    private function _select_country()
    {
        global $n ;

        $languages = Language::getLanguages();

        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));
        $amazonEurope = unserialize(base64_decode(Amazon::configurationGet('AMAZON_EUROPE')));
        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE'))); 

        // Use when having attributes on country change
        $reference = Tools::getValue('combination_reference') ;
        
        $selected_lang = $this->amazon_lang ;
        
        $html = '
            <fieldset style="width:690px;padding:1em;" >
            <legend><img src="' . $this->images . 'world.gif" alt="" />' . $this->l('Choose Amazon Platform') . '</legend>';

        $i = 0;

        foreach (Amazon_Tools::languages() as $language)
        {
            $id_lang = $language['id_lang'] ;

            if (!(isset($actives[$id_lang]) && intval($actives[$id_lang])))
                continue;      

            if ( $amazonEurope )
                if ( isset($marketPlaceIds[$id_lang]) && Amazon_Tools::isEuropeMarketplaceId($marketPlaceIds[$id_lang]) )
                    $language['europe'] = true ;        

            $language['short_name'] = preg_replace('/ .*/', '', $language['name']) ;
            
            if ( $selected_lang == $id_lang )
                $checked = 'checked="checked"';
            else
                $checked = '';
                
            $html .= '
                <div style="float:left;margin-right:10px;">
                    <span>
                        <input type="radio" name="amazon_lang" value="' . $id_lang . '" ' . $checked . ' rel="' . $reference . '" />';
            $html .= '
                        &nbsp;<img src="' . $this->images . 'geo_flags/' . $language['iso_code'] . '.gif" alt="' . $language['name'] . '" />&nbsp;&nbsp;' . $language['short_name'] . '
                    </span>
                </div>
            ';
        }

        $html .= '
            <input type="hidden" name="path" value="' . $this->url . '" />
            </fieldset>';
        return($html);
    }

    function calculate($min, $max, $gap, $lowestConcurrentPrice, $shipping)
    {
        $newPrice = $lowestConcurrentPrice - $shipping - $gap;

        if ($newPrice > $max)
            $newPrice = $max;

        if ($newPrice < $min)
            $newPrice = $min;

        return($newPrice);
    }

    public function productBid()
    {
        $images = $this->url . '/images/';
        $amazon_lang = $this->amazon_lang ;
        
        $ASIN = null ;
        
        $minimumGap = 0.10;

        // Shipping Rules
        //
        $shipping_rules = unserialize(base64_decode(Amazon::configurationGet('AMAZON_SHIPPING_RULES')));
        $shipping_rule = $shipping_rules[$amazon_lang];

        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->debug = intval($debugMode) ? true : false;
        
        if ( Tools::getValue('debug') )
            $this->_debug = true ;
        
        if ( $this->debug )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);            
        }         
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));
        
        // Use Reduc / specials price
        //
        $specials = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_SPECIALS')))) ? true : false;
        $useTax = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_TAXES')))) ? true : false;

        // FBA 
        // 
        $params = Amazon::configurationGet('AMAZON_FBA') ;
        $FBA = (bool)$params ;
        
        $params = unserialize(base64_decode(Amazon::configurationGet('AMAZON_FBA_PRICE_FORMULA'))) ;
        
        if ( ! empty($params) || $params != '@' && $FBA )
             $fbaFormula = $params ;
        else $fbaFormula = null ;
        
        // Init
        //
        $amazonEurope = unserialize(base64_decode(Amazon::configurationGet('AMAZON_EUROPE')));

        $amazon = Amazon_Tools::selectPlatform($amazon_lang, $this->debug);

        if ($this->debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        if (!($this->_amazonApi = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazonEurope, $this->debug)))
        {
            echo $this->l('Unable to login') ;
            die;
        }
        $country = $amazon['params']['Country'];

        // Currency Selector
        //
        $default_id_currency = (int)Configuration::get('PS_CURRENCY_DEFAULT') ;
        $current_id_currency = Currency::getIdByIsoCode($amazon['params']['Currency']);
        $id_currency         = $current_id_currency ;
        $currency            = new Currency($id_currency) ;        
        $originCurrency      = new Currency($default_id_currency) ;        

        $currentCurrency = new Currency($current_id_currency) ;
        $currentCurrencyRate = Tools::ps_round($currentCurrency->conversion_rate, 4) ;        
        
        $id_product = intval(Tools::getValue('id_product'));
        $reference  = Tools::getValue('combination_reference') ;
        $id_product_attribute = null ;

        if ( empty($reference) )
        {
            $reference  = Amazon_Product::getProductById($id_product);
            
            if ( empty($reference) )
            {
                die( $this->badWindow($this->l('Your product must have a reference.')) ) ;
            }
        }   

        $product = new Amazon_Product($reference, true, $amazon_lang);

        if ( ! Validate::isLoadedObject($product) )
        {
            printf('Failed to load product id %d', $id_product) ;
            die;
        }
        $attribute_name = null ;
        $product_name = $product->name ;
      
        if ( $product->hasAttributes() )
        {
            if ( ! Tools::getValue('combination_reference') )
            {
                die( $this->badWindow($this->l('This product has combinations.') . '<br />' . $this->l('Please open it from the combination tab.')) ) ;
            }
                
            // Product Combinations
            //
            if (version_compare(_PS_VERSION_, '1.5', '<'))
                $combinations = $product->getAttributeCombinaisons($amazon_lang);
            else
                $combinations = $product->getAttributeCombinations($amazon_lang);
            if ($combinations)
                foreach ($combinations as $combination)
                    if (trim($combination['reference']) == $reference)
                    {
                        $id_product_attribute = intval($combination['id_product_attribute']);
                        $product->ean13 = $combination['ean13'] ;
                        $product->upc = $combination['upc'] ;
                        $attribute_name .= $combination['attribute_name'] . ' - ' ;
                    }     
            if ( $id_product_attribute )
            {
                $attribute_name = rtrim($attribute_name, ' - ') ;
                $product_name = sprintf('%s (%s)', $product->name, $attribute_name) ;
            }    
        }
        $ean = $product->ean13;
        
        $id_shop = (int)Amazon::configurationGet('AMAZON_SHOP') ; 
        $id_warehouse = (int)Amazon::configurationGet('AMAZON_WAREHOUSE') ;
        $id_warehouse = $id_warehouse ? $id_warehouse : null ; 
        
        if (version_compare(_PS_VERSION_, '1.5', '<'))
            $quantity = (int)Product::getQuantity($id_product, $id_product_attribute) ;        
        else
            $quantity = Product::getRealQuantity($id_product, $id_product_attribute, $id_warehouse, $id_shop);
            
        if (isset($product->condition))
            $condition = $product->condition;
        else
            $condition = 'new';


        switch (strtolower($condition))
        {
            case 'new' :
                $condition = 'New';
                break;
            default :
                $condition = 'Used';
                break;
        }

        $options = $product->getProductOptions($id_product, $amazon_lang);

        $wholesale_price = Tools::displayPrice($product->wholesale_price * (1 + ($product->tax_rate / 100)));

        // Main Price W/VAT
        //
        $amazonPrice = $product->getPrice($useTax, $id_product_attribute, 6, NULL, false, $specials) ;
        $catalogPrice = $amazonPrice ;
        
        // Amazon Shipping Rate Table (modules > amazon > configuration)
        //
        $shipping = Amazon_Tools::getShippingRate($amazonPrice, $shipping_rule);

        // Shipping Override
        //
        if (isset($options['shipping']) && is_numeric($options['shipping']))
            $shipping = floatval($options['shipping']);
        
        // Price Override
        if ( ! empty($options['price']) && (float)$options['price'] )
        {
            $amazonPrice = (float)$options['price'] ;
        }
        
        $initial_highest = $suggested = $amazonPrice;

        // Si strategie existante on r�cup�re le prix actuel de la strategie
        //
        $strategy = new Amazon_Strategy($reference, true, $amazon_lang);

        // Historique des commandes de ce produit
        //
        $history = $strategy->history();

        $mpPrice = 0;

        if ($strategy->lookup())
            if ($stratege = $strategy->get())
                $mpPrice = $stratege['actual_price'];

        // Price Formula & Callback
        //
        $formula = unserialize(base64_decode(Configuration::get('AMAZON_PRICE_FORMULA')));
        $formula = isset($formula[$amazon_lang]) ? $formula[$amazon_lang] : null ;

        $price_rules = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PRICE_RULE')));        
        $price_rules = isset($price_rules[$amazon_lang]) ? $price_rules[$amazon_lang] : null ;

        $callbackf = unserialize(base64_decode(Amazon::configurationGet('AMAZON_PRICE_CALLBACK')));
        $callbackf = $callbackf[$amazon_lang];

        // Price Formula (see Admin > Module > Amazon)
        //
        if ( $price_rules )
            $amazonPrice = Amazon_Tools::PriceRule($amazonPrice, $price_rules);
        else
            $amazonPrice = Amazon_Tools::Formula($amazonPrice, $formula);

        // Price CallBack (see Admin > Module > Amazon)
        //
        $amazonPrice = Amazon_Tools::CallBack($amazonPrice, $callbackf);
        $amazonPrice = Tools::ps_round((float)str_replace(',', '.',  $amazonPrice), 2) ;


        $concurrentInfoAPI = new ConcurrentInfo($this->_amazonApi, $country, $this->debug);

        $SKU = trim($reference);

        $SKUList = array();
        $SKUList[] = $SKU;

        $noOffers = false ;
        
        if (!$amazonPricingData = $concurrentInfoAPI->GetOurInfo($SKUList))
        {
            printf("Unable to fetch our informations for product SKU: %s\n", $reference);
        }   
        
        if ( empty($ASIN) && isset($amazonPricingData->ASIN) )
        {
            $ASIN = $amazonPricingData->ASIN ;
        }
        
        if (!$concurrentInfoAPI->GetConcurrentInfo($SKUList))
        {
            printf("Unable to fetch concurrent informations for product SKU: %s\n", $reference);
            $noOffers = true ;
        }

        if (!$concurrentInfoAPI->ParseConcurrentInfo())
        {
            printf("No Offers for %s\n", $reference);
            $noOffers = true ;
        }

        
        if ($mpPrice)
        {
            if ( isset($amazonPricingData->ListingPrice) && $amazonPricingData->ListingPrice )
                    $price = $amazonPricingData->ListingPrice ;
            else    $price = $mpPrice;
            
            $maximum = $stratege['target_price'];
        }
        else
        {
            if ( isset($amazonPricingData->ListingPrice) && $amazonPricingData->ListingPrice )
                    $price = $amazonPricingData->ListingPrice ;
            else    $price = $amazonPrice ;

            $maximum = $price;
        }

        if ($mpPrice > $maximum)
            $maximum = $mpPrice;

        if ($price > $maximum)
            $maximum = $price;

        if ($amazonPrice > $maximum)
            $maximum = $amazonPrice;

        $SuggestedPrice = null ;
        $newOffers = $usedOffers = 0 ;
        $newLowestTotalPrice = $usedLowestTotalPrice = 0 ;  
        
        if (!$noOffers)
        {
            // Shipping Prices
            //
            $newItems = isset($concurrentInfoAPI->concurrentInfoData[$SKU]['New']) ? true : false;
            $usedItems = isset($concurrentInfoAPI->concurrentInfoData[$SKU]['Used']) ? true : false;

            $newLowestTotalPrice = $newHighestTotalPrice = $newLowestShippingPrice = $newOffers = 0 ;
            
            if ($newItems)
            {
                $newOffers = count($concurrentInfoAPI->concurrentInfoData[$SKU]['New']) ;
                $highestIndex = $newOffers - 1;

                if ( empty($ASIN) )
                    $ASIN = $concurrentInfoAPI->concurrentInfoData[$SKU]['New'][0]->ASIN ;
                
                $newHighestShippingPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['New'][$highestIndex]->Shipping;
                $newLowestShippingPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['New'][0]->Shipping;

                $newHighestPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['New'][$highestIndex]->Price;
                $newLowestPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['New'][0]->Price;

                $newLowestTotalPrice = $newLowestShippingPrice + $newLowestPrice;
                $newHighestTotalPrice = $newHighestShippingPrice + $newHighestPrice;
            }

            $usedLowestTotalPrice = $usedHighestTotalPrice = $usedLowestShippingPrice = $usedOffers = 0 ;
            
            if ($usedItems)
            {
                $usedOffers = count($concurrentInfoAPI->concurrentInfoData[$SKU]['Used']) ;
                $highestIndex = $usedOffers - 1;

                if ( empty($ASIN) )
                    $ASIN = $concurrentInfoAPI->concurrentInfoData[$SKU]['Used'][0]->ASIN ;
                
                $usedHighestShippingPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['Used'][$highestIndex]->Shipping;
                $usedLowestShippingPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['Used'][0]->Shipping;

                $usedHighestPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['Used'][$highestIndex]->Price;
                $usedLowestPrice = $concurrentInfoAPI->concurrentInfoData[$SKU]['Used'][0]->Price;

                $usedLowestTotalPrice = $usedLowestShippingPrice + $usedLowestPrice;
                $usedHighestTotalPrice = $usedHighestShippingPrice + $usedHighestPrice;
            }
            if ( ! empty($ASIN) && empty($options['asin1']) )
            {
                $options['asin1'] = $ASIN ;
                Amazon_Product::setProductOptions($id_product, $amazon_lang, $options) ;
            }

            $newHighestPriceColor = 'green';
            $newLowestPriceColor = 'green';
            $newCurrentPriceColor = 'green';

            $usedHighestPriceColor = 'green';
            $usedLowestPriceColor = 'green';

            // New Products
            //
            if ($newHighestTotalPrice > $price)
                $newHighestPriceColor = 'red';

            if ($newLowestTotalPrice < $price)
                $newLowestPriceColor = 'red';

            // Used Products
            //
            if ($usedLowestTotalPrice < $price)
                $usedLowestPriceColor = 'red';

            if ($usedHighestTotalPrice > $price)
                $usedHighestPriceColor = 'red';

            $newCurrentPriceColor = $newLowestPriceColor;
            $newMinimumPriceColor = $newCurrentPriceColor;

            // Corrections demand�es par MM
            //
            $strategy = new Amazon_Strategy($reference, true, $amazon_lang);

            $result = $strategy->get();
            $gap = $result['gap'] > 0 ? $result['gap'] : $minimumGap;

            if ($condition == 'New')
                $base = $newLowestTotalPrice;
            else
                $base = $usedLowestTotalPrice;
            
            if ($result['target_price'])
                $suggested = $this->calculate(0, $maximum, $gap, $base, $shipping) ;
            else
                $suggested = $price;

            // Fin
            if ($base > $price)
            {
                $SuggestedPriceColor = 'orange';
                $newLowestPriceColor = 'orange';
            }
            else
            {
                $SuggestedPriceColor = 'green';
                $newLowestPriceColor = 'green';
            }

            // Our Prices
            //
            $CurrentPrice = sprintf('<span style="color:%s;">%s</span>', $newCurrentPriceColor, Tools::displayPrice($price));
            $MinimumPrice = sprintf('<span style="color:%s;">%s</span>', $newMinimumPriceColor, Tools::displayPrice($price));
            $SuggestedPrice = sprintf('<span style="color:%s;">%s</span>', $SuggestedPriceColor, Tools::displayPrice($suggested));
            $MaximumPrice = sprintf('<span style="color:#638fe8;">%s</span>', Tools::displayPrice($maximum));
            
            $initial_highest = $newHighestTotalPrice;
        }

        ?>
        <div id="amazon-overlay"></div>
        <div id="amazon-window" style="display:block">
            <div id="window">
                <span id="awindow-closeX"></span>
                <div style="float:left;">
                    <img src="<?php echo $this->images ?>wozapi.gif"  title="Wozapi" alt="Wozapi"  id="wozapi-img" />
                </div>
                <br />
                <h1 style="line-height:0.8em"><?php echo $product_name ?></h1>
                <span><?php echo $this->l('EAN13') ?> : <?php echo $ean ?> - <?php echo $this->l('Reference') ?> : <?php echo $reference ?> <?php echo $this->l('ASIN') ?> : <?php echo $ASIN ?></span>
                <br />
                <br />
        <?php
        echo $this->_select_country();
        ?>

                <div style="clear:both;height:3px;"></div>

                <fieldset class="comp-heading">
                    <legend><img src="<?php echo $this->images . 'a16.gif' ?>" alt="" /><?php echo $this->l('Amazon Market Place') ?></legend>


                    <?php

                    if ( $newOffers && $condition == 'New')
                    {
                        // MarketPlace Prices - New
                        //
                        $newLowestPriceFormated = sprintf('<span>%s</span>', Tools::displayPrice($newLowestPrice, $currency));
                        $newLowestTotalPriceFormated = sprintf('<span style="color:%s;">%s</span>', $newLowestPriceColor, Tools::displayPrice($newLowestTotalPrice, $currency));

                        $newHighestTotalPriceFormated = sprintf('<span style="color:%s;">%s</span>', $newHighestPriceColor, Tools::displayPrice($newHighestTotalPrice, $currency));
                        $newHighestPriceFormated = sprintf('<span>%s</span>', Tools::displayPrice($newHighestPrice, $currency));

                        $newLowestShippingPriceFormated = sprintf('<span style="color:grey;">%s</span>', Tools::displayPrice($newLowestShippingPrice, $currency));
                        $newHighestShippingPriceFormated = sprintf('<span style="color:grey;">%s</span>', Tools::displayPrice($newHighestShippingPrice, $currency));                        
                        
                        $newLowestPriceFormatedConverted = $newLowestTotalPriceFormatedConverted = $newHighestTotalPriceFormatedConverted = $newHighestPriceFormatedConverted = $newLowestShippingPriceFormatedConverted = $newHighestShippingPriceFormatedConverted = null ;

                        if ($default_id_currency != $current_id_currency)                
                        {
                            $newLowestPriceFormatedConverted = sprintf('&nbsp;<span style="color:silver;font-weight:normal;">(%s)</span>&nbsp;&nbsp;', Tools::displayPrice(Tools::ps_round($newLowestPrice * $currency->conversion_rate, 2), $originCurrency));
                            $newLowestTotalPriceFormatedConverted = sprintf('&nbsp;<span style="color:silver;font-weight:normal;">(%s)</span>&nbsp;&nbsp;', Tools::displayPrice(Tools::ps_round($newLowestTotalPrice * $currency->conversion_rate, 2), $originCurrency));

                            $newHighestTotalPriceFormatedConverted = sprintf('<span style="color:silver;font-weight:normal;">(%s)</span>&nbsp;&nbsp;', Tools::displayPrice(Tools::ps_round($newHighestTotalPrice * $currency->conversion_rate, 2), $originCurrency)); 
                            $newHighestPriceFormatedConverted = sprintf('<span style="color:silver;font-weight:normal;">(%s)</span>&nbsp;&nbsp;', Tools::displayPrice(Tools::ps_round($newHighestPrice * $currency->conversion_rate, 2), $originCurrency));

                            $newLowestShippingPriceFormatedConverted = sprintf('<span style="color:silver;font-weight:normal;">(%s)</span>&nbsp;&nbsp;', Tools::displayPrice(Tools::ps_round($newLowestShippingPrice * $currency->conversion_rate, 2), $originCurrency));
                            $newHighestShippingPriceFormatedConverted = sprintf('<span style="color:silver;font-weight:normal;">(%s)</span>&nbsp;&nbsp;', Tools::displayPrice(Tools::ps_round($newHighestShippingPrice * $currency->conversion_rate, 2), $originCurrency)); 
                        }
                        
                        
                        ?>
                        <fieldset class="mainprice-fs">
                            <legend><?php echo $this->l('Products - New') ?></legend>
                            <table class="products">
                                <tr><td align="right" style="color:green"><?php echo $this->l('Lowest Price with Shipping') ?></td><td class="apriceb"><?php echo $newLowestTotalPriceFormatedConverted . $newLowestTotalPriceFormated ?></td></tr>
                                <tr><td align="right"><?php echo $this->l('Price') ?></td><td class="apriceb"><b><?php echo $newLowestPriceFormatedConverted . $newLowestPriceFormated ?></b></td></tr>
                                <tr><td align="right"><?php echo $this->l('Shipping Price') ?></td><td class="aprice"><?php echo $newLowestShippingPriceFormatedConverted . $newLowestShippingPriceFormated ?></td></tr>
                                
                                <tr><td colspan="3"><hr /></td></tr>
                                <tr><td align="right" style="color:red"><?php echo $this->l('Highest Price with Shipping') ?></td><td class="apriceb"><?php echo $newHighestTotalPriceFormatedConverted . $newHighestTotalPriceFormated ?></td></tr>
                                <tr><td align="right"><?php echo $this->l('Price') ?></td><td class="apriceb"><b><?php echo $newHighestPriceFormatedConverted . $newHighestPriceFormated ?></b></td></tr>
                                <tr><td align="right"><?php echo $this->l('Shipping Price') ?></td><td class="aprice"><?php echo $newHighestShippingPriceFormatedConverted . $newHighestShippingPriceFormated ?></td></tr>
                                
                            </table>
                        </fieldset>
                        <?php
                    }
                    if ( $usedOffers && $condition != 'New')
                    {
                        // Prices - Used
                        //
                        $usedLowestPriceFormated = sprintf('<span>%s</span>', Tools::displayPrice($usedLowestPrice, $currency));
                        $usedHighestPriceFormated = sprintf('<span>%s</span>', Tools::displayPrice($usedHighestPrice, $currency));

                        $usedLowestTotalPriceFormated = sprintf('<span style="color:%s;">%s</span>', $usedLowestPriceColor, Tools::displayPrice($usedLowestTotalPrice, $currency));
                        $usedHighestTotalPriceFormated = sprintf('<span style="color:%s;">%s</span>', $usedHighestPriceColor, Tools::displayPrice($usedHighestTotalPrice, $currency));

                        $usedLowestShippingPriceFormated = sprintf('<span style="color:grey;">%s</span>', Tools::displayPrice($usedLowestShippingPrice, $currency));
                        $usedHighestShippingPriceFormated = sprintf('<span style="color:grey;">%s</span>', Tools::displayPrice($usedHighestShippingPrice, $currency));                        
                        ?>
                        <fieldset class="mainprice-fs">
                            <legend><?php echo $this->l('Products - Used') ?></legend>

                            <table class="products">
                                <tr><td align="right" style="color:green"><?php echo $this->l('Lowest Price with Shipping') ?></td><td class="apriceb"><?php echo $usedLowestTotalPriceFormated ?></td></tr>
                                <tr><td align="right"><?php echo $this->l('Price') ?></td><td class="aprice"><?php echo $usedLowestPriceFormated ?></td></tr>
                                <tr><td align="right"><?php echo $this->l('Shipping Price') ?></td><td class="aprice"><?php echo $usedLowestShippingPriceFormated ?></td></tr>
                                <tr><td colspan="3"><hr /></td></tr>
                                <tr><td align="right" style="color:red"><?php echo $this->l('Highest Price with Shipping') ?></td><td class="apriceb"><?php echo $usedHighestTotalPriceFormated ?></td></tr>
                                <tr><td align="right"><?php echo $this->l('Price') ?></td><td class="aprice"><?php echo $usedHighestPriceFormated ?></td></tr>
                                <tr><td align="right"><?php echo $this->l('Shipping Price') ?></td><td class="aprice"><?php echo $usedHighestShippingPriceFormated ?></td></tr>
                            </table>
                        </fieldset>
                        <?php
                    }

                    if ( ! $newOffers && ! $usedOffers )
                    {
                        ?>
                        <div>
                        <fieldset class="mainprice-fs">
                            <legend><?php echo $condition != 'New' ? $this->l('Products - Used') : $this->l('Products - New') ?></legend>                            
                        <?php echo $this->l('Sorry, no matching products found') ?>
                        </fieldset>
                        </div>
                        <?php
                    }

                    if ($usedOffers || $newOffers)
                    {
                        $i = 1;

                        if ($condition == 'New')
                        {
                            if ( $usedOffers && $newOffers )
                                    $Offers = array_merge($concurrentInfoAPI->concurrentInfoData[$SKU]['New'], $concurrentInfoAPI->concurrentInfoData[$SKU]['Used']) ;
                            elseif ( $usedOffers )
                                    $Offers = $concurrentInfoAPI->concurrentInfoData[$SKU]['Used'] ;
                            elseif ( $newOffers )
                                    $Offers = $concurrentInfoAPI->concurrentInfoData[$SKU]['New'] ;
                        }
                        else
                        {
                            if ( $usedOffers && $newOffers )
                                    $Offers = array_merge($concurrentInfoAPI->concurrentInfoData[$SKU]['Used'], $concurrentInfoAPI->concurrentInfoData[$SKU]['New']) ;
                            elseif ( $usedOffers )
                                    $Offers = $concurrentInfoAPI->concurrentInfoData[$SKU]['Used'] ;
                            elseif ( $newOffers )
                                    $Offers = $concurrentInfoAPI->concurrentInfoData[$SKU]['New'] ;                            
                        }

                            ?>
                            <fieldset class="topoffer-fs">
                                <legend><?php echo $this->l('Best Offers') ?></legend>
                                <table class="products">
                                    <tr class="grey-heading">
                                        <td><?php echo $this->l('Cond.') ?></td>
                                        <td><?php echo $this->l('Rating') ?></td>
                                        <td><?php echo $this->l('FBA') ?></td>
                                        <td><?php echo $this->l('Price') ?></td>
                                        <td><?php echo $this->l('Shipping') ?></td>
                                        <td><?php echo $this->l('Total') ?></td></tr>
                                    <?php
                                    foreach ($Offers as $index => $Offer)
                                    {
                                            // Shipping Prices
                                            //
                                            $shippingPrice = sprintf('<span style="color:black">+ %s</span>', Tools::displayPrice($Offer->Shipping, $currency));

                                            // $OfferPrice 
                                            $OfferPrice = Tools::displayPrice($Offer->Price, $currency) ;
                                            
                                            // Our Price + Shipping
                                            if ( isset($amazonPricingData->ListingPrice) )
                                                $ourAmazonPrice = $amazonPricingData->ListingPrice + $amazonPricingData->ShippingPrice ; 
                                            else
                                                $ourAmazonPrice = $amazonPrice + $shipping ;
                                            
                                            if ($Offer->Shipping + $Offer->Price > $ourAmazonPrice)
                                                $style = ' style="color:red;"';
                                            else
                                                $style = ' style="color:green;"';
                                            
                                            if ( strtolower($Offer->FulfillmentChannel) == 'merchant' ) 
                                                    $fba = $this->l('No') ;
                                            else    $fba = sprintf('<span style="color:green">%s</span>', $this->l('Yes')) ;
                                            
                                            $rating = sprintf('%s <span style="color:grey">(%s)</span>', $Offer->SellerPositiveFeedbackRating, $Offer->SellerFeedbackCount) ;
                                            
                                            $total = Tools::displayPrice($Offer->Shipping + $Offer->Price, $currency) ; 
                                            ?>
                                                <tr style="line-height:125%">
                                                    <td><?php echo $condition ?></td>
                                                    <td align="left"><?php echo $rating ?></td>
                                                    <td align="right"><?php echo $fba ?></td>
                                                    <td align="right"><?php echo $OfferPrice ?></td>
                                                    <td align="right"><?php echo $shippingPrice ?></td>
                                                    <td align="right"<?php echo $style ?>><?php echo $total ?></td>
                                                </tr>
                                            <?php
                                            if ($i++ >= 3)
                                                break;
                                    }                                    

                                    ?>
                                </table>
                            </fieldset>
                                    <?php
  
                            }
                             
                            if ( isset($amazonPricingData->ListingPrice) && $amazonPricingData->ListingPrice ) 
                            {                            
                            ?>
                            <fieldset class="ouroffer-fs">
                                <legend><?php echo $this->l('Our Offer') ?></legend>
                                <table class="products">
                                    <tr class="grey-heading">
                                        <td><?php echo $this->l('Cond.') ?></td>
                                        <td>&nbsp;</td>
                                        <td><?php echo $this->l('FBA') ?></td>
                                        <td><?php echo $this->l('Price') ?></td>
                                        <td><?php echo $this->l('Shipping') ?></td>
                                        <td style="text-align: right;padding-right: 25px;"><?php echo $this->l('Total') ?></td></tr>
                                    <?php
                                            // Our Shipping Prices
                                            //
                                            $shippingPrice = sprintf('<span style="color:grey">+ %s</span>', Tools::displayPrice($amazonPricingData->ShippingPrice, $currency));

                                            // Our Price 
                                            $OfferPrice = Tools::displayPrice($amazonPricingData->ListingPrice, $currency) ;
                                            
                                            // Our Price + Shipping
                                            $total = $amazonPricingData->ListingPrice + $amazonPricingData->ShippingPrice ;
                                           
                                            // comparaison base :
                                            if ( $condition == 'New' )
                                                if ( $total > $newLowestTotalPrice )  
                                                    $cheapest = false ;
                                                else    
                                                    $cheapest = true ;
                                            else
                                                if ( $total > $usedLowestTotalPrice )  
                                                    $cheapest = false ;
                                                else    
                                                    $cheapest = true ; 
                                            
                                            if ( $cheapest )
                                            {
                                                $style = ' style="color:green;"';
                                                $img='<img src="' . $this->images . '/success-small.png" class="cheapest" />' ;
                                            }
                                            else    
                                            {
                                                $style = ' style="color:red;"';
                                                $img='' ;
                                            }
                                            if ( strtolower($amazonPricingData->Fulfillment) == 'merchant' ) 
                                                    $fba = $this->l('No') ;
                                            else    $fba = $this->l('Yes') ;
                                            
                                            ?>
                                                <tr style="line-height:125%">
                                                    <td><?php echo $condition ?></td>
                                                    <td align="left"></td>
                                                    <td align="left"><?php echo $fba ?></td>
                                                    <td align="right"><?php echo $OfferPrice ?></td>
                                                    <td align="right"><?php echo $shippingPrice ?></td>
                                                    <td align="right"<?php echo $style ?>><?php echo $img ?><?php echo Tools::displayPrice($total, $currency) ?></td>
                                                </tr>
                                            <?php
                            
                                    ?>
                                </table>
                            </fieldset>
                                    <?php
                            }
                            /*

                              $strategy->salesPositions() (array)
                              total_sales	22656.423636
                              total_quantity	110
                              product_sales	2654.631036
                              total_quantity	5
                              percent_val	11.716902361333
                              percent_qty	4.5454545454545
                             */

                            $statistics = $strategy->salesPositions();
                            $percent_sale = sprintf('%.02f%%', round($statistics['percent_val'], 1));
                            $percent_qty = sprintf('%.02f%%', round($statistics['percent_qty'], 1));
                            $quantity_sold = sprintf('%d', $statistics['product_quantity']);

                            /*
                            if ($failed)
                            {
                                $this->l('h1>failed to connect to Amazon Market Place</h1>');
                            }
                             */
                            ?>

                    <div style="clear:both"></div>
                </fieldset>
                <div style="clear:both;display:block;height:10px;"></div>
                <fieldset class="comp-heading">
                    <legend><img src="../img/admin/home.gif" alt="" /><?php echo Configuration::get('PS_SHOP_NAME') ?></legend>
                    <fieldset class="aprice-fs">
                        <legend><?php echo $this->l('Actual Price'); ?></legend>
                        <table class="products">
                            <?php
                                if ($default_id_currency != $current_id_currency)                
                                    $currencyAmazonPrice = Tools::convertPrice($amazonPrice, $currency) ;                            
                                else $currencyAmazonPrice = $amazonPrice ;
                                
                                $displayAmazonPriceCurrency = sprintf('<span style="color:navy;">%s</span>', Tools::displayPrice($currencyAmazonPrice, $currency));
                                $displayAmazonPrice = sprintf('<span style="color:navy;">%s</span>', Tools::displayPrice($amazonPrice));
                                $displayCatalogPrice = sprintf('<span style="color:grey;">%s</span>', Tools::displayPrice($catalogPrice)); 
                            ?>
                            <tr><td align="right"><?php echo $this->l('Amazon Price') ?></td><td class="apriceb"><?php echo $displayAmazonPrice ?></td></tr>
                            <tr><td align="right"><?php echo $this->l('Amazon Price (Currency)') ?></td><td class="apriceb"><?php echo $displayAmazonPriceCurrency ?></td></tr>
                            <tr><td align="right"><?php echo $this->l('Currency Rate') ?></td><td class="apriceb"><?php echo $currentCurrencyRate ?></td></tr>
                            <tr><td align="right"><?php echo $this->l('Catalog Price') ?></td><td class="apriceb"><?php echo $displayCatalogPrice ?></td></tr>
                            
                            <tr><td align="right"><?php echo $this->l('Qty Available') ?></td><td class="aprice"><?php echo $quantity ?></td></tr>
                            <tr><td align="right"><?php echo $this->l('Wholesale (w/VAT)') ?></td><td class="aprice"><?php echo $wholesale_price ?></td></tr>
                            <tr><td colspan="2" align="center"><hr /></td></tr>
                            <tr><td align="right"><?php echo $this->l('% Sales (value)') ?></td><td class="aprice"><?php echo $percent_sale ?></td></tr>
                            <tr><td align="right"><?php echo $this->l('% Sales (qty)') ?></td><td class="aprice"><?php echo $percent_qty ?></td></tr>
                            <tr><td align="right"><?php echo $this->l('Quantity Sold') ?></td><td class="aprice"><?php echo $quantity_sold ?></td></tr>
                        </table>
                    </fieldset>
                    <form id="update-bid" name="update-amazon-bid" method="POST">
                        <input type="hidden" name="id_lang" value="<?php echo $this->id_lang ?>" />
                        <input type="hidden" name="amazon_lang" value="<?php echo $this->amazon_lang ?>" />
                        <input type="hidden" name="id_product_attribute" value="<?php echo $id_product_attribute ?>" />
                        <input type="hidden" name="ASIN" value="<?php echo $ASIN ?>" />
                        <input type="hidden" name="ref_product" value="<?php echo $reference ?>" />
                        <input type="hidden" name="initial_price" value="<?php echo isset($amazonPricingData->ListingPrice) ? $amazonPricingData->ListingPrice : $amazonPrice ?>" />
                        <input type="hidden" name="shipping_price" value="<?php echo $shipping ?>" />
                        <input type="hidden" name="suggested" value="<?php echo $suggested ?>" />
                        <input type="hidden" name="lowest" value="<?php echo $usedLowestTotalPrice ? $usedLowestTotalPrice : $newLowestTotalPrice ?>" />
                        <input type="hidden" name="initial_highest" value="<?php echo $initial_highest ?>" />

                        <fieldset class="strategy-fs">
                            <legend><?php echo $this->l('Strategies') ?></legend>
                            <div style="height:10px;"></div>
                            <table class="products">
                                <tr class="grey-heading">
                                    <td align="right"><?php echo $this->l('Minimum Price') ?></td>
                                    <td align="right"><?php echo $this->l('Shipping') ?></td>
                                    <td align="right"><?php echo $this->l('Suggested Price') ?></td>
                                    <td align="right"><?php echo $this->l('Maximum Price') ?></td>
                                </tr>
                                <tr>
                                    <td class="aprice" id="amz-dis-min" style="color:grey;font-weight:bold;"></td>
                                    <td class="aprice" id="amz-dis-ship" style="font-weight:bold;"></td>
                                    <td class="aprice" id="amz-dis-sug" style="color:brown;font-weight:bold;"><?php echo $SuggestedPrice ?></td>
                                    <td class="aprice" id="amz-dis-max" style="color:navy;font-weight:bold;"></td>
                                </tr>
                                <tr>
                                    <td colspan="4"><hr /></td>
                                </tr>
                            </table>
                            <table class="product" width="100%">
                                <tr>
                                    <td><?php echo $this->l('Minimum Price'); ?></td>
                                    <td class="apriceb">
                                        <input type="text" style="width:50px;text-align:right;" name="min" id="amz-min" /></td>
                                    <td><?php echo $this->l('Current Price'); ?></td>
                                    <td class="apriceb">
                                        <input type="text" style="width:50px;text-align:right;" name="cur" id="amz-cur" /></td>
                                    <td><?php echo $this->l('Gap'); ?></td>
                                    <td class="apriceb">
                                        <input type="text" style="width:50px;text-align:right;" name="gap" id="amz-gap" /></td>
                                    <td><?php echo $this->l('Target Price'); ?></td>
                                    <td class="apriceb">
                                        <input type="text" style="width:50px;text-align:right;" name="max" id="amz-max" /></td>
                                </tr>
                                <tr>
                                    <td>&nbsp;</td>
                                </tr>
                            </table>        

                        </fieldset>
                        <div style="clear:both"></div>
                        <fieldset class="price-fs" style="min-height:90px;">
                            <legend><?php echo $this->l('Sales History'); ?></legend>
                            <table class="products">
                                <tr class="grey-heading">
                                    <td><?php echo $this->l('Sale Date') ?></td>
                                    <td><?php echo $this->l('Qty') ?></td>
                                    <td><?php echo $this->l('Total TTC') ?></td>
                                </tr>

                                <?php
                                $i = 1;
                                if (count($history))
                                    foreach ($history as $sale)
                                    {
                                        if (!$sale['product_quantity'])
                                            continue;
                                        $price = round(($sale['product_price'] * $sale['product_quantity']) * (1 + ($sale['tax_rate'] / 100)), 1);
                                        $price = Tools::displayPrice($price);
                                        ?> 
                                        <tr><td><?php echo Amazon_Tools::displayDate($sale['date_add'], $amazon_lang, true); ?></td><td><?php echo $sale['product_quantity'] ?></td><td align="right" style="color:grey;"><?php echo $price ?></td></tr>
                                        <?php
                                        if ($i++ >= 4)
                                            break;
                                    }
                                ?>
                            </table>      
                        </fieldset>

                        <fieldset class="action-fs">
                            <legend><?php echo $this->l('Action'); ?></legend>
                            <table class="products">
                                <tr>
                                    <td>
                                        <?php
                                            if ( isset($marketPlaceIds[$amazon_lang]) && Amazon_Tools::isEuropeMarketplaceId($marketPlaceIds[$amazon_lang]) )
                                            {
                                        ?>
                                        <input type="checkbox" name="strategy-europe" value="1" style="margin:5px;" /><?php echo $this->l('Europe'); ?>
                                        <?php
                                            }
                                        ?>       
                                    </td>
                                    <td>
                                        <input type="checkbox" name="freeze" id="freeze-price" value="1" style="margin:5px;" /><?php echo $this->l('Freeze Price'); ?>
                                    </td>
                                    <td>
                                        <input type="checkbox" id="suggested-price" value="1" style="margin:5px;" /><?php echo $this->l('Suggested Price'); ?>&nbsp;&nbsp;
                                    </td>
                                    <td>
                                        <div style="height:30px;float:left;margin-top:17px;"><span id="amz-delete"><img src="<?php echo $this->images ?>cross.png" alt="" /><?php echo $this->l('Delete') ?></span></div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="3" style="height:16px">
                                        <span id="amz-loader"><?php echo $this->l('Updating...'); ?>&nbsp;&nbsp;<img src="<?php echo $images ?>small-loader.gif" alt="" /> </span>
                                    </td>
                                </tr>
                            </table>  

                        </fieldset> 
                        <input type="submit" id="update-online" value="<?php echo $this->l('Save'); ?>" class="button" style="float:right;width:220px;margin:3px;padding:3px;" />
                        <input type="submit" id="view-online" rel="<?php echo Amazon_Tools::goToProductPage($amazon_lang, $ASIN) ?>/" value="<?php echo $this->l('Lookup on Amazon'); ?>" class="button" style="float:right;width:220px;margin:3px;padding:3px;" />
                    </form>
                </fieldset>


            </div>
        </div>
        <?php
    }

    function badWindow($message)
    {
        $html = '
        <div id="amazon-overlay"></div>
        <div id="amazon-window" style="display:block">
            <div id="window">
                <span id="awindow-closeX"></span>
                <div style="float:left;">
                    <img src="' . $this->images . 'wozapi.gif"  title="Wozapi" alt="Wozapi"  id="pic" style="border:none" />
                </div>
                <br />
                <h1 style="width:700px">' . $message . '</h1>
                <br />
                <br />
            </div>
        </div>
        ' ;
        echo $html;
    }
}

$amazonBid = new Product_Bid();
$amazonBid->productBid();