<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['DropBox']) && $_SERVER['DropBox'])
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') ) ;
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') ) ;
}
else    
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php') ;
    @require_once(dirname(__FILE__) . '/../../../init.php');
}
require_once(dirname(__FILE__) . '/../amazon.php');

require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.address.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.order.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.orderhistory.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.cart.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.payment.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.mail.logger.class.php');

class AmazonImportOrder extends Amazon
{
    private $_amazonApi = array();
    private $_debug = false;

    static public $errors = array();
    static public $warnings = array();
    static public $messages = array() ;
    static public $send_email = false ;
    static public $orders = array() ;
    
    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    static public function JSON_Display_Exit()
    {
        if ( !count(AmazonImportOrder::$orders) )
        {
            $result = trim(ob_get_clean()) ;
            if ( trim($result) )
                AmazonImportOrder::$warnings[] = trim($result) ;
        }
        else
        {
            $result = trim(ob_get_clean()) ;
            if ( trim($result) )
                AmazonImportOrder::$messages[] = trim($result) ;
        }
        
        if ( self::$send_email && count(AmazonImportOrder::$errors) && Tools::getValue('cron') )
        {
            $email = Amazon_Tools::CallingFunction() . self::LF ;
            $email .= sprintf('%s : %s', 'Error From', __CLASS__) . self::LF ;
            
            if ( count(AmazonImportOrder::$messages) )
            {
                $email .= sprintf('Messages : ') . self::LF ;
                foreach(AmazonImportOrder::$messages as $message)
                    $email .= " - " . $message . self::LF ;
            }
            if ( count(AmazonImportOrder::$warnings) )
            {
                $email .= sprintf('Warnings : ') . self::LF ;
                foreach(AmazonImportOrder::$warnings as $warning)
                    $email .= " - " . $warning . self::LF ;
            }            
            if ( count(AmazonImportOrder::$errors) )
            {
                $email .= sprintf('Errors : ') . self::LF ;
                foreach(AmazonImportOrder::$errors as $error)
                    $email .= " - " . $error . self::LF ;
            }

            Amazon_MailLogger::message($email) ;
        }
        
        $json = Amazon_Tools::jsonEncode(
                    array( 
                            'orders' => AmazonImportOrder::$orders, 
                            'count'  => count(AmazonImportOrder::$orders), 
                            'error' => (count(AmazonImportOrder::$errors) ? true : false), 
                            'errors' => AmazonImportOrder::$errors, 
                            'warning' => (count(AmazonImportOrder::$warnings) ? true : false), 
                            'warnings' => AmazonImportOrder::$warnings, 
                            'message' => count(AmazonImportOrder::$messages),
                            'messages' => AmazonImportOrder::$messages
                          )) ;
        
        if ( ($callback = Tools::getValue('callback')) ) // jquery
        {
            echo strval($callback) . '(' . $json . ')';
        }
        else // cron
        {
            echo $json;
        }
        
    }    
    public function Import()
    {
        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->_debug = $debugMode ? true : false;
        
        if ( Tools::getValue('debug') )
            $this->_debug = true ;
        
        if ( $this->_debug )
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);            
        } 
        self::$send_email = (bool)Amazon::configurationGet('AMAZON_EMAIL') ;
        
        ob_start() ;
        register_shutdown_function( array('AmazonImportOrder', 'JSON_Display_Exit') ) ;
        
        $cronMode = 0;
        $currentDate = date('Y-m-d H:i:s');

        // Regions
        //
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $marketLang2Region = array_flip($marketPlaceRegion);
        
        // WGET MODE
        if (Tools::getValue('cron'))
        {
            $lang = Tools::getValue('lang');
            $cronToken = Tools::getValue('cron_token');

            $cr = "<br />\n"; // carriage return

            $cronMode = 1;
            echo "Starting Order Query in WS API/Cron Mode" . ' - ' . $currentDate . $cr;

            $date1 = date('c', ($storedDate = strtotime(Amazon::configurationGet('AMAZON_ORDERS_RETRIEVED'))));

            if ($storedDate < strtotime($currentDate))
                $date1 = date('c', strtotime('now - 1 day')); // first time ...

            $date2 = date('c', strtotime('now - 15 min'));

            echo "Fetching orders from $date1 to $date2 " . $cr;

            if (!isset($marketLang2Region[$lang]) || !$marketLang2Region[$lang])
                die($this->l('No selected language, nothing to do...'));

            $id_lang = $marketLang2Region[$lang];

            if (!Amazon_Tools::checkToken($cronToken, $id_lang))
                die('Wrong Token');

            $status = array();
            $status = 'Unshipped';
        }
        //
        // Web Mode
        //
        else
        {
            $cr = "<br />\n"; // carriage return

            $status     = strval(Tools::getValue('statuses'));
            $id_lang    = intval(Tools::getValue('amazon_lang'));
            $tokens     = Tools::getValue('amazon_token');
            
            if (intval(Tools::getValue('europe')))
            {
                $masterMarketplace = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MASTER')));

                if ( isset($marketLang2Region[$masterMarketplace]) && $marketLang2Region[$masterMarketplace] )
                    $id_lang = $marketLang2Region[$masterMarketplace] ;
                else
                    $id_lang = (int)Configuration::get('PS_LANG_DEFAULT') ;

                $europe = 1;
            }
            else
            {
                $europe = 0;
            }            

            if (!Amazon_Tools::checkToken($tokens, $id_lang))
                die($this->l('Wrong Token'));

            if (!intval($id_lang))
                die($this->l('No selected language, nothing to do...'));
        }
        
        $i = 0;

        $tokenOrders = Tools::getValue('token_order');
        
        $id_warehouse = null;
        $id_shop = 1;

        // Shop Configuration (PS 1.5)
        // 
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $id_shop = (int) Amazon::configurationGet('AMAZON_SHOP');
            $id_warehouse = (int) Amazon::configurationGet('AMAZON_WAREHOUSE');

            if (!$id_shop)
                $id_shop = 1;
        }

        // Carriers
        //
        $carriers = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CARRIER')));
        $amazon_carriers = unserialize(base64_decode(Amazon::configurationGet('AMAZON_AMAZON_CARRIER')));

        // Currency
        //
        $currencies = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CURRENCY')));

        // To access to the module properties
        //
        $amazon = new Amazon();

        // Fulfillment by Amazon (FBA)
        //
        $FBA = (bool)Amazon::configurationGet('AMAZON_FBA');

        // Order State
        //
        $idOrderState = array();
        $idOrderState[Amazon::MFN] = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_ORDER_STATE'))));
        $idOrderState[Amazon::AFN] = intval(Amazon::configurationGet('AMAZON_FBA_ORDER_STATE'));

        if ( ! $FBA )
            $idOrderState[Amazon::AFN] = $idOrderState[Amazon::MFN] ;
        
        // Use Taxes - Amazon Config overrides PS Config
        //
        $useTaxes = false;

        if (Tax::excludeTaxeOption())
            $useTaxes = false;

        if (intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_TAXES')))))
            $useTaxes = true;

        // Force import on out of stock
        //
        $force_import = unserialize(base64_decode(Amazon::configurationGet('AMAZON_FORCE_IMPORT'))) ? true : false ;

        // Import unknown products as a dummy product
        //
        $dummy = (int) Amazon::configurationGet('AMAZON_DUMMY');
        $dummy_product = Amazon::configurationGet('AMAZON_DUMMY_PRODUCT');

        // Add Region to the payment title (UK, FR, US etc..)
        //
        $paymentRegion = Amazon::configurationGet('AMAZON_PAYMENT_REGION') ? true : false;

        // Init
        //
        $amazon = Amazon_Tools::selectPlatforms($id_lang, $this->_debug);

        if ($this->_debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        if (!$this->_amazonApi = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $this->_debug, "<br />\n"))
        {
            echo $this->l('Unable to login') . $cr;
            die;
        }

        // Amazon Throtlling Management
        // 
        $this->_amazonApi->setTimerReadHandler('Configuration', 'get', 'AMAZON_API_TIMER');
        $this->_amazonApi->setTimerWriteHandler('Configuration', 'updateValue', 'AMAZON_API_TIMER');
        // Do not drop in this context
        // $this->_amazonApi->setTimerAction( Amazon_WebService::DROP_THROTLLED_QUERIES ) ;

        if ($cronMode)
        {
            $amazonOrders = null;
            $returnXML = true ;
            
            echo $date1 . $cr;
            echo $date2 . $cr;
            
            // Lookup earliest for FBA orders
            if ( $FBA )
            {
                $date1 = date('c', strtotime($date1 . ' -24 hours')) ;
            }

            if (!$amazonOrders = $this->_amazonApi->GetUnshippedOrdersList($date1, $date2, $status, $FBA, $returnXML))
            {
                printf($this->l('No orders fetched from Amazon') . $cr);
                die;
            }
            if ( isset($amazonOrders->Error) )
            {
                $caller = Amazon_Tools::CallingFunction() ;
                
                $message = sprintf('%s : %s', 'Error From', $caller) . self::LF ;
                $message .= sprintf('%s :', $this->l('Error while retrieving orders')) . self::LF ;
                $message .= sprintf('Type : %s', $amazonOrders->Error->Type) . self::LF ;
                $message .= sprintf('Code : %s', $amazonOrders->Error->Code) . self::LF ;
                $message .= sprintf('Message : %s', $amazonOrders->Error->Message) . self::LF ;
                $message .= sprintf('Request ID : %s', $amazonOrders->RequestID) . self::LF ;
              
                if ( self::$send_email )
                {
                    Amazon_MailLogger::message($message) ;
                }
                die($message) ;
            }
        }
        else
        {
            $orders_ids = Tools::getValue('order_id');

            if (!count($orders_ids))
            {
                printf($this->l('Nothing to import...') . $cr);
                die;
            }

            if (!$amazonOrders = $this->_amazonApi->GetOrders($orders_ids))
            {
                printf($this->l('No orders fetched from Amazon') . $cr);
                die;
            }
        }

        // Identify the order's country
        //
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));
        $marketPlace2IsoId = array_flip($marketPlaceIds);
  
        foreach ($amazonOrders as $key => $order)
        {
            $order_id = (string) $order->AmazonOrderId;

            AmazonImportOrder::$orders[$order_id] = array() ;
            AmazonImportOrder::$orders[$order_id]['products'] = array() ;
            AmazonImportOrder::$orders[$order_id]['status'] = false ; 

            // Charset conversion 
            //
            foreach ($order as $order_key => $order_item)
            {
                if (!is_object($order->$order_key) && !is_array($order->$order_key) && strval($order->$order_key))
                    if ( mb_detect_encoding(strval($order->$order_key)) != 'UTF-8' )
                        $order->$order_key = iconv("ISO-8859-15", "UTF-8//TRANSLIT", $order_item);
            }

            // Skipping Cancelled Orders
            //
            if ((string) $order->OrderStatus == 'Canceled')
            {
                AmazonImportOrder::$warnings[] = basename(__FILE__) . ': ' . __LINE__ . ' - ' . $this->l('Skipping Cancelled Order') . ' #' . $order_id;
                continue;
            }
            if ($this->_debug)
                echo nl2br(print_r($order, true));

            if (Amazon_Order::checkByMpId($order_id))
            {
                AmazonImportOrder::$warnings[] = sprintf($this->l('Order ID (%s) Was already imported...') . $cr, $order_id);
                continue;
            }

            if (!isset($order->Address) || !is_object($order->Address) ||
                    !isset($order->Address->Name))
            {
                AmazonImportOrder::$errors[] = basename(__FILE__) . ': ' . __LINE__ . ' - ' . $this->l('Couldn\'t import incomplete order') . '[' . print_r($order, true) . ']' . $cr;
                continue;
            }

            if (empty($order->Address->Name) || empty($order->Address))
            {
                AmazonImportOrder::$errors[] = basename(__FILE__) . ': ' . __LINE__ . ' - ' . $this->l('Couldn\'t import incomplete order') . '[' . print_r($order->Address, true) . ']' . $cr;
                continue;
            }

            if (!isset($order->BuyerEmail) || empty($order->BuyerEmail))
            {
                AmazonImportOrder::$errors[] = basename(__FILE__) . ': ' . __LINE__ . ' - ' . $this->l('Missing Buyer Email for this order') . $cr;
                continue;
            }
            $idCurrency = (int) Currency::getIdByIsoCode($order->OrderTotalCurrency);

            // Langue de la Commande
            //
            if (isset($marketPlace2IsoId[$order->MarketPlaceId]))
                $id_lang = $marketPlace2IsoId[$order->MarketPlaceId];

            // Amazon Region (fr, de, ...)
            // 
            if (isset($marketPlaceRegion[$id_lang]))
                $region = strtoupper($marketPlaceRegion[$id_lang]);
            else
                $region = null;

            // Amazon Global Customer Account ID
            //
            $id_customer = Amazon::configurationGet('AMAZON_CUSTOMER_ID');

            $account_type = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACCOUNT_TYPE')));

            // Customer individual account
            //
            if ($account_type == Amazon::AccounTypeIndividual && isset($order->BuyerEmail) && !empty($order->BuyerEmail))
            {
                $email_address = (string) $order->BuyerEmail;

                $customer = new Customer();

                if (empty($email_address))
                {
                    AmazonImportOrder::$errors[] = basename(__FILE__) . ': ' . __LINE__ . ' - ' . $this->l('Couldn\'t add this customer') . ' : ' . $name . '(' . $email_address . ')';
                    continue;
                }
                $customer->getByEmail($email_address);

                if ($customer->id)
                {
                    $id_customer = $customer->id;
                }
                else
                {
                    $email_address = (string) $order->BuyerEmail;

                    $name = Amazon_Address::getAmazonName((string) $order->Address->Name);
                    
                    $customer->firstname = $name['firstname'];
                    $customer->lastname = $name['lastname'];
                    $customer->email = $email_address;
                    $customer->passwd = md5(rand());
                    
                    if ( Amazon_Tools::propertyIsAccessible('Customer', 'id_lang') )
                        $customer->id_lang = $id_lang ; // Added: 2014-04-16 

                    if ( ! Validate::isName($customer->firstname) || ! Validate::isName($customer->lastname) || ! Validate::isEmail($customer->email) )
                    {
                        AmazonImportOrder::$errors[] = basename(__FILE__) . ': ' . __LINE__ . ' - ' .  $this->l('Couldn\'t add this customer') . ' : ' . print_r($name, true) . '(' . $email_address . ')';
                        continue ;
                    }
                    else
                    {
                        if (!$customer->add())
                        {
                            AmazonImportOrder::$errors[] = basename(__FILE__) . ': ' . __LINE__ . ' - ' .  $this->l('Couldn\'t add this customer') . ' : ' . print_r($name, true) . '(' . $email_address . ')';
                            continue ;
                        }
                        else
                        {
                            $id_customer = $customer->id;
                        }
                    }
                }
            }

            // FROM AMZON to PRESTASHOP !
            //
            $shipping_address = new Amazon_Address();
            $shipping_address->id_customer = $id_customer;
            $shipping_address_id = $shipping_address->lookupOrCreateAmazonAddress($order->Address, $order->BuyerEmail);

            $date_add = date('Y-m-d H:i:s', strtotime($order->PurchaseDate));
            $shipping_price = 0;
            $channel = (string) $order->FulfillmentChannel;

            // Associate Shipping Method
            //
            $shipping_method = trim((string) $order->ShipServiceLevel);

            for ($i = 0, $id_carrier = 0; $i < count($amazon_carriers[$id_lang]); $i++)
            {
                if (md5($shipping_method) == $amazon_carriers[$id_lang][$i])
                    $id_carrier = $carriers[$id_lang][$i];
            }

            if (!$id_carrier)
            {   
                AmazonImportOrder::$errors[] = 
                        sprintf($this->l('Unable to associate the carrier (%s) for order #%s') . $cr, $shipping_method, $order->AmazonOrderId) ;
                AmazonImportOrder::$errors[] = 
                        sprintf('%s', $this->l('This is not an error ! You must configure the carrier mapping in the module configuration...')) ;
                continue;
            }

            if (!$Items = $this->_amazonApi->getOrderItems($order_id))
            {
                AmazonImportOrder::$errors[] = $this->l('Unable to retrieve items for Amazon Order') . ': ' . $order_id ;
                continue;
            }

            $itemDetails = array();

            // Building Cart
            //
            $cart = new Amazon_Cart();
            $cart->id_address_delivery = $shipping_address_id;
            $cart->id_address_invoice = $shipping_address_id;
            $cart->id_carrier = $id_carrier;
            $cart->id_currency = $idCurrency;
            $cart->id_customer = $id_customer;
            $cart->id_lang = $id_lang;
            $cart->add();

            $totalQuantity = $totalSaleableQuantity = 0;

            $status = strval($order->OrderStatus);
            $mpStatusId = constant("Amazon_Order::$status");
            
            $i = 0;
            foreach ($Items as $key => $item)
            {
                $quantity = intval($item->QuantityOrdered);
                $price = floatval($item->ItemPriceAmount) / $quantity;
                $totalQuantity += intval($item->QuantityOrdered);
                $product_name = strval($item->Title);
                $SKU = trim(strval($item->SKU));
                $giftwrap = $item->GifWrapPrice ? (float)$item->GifWrapPrice : null ;
                $shipping_price += floatval($item->ShippingPriceAmount);
                
                $product = new Amazon_Product($SKU, false, $id_lang);

                $id_product = isset($product->id) ? $product->id : null;

                $dummy_import = false;
                $realSKU = $SKU;

                if (!$id_product && $dummy)
                {
                    $product = new Amazon_Product($dummy_product, false, $id_lang);

                    $id_product = isset($product->id) ? $product->id : null;

                    $SKU = $dummy_product;

                    $dummy_import = true;
                }
                
                AmazonImportOrder::$orders[$order_id]['products'][$i] = array() ;
                AmazonImportOrder::$orders[$order_id]['products'][$i]['SKU'] = $SKU ;
                AmazonImportOrder::$orders[$order_id]['products'][$i]['ASIN'] = $item->ASIN ;
                AmazonImportOrder::$orders[$order_id]['products'][$i]['product'] = $product_name;
                AmazonImportOrder::$orders[$order_id]['products'][$i]['quantity'] = $quantity;
                AmazonImportOrder::$orders[$order_id]['products'][$i]['currency'] = $item->ItemPriceCurrency ;
                AmazonImportOrder::$orders[$order_id]['products'][$i]['price'] = Tools::displayPrice($price * $quantity, $idCurrency);
                
                if (!$id_product)
                {
                    AmazonImportOrder::$errors[] = 
                            sprintf($this->l('Unable to find the expected product for order #%s product ASIN: %s SKU: %s'), $order->AmazonOrderId, $item->ASIN, $SKU);
                    unset($itemDetails[$SKU]);
                    continue;
                }

                // Two products but with the same reference !
                //
                if (isset($itemDetails[$SKU]))
                {
                    $itemDetails[$SKU]['qty'] += $quantity;
                }
                else
                {
                    $itemDetails[$SKU] =
                            array(
                                'id'              => $SKU,
                                'qty'             => $quantity,
                                'price'           => $price,
                                'name'            => $product_name,
                                'dummy'           => $dummy_import,
                                'real_sku'        => $realSKU,
                                'giftwrap'        => $giftwrap,
                                'shipping'        => 0,
                                'fees'            => 0
                            );
                }
                if ($useTaxes)
                // PS 1.4 sinon 1.3
                    //
                if (method_exists('Tax', 'getProductTaxRate'))
                        $product_tax_rate = (float) (Tax::getProductTaxRate($product->id, $shipping_address_id));
                    else
                        $product_tax_rate = (float) (Tax::getApplicableTax($product->id_tax, $product->tax_rate, $shipping_address_id));
                else
                    $product_tax_rate = 0;

                // Modif YB
                $itemDetails[$SKU]["tax_rate"] = $product_tax_rate;
                $itemDetails[$SKU]["id_tax"] = isset($product->id_tax) ? $product->id_tax : false;
                $itemDetails[$SKU]["id_product"] = $product->id;
                $itemDetails[$SKU]["id_address_delivery"] = $shipping_address_id;

                // Product Combinations
                //
                if (version_compare(_PS_VERSION_, '1.5', '<'))
                    $combinations = $product->getAttributeCombinaisons($id_lang);
                else
                    $combinations = $product->getAttributeCombinations($id_lang);

                $id_product_attribute = 0;

                if ($combinations)
                    foreach ($combinations as $key => $combination)
                        if (trim($combination['reference']) == $SKU)
                        {
                            $id_product_attribute = intval($combination['id_product_attribute']);
                            $itemDetails[$SKU]['id_product_attribute'] = $id_product_attribute;
                        }

                if (version_compare(_PS_VERSION_, '1.5', '<'))
                {
                    $productQuantity = Product::getQuantity(intval($id_product), $id_product_attribute ? $id_product_attribute : null);
                }
                else
                {
                    $productQuantity = Product::getRealQuantity($id_product, $id_product_attribute ? $id_product_attribute : null, $id_warehouse, $id_shop);
                }

                $options = Amazon_Product::getProductOptions($id_product, $id_lang);

                $force = $options['force'] ? true : false;
                
                $restock = false ;
                
                if ( $dummy_import )
                {
                    $restock = true ;
                }
                // In case of FBA restock in all cases 
                elseif ( $FBA && $channel == Amazon::AFN )
                {
                    $restock = true ;
                }
                elseif (!($force || $force_import) && $productQuantity - $quantity < 0)
                {
                    AmazonImportOrder::$errors[] = sprintf('%s ASIN: %s SKU: %s', $this->l('Not enough stock to import this product'), $item->ASIN, $SKU);
                    unset($itemDetails[$SKU]);
                    continue;
                }
                elseif (($force || $force_import) && $productQuantity - $quantity < 0)
                {
                    $restock = true ;
                }

                if ( $restock )
                {
                    if (version_compare(_PS_VERSION_, '1.5', '>='))
                    {
                        StockAvailable::updateQuantity($id_product, $id_product_attribute ? $id_product_attribute : null, $quantity);
                    }
                    else
                    {
                        Amazon_Product::updateProductQuantity($id_product, $id_product_attribute ? $id_product_attribute : null, $productQuantity + $quantity);
                    }
                }
                
                if ($cart->updateQty($quantity, $id_product, $id_product_attribute) < 0)
                {
                    AmazonImportOrder::$errors[] = $this->l('Couldn\'t update cart quantity: not enough stock ?') . ' (ASIN:' . $item->ASIN . ' SKU:' . $SKU . ')' ;
                    unset($itemDetails[$SKU]);
                    continue;
                }

                $i++;

                $totalSaleableQuantity += intval($item->QuantityOrdered);
            }

            if ($totalQuantity != $totalSaleableQuantity)
            {
                AmazonImportOrder::$errors[] = $this->l('Skipping Order: Product count mismatch') . ' (' . $order->AmazonOrderId . ')' ;

                if (Validate::isLoadedObject($cart))
                    $cart->delete();

                continue;
            }

            if (!count($itemDetails))
            {
                AmazonImportOrder::$errors[] = $this->l('Skipping Order: No products for this order') . ' (' . $order->AmazonOrderId . ')' ;

                if (Validate::isLoadedObject($cart))
                    $cart->delete();

                continue;
            }

            // Using price, shipping details etc... from the Market Place
            //
            $cart->amazonProducts = $itemDetails;
            $cart->amazonShipping = $shipping_price;
            $cart->amazonChannel = $channel;

            if ($this->_debug)
                printf('Amazon Cart: %s', nl2br(print_r($cart->amazonProducts, true)));

            // Payment Title
            //
            if ($paymentRegion)
                $paymentTitle = trim(sprintf('%s %s', Amazon::PaymentMethodTitle, $region));
            else
                $paymentTitle = Amazon::PaymentMethodTitle;

            // duplication du panier, important !!!
            //
            $acart = $cart;

            $payment = new Amazon_PaymentModule();
            
            if (!$i)
            {
                AmazonImportOrder::$errors[] = $this->l('Skipping Order: No products for this order') . ' (' . $order->AmazonOrderId . ')' ;

                if (Validate::isLoadedObject($cart))
                    $cart->delete();
                
                continue;
            }
            elseif ( ($newOrderId = $payment->validateMarketplaceOrder($cart->id, $idOrderState[$channel], $paymentTitle, $order_id, $mpStatusId, $acart, $useTaxes, $date_add)) )
            {
                if ( $tokenOrders )
                {
                    $url = '?tab=AdminOrders&id_order=' . $newOrderId . '&vieworder&token=' . $tokenOrders;
                    $order_link = '<a href="' . $url . '" title="" target="_blank" >' . $order->AmazonOrderId . ' (' . $newOrderId  . ')</a>' ;
                    
                    AmazonImportOrder::$orders[$order_id]['link'] = $order_link ; 
                    AmazonImportOrder::$orders[$order_id]['status'] = true ; 
                }
            }
            else
            {
                AmazonImportOrder::$errors[] = $this->l('Error while importing this order ID') . ': ' . $order->AmazonOrderId ;

                if (Validate::isLoadedObject($cart))
                    $cart->delete();
            }
        }
        if ($cronMode && $i)
            Amazon::configurationUpdateValue('AMAZON_ORDERS_RETRIEVED', $currentDate);
    }

    public function Dispatch($action)
    {
        switch ($action)
        {
            default :
                $this->Import();
        }
    }

}

$amazonImportOrder = new AmazonImportOrder();
$amazonImportOrder->Dispatch('');
?>