<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'localhost')
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../init.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
    @require_once(dirname(__FILE__) . '/../../../init.php');
}
require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class AmazonFBAManager extends Amazon
{
    private $_debug = false;
    static public $errors = array();
    static public $log = array();

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    public function Dispatch()
    {
        switch (Tools::getValue('action'))
        {
            default :
                $this->ManageStocks();
                break;
        }
    }

    public function ManageStocks()
    {
        if (Tools::getValue('debug') == true)
            $this->_debug = true;
        else
            $this->_debug = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG'))) ? true : false;

        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }

        if (Tools::getValue('force') == true)
            $forceUpdate = true;
        else
            $forceUpdate = false;

        if (Tools::getValue('days'))
            $days = (int) Tools::getValue('days');
        else
            $days = 1;

        // ID_Lang : No managed at this time - to be implemented for Amazon outside EU and FBA
        $id_lang = null;
        /*
          $id_lang = intval(Tools::getValue('amazon_lang'));

          if ( ! $id_lang )
          {
          die('Missing Parameter: lang') ;
          }
         */

        // Regions
        //
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $marketLang2Region = array_flip($marketPlaceRegion);

        // Identify the marketplace's country
        //
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));

        if (intval(Tools::getValue('europe')))
        {
            $masterMarketplace = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MASTER')));

            if (isset($marketLang2Region[$masterMarketplace]) && $marketLang2Region[$masterMarketplace])
                $id_lang = $marketLang2Region[$masterMarketplace];
            else
                die('The module is not yet configured for Europe');

            $targets_id_lang = array();
            $targets_id_lang[$id_lang] = $id_lang; // at least contains the master marketplace

            foreach ($marketPlaceIds as $marketplace_id_lang => $marketPlaceId)
            {
                if (Amazon_Tools::isEuropeMarketplaceId($marketPlaceId))
                    $targets_id_lang[$marketplace_id_lang] = $marketplace_id_lang;
            }
            $this->europe = 1;
        }
        else
        {
            die('Only Europe is managed at this time');
        }

        //  Check Access Tokens
        //
        $tokens = Tools::getValue('cron_token');

        if (!Amazon_Tools::checkToken($tokens, $id_lang, $this->europe))
        {
            die($this->l('Wrong Token'));
        }

        // Init
        //
        $amazon = Amazon_Tools::selectPlatforms($id_lang, $this->_debug);

        if ($this->_debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        $pass = true;

        if (!($this->_amazonApi = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $this->_debug)))
        {
            AmazonFBAManager::$errors[] = $this->l('Unable to login');
            $pass = false;
        }
        /*
          $SKUs = array('0583215013169', '0074427814427');
          $result = $this->_amazonApi->ListInventoryBySKU($SKUs) ; // By SKU
         */
        if ($pass)
            $result = $this->_amazonApi->ListInventoryByDate(date('Y-m-d', time() - (86400 * $days))); // By Date, 24 hours
        else
            $result = null;

        /*
          $result['nano1'] = array() ;
          $result['nano1']['SKU'] = 'nano1';
          $result['nano1']['InStockSupplyQuantity'] = '1' ;
          $result['nano1']['TotalSupplyQuantity'] = '0';

          'InStockSupplyQuantity' => int 10 : Expédiable
          'TotalSupplyQuantity' => int 17 : Expédiable + En Transit
         */
        if ($pass && $result && is_array($result) && count($result))
        {
            foreach ($result as $SKU => $item)
            {
                $product = new Amazon_Product($SKU, false, $id_lang);

                if (!Validate::isLoadedObject($product))
                {
                    AmazonFBAManager::$errors[] = sprintf('%s - %s(%s)', $this->l('Unable to find product'), $product->name, $SKU);
                    continue;
                }

                if (!($options = Amazon_Product::getProductOptions($product->id, $id_lang)))
                {
                    continue;
                }

                if ($item['InStockSupplyQuantity'] == 0) // Became out of stock
                {
                    // Product is set as FBA
                    //
                    if ($options['fba'] || $forceUpdate)
                    {
                        // Turns Product to MFN for all targets marketplaces 
                        foreach ($targets_id_lang as $marketplace_id_lang)
                            Amazon_Product::updateProductOptions($product->id, $marketplace_id_lang, 'fba', 0);

                        // Log the event 
                        Amazon_Product::marketplaceActionSet(Amazon::Update, $product->id);

                        AmazonFBAManager::$log[] = sprintf('%s(%s) - %s', $product->name, $SKU, $this->l('Product became out of stock, switching to MFN'));
                    }
                }
                else // FBA - In Stock
                {
                    // Product is not set as FBA, but Amazon have it in stock
                    //
                    if ((!$options['fba'] || $forceUpdate) && $options['fba_value'])
                    {
                        // Turns Product to AFN for all targets marketplaces 
                        foreach ($targets_id_lang as $marketplace_id_lang)
                            Amazon_Product::updateProductOptions($product->id, $marketplace_id_lang, 'fba', 1);

                        // Log the event 
                        Amazon_Product::marketplaceActionSet(Amazon::Update, $product->id);

                        AmazonFBAManager::$log[] = sprintf('%s(%s) - %s', $product->name, $SKU, $this->l('Product in stock (FBA), switching to AFN'));
                    }
                    elseif (!$options['fba'] && !$options['fba_value'])
                    {
                        foreach ($targets_id_lang as $marketplace_id_lang)
                            Amazon_Product::updateProductOptions($product->id, $marketplace_id_lang, 'fba', 0);

                        // Log the event 
                        Amazon_Product::marketplaceActionSet(Amazon::Update, $product->id);

                        AmazonFBAManager::$log[] = sprintf('%s(%s) - %s', $product->name, $SKU, $this->l('Product in stock (FBA), but not valued for FBA, switching to MFN'));
                    }
                }
            }
        }

        if (count(AmazonFBAManager::$errors) || count(AmazonFBAManager::$log))
        {
            $mailcontent = array();
            $mailcontent['{events}'] = null;
            $mailsend = false;

            if (AmazonFBAManager::$log)
            {
                $mailcontent['{events}'] = $this->l('Events') . ":<br /><br />\n";
                $mailsend = true;

                foreach (AmazonFBAManager::$log as $log)
                {
                    $mailcontent['{events}'] .= $log . "<br />\n";
                }
            }
            $mailcontent['{errors}'] = null;
            /*
              if ( AmazonFBAManager::$errors )
              {
              $mailcontent['{errors}'] = $this->l('Errors') . ":<br /><br />\n" ;

              foreach(AmazonFBAManager::$errors as $error)
              {
              $mailcontent['{errors}'] .= $error . "<br />\n" ;
              }
              }
             */

            if ($mailsend)
            {
                Mail::Send(
                        $id_lang, // id_lang
                        'fba_stocks', // template
                        $this->l('Amazon FBA: You have new events from your shop'), // subject
                        $mailcontent, // templateVars 
                        Configuration::get('PS_SHOP_EMAIL'), // to
                        null, // To Name
                        null, // From
                        null, // From Name 
                        null, // Attachment
                        null, // SMTP
                        $this->path . 'mail/');
            }
        }
    }

}

$amazonFBAManager = new AmazonFBAManager();
$amazonFBAManager->Dispatch();
?>