<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@smartmarseille.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@smartmarseille.com
 * ...........................................................................
 * @package    Amazon
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2011 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  olivier@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
if (isset($_SERVER['HTTP_HOST']) && $_SERVER['HTTP_HOST'] == 'localhost')
{
    require_once( readlink(dirname($_SERVER['SCRIPT_FILENAME']) . '/../../../config/config.inc.php') );
}
else
{
    @require_once(dirname(__FILE__) . '/../../../config/config.inc.php');
}

require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

require_once(dirname(__FILE__) . '/../amazon.php');

class AmazonConnexionCheck extends Amazon
{
    private $_debug;

    public function l($string, $specific = false, $id_lang = null)
    {
        return( parent::l($string, basename(__FILE__, '.php'), $id_lang) );
    }

    public function Dispatch()
    {
        $debugMode = unserialize(base64_decode(Amazon::configurationGet('AMAZON_DEBUG')));
        $this->_debug = intval($debugMode) ? true : false;

        if (Tools::getValue('debug'))
            $this->_debug = true;

        
        if ($this->_debug)
        {
            @ini_set('display_errors', 'on');
            @define('_PS_DEBUG_SQL_', true);
            @error_reporting(E_ALL | E_STRICT);
        }

        switch (Tools::getValue('action'))
        {
            case 'check' :
                $this->Check();
                break;
            case 'status' :
                $this->Status();
                break;
            case 'participations' :
                $this->Participations();
                break;
        }
    }

    public function Participations()
    {
        $participations = array();
        $status = true;
        $pass = true;
        $errors = null;

        $regions = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));

        $marketplacesIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));

        if (is_array($marketplacesIds) && count($marketplacesIds))
            $current_marketplaces = array_unique(array_flip($marketplacesIds));
        else
            $current_marketplaces = null;

        $merchantIds = Tools::getValue('merchantId');
        $awsKeyIds = Tools::getValue('awsKeyId');
        $awsSecretKeys = Tools::getValue('awsSecretKey');
        $marketPlaceRegions = Tools::getValue('marketPlaceRegion');

        if (!is_array($merchantIds))
        {
            $pass = false;
        }
        else
        {
            $merchantIds = array_unique($merchantIds);

            foreach ($merchantIds as $id_lang => $merchantId)
            {
                if (empty($merchantId))
                    continue;
                if (!isset($actives[$id_lang]) || !$actives[$id_lang])
                    continue;
                if (!isset($marketPlaceRegions[$id_lang]) || empty($marketPlaceRegions[$id_lang]))
                    continue;
                if (!isset($awsKeyIds[$id_lang]) || empty($awsKeyIds[$id_lang]))
                    continue;
                if (!isset($awsSecretKeys[$id_lang]) || empty($awsSecretKeys[$id_lang]))
                    continue;

                $auth = array(
                    'MerchantID' => $merchantId,
                    'AWSAccessKeyID' => trim($awsKeyIds[$id_lang]),
                    'SecretKey' => trim($awsSecretKeys[$id_lang])
                );

                $marketPlace = array();
                $marketPlace['Country'] = $marketPlaceRegions[$id_lang];

                if (!$amazonApi = new Amazon_WebService($auth, $marketPlace, null, $this->_debug))
                {
                    $errors .= sprintf($this->l('Unable to init API for merchant: %s, please check the configuration') . "<br/>\n", $merchantId);
                    continue;
                }
                $result = $amazonApi->ListMarketplaceParticipations(true);

                $participations[$merchantId] = array();

                if (isset($result->ListMarketplaceParticipationsResult->ListParticipations->Participation))
                {
                    foreach ($result->ListMarketplaceParticipationsResult->ListParticipations->Participation as $Participation)
                    {
                        if ((string) $Participation->SellerId != (string) $merchantId)
                            continue;

                        if (!isset($participations[$merchantId][(string) $Participation->MarketplaceId]))
                            $participations[$merchantId][(string) $Participation->MarketplaceId] = array();

                        $l_status = false;

                        if ($current_marketplaces)
                            if (isset($current_marketplaces[(string) $Participation->MarketplaceId]) && $current_marketplaces[(string) $Participation->MarketplaceId] && isset($actives[$current_marketplaces[(string) $Participation->MarketplaceId]]) && $actives[$current_marketplaces[(string) $Participation->MarketplaceId]])
                                $l_status = true;

                        $participations[$merchantId][(string) $Participation->MarketplaceId]['l_status'] = ($l_status ? $this->l('Active') : $this->l('Inactive'));
                        $participations[$merchantId][(string) $Participation->MarketplaceId]['l_image'] = ($l_status ? $this->images . 'status_green.png' : $this->images . 'status_red.png');

                        $participations[$merchantId][(string) $Participation->MarketplaceId]['r_status'] = ($Participation->HasSellerSuspendedListings == 'No' ? $this->l('Valid') : $this->l('Suspended') );
                        $participations[$merchantId][(string) $Participation->MarketplaceId]['r_image'] = ($Participation->HasSellerSuspendedListings == 'No' ? $this->images . 'status_green.png' : $this->images . 'status_red.png' );
                    }

                    foreach ($result->ListMarketplaceParticipationsResult->ListMarketplaces->Marketplace as $Marketplace)
                    {
                        $participations[$merchantId][(string) $Marketplace->MarketplaceId]['name'] = (string) $Marketplace->Name;
                        $participations[$merchantId][(string) $Marketplace->MarketplaceId]['cc'] = (string) $Marketplace->DefaultCountryCode;
                        $participations[$merchantId][(string) $Marketplace->MarketplaceId]['currency'] = (string) $Marketplace->DefaultCurrencyCode;
                        $participations[$merchantId][(string) $Marketplace->MarketplaceId]['domain'] = (string) $Marketplace->DomainName;

                        $currency_state = false;

                        if (($id_currency = Currency::getIdByIsoCode((string) $Marketplace->DefaultCurrencyCode)))
                        {
                            $currency = new Currency($id_currency);

                            if (Validate::isLoadedObject($currency))
                                $currency_state = true;
                            else
                                $currency_state = false;
                        }
                        else
                            $currency_state = false;

                        $participations[$merchantId][(string) $Marketplace->MarketplaceId]['currency_state'] = $currency_state;

                        if (!isset($participations[$merchantId][(string) $Marketplace->MarketplaceId]['l_status']))
                        {
                            $l_status = false;

                            if ($current_marketplaces)
                                if (isset($current_marketplaces[(string) $Marketplace->MarketplaceId]) && $current_marketplaces[(string) $Marketplace->MarketplaceId] && isset($actives[$current_marketplaces[(string) $Marketplace->MarketplaceId]]) && $actives[$current_marketplaces[(string) $Marketplace->MarketplaceId]])
                                    $l_status = true;
                        }

                        if (!isset($participations[$merchantId][(string) $Marketplace->MarketplaceId]['r_status']))
                        {
                            $participations[$merchantId][(string) $Marketplace->MarketplaceId]['l_status'] = ($l_status ? $this->l('Active') : $this->l('Inactive'));
                            $participations[$merchantId][(string) $Marketplace->MarketplaceId]['l_image'] = ($l_status ? $this->images . 'status_green.png' : $this->images . 'status_red.png');

                            $participations[$merchantId][(string) $Marketplace->MarketplaceId]['r_status'] = $this->l('Unknown');
                            $participations[$merchantId][(string) $Marketplace->MarketplaceId]['r_image'] = $this->images . 'status_yellow.png';
                        }
                    }
                }
            }
        }
        if (!count($participations))
            $pass = false;

        $callback = Tools::getValue('callback');

        if ($callback == '?' || empty($callback))
            $callback = 'jsonp_' . time();

        die(strval($callback) . '(' . Amazon_Tools::jsonEncode(array('error' => !$pass, 'errors' => $errors, 'status' => $status, 'participations' => $participations)) . ')');
    }

    public function Status()
    {
        $statuses = array();
        $status = true;
        $pass = true;
        $errors = null;

        $regions = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));

        $merchantIds = Tools::getValue('merchantId');
        $awsKeyIds = Tools::getValue('awsKeyId');
        $awsSecretKeys = Tools::getValue('awsSecretKey');
        $marketPlaceRegions = Tools::getValue('marketPlaceRegion');


        if (!is_array($merchantIds))
        {
            $pass = false;
        }
        else
        {
            $merchantIds = array_unique($merchantIds);

            foreach ($merchantIds as $id_lang => $merchantId)
            {
                if (empty($merchantId))
                    continue;
                if (!isset($actives[$id_lang]) || !$actives[$id_lang])
                    continue;
                if (!isset($marketPlaceRegions[$id_lang]) || empty($marketPlaceRegions[$id_lang]))
                    continue;
                if (!isset($awsKeyIds[$id_lang]) || empty($awsKeyIds[$id_lang]))
                    continue;
                if (!isset($awsSecretKeys[$id_lang]) || empty($awsSecretKeys[$id_lang]))
                    continue;


                $auth = array(
                    'MerchantID' => $merchantId,
                    'AWSAccessKeyID' => trim($awsKeyIds[$id_lang]),
                    'SecretKey' => trim($awsSecretKeys[$id_lang])
                );

                $marketPlace = array();
                $marketPlace['Country'] = $marketPlaceRegions[$id_lang];

                if (!$amazonApi = new Amazon_WebService($auth, $marketPlace, null, $this->_debug))
                {
                    $errors .= sprintf($this->l('Unable to init API for merchant: %s, please check the configuration') . "<br/>\n", $merchantId);
                    continue;
                }
                $request_time = time();
                $result = $amazonApi->ServiceStatus(true);

                $statuses[$merchantId] = array();
                $statuses[$merchantId]['platform'] = 'Amazon ' . strtoupper($marketPlaceRegions[$id_lang]);
                $statuses[$merchantId]['image'] = $this->images . 'status_red.png';

                if (isset($result->GetServiceStatusResult))
                {
                    $statuses[$merchantId]['status'] = isset($result->GetServiceStatusResult->Status) ? (string) $result->GetServiceStatusResult->Status : $this->l('Unknown');
                    $statuses[$merchantId]['datetime'] = date('Y-m-d H:i:s', (int) strtotime($result->GetServiceStatusResult->Timestamp));

                    switch ($statuses[$merchantId]['status'])
                    {
                        case 'GREEN' :
                        case 'GREEN_I' :
                            $statuses[$merchantId]['image'] = $this->images . 'status_green.png';
                            $status = true && $status;
                            break;
                        case 'YELLOW' :
                            $statuses[$merchantId]['image'] = $this->images . 'status_yellow.png';
                            $status = true && $status;
                            break;
                        default :
                            $status = false && $status;
                            break;
                    }

                    if (isset($result->GetServiceStatusResult->Timestamp))
                        $statuses[$merchantId]['drift'] = (int) strtotime($result->GetServiceStatusResult->Timestamp) - $request_time;
                    else
                        $statuses[$merchantId]['drift'] = 0;

                    $statuses[$merchantId]['messages'] = null;

                    if (isset($result->GetServiceStatusResult->Messages))
                    {
                        foreach ($result->GetServiceStatusResult->Messages as $message)
                            $statuses[$merchantId]['messages'] .= (string) $message . "<br />\n";
                    }
                    else
                    {
                        $statuses[$merchantId]['messages'] .= $this->l('Everything is OK, no message has been returned') . "<br />\n";
                    }
                    if ((int) $statuses[$merchantId]['drift'] > 30)
                        $statuses[$merchantId]['messages'] .= sprintf($this->l('There is a time drift of %d seconds. Amazon allows a maximum of 2 minutes. Please consider this point.') . "<br />\n", $statuses[$merchantId]['drift']);
                }
                else
                {
                    $statuses[$merchantId]['status'] = $this->l('Failed');
                    $statuses[$merchantId]['datetime'] = null;
                    $statuses[$merchantId]['drift'] = null;
                    $statuses[$merchantId]['messages'] = $this->l('Unable to connect to');
                }
            }
        }
        $callback = Tools::getValue('callback');

        if ($callback == '?' || empty($callback))
            $callback = 'jsonp_' . time();

        die(strval($callback) . '(' . Amazon_Tools::jsonEncode(array('error' => !$pass, 'errors' => $errors, 'status' => $status, 'statuses' => $statuses)) . ')');
    }

    public function Check()
    {
        ob_start();

        $merchantId = Tools::getValue('merchantId');
        $marketPlaceId = Tools::getValue('marketPlaceId');
        $awsKeyId = Tools::getValue('awsKeyId');
        $awsSecretKey = Tools::getValue('awsSecretKey');
        $marketPlaceRegion = Tools::getValue('marketPlaceRegion');
        $marketPlaceCurrency = Tools::getValue('marketPlaceCurrency');

        if (!isset($merchantId) || empty($merchantId))
            die($this->l('Merchant Id is missing...'));

        if (!isset($marketPlaceId) || empty($marketPlaceId))
            die($this->l('MarketPlace Id Id is missing...'));

        if (!isset($awsKeyId) || empty($awsKeyId))
            die($this->l('AWS KeyId Id is missing...'));

        if (!isset($awsSecretKey) || empty($awsSecretKey))
            die($this->l('AWS Secret Key Id is missing...'));

        if (!isset($marketPlaceRegion) || empty($marketPlaceRegion))
            die($this->l('Market Place Platform is missing...'));

        if (!isset($marketPlaceCurrency) || empty($marketPlaceCurrency))
            die($this->l('Market Place Currency is missing...'));

        $auth = array(
            'MerchantID' => trim($merchantId),
            'MarketplaceID' => trim($marketPlaceId),
            'AWSAccessKeyID' => trim($awsKeyId),
            'SecretKey' => trim($awsSecretKey)
        );

        $marketPlace = array();
        $marketPlace['Currency'] = $marketPlaceCurrency;
        $marketPlace['Country'] = $marketPlaceRegion;

        if (!$amazonApi = new Amazon_WebService($auth, $marketPlace, null, $this->_debug))
            die($this->l('Unable to login'));

        $debug = ob_get_clean();

        $result = $amazonApi->ListMarketplaceParticipations();

        if ($this->_debug)
        {
            echo nl2br(print_r($debug, true));
            echo nl2br(print_r($result, true));
        }
        if ( isset($result->ListMarketplaceParticipationsResult->ListParticipations) )
            die('<span style="color:green;font-weight:bold;">' . $this->l('Connection to Amazon : Ok') . '</span>');
        elseif (is_object($result) && isset($result->Error))
            die($this->l('Warning: Connection to Amazon Failed !') . nl2br("\n" . print_r($result->Error, true)));
        else
            die($this->l('Warning: Connection to Amazon Failed !') . nl2br("\n" . print_r($result, true)));
    }

}

$pmConnexionCheck = new AmazonConnexionCheck();
$pmConnexionCheck->Dispatch();
?>