<?php
/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

require_once(dirname(__FILE__) . '/../../amazon.php');
require_once(dirname(__FILE__) . '/../../classes/amazon.tools.class.php');


class AdminAmazonOrdersController extends ModuleAdminController 
{
        public $module = 'amazon' ;
        public $name = 'amazon' ;
        
	public function __construct()
	{
            $this->path = _PS_MODULE_DIR_ . $this->module . '/' ;

            $this->className = 'amazon';
            $this->display = 'edit' ;
            
            $this->multishop_context = Shop::CONTEXT_ALL ;
            $this->id_lang = (int)Context::getContext()->language->id ;
            
            $this->lang = true;
            $this->deleted = false;
            $this->colorOnBackground = false;

            $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/' ;
            $this->images =  $this->url . 'images/' ;
        
            $this->context = Context::getContext();
            $this->bootstrap = true;

            parent::__construct();
            
            if (version_compare(_PS_VERSION_, '1.6', '>='))
                $this->psIs16x = true;
            else
                $this->psIs16x = false;
	}
	
	public function renderForm()
	{
                $html   = null ;
                $html  .=  $this->tabHeader() ;
                $html  .= $this->languageSelector() ;
                
                if ($this->psIs16x)
                    $this->addCSS($this->url.'css/OrdersAmazon16.css', 'screen');
                else
                    $this->addCSS($this->url.'css/OrdersAmazon.css', 'screen');
                
                $this->addJS($this->url . 'js/orders.js') ;

                $this->context->smarty->assign('path', $this->url) ;
                $this->context->smarty->assign('images', $this->images) ;
                $this->context->smarty->assign('selected_tab', 'import') ;
                $this->context->smarty->assign('psIs16', $this->psIs16x) ;
                
                $html  .= $this->context->smarty->fetch($this->path . 'views/AdminOrdersAmazon.tpl');
                
		return $html . $this->content . parent::renderForm();
	}
	
        public function tabHeader() 
        {
            $this->context->smarty->assign('images', $this->images) ;
            
            $amazonTokens = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CRON_TOKEN')));
            
            $tokenOrders = Tools::getAdminToken('AdminOrders' . (int) Tab::getIdFromClassName('AdminOrders') . (int) $this->context->employee->id);
            
            $day            = 86400;
            $days           = 7;
            $startDate      = date('Y-m-d', time() - ($day * $days));
            $currentDate    = date('Y-m-d');
            
            $this->addJqueryUI('ui.datepicker');
            
            $this->context->smarty->assign('tokens', $amazonTokens) ;    
            $this->context->smarty->assign('token_order', $tokenOrders) ;    
            $this->context->smarty->assign('orders_url', $this->url . 'functions/orders.php') ;    
            $this->context->smarty->assign('import_url', $this->url . 'functions/import.php') ;    
            $this->context->smarty->assign('img_loader', $this->images . 'loading.gif') ;    
            $this->context->smarty->assign('img_loader_small', $this->images . 'small-loader.gif') ;    
            $this->context->smarty->assign('current_date', $currentDate) ;    
            $this->context->smarty->assign('start_date', $startDate) ;
            $this->context->smarty->assign('psIs16', $this->psIs16x) ;
            
            $this->context->smarty->assign('id_lang', $this->id_lang) ;    
            
            $documentation = Amazon_Tools::documentation($this->id_lang) ;
            $faq = Amazon_Tools::documentation($this->id_lang, 'faq') ;
            
            $this->context->smarty->assign('documentation', $documentation) ;
            $this->context->smarty->assign('faq', $faq) ;            
            
            return( $this->context->smarty->fetch( $this->path . 'views/items/orders_header.tpl') ) ;
        }
        public function languageSelector()
        {
            $html = null ;

            $europe  = unserialize(base64_decode(Amazon::configurationGet('AMAZON_EUROPE')));
            $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));
            $regions = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
            $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));
            
            $this->addCSS($this->url.'/css/country_selector.css', 'screen');
            
            
            $marketplaces = array() ;

            if ( $europe )
            {
                $marketplacesEuro = array() ;
                $marketplacesNotEuro = array() ;
                
                if ( is_array($actives) )
                    foreach (Amazon_Tools::languages() as $language)
                    {
                        $id_lang = $language['id_lang'];

                        if ( ! isset($actives[$id_lang]) || ! $actives[$id_lang] )          continue ;

                        if ( ! isset($regions[$id_lang]) || empty($regions[$id_lang]) )     continue ;

                        if ( ! isset($marketPlaceIds[$id_lang]) ) continue ;
                        
                        if ( Amazon_Tools::isEuropeMarketplaceId($marketPlaceIds[$id_lang]) && Amazon_Tools::isEuroMarketplaceId($marketPlaceIds[$id_lang]) )
                        {
                            // Euro Zone Area
                            //
                            $marketplacesEuro[$id_lang] = array() ;
                            $marketplacesEuro[$id_lang]['name'] = sprintf('www.amazon.%s', Amazon_Tools::idToDomain($id_lang)) ;
                            $marketplacesEuro[$id_lang]['region'] = $regions[$id_lang] ;
                            $marketplacesEuro[$id_lang]['id_lang'] = $id_lang ;
                            $marketplacesEuro[$id_lang]['lang'] = $language['iso_code'] ;
                            $marketplacesEuro[$id_lang]['image'] = $this->images . 'geo_flags_web2/flag_' . $regions[$id_lang] . '_64px.png' ;
                        }   
                        else
                        {
                            // Outside Euro Zone Area
                            //
                            $marketplacesNotEuro[$id_lang] = array() ;
                            $marketplacesNotEuro[$id_lang]['name'] = sprintf('www.amazon.%s', Amazon_Tools::idToDomain($id_lang)) ;
                            $marketplacesNotEuro[$id_lang]['region'] = $regions[$id_lang] ;
                            $marketplacesNotEuro[$id_lang]['id_lang'] = $id_lang ;
                            $marketplacesNotEuro[$id_lang]['lang'] = $language['iso_code'] ;
                            $marketplacesNotEuro[$id_lang]['image'] = $this->images . 'geo_flags_web2/flag_' . $regions[$id_lang] . '_64px.png' ;                            
                        }
                    }
                    
                    if ( count($marketplacesEuro) )
                        $europeEuroArea = true  ;
                    else
                        $europeEuroArea = false  ;

                    if ( count($marketplacesNotEuro) )
                        $europeNotEuroArea = true  ;
                    else
                        $europeNotEuroArea = false  ;                    
                    
                    $this->context->smarty->assign('images', $this->images) ;
                    $this->context->smarty->assign('europeEuroArea', $europeEuroArea) ;
                    $this->context->smarty->assign('europeNotEuroArea', $europeNotEuroArea) ;
                    $this->context->smarty->assign('europe_flag', $this->images . 'geo_flags_web2/flag_eu_64px.png') ;
                    $this->context->smarty->assign('marketplacesEuro', $marketplacesEuro) ;
                    $this->context->smarty->assign('marketplacesNotEuro', $marketplacesNotEuro) ;

                    return( $this->context->smarty->fetch( $this->path . 'views/items/europe_selector.tpl') ) ;                
            }
            else
            {
                if ( is_array($actives) )
                    foreach (Amazon_Tools::languages() as $language)
                    {
                        $id_lang = $language['id_lang'];

                        if ( ! isset($actives[$id_lang]) || ! $actives[$id_lang] )          continue ;

                        if ( ! isset($regions[$id_lang]) || empty($regions[$id_lang]) )     continue ;

                        $marketplaces[$id_lang] = array() ;
                        $marketplaces[$id_lang]['name'] = sprintf('www.amazon.%s', Amazon_Tools::idToDomain($id_lang)) ;
                        $marketplaces[$id_lang]['region'] = $regions[$id_lang] ;
                        $marketplaces[$id_lang]['id_lang'] = $id_lang ;
                        $marketplaces[$id_lang]['lang'] = $language['iso_code'] ;
                        $marketplaces[$id_lang]['image'] = $this->images . 'geo_flags_web2/flag_' . $regions[$id_lang] . '_64px.png' ;
                    }
                    $this->context->smarty->assign('images', $this->images) ;
                    $this->context->smarty->assign('marketplaces', $marketplaces) ;
                    $this->context->smarty->assign('psIs16', $this->psIs16x);
                    
                    return( $this->context->smarty->fetch( $this->path . 'views/items/country_selector.tpl') ) ;
            }
        }

}