<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

class Amazon_Tools extends Tools
{
    //  Check Access Tokens
    //
    static public function checkToken($tokens)
    {
        $pass = true ;
        $amazonTokens = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CRON_TOKEN')));

        if ( ! $tokens )
            return(false) ;
        
        if ( ! is_array($tokens) )
            $tokens = array($tokens) ;
        
        foreach($tokens as $token)
            $pass = in_array($token, $amazonTokens) && $pass ;   
     
        return( $pass );
    }
    
    static function selectEuropeanPlatforms($debug = false)
    {
        $id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT') ;
        $id_lang_prefered = null ;
        $id_lang_selected = null ;
        
        $marketPlaceMaster = unserialize(base64_decode(Configuration::get('AMAZON_MASTER')));
        $marketPlaceRegion = unserialize(base64_decode(Configuration::get('AMAZON_REGION')));

        // Amazon API keypairs
        //
        $merchantIds = unserialize(base64_decode(Configuration::get('AMAZON_MERCHANT_ID')));
        $marketPlaceIds = unserialize(base64_decode(Configuration::get('AMAZON_MARKETPLACE_ID')));
        $awsKeyIds = unserialize(base64_decode(Configuration::get('AMAZON_AWS_KEY_ID')));
        $awsSecretKeys = unserialize(base64_decode(Configuration::get('AMAZON_SECRET_KEY')));
        
        if ( is_array($marketPlaceRegion) )
            $marketPlaceRegion2Lang = array_flip($marketPlaceRegion);
        
        $id_lang_master = isset($marketPlaceRegion2Lang[$marketPlaceMaster]) ? $marketPlaceRegion2Lang[$marketPlaceMaster] : null ;
        $platforms = array() ;
        
        foreach($marketPlaceRegion as $marketplace_id_lang => $iso_code)
        {
            if ( ! isset($marketPlaceIds[$marketplace_id_lang]) || empty($marketPlaceIds[$marketplace_id_lang]) )
                continue ;
            if ( ! isset($marketPlaceRegion[$marketplace_id_lang]) || empty($marketPlaceRegion[$marketplace_id_lang]) )
                continue ;
            if ( ! self::isEuroMarketplaceId($marketPlaceIds[$marketplace_id_lang]) )
                continue ;
            
            $platforms[] = trim($marketPlaceIds[$marketplace_id_lang]) ;
            
            if ( $id_lang_master == $marketplace_id_lang && ! $id_lang_prefered )
                $id_lang_prefered = $marketplace_id_lang ;
            elseif ( $id_lang_default == $marketplace_id_lang && ! $id_lang_prefered  )
                $id_lang_prefered = $marketplace_id_lang ;
        }
        
        // Use first available marketplace in Europe except UK
        if ( ! $id_lang_prefered )
        {
           foreach($marketPlaceRegion as $marketplace_id_lang => $iso_code) 
               if ( self::isEuroMarketplaceId($marketPlaceIds[$marketplace_id_lang]) )
                      $id_lang_prefered = $marketplace_id_lang ;
        }
        
        if ( $id_lang_prefered )
            $id_lang_selected = $id_lang_prefered ;
        elseif ( $id_lang_default && $id_lang_default != $id_lang_master )
            $id_lang_selected = $id_lang_default ;
        elseif ( $id_lang_master && $id_lang_master != 'uk' )
            $id_lang_selected = $id_lang_master ;

        if ( ! $id_lang_selected )
        {
           printf('%s(#%d): authArray: %s' . Amazon::LF, basename(__FILE__), __LINE__, 'Unable to select a valid id_lang') ; 
           return(null) ;
        }
        
        // Force to use the ID of master marketplace 
        if ( $id_lang_master )
           $id_lang_main = $id_lang_master ;
        else
           $id_lang_main = $id_lang_selected ;
        
        $auth = self::authArray($merchantIds[$id_lang_main], $marketPlaceIds[$id_lang_selected], $awsKeyIds[$id_lang_main], $awsSecretKeys[$id_lang_main], $debug) ;

        if ( is_array($platforms) && count($platforms) )
            foreach($platforms as $key => $platform)
                if ( $marketPlaceIds[$id_lang_selected] == $platform )
                    unset($platforms[$key]) ;
                
        $amzCurrency = array();
        $amzCurrency['Currency'] = 'EUR' ;
        $amzCurrency['Country'] = $marketPlaceRegion[$id_lang_selected];                    
        
        return( array('params'    => $amzCurrency, 'auth'      => $auth, 'platforms' => $platforms) );
    }
    
    // Select platform or select platforms for Europe
    //
    static function selectPlatforms($id_lang, $debug = false)
    {
        $marketPlaceId = null;

        // Amazon Europe overidding
        //
        $amazonEurope = unserialize(base64_decode(Configuration::get('AMAZON_EUROPE')));
        $marketPlaceMaster = unserialize(base64_decode(Configuration::get('AMAZON_MASTER')));
        $marketPlaceRegion = unserialize(base64_decode(Configuration::get('AMAZON_REGION')));

        // Amazon API keypairs
        //
        $merchantIds = unserialize(base64_decode(Configuration::get('AMAZON_MERCHANT_ID')));
        $marketPlaceIds = unserialize(base64_decode(Configuration::get('AMAZON_MARKETPLACE_ID')));
        $awsKeyIds = unserialize(base64_decode(Configuration::get('AMAZON_AWS_KEY_ID')));
        $awsSecretKeys = unserialize(base64_decode(Configuration::get('AMAZON_SECRET_KEY')));

        // Currencies
        //
        $currencies = unserialize(base64_decode(Configuration::get('AMAZON_CURRENCY')));


        // Platform list
        $platforms = array();

        // Amazon Marketplace Europe values
        //
        $europeanPlatforms = array('A13V1IB3VIYZZH', 'A1RKKUPIHCS9HS', 'A1PA6795UKMFR9', 'APJ6JRA9NG5V4', 'A1F83G8C2ARO7P');

        if ( is_array($marketPlaceRegion) )
            $marketPlaceRegion2Lang = array_flip($marketPlaceRegion);
        
        $marketPlaceMasterLangId = false;

        if (isset($marketPlaceRegion2Lang[$marketPlaceMaster]))
            $marketPlaceMasterLangId = $marketPlaceRegion2Lang[$marketPlaceMaster];

        if ($marketPlaceMasterLangId && $amazonEurope && in_array($marketPlaceIds[$id_lang], $europeanPlatforms))
        {
            // auth
            $merchantId = trim($merchantIds[$marketPlaceMasterLangId]);
            $awsKeyId = trim($awsKeyIds[$marketPlaceMasterLangId]);
            $awsSecretKey = trim($awsSecretKeys[$marketPlaceMasterLangId]);

            foreach ($marketPlaceIds as $amazon_lang => $currentMarketPlaceId)
            {
                if ($amazon_lang == $id_lang)
                    $selected = $id_lang;
                else
                    $selected = '';

                if (!in_array($currentMarketPlaceId, $europeanPlatforms))
                    continue;

                // UK Exception
                if ($currentMarketPlaceId != 'A1F83G8C2ARO7P')
                    $platforms[] = $currentMarketPlaceId;

                if (isset($selected) && $selected == $id_lang)
                    $marketPlaceId = trim($marketPlaceIds[$id_lang]);
            }

            // UK Exception
            if ($marketPlaceId == 'A1F83G8C2ARO7P')
                $platforms = array();

            // Clear Duplicates
            if ($platforms)
            {
                foreach ($platforms as $idx => $platform)
                    if ($platform == $marketPlaceId)
                        unset($platforms[$idx]);
                $platforms = array_values($platforms);
            }

            // Return values
            $amzCurrency = array();
            $amzCurrency['Currency'] = $currencies[$id_lang];
            $amzCurrency['Country'] = $marketPlaceRegion[$id_lang];

            $auth = self::authArray($merchantId, $marketPlaceId, $awsKeyId, $awsSecretKey, $debug) ;
        }
        else
        {
            if (!isset($merchantIds[$id_lang]) || !isset($marketPlaceIds[$id_lang]) || !isset($awsKeyIds[$id_lang]) || !isset($awsSecretKeys[$id_lang]))
                return(false);

            $auth = self::authArray($merchantIds[$id_lang], $marketPlaceIds[$id_lang], $awsKeyIds[$id_lang], $awsSecretKeys[$id_lang]) ;

            $platforms = array();

            $amzCurrency = array();
            $amzCurrency['Currency'] = $currencies[$id_lang];
            $amzCurrency['Country'] = $marketPlaceRegion[$id_lang];
        }
        if (isset($debug) && $debug)
        {
            echo nl2br(print_r($auth, true));
            echo nl2br(print_r($platforms, true));
            echo nl2br(print_r($amzCurrency, true));
        }
        return( array('params'    => $amzCurrency, 'auth'      => $auth, 'platforms' => $platforms) );
    }

    // Select only 1 platform
    //
    static function selectPlatform($id_lang, $debug = false)
    {
        // Amazon Europe overidding
        //
        $amazonEurope = unserialize(base64_decode(Configuration::get('AMAZON_EUROPE')));
        $marketPlaceMaster = unserialize(base64_decode(Configuration::get('AMAZON_MASTER')));
        $marketPlaceRegion = unserialize(base64_decode(Configuration::get('AMAZON_REGION')));

        // Amazon API keypairs
        //
        $merchantIds = unserialize(base64_decode(Configuration::get('AMAZON_MERCHANT_ID')));
        $marketPlaceIds = unserialize(base64_decode(Configuration::get('AMAZON_MARKETPLACE_ID')));
        $awsKeyIds = unserialize(base64_decode(Configuration::get('AMAZON_AWS_KEY_ID')));
        $awsSecretKeys = unserialize(base64_decode(Configuration::get('AMAZON_SECRET_KEY')));

        if (!isset($marketPlaceIds[$id_lang]))
            return(false);

        // Currencies
        //
        $currencies = unserialize(base64_decode(Configuration::get('AMAZON_CURRENCY')));


        // Platform list
        $platforms = array();

        // Amazon Marketplace Europe values
        //
        $europeanPlatforms = array('A13V1IB3VIYZZH', 'A1RKKUPIHCS9HS', 'A1PA6795UKMFR9', 'APJ6JRA9NG5V4', 'A1F83G8C2ARO7P');

        $marketPlaceRegion2Lang = array_flip($marketPlaceRegion);
        if (isset($marketPlaceRegion2Lang[$marketPlaceMaster]))
            $marketPlaceMasterLangId = $marketPlaceRegion2Lang[$marketPlaceMaster];
        else
            $marketPlaceMasterLangId = null;

        if ($amazonEurope && in_array($marketPlaceIds[$id_lang], $europeanPlatforms))
        {
            // auth
            $merchantId = trim($merchantIds[$marketPlaceMasterLangId]);
            $awsKeyId = trim($awsKeyIds[$marketPlaceMasterLangId]);
            $awsSecretKey = trim($awsSecretKeys[$marketPlaceMasterLangId]);

            foreach ($marketPlaceIds as $amazon_lang => $currentMarketPlaceId)
            {
                if ($amazon_lang == $id_lang)
                    $selected = $id_lang;
                else
                    $selected = '';

                if (!in_array($currentMarketPlaceId, $europeanPlatforms))
                    continue;

                if (isset($selected) && $selected == $id_lang)
                {
                    $marketPlaceId = trim($marketPlaceIds[$id_lang]);
                    break;
                }
            }


            // Return values
            $amzCurrency = array();
            $amzCurrency['Currency'] = $currencies[$id_lang];
            $amzCurrency['Country'] = $marketPlaceRegion[$id_lang];

            $auth = self::authArray($merchantId, $marketPlaceId, $awsKeyId, $awsSecretKey, $debug) ;
        }
        else
        {
            $auth = self::authArray($merchantIds[$id_lang], $marketPlaceIds[$id_lang], $awsKeyIds[$id_lang], $awsSecretKeys[$id_lang], $debug) ;
            
            $platforms = array();

            $amzCurrency = array();
            $amzCurrency['Currency'] = $currencies[$id_lang];
            $amzCurrency['Country'] = $marketPlaceRegion[$id_lang];
        }
        if (isset($debug) && $debug)
        {
            echo nl2br(print_r($auth, true));
            echo nl2br(print_r($platforms, true));
            echo nl2br(print_r($amzCurrency, true));
        }
        return( array('params'    => $amzCurrency, 'auth'      => $auth, 'platforms' => $platforms) );
    }

    static function authArray($merchantId, $marketPlaceId, $awsKeyId, $awsSecretKey, $debug = false)
    {
        if ( empty($merchantId) || empty($marketPlaceId) || empty($awsKeyId) || empty($awsSecretKey) )
        {
           if ( $debug)
            printf('%s(#%d): %s from %s' . Amazon::LF, basename(__FILE__), __LINE__, 'Empty parameter', self::CallingFunction()) ; 
           return(null) ;
        }
        $auth = array(
            'MerchantID'     => trim($merchantId),
            'MarketplaceID'  => trim($marketPlaceId),
            'AWSAccessKeyID' => trim($awsKeyId),
            'SecretKey'      => trim($awsSecretKey)
                );     
        
        if ( $debug )
        {
            printf('%s(#%d): Auth Array: %s' . Amazon::LF, basename(__FILE__), __LINE__, nl2br(print_r($auth, true))) ;
        }
        return($auth) ;
    }
    
    static public function hfilter($str)
    {
        $str = htmlspecialchars(strip_tags($str));
        $str = preg_replace("/\\n/i", '<br>', $str);
        $str = preg_replace("/\\r/i", '<br>', $str);
        return($str);
    }

    static public function PriceRule($price, $rule)
    {
        // Integrity check
        if ( ! isset($rule['rule']) || ! isset($rule['rule']['from']) || ! isset($rule['rule']['to']) )
            return((float)$price) ;
        
         if ( ! is_array($rule['rule']) || ! is_array($rule['rule']['from']) || ! is_array($rule['rule']['to']) )
            return((float)$price) ;
         
         if ( $rule['type'] == 'percent' && ! (isset($rule['rule']['percent']) || ! is_array($rule['rule']['percent']) || ! max($rule['rule']['percent'])) )
             return((float)$price) ;
         if ( $rule['type'] == 'value' && ! (isset($rule['rule']['value']) || ! is_array($rule['rule']['value']) || ! max($rule['rule']['value'])) )
             return((float)$price) ;

        $index = null ;

        if ( is_array($rule['rule']['to']) && is_array($rule['rule']['from']) && count($rule['rule']['to']) && count($rule['rule']['from']) )
        {
            end($rule['rule']['to']) ; 
            $max_key = key($rule['rule']['to']) ; 
            reset($rule['rule']['to']) ;
            
            foreach($rule['rule']['from'] as $key => $val1)
            {
                if ( empty($rule['rule']['to'][$max_key]) )
                    $rule['rule']['to'][$max_key] = $price ;
            
                if ( (int)$price >= (int)$val1 && (int)$price <= (int)$rule['rule']['to'][$key] )
                    $index=$key ;         
            }
        }    
        if ( $index === null )
            return((float)$price) ;
        
        if ( $rule['type'] == 'value' )
        {    
            $price += (float)$rule['rule']['value'][$index] ;
        }    
        elseif ( $rule['type'] == 'percent' )
        {
            $price += $price * ((float)$rule['rule']['percent'][$index] / 100);
        }
        return((float)$price) ;
    }
    
    static public function Formula($price, $formula)
    {
        if ( empty($price) )
            return($price) ;
        if ( strpos($formula, '@') === false )
            return($price) ;
        
        $formula = trim(str_replace(',', '.', $formula));
        $formula = preg_replace("/\\n/i", '', $formula);
        $formula = preg_replace("/\\r/i", '', $formula);

        if (preg_match('#([0-9\., ]*)%#', $formula, $result))
        {
            $toPercent = $price * (floatval($result[1]) / 100);
            $formula = preg_replace('#([0-9\., ]*)%#', $toPercent, $formula);
        }
        $formula = str_replace('%', '', $formula);
        $equation = str_replace('@', $price ? $price : 0, $formula);

        $result = self::_matheval($equation);
       
        return($result);
    }

    static public function CallBack($price, $callback)
    {
        $callback = preg_replace("/\\n/i", '', $callback);
        $callback = preg_replace("/\\r/i", '', $callback);

        $code = str_replace('@', $price ? $price : 0, $callback);

        return( eval("return $code;") );
    }

    static public function idToDomain($id_lang)
    {
        $marketPlaceRegion = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));

        if (!isset($marketPlaceRegion[$id_lang]))
            return(false);

        switch ($marketPlaceRegion[$id_lang])
        {
            case 'uk' :
                return('co.uk');
            case 'us' :
                return('com');
            default:
                return($marketPlaceRegion[$id_lang]);
        }
    }

    static public function SellerCentralURL($id_lang, $orderID)
    {
        if (!($tld = self::idToDomain($id_lang)))
            return(false);

        return('https://sellercentral.amazon.' . $tld . '/gp/orders-v2/details?ie=UTF8&orderID=' . $orderID);
    }

    static public function goToProductPage($id_lang, $asin)
    {
        if (!($tld = self::idToDomain($id_lang)))
            return(false);

        return('http://www.amazon.' . $tld . '/gp/product/' . $asin);
    }

     static public function goToSellerReviewPage($id_lang)
    {
        if (!($tld = self::idToDomain($id_lang)))
            return(false);

        return('https://www.amazon.' . $tld . '/gp/feedback/');
    }   
    
    static public function classifierURL($id_lang)
    {
        return('https://catalog-mapper-eu.amazon.com/catm/classifier/ProductClassifier.amzn');
    }

    // Return availables languages
    //
    public static function languages()
    {
        static $languages = null ;
        static $available_languages = array();
        
        if ( $available_languages )
                return($available_languages) ;
        
        if ( ! $languages )
               $languages = Language::getLanguages();

        foreach ($languages as $language)
        {
            // For active languages
            //
          if ($language['active'] === false)
                continue;

            // Allow only available platforms
            //
          switch ($language['iso_code'])
            {
                case 'fr' :
                case 'de' :
                case 'us' :
                case 'en' :
                case 'gb' :
                case 'it' :
                case 'in' :
                case 'es' :
                case 'ca' :
                case 'ja' :
                case 'be' :
                case 'cn' :
                    $pass = true;
                    break;
                default :
                    $pass = false;
                    continue;
            }
            if (!$pass)
                continue;

            $available_languages[ $language['id_lang'] ] = $language;
        }
        return($available_languages);
    }

    static public function isEurope($iso_code)
    {
        switch ($iso_code)
        {
            case 'fr' :
            case 'de' :
            case 'be' :
            case 'it' :
            case 'es' :
                return(true);
            default :
                return(false);
        }
    }
    
    static public function isUSMarketplaceId($marketplaceID)
    {
        return( trim($marketplaceID) == 'ATVPDKIKX0DER' ) ;
    }
    static public function isINMarketplaceId($marketplaceID)
    {
        return( trim($marketplaceID) == 'A21TJRUUN4KGV' ) ;
    }
    
    static public function isUnifiedAccount($iso_code)
    {
        switch ($iso_code)
        {
            case 'fr' :
            case 'uk' :
            case 'de' :
            case 'it' :
            case 'es' :
                return(true);
            default :
                return(false);
        }
    }
    
    static public function isEuropeMarketplaceId($marketplaceID)
    {
        return( in_array($marketplaceID, array('A13V1IB3VIYZZH', 'A1RKKUPIHCS9HS', 'A1PA6795UKMFR9', 'APJ6JRA9NG5V4', 'A1F83G8C2ARO7P')) );
    }
    
    static public function isEuroMarketplaceId($marketplaceID)
    {
        return( in_array($marketplaceID, array('A13V1IB3VIYZZH', 'A1RKKUPIHCS9HS', 'A1PA6795UKMFR9', 'APJ6JRA9NG5V4')) );
    }
    
    static public function lang2MarketplaceId($lang)
    {
        switch($lang)
        {
                case 'en' : // 
                case 'us' : // US
                    return('ATVPDKIKX0DER') ;
                case 'fr' : // France
                    return('A13V1IB3VIYZZH') ;
                case 'es' : // Spain
                    return('A1RKKUPIHCS9HS') ;
                case 'de' : // Germany
                    return('A1PA6795UKMFR9') ;
                case 'it' : // Italy
                    return('APJ6JRA9NG5V4') ;
                case 'uk' : // UK
                case 'gb' : // UK
                    return('A1F83G8C2ARO7P') ;
                case 'jp' : // Japan
                    return('A1VC38T7YXB528') ;
                case 'in' : // India
                    return('A21TJRUUN4KGV') ;
                case 'ca' : // Canada
                    return('A2EUQ1WTGCTBG2') ;
        }
        return(null) ;
    }
    static public function marketplaceIdToFullfillmentCenterId($marketplaceID)
    {
        switch ($marketplaceID)
        {
            case 'A13V1IB3VIYZZH' :
            case 'A1RKKUPIHCS9HS' :
            case 'A1PA6795UKMFR9' :
            case 'APJ6JRA9NG5V4' :
            case 'A1F83G8C2ARO7P' : // Europe
                $fullfillmentCenterId = 'AMAZON_EU';
                break;
            case 'ATVPDKIKX0DER' : // US
                $fullfillmentCenterId = 'AMAZON_NA';
                break;
            case 'A2EUQ1WTGCTBG2' : // Canada
                $fullfillmentCenterId = '?';
                break;
            case 'A1VC38T7YXB528' : // Japan
                $fullfillmentCenterId = 'AMAZON_JP';
                break;
            case 'A21TJRUUN4KGV' : // India
                $fullfillmentCenterId = 'AMAZON_IN'; // to be verified
                break;                
            default :
                $fullfillmentCenterId = '?';
                break;
        }
        return($fullfillmentCenterId);
    }

    static public function toCurrency($price, $to_currency = NULL)
    {
        //$currency = Currency::getCurrent();

        $c_rate = (is_array($to_currency) ? $to_currency['conversion_rate'] : $to_currency->conversion_rate);

        if ($to_currency)
            $price /= $c_rate;

        return $price;
    }

    static public function fromCurrency($price, $from_currency = NULL)
    {
        //$currency = Currency::getCurrent();

        $c_rate = (is_array($from_currency) ? $from_currency['conversion_rate'] : $to_currency->conversion_rate);

        if ($from_currency)
            $price *= $c_rate;

        return $price;
    }

    // Shipping Rates
    //
    static public function getShippingRate($price, $rules)
    {
        $table = preg_split("/[;,]/", rtrim(str_replace(' ', '', $rules), ';'));
        $rate = $table[count($table) - 1]; // max as default

        for ($i = 0; $i < sizeof($table); $i+=2)
        {
            if (floatval($price) < floatval($table[$i]))
            {
                $rate = $table[$i + 1];
                break;
                ;
            }
        }
        return($rate);
    }

    static public function strip_html($html)
    {
        $text = strip_tags($html, '<br>');
        $text = preg_replace('#<br\s{0,}/{0,}>#i', "\n", $text); // br to newline
        $text = preg_replace('#[\n]+#i', "\n", $text); // multiple-return
        $text = preg_replace('#^[\n\r\s]+#i', "", $text); // trim
        $text = str_replace("\n", "<br />\n", $text); // newline to br        
        return(trim($text));
    }

//
// Code pomp� et adapt� du core prestashop
//

    /**
     * Build a categories tree
     *
     * @param array $indexedCategories Array with categories where product is indexed (in order to check checkbox)
     * @param array $categories Categories to list
     * @param array $current Current category
     * @param integer $id_category Current category id
     */
    static public function recurseCategoryForInclude($indexedCategories, $categories, $current, $id_category = 1, $id_category_default = NULL, $default_categories = array())
    {
        global $done;
        static $irow;
        global $html;
        $html = isset($html) ? $html : null;

        $images = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/amazon/images/';

        if (is_array($default_categories) && in_array($id_category, $default_categories))
            $checked = ' checked="checked"';
        else
            $checked = '';

        if (!isset($done[$current['infos']['id_parent']]))
            $done[$current['infos']['id_parent']] = 0;
        $done[$current['infos']['id_parent']] += 1;

        $todo = sizeof($categories[$current['infos']['id_parent']]);
        $doneC = $done[$current['infos']['id_parent']];

        $level = $current['infos']['level_depth'] + 1;
        $img = $level == 1 ? 'lv1.gif' : 'lv' . $level . '_' . ($todo == $doneC ? 'f' : 'b') . '.gif';

        $html .= '
		<tr class="' . ($irow++ % 2 ? 'alt_row' : '') . '">
			<td>
				<input type="checkbox" name="categoryBox[]" class="categoryBox' . ($id_category_default == $id_category ? ' id_category_default' : '') . '" id="categoryBox_' . $id_category . '" value="' . $id_category . '"' . $checked . ' />
			</td>
			<td>
				' . $id_category . '
			</td>
			<td>
				<img src="' . $images . $img . '" alt="" /> &nbsp;<label for="categoryBox_' . $id_category . '" class="t">' . stripslashes($current['infos']['name']) . '</label>
			</td>
		</tr>';

        if (isset($categories[$id_category]))
            foreach ($categories[$id_category] AS $key => $row)
                if ($key != 'infos')
                    Amazon_Tools::recurseCategoryForInclude($indexedCategories, $categories, $categories[$id_category][$key], $key, $id_category_default, $default_categories);

        return($html);
    }

    ///// http://stackoverflow.com/questions/6054033/pretty-printing-json-with-php
    static function jsonPrettyPrint($json)
    {
        $result = '';
        $level = 0;
        $prev_char = '';
        $in_quotes = false;
        $ends_line_level = NULL;
        $json_length = strlen($json);

        for ($i = 0; $i < $json_length; $i++)
        {
            $char = $json[$i];
            $new_line_level = NULL;
            $post = "";
            if ($ends_line_level !== NULL)
            {
                $new_line_level = $ends_line_level;
                $ends_line_level = NULL;
            }
            if ($char === '"' && $prev_char != '\\')
            {
                $in_quotes = !$in_quotes;
            }
            else if (!$in_quotes)
            {
                switch ($char)
                {
                    case '}': case ']':
                        $level--;
                        $ends_line_level = NULL;
                        $new_line_level = $level;
                        break;

                    case '{': case '[':
                        $level++;
                    case ',':
                        $ends_line_level = $level;
                        break;

                    case ':':
                        $post = " ";
                        break;

                    case " ": case "\t": case "\n": case "\r":
                        $char = "";
                        $ends_line_level = $new_line_level;
                        $new_line_level = NULL;
                        break;
                }
            }
            if ($new_line_level !== NULL)
            {
                $result .= "\n" . str_repeat("\t", $new_line_level);
            }
            $result .= $char . $post;
            $prev_char = $char;
        }

        return $result;
    }
    
    /**
     * jsonDecode convert json string to php array / object
     *
     * @param string $json
     * @param boolean $assoc  (since 1.4.2.4) if true, convert to associativ array
     * @return array
     */
    public static function jsonDecode($json, $assoc = false)
    {
        if (function_exists('json_decode'))
            return json_decode($json, $assoc);
        else
        {
            include_once(dirname(__FILE__) . '/json/json.php');
            $pearJson = new Services_JSON(($assoc) ? SERVICES_JSON_LOOSE_TYPE : 0);
            return $pearJson->decode($json);
        }
    }

    /**
     * Convert an array to json string
     *
     * @param array $data
     * @return string json
     */
    public static function jsonEncode($data, $prettyprint = true)
    {
        if (function_exists('json_encode'))
            $json = json_encode($data);
        else
        {
            include_once(dirname(__FILE__) . '/json/json.php');
            $pearJson = new Services_JSON();
            $json = $pearJson->encode($data);
        }
        if ( $prettyprint )
            return(self::jsonPrettyPrint($json)) ;
        else return($json) ;        
    }

    /*
     * For PS 1.2 compatibility
     */

    static public function getHttpHost($http = false, $entities = false, $ignore_port = false)
    {
        if (method_exists('Tools', 'getHttpHost'))
        {
            return( Tools::getHttpHost($http, $entities, $ignore_port) );
        }
        else
        {
            $host = (isset($_SERVER['HTTP_X_FORWARDED_HOST']) ? $_SERVER['HTTP_X_FORWARDED_HOST'] : $_SERVER['HTTP_HOST']);
            if ($entities)
                $host = htmlspecialchars($host, ENT_COMPAT, 'UTF-8');
            if ($http)
                $host = (Amazon::configurationGet('PS_SSL_ENABLED') ? 'https://' : 'http://') . $host;
            return $host;
        }
    }

    static public function getProductImages($id_product, $id_product_attribute, $id_lang)
    {
        $product = new Product($id_product);

        if (intval($id_product_attribute))
        {
            $images = $product->getCombinationImages($id_lang);
            $id_images = array();

            if (is_array($images) && count($images))
            {
                if (isset($images[$id_product_attribute]))
                {
                    foreach ($images[$id_product_attribute] as $key => $image)
                        $id_images[] = $image['id_image'];
                }
                else
                    $id_images = false;
            }
            else
            {
                $images = $product->getImages($id_lang);
                if (is_array($images) && count($images))
                {
                    foreach ($images as $key => $image)
                        $id_images[] = $image['id_image'];
                }
                else
                    $id_images = false;
            }
        }
        else
        {
            $images = $product->getImages($id_lang);
            if (is_array($images) && count($images))
            {
                foreach ($images as $key => $image)
                    $id_images[] = $image['id_image'];
            }
            else
                $id_images = false;
        }
        $images = array();

        if ($id_images)
            foreach ($id_images as $id_image)
                $images[] = self::getImageUrl($id_image, $id_product);
        return($images);
    }

    static public function getImageUrl($id_image, $productid)
    {
        $image_type = 'large';
        $ext = 'jpg';

        #image url
        if (version_compare(_PS_VERSION_, '1.4', '>='))
        {
            $image_obj = new Image($id_image);

            // PS > 1.4.3
            if (method_exists($image_obj, 'getExistingImgPath'))
            {
                $img_path = $image_obj->getExistingImgPath();
                $imageurl = $img_path;
            }
            else
            {
                $imageurl = $productid . '-' . $id_image;
            }
        }
        else
            $imageurl = $productid . '-' . $id_image;

        if (version_compare(_PS_VERSION_, '1.5.3', '>='))
        {
            $image_type = Amazon::configurationGet('AMAZON_IMAGE_TYPE') ;
            
            if ( empty($image_type) )
                $image_type = ImageType::getFormatedName('large');
        }
        elseif (version_compare(_PS_VERSION_, '1.5', '>='))
            $image_type = 'large_default';
        else
            $image_type = 'large';

        $imageurl = sprintf('%s-%s.%s', $imageurl, $image_type, $ext);

        return $imageurl;
    }

    // Source : http://www.edmondscommerce.co.uk/php/ean13-barcode-check-digit-with-php/
    // Many thanks ;)
    public static function EAN_UPC_Check($code)
    {
        //first change digits to a string so that we can access individual numbers
        $digits = sprintf('%012s', substr(sprintf('%013s', $code), 0, 12));
        // 1. Add the values of the digits in the even-numbered positions: 2, 4, 6, etc.
        $even_sum = $digits{1} + $digits{3} + $digits{5} + $digits{7} + $digits{9} + $digits{11};
        // 2. Multiply this result by 3.
        $even_sum_three = $even_sum * 3;
        // 3. Add the values of the digits in the odd-numbered positions: 1, 3, 5, etc.
        $odd_sum = $digits{0} + $digits{2} + $digits{4} + $digits{6} + $digits{8} + $digits{10};
        // 4. Sum the results of steps 2 and 3.
        $total_sum = $even_sum_three + $odd_sum;
        // 5. The check character is the smallest number which, when added to the result in step 4,  produces a multiple of 10.
        $next_ten = (ceil($total_sum / 10)) * 10;
        $check_digit = $next_ten - $total_sum;
        return ((int) $code == (int) ($digits . $check_digit));
    }

    // https://sellercentral.amazon.fr/gp/help/help-page.html/ref=pt_200692370_cont_scsearch?ie=UTF8&itemID=200692370
    // TODO: Add UPC Check
    public static function EAN_UPC_isPrivate($code)
    {
        return(in_array(substr(sprintf('%013s', $code), 0, 1), array('2')));
    }

    // Check if the condition field is present in the DB (for Prestashop < 1.4)
    //
    public static function getConditionField()
    {
        // Products Condition/State
        //
        $sql = 'SHOW COLUMNS FROM `' . _DB_PREFIX_ . 'product` where Field = "condition"';
        $query = Db::getInstance()->ExecuteS($sql);

        if (is_array($query))
            $query = array_shift($query);

        if (isset($query['Field']) && $query['Field'] == 'condition')
            return($query) ;
        else
            return(false) ;
    }
    
    public static function ValidateASIN($ASIN)
    {
        return( $ASIN != null && strlen($ASIN) && preg_match('/[A-Z0-9]{10}/', $ASIN) ) ;
    }
    public static function ValidateSKU($SKU)
    {
        return( $SKU != null && strlen($SKU) && preg_match('/[\x00-\xFF]{1,40}/', $SKU) && preg_match('/[^ ]$/', $SKU) ) ;
    }
    
    /*
      found there :
      http://fr.php.net/eval
      David Schumann
      04-Nov-2003 08:17
      To evaluate math expressions (multiply, divide, addition, subtraction, percentages),
      use the following function, based on Taras Young's 'evalsum' function posted earlier
      MERCI !
     */

    static private function _matheval($equation)
    {
        $equation = preg_replace("/[^0-9+\-.*\/()%]/", "", $equation);
        $equation = preg_replace("/([+-])([0-9]+)(%)/", "*(1\$1.\$2)", $equation);
        // you could use str_replace on this next line
        // if you really, really want to fine-tune this equation
        $equation = preg_replace("/([0-9]+)(%)/", ".\$1", $equation);
        if ($equation == "")
        {
            $return = 0;
        }
        else
        {
            eval("\$return=" . $equation . ";");
        }
        return $return;
    }
    
    static public function displayDate($date, $id_lang = null, $full = false, $separator = '-')
    {
        if (version_compare(_PS_VERSION_, '1.5', '>='))
        {
            $id_lang = null;
            return( Tools::displayDate($date, $id_lang, $full) );
        }
        else
        {
            return( Tools::displayDate($date, $id_lang, $full, $separator) );            
        }
    }
    
    // http://stackoverflow.com/questions/336127/calculate-business-days
    //The function returns the no. of business days between two dates and it skips the holidays
    static public function getWorkingDays($startDate, $endDate, $holidays = array())
    {
        // do strtotime calculations just once
        $endDate = strtotime($endDate);
        $startDate = strtotime($startDate);

        //The total number of days between the two dates. We compute the no. of seconds and divide it to 60*60*24
        //We add one to inlude both dates in the interval.
        $days = ($endDate - $startDate) / 86400 + 1;

        $no_full_weeks = floor($days / 7);
        $no_remaining_days = fmod($days, 7);

        //It will return 1 if it's Monday,.. ,7 for Sunday
        $the_first_day_of_week = date("N", $startDate);
        $the_last_day_of_week = date("N", $endDate);

        //---->The two can be equal in leap years when february has 29 days, the equal sign is added here
        //In the first case the whole interval is within a week, in the second case the interval falls in two weeks.
        if ($the_first_day_of_week <= $the_last_day_of_week)
        {
            if ($the_first_day_of_week <= 6 && 6 <= $the_last_day_of_week)
                $no_remaining_days--;
            if ($the_first_day_of_week <= 7 && 7 <= $the_last_day_of_week)
                $no_remaining_days--;
        }
        else
        {
            // (edit by Tokes to fix an edge case where the start day was a Sunday
            // and the end day was NOT a Saturday)
            // the day of the week for start is later than the day of the week for end
            if ($the_first_day_of_week == 7)
            {
                // if the start date is a Sunday, then we definitely subtract 1 day
                $no_remaining_days--;

                if ($the_last_day_of_week == 6)
                {
                    // if the end date is a Saturday, then we subtract another day
                    $no_remaining_days--;
                }
            }
            else
            {
                // the start date was a Saturday (or earlier), and the end date was (Mon..Fri)
                // so we skip an entire weekend and subtract 2 days
                $no_remaining_days -= 2;
            }
        }

        //The no. of business days is: (number of weeks between the two dates) * (5 working days) + the remainder
        //---->february in none leap years gave a remainder of 0 but still calculated weekends between first and last day, this is one way to fix it
        $workingDays = $no_full_weeks * 5;
        if ($no_remaining_days > 0)
        {
            $workingDays += $no_remaining_days;
        }

        //We subtract the holidays
        foreach ($holidays as $holiday)
        {
            $time_stamp = strtotime($holiday);
            //If the holiday doesn't fall in weekend
            if ($startDate <= $time_stamp && $time_stamp <= $endDate && date("N", $time_stamp) != 6 && date("N", $time_stamp) != 7)
                $workingDays--;
        }

        return $workingDays;
    }    
    
    public static function documentation($id_lang, $type = 'readme')
    {
        $url  = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/amazon/documentation';
        $path = _PS_MODULE_DIR_ . '/amazon/documentation'  ;
                
        $current_lang = strtolower(Language::getIsoById($id_lang)) ;

        $target_file = sprintf('%s/%s_%s.pdf', $path, $type, $current_lang) ;
        $target_link = sprintf('%s/%s_%s.pdf', $url, $type, $current_lang) ; 
        
        if ( file_exists($target_file) )
            return($target_link) ;
        
        return( sprintf('%s/%s_en.pdf', $url, $type) ) ;
    }

    // http://stackoverflow.com/questions/3466035/how-to-skip-invalid-characters-in-xml-file-using-php
    public static function stripInvalidXml($value)
    {
        $ret = "";
        $current;
        if (empty($value)) 
        {
            return $ret;
        }

        $length = strlen($value);
        for ($i=0; $i < $length; $i++)
        {
            $current = ord($value{$i});
            if (($current == 0x9) ||
                ($current == 0xA) ||
                ($current == 0xD) ||
                (($current >= 0x20) && ($current <= 0xD7FF)) ||
                (($current >= 0xE000) && ($current <= 0xFFFD)) ||
                (($current >= 0x10000) && ($current <= 0x10FFFF)))
            {
                $ret .= chr($current);
            }
            else
            {
                $ret .= " ";
            }
        }
        return $ret;
    }     
    public static function encodeText($string, $verySafe = false)
    {
        if ( $verySafe )
        {
            $string = str_replace("’", "'", $string) ;
            $string = @utf8_encode(utf8_decode($string)) ;
            $string = html_entity_decode($string, ENT_COMPAT, 'UTF-8') ;
            $string = self::stripInvalidXml($string) ;
            $string = str_replace('&#39;', "'", $string) ;
        }
        return($string) ;
    }
    
    // Prestashop 1.2 / 1.3 compat
    public static function moduleIsInstalled($moduleName)
    {
        if ( method_exists('Module', 'isInstalled') )
        {
            return( Module::isInstalled($moduleName) ) ;
        }
        else
        {
            Db::getInstance()->ExecuteS('SELECT `id_module` FROM `'._DB_PREFIX_.'module` WHERE `name` = \''.pSQL($moduleName).'\'');
            return (bool)Db::getInstance()->NumRows();
        }
    }   
    
    public static function CallingFunction()
    {
      $trace=debug_backtrace();
      $caller=$trace[1];
      $ret = null ;
      
      if ( isset($caller['line']) && isset($caller['file']) )
        $ret = sprintf('%s(#%d): %s()', basename($caller['file']), $caller['line'], $caller['function']) ;
    else
        $ret = sprintf('%s()', $caller['function']) ;
    
      if (isset($caller['class']))
        $ret .= sprintf(' in %s', $caller['class']) ;
      
      if ( $ret )
        $ret .= "\n" ;
      
      return($ret) ;
    }
    
    // Copied from Tools for PS 1.2 compat.
    public static function file_get_contents($url, $use_include_path = false, $stream_context = null, $curl_timeout = 5)
    {
            if ($stream_context == null && preg_match('/^https?:\/\//', $url))
                    $stream_context = @stream_context_create(array('http' => array('timeout' => $curl_timeout)));
            if (in_array(ini_get('allow_url_fopen'), array('On', 'on', '1')) || !preg_match('/^https?:\/\//', $url))
                    return @file_get_contents($url, $use_include_path, $stream_context);
            elseif (function_exists('curl_init'))
            {
                    $curl = curl_init();
                    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($curl, CURLOPT_URL, $url);
                    curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 5);
                    curl_setopt($curl, CURLOPT_TIMEOUT, $curl_timeout);
                    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
                    if ($stream_context != null) {
                            $opts = stream_context_get_options($stream_context);
                            if (isset($opts['http']['method']) && Tools::strtolower($opts['http']['method']) == 'post')
                            {
                                    curl_setopt($curl, CURLOPT_POST, true);
                                    if (isset($opts['http']['content']))
                                    {
                                            parse_str($opts['http']['content'], $datas);
                                            curl_setopt($curl, CURLOPT_POSTFIELDS, $datas);
                                    }
                            }
                    }
                    $content = curl_exec($curl);
                    curl_close($curl);
                    return $content;
            }
            else
                    return false;
    }    
    
    /*
     * Return if a property is accessible (ie: not protected or private)
     */
    public static function propertyIsAccessible($class, $property)
    {
        if ( !method_exists($class, '__construct') )
                return(false) ;
        
        $obj = new $class; 
        $vars     = get_object_vars($obj); 
        
        return( array_key_exists($property, $vars) ) ;
    }     
}

?>