<?php
  class Amazon_Strategy extends Amazon_Product
  {
      public $id_lang ;
      public $id_product_attribute = null ;
      protected $ASIN = null ;
      
      public function __construct($id, $full = false, $id_lang = false, $reference = 'reference')
      {
        $this->id_lang = $id_lang ;

        return( parent::__construct($id, $full, $id_lang, $reference) ) ;
      }
      
      // Added 2013/04/02 - Support of combinations
      //
      public function setIdProductAttribute($id_product_attribute)
      {
          if ( (int)$id_product_attribute )
              $this->id_product_attribute = (int)$id_product_attribute ;
      }
      public function setASIN($ASIN)
      {
          if ( $ASIN && ! empty($ASIN) )
              $this->ASIN = $ASIN ;
      }
      
      public function lookup()
      {
          if ( $this->id_product_attribute )
                $attribute_sql = ' AND mps.`id_product_attribute`=' . (int)$this->id_product_attribute ;
          else  $attribute_sql = ' AND `id_product_attribute` IS NULL' ;
          
          $sql = 'SELECT mps.`minimum_price`, mps.`actual_price`, mps.`target_price`, mps.`ASIN` from `'._DB_PREFIX_.'marketplace_strategies` mps
                         WHERE mps.`id_product` = ' . $this->id . ' and mps.`id_lang` = ' . $this->id_lang . $attribute_sql . '
                         GROUP by mps.`id_product` ; ' ;

          $rq = Db::getInstance()->ExecuteS($sql);

          return( count($rq) ? true : false ) ;
      }

      public function create($cur, $min, $max, $gap)
      {
          $min = str_replace(',', '.', $min) ;
          $cur = str_replace(',', '.', $cur) ;
          $max = str_replace(',', '.', $max) ;
          $gap = str_replace(',', '.', $gap) ;
          
          $sql  = 'INSERT INTO `'._DB_PREFIX_.'marketplace_strategies` (id_product, id_product_attribute, id_lang, minimum_price, actual_price, target_price, gap, ASIN)' ;
          $sql .= ' VALUES (' . $this->id  . ', ' . ($this->id_product_attribute ? $this->id_product_attribute : 'NULL') . ', ' . $this->id_lang . ', ' . $min . ', ' . $cur . ', ' . $max . ', ' . $gap . ', "' . $this->ASIN . '") ; ' ;

          if ( ! Db::getInstance()->Execute($sql) ) return false ;

          $sql = 'UPDATE `'._DB_PREFIX_.'product` SET `date_upd`="' . date("Y-m-d H:i:s")  . '"
                      WHERE `id_product` = ' . $this->id  ;

          if ( ! Db::getInstance()->Execute($sql) ) return false ;

          return(true) ;
      }
      
      public function duplicate($id_lang)
      {
          if ( $this->id_lang == $id_lang ) return(false) ;
          
          if ( $this->id_product_attribute )
                $attribute_sql = ' AND ms.`id_product_attribute`=' . (int)$this->id_product_attribute ;
          else  $attribute_sql = ' AND ms.`id_product_attribute` IS NULL' ;
          
          $sql = 'REPLACE INTO ps_marketplace_strategies 
                        (id_product, id_product_attribute, id_lang, ASIN, minimum_price, actual_price, target_price, gap)
                    (SELECT id_product, id_product_attribute, ' . (int)$id_lang . ', ASIN, minimum_price, actual_price, target_price, gap
                        FROM ps_marketplace_strategies ms
                        WHERE ms.id_product = ' . (int)$this->id . ' ' . $attribute_sql . ' AND ms.`id_lang` = ' . (int)$this->id_lang . ')' ;

          if ( ! Db::getInstance()->Execute($sql) ) return false ;

          return(true) ;        
      }      
      public function adjust($cur, $min, $max, $gap)
      {
          if ( $this->id_product_attribute )
                $attribute_sql = ' AND `id_product_attribute`=' . (int)$this->id_product_attribute ;
          else  $attribute_sql = ' AND `id_product_attribute` IS NULL' ;
          
          $min = str_replace(',', '.', $min) ;
          $cur = str_replace(',', '.', $cur) ;
          $max = str_replace(',', '.', $max) ;
          $gap = str_replace(',', '.', $gap) ;

          if ( ! empty($this->ASIN) )
              $setASIN = ', `ASIN`="' . pSQL($this->ASIN) . '" ' ;
          else
              $setASIN = null;
          
          $sql = 'UPDATE `'._DB_PREFIX_.'marketplace_strategies`
                  SET `minimum_price`=' . floatval($min)  . ', `actual_price`=' . floatval($cur) . ', `target_price`=' . floatval($max) . ',  `gap`=' . floatval($gap) . $setASIN . '
                  WHERE `id_product` = ' . $this->id . ' and `id_lang` = ' . $this->id_lang . $attribute_sql ;

          if ( ! Db::getInstance()->Execute($sql) ) return false ;

          return(true) ;
      }
      public function erase()
      {
          if ( $this->id_product_attribute )
                $attribute_sql = ' AND `id_product_attribute`=' . (int)$this->id_product_attribute ;
          else  $attribute_sql = ' AND `id_product_attribute` IS NULL' ;
          
          $sql = 'DELETE FROM `'._DB_PREFIX_.'marketplace_strategies`
                  WHERE `id_product` = ' . $this->id . ' and `id_lang` = ' . $this->id_lang . $attribute_sql ;
                          
          return( Db::getInstance()->Execute($sql) ) ;

          $sql = 'UPDATE `'._DB_PREFIX_.'product` SET `date_upd`="' . date("Y-m-d H:i:s")  . '"
                      WHERE `id_product` = ' . $this->id  ;

          if ( ! Db::getInstance()->Execute($sql) ) return false ;
          
          return(true) ;
      }      
      public function get()
      {
          if ( $this->id_product_attribute )
                $attribute_sql = ' AND `id_product_attribute`=' . (int)$this->id_product_attribute ;
          else  $attribute_sql = ' AND `id_product_attribute` IS NULL' ;
          
          $sql = 'SELECT * FROM `'._DB_PREFIX_.'marketplace_strategies`
                  WHERE `id_product` = ' . $this->id . ' and `id_lang` = ' . $this->id_lang . $attribute_sql . ' LIMIT 1 ; ' ;
          
          if ( ! ($result = Db::getInstance()->ExecuteS($sql)) ) return false ;
          
          return( array_shift($result) ) ;
      }
      
      public function history()
      {
          $sql = 'SELECT od.`product_quantity`, od.`product_price`, od.`tax_rate`, o.`date_add` 
                  FROM `'._DB_PREFIX_.'order_detail` od
                  LEFT JOIN `'._DB_PREFIX_.'orders` o on (od.`id_order` = o.`id_order`)
                  WHERE od.`product_id` = ' . $this->id . ' GROUP by od.`product_price` order by o.`id_order` DESC LIMIT 5 ;' ; 
         
          return( Db::getInstance()->ExecuteS($sql) ) ;
      }

      public function salesPositions()
      {

          $sql = 'SELECT count(od.`product_quantity`) as qty, sum(od.`product_price` * od.`product_quantity`) as total
                      FROM `'._DB_PREFIX_.'order_detail` od' ;

          $result1 = Db::getInstance()->getRow($sql) ;

          $sql = 'SELECT count(od.`product_quantity`) as qty, sum(od.`product_price` * od.`product_quantity`) as total
                      FROM `'._DB_PREFIX_.'order_detail` od
                      WHERE od.`product_id`=' . $this->id . '
                      GROUP by od.`product_id`' ;

          $result2 = Db::getInstance()->getRow($sql) ;


          $result = array() ;
          $result['total_sales'] = $result1['total'] ;
          $result['total_quantity'] = $result1['qty'] ;
          $result['product_sales'] = $result2['total'] ;
          $result['product_quantity'] = $result2['qty'] ;
          $result['percent_val'] = ($result2['total'] / $result1['total']) * 100 ;
          $result['percent_qty'] = ($result2['qty'] / $result1['qty']) * 100 ;
          return($result) ;
       }

       static public function getStrategiesByCategories($categories, $id_lang, $limit = 2000, $outOfStock = 1)
       {
          if ( ! count($categories) ) return(false) ;

          $searchin = '' ;

          foreach($categories as $key => $categorie)
            $searchin .= $categorie . ', ' ;
          $categories = rtrim($searchin, ', ') ;

          $sql = 'SELECT cp.`id_product`, mps.`id_lang`, cp.`id_category`, mps.`minimum_price`, mps.`actual_price`, mps.`target_price`, mps.`gap`
              FROM `'._DB_PREFIX_.'category_product` cp
              LEFT JOIN `'._DB_PREFIX_.'product` p on (p.`id_product` = cp.`id_product`)
              CROSS JOIN `'._DB_PREFIX_.'marketplace_strategies` mps on (cp.`id_product` = mps.`id_product`)
              WHERE mps.`id_lang` = ' . $id_lang . ' and cp.`id_category` in (' . $categories . ')
              AND p.quantity >= ' . intval($outOfStock) . ' AND mps.`id_product_attribute` IS NULL
              GROUP by mps.`id_product`, mps.`id_lang`
              ORDER BY RAND() LIMIT ' . $limit . ' ;' ;
          
           return( Db::getInstance()->ExecuteS($sql) ) ;
       }
           
       static public function getStrategies()
       {   
           $categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES'))) ;
              
           if ( ! $categories || ! count($categories) )
                  return(false) ;
              
           $list = implode(',', $categories) ;
                      
           if ( Amazon_Tools::getConditionField() )
                 $condition_sql = 'p.condition, ' ;
            else $condition_sql = '"new" as `condition`, ' ;
            
            $sql = '
                SELECT pl.name, if (pa.id_product_attribute, pa.`reference`, p.`reference`) as `reference`, ms.`asin` as ASIN, pl.`id_lang`, ms.`minimum_price`, ms.`actual_price`, ms.`target_price`, ms.`gap`, if (pa.`weight`, pa.`weight`, p.`weight`) as `weight`, ' . $condition_sql . 'po.`fba`, po.`shipping`, po.`disable`, p.`id_product`, pa.`id_product_attribute`, If(MAX(pa2.`id_product_attribute`), 1, 0) AS has_attributes
                    FROM `'._DB_PREFIX_.'product` p
                        LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.id_product = pl.id_product)
                        LEFT JOIN `'._DB_PREFIX_.'marketplace_strategies` ms ON (p.id_product = ms.id_product AND ms.id_lang = pl.id_lang)
                        LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa ON (p.id_product = pa.id_product AND pa.id_product_attribute = ms.id_product_attribute)						
                        LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa2 ON (p.id_product = pa2.id_product)						
                        LEFT JOIN `'._DB_PREFIX_.'marketplace_product_option` po on (p.id_product = po.id_product AND po.id_lang = pl.id_lang)
                        LEFT JOIN `'._DB_PREFIX_.'category_product` cp on (p.id_product = cp.id_product)
                    WHERE p.active = 1 AND cp.id_category IN (' . $list . ') 
                        GROUP BY p.id_product, pa.id_product_attribute, pl.id_lang                
                        HAVING `reference` > "" AND (`disable` != 1 OR `disable` IS NULL OR `disable` = 0)' ;

            return( Db::getInstance()->ExecuteS($sql) ) ;
       }
       
       static public function reInit()
       {
            $sql = 'UPDATE `'._DB_PREFIX_.'marketplace_strategies`
                  SET actual_price = target_price' ;
           return( Db::getInstance()->Execute($sql) ) ;
       }

  }
?>
