<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

class Amazon_Product extends Product
{

    public $id_product_attribute;

    public function __construct($SKU = NULL, $full = false, $id_lang = NULL, $reference = 'reference')
    {
        $id_product_attribute = null;

        // get combination first
        $sql = 'SELECT `id_product`, `id_product_attribute` FROM `' . _DB_PREFIX_ . 'product_attribute` p where `' . $reference . '` = "' . pSQL(trim($SKU)) . '"';

        $result = Db::getInstance()->getRow($sql);

        if (!$result || !$result['id_product'])
        {
            $sql = 'SELECT `id_product` FROM `' . _DB_PREFIX_ . 'product` p where `' . $reference . '` = "' . pSQL(trim($SKU)) . '"';

            $result = Db::getInstance()->getRow($sql);

            if (!$result || !$result['id_product'])
                return false;
        }
        else
        {
            $id_product_attribute = $result['id_product_attribute'];
        }
        parent::__construct($result['id_product'], $full, $id_lang);

        if (Validate::isLoadedObject($this))
        {
            $this->id_product_attribute = $id_product_attribute;
            return($this->id);
        }
        return(false);
    }

    static public function getProductById($id_product, $id_product_attribute = null)
    {
        if ($id_product_attribute == null)
        {
            $sql = 'SELECT `reference` FROM `' . _DB_PREFIX_ . 'product` where id_product = ' . (int) $id_product . ' ;';

            $rq = Db::getInstance()->ExecuteS($sql);
        }
        else
        {
            $sql = 'SELECT `reference` FROM `' . _DB_PREFIX_ . 'product_attribute` where id_product = ' . (int) $id_product . ' and id_product_attribute = ' . (int) $id_product_attribute;

            $rq = Db::getInstance()->ExecuteS($sql);
        }
        if (!isset($rq[0]['reference']))
            return(false);

        return( $rq[0]['reference'] );
    }
    
    static public function getIdByAsin($id_lang, $ASIN)
    {
        $sql = 'SELECT id_product, id_product_attribute FROM `' . _DB_PREFIX_ . 'marketplace_product_option` p where `asin1` = "' . $ASIN . '" and id_lang = "' . (int)$id_lang . '" ;';
        
        $rq = Db::getInstance()->getRow($sql);
        
        if ( ! $rq )
            return(null) ;
        
        if ( ! count(array_keys($rq)) )  
            return(null) ;
        
        $obj = new StdClass ;
        $obj->id_product = (int)$rq['id_product'] ;
        $obj->id_product_attribute = (int)$rq['id_product_attribute'] ;

        return($obj) ;
    }
    
    // Options produits (actif, stock etc..)
    //
    static public function getProductOptions($id_product, $id_lang)
    {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'marketplace_product_option` p where id_product = "' . $id_product . '" and id_lang = "' . (int)$id_lang . '" ;';

        $rq = Db::getInstance()->ExecuteS($sql);

        if ($rq)
            return( array_shift($rq) );
        else
            return( array('force' => 0, 'nopexport' => 0, 'noqexport' => 0, 'fba' => 0, 'fba_value' => 0, 'latency' => 0, 'disable' => 0, 'price' => '', 'asin1' => '', 'asin2' => '', 'asin3' => '', 'text' => '', 'shipping' => '', 'shipping_type' => '') );
    }

    static public function updateProductOptions($id_product, $id_lang, $field, $value, $id_product_attribute = 0)
    {
        if (is_numeric($value))
        {
            if (is_float($value))
                $set = '=' . (float) $value;
            else
                $set = '=' . (int) $value;
        }
        else
        {
            if (is_null($value))
                $set = '=NULL ';
            else
                $set = '="' . pSQL($value) . '"';
        }

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'marketplace_product_option` SET `' . pSQL($field) . '` ' . $set . ' WHERE `id_product`=' . (int) $id_product . ' AND `id_lang`=' . (int) $id_lang . ' AND `id_product_attribute`=' . ($id_product_attribute ? (int)$id_product_attribute : 0) ;

        $rq = Db::getInstance()->Execute($sql);

        return( $rq );
    }

    static public function setProductOptions($id_product, $id_lang, $options)
    {
        //
        // NB: Shipping : We don't cast to float the shipping value: this value could be 0 or > 0 or NULL !
        //
              $sql = 'REPLACE INTO `' . _DB_PREFIX_ . 'marketplace_product_option`
                      (`id_product`, `id_lang`, `force`, `nopexport`, `noqexport`, `fba`, `fba_value`, `latency`, `price`, `asin1`, `asin2`, `asin3`, `text`, `disable`, `bullet_point1`,  `bullet_point2`,  `bullet_point3`,  `bullet_point4`,  `bullet_point5`, `shipping`, `shipping_type`) values(' .
                pSQL($id_product) . ', ' .
                pSQL($id_lang) . ', ' .
                intval($options['force']) . ', ' .
                intval($options['nopexport']) . ', ' .
                intval($options['noqexport']) . ', ' .
                intval($options['fba']) . ', ' .
                floatval($options['fba_value']) . ', ' .
                intval($options['latency']) . ', ' .
                floatval($options['price']) . ', "' .
                pSQL($options['asin1']) . '", "' .
                pSQL($options['asin2']) . '", "' .
                pSQL($options['asin3']) . '", "' .
                pSQL($options['text']) . '", ' .
                intval($options['disable']) . ', "' .
                pSQL($options['bullet_point1']) . '", "' .
                pSQL($options['bullet_point2']) . '", "' .
                pSQL($options['bullet_point3']) . '", "' .
                pSQL($options['bullet_point4']) . '", "' .
                pSQL($options['bullet_point5']) . '", ' .
                (is_numeric($options['shipping']) ? $options['shipping'] : 'NULL') . ', ' .
                intval($options['shipping_type']) . '); ';

        $rq = Db::getInstance()->Execute($sql);

        return( $rq );
    }

    static public function setProductASIN($id_product, $id_lang, $asins)
    {
        $pass = true;

        if (!is_array($asins))
            $asins = array(0 => $asins);

        for ($i = 0; $i < count($asins) && $i < 3; $i++)
        {
            if (!isset($asins[$i]) || !empty($asin[$i]))
                continue;

            $sql = 'SELECT `id_product` FROM `' . _DB_PREFIX_ . 'marketplace_product_option` WHERE `id_product` =' . intval($id_product) . ' AND `id_lang`= ' . $id_lang;

            if (Db::getInstance()->getRow($sql))
            {

                $sql = 'UPDATE `' . _DB_PREFIX_ . 'marketplace_product_option` set `asin' . ($i + 1) . '`="' . pSQL($asins[$i]) . '"' .
                        ' WHERE `id_product` = ' . intval($id_product) . ' AND `id_lang`= ' . $id_lang;

                if (!$rq = Db::getInstance()->Execute($sql))
                    $pass = false && $pass;
            }
            else
            {

                $sql = 'REPLACE INTO `' . _DB_PREFIX_ . 'marketplace_product_option`
                          (`id_product`, `id_lang`, `asin' . ($i + 1) . '`) values(' .
                        pSQL($id_product) . ', ' .
                        pSQL($id_lang) . ', "' .
                        pSQL($asins[$i]) . '") ;';

                if (!$rq = Db::getInstance()->Execute($sql))
                    $pass = false && $pass;
            }
        }
        $pass = self::marketplaceActionSet(Amazon::Update, $id_product) && $pass;

        if ($pass)
            return( $rq );
        else
            return(false);
    }

    static public function populateProductOptions()
    {
        $pass = true ;
        
        $sql = 'INSERT IGNORE INTO `' . _DB_PREFIX_ . 'marketplace_product_option` (`id_product`, `id_lang`, `id_product_attribute`)
                        (SELECT DISTINCT `id_product`, `id_lang`, 0 from `' . _DB_PREFIX_ . 'product_lang`)';

        $pass = $pass && Db::getInstance()->Execute($sql); 
        
        $sql = 'INSERT IGNORE INTO `' . _DB_PREFIX_ . 'marketplace_product_option` (`id_product`, `id_product_attribute`, `id_lang`)
                        (SELECT DISTINCT pa.`id_product`, pa.`id_product_attribute`, pl.`id_lang` from `ps1550_product_lang` pl, `ps1550_product_attribute` pa)' ;
        
        $pass = $pass && Db::getInstance()->Execute($sql); 

        return($pass) ;
    }

    static public function fillProductOptions($id_product, $id_lang)
    {
        $sql = 'INSERT IGNORE INTO `' . _DB_PREFIX_ . 'marketplace_product_option` (id_product, id_lang) 
                        SELECT id_product, ' . (int) $id_lang . ' FROM `' . _DB_PREFIX_ . 'product`';

        return( Db::getInstance()->Execute($sql) );
    }

    static public function propagateProductActionToCategory($id_product, $id_category, $action)
    {
        $pass = true;

        // Add in the queue
        //
              $sql = 'SELECT  p.`id_product` FROM `' . _DB_PREFIX_ . 'product` p
                        WHERE p.`id_category_default` = ' . (int) $id_category . '
                        GROUP by p.`id_product`';

        if (!($result = Db::getInstance()->ExecuteS($sql)))
            return(false);

        if (is_array($result))
            foreach ($result as $product)
                self::marketplaceActionSet($action, $product['id_product']);

        return($pass);
    }

    static public function propagateProductActionToManufacturer($id_product, $id_manufacturer, $action)
    {
        $pass = true;

        // Add in the queue
        //
              $sql = 'SELECT p.`id_product` FROM `' . _DB_PREFIX_ . 'product` p WHERE
                        p.`id_manufacturer` = ' . (int) $id_manufacturer . '
                        GROUP by p.`id_product`';

        if (!($result = Db::getInstance()->ExecuteS($sql)))
            return(false);

        if (is_array($result))
            foreach ($result as $product)
                self::marketplaceActionSet($action, $product['id_product']);

        return($pass);
    }

    static public function propagateProductActionToSupplier($id_product, $id_supplier, $action)
    {
        $pass = true;

        // Add in the queue
        //
              $sql = 'SELECT p.`id_product` FROM `' . _DB_PREFIX_ . 'product` p WHERE
                        p.`id_supplier` = ' . (int) $id_supplier . '
                        GROUP by p.`id_product`';

        if (!($result = Db::getInstance()->ExecuteS($sql)))
            return(false);

        if (is_array($result))
            foreach ($result as $product)
                self::marketplaceActionSet($action, $product['id_product']);

        return($pass);
    }

    static public function propagateProductActionToShop($id_product, $action)
    {
        $pass = true;

        // Add in the queue
        //
              $sql = 'SELECT p.`id_product` FROM `' . _DB_PREFIX_ . 'product` p GROUP by p.`id_product`';

        if (!($result = Db::getInstance()->ExecuteS($sql)))
            return(false);

        if (is_array($result))
            foreach ($result as $product)
                self::marketplaceActionSet($action, $product['id_product']);

        return($pass);
    }

    static public function propagateProductOptionToCategory($id_product, $id_lang, $id_category, $field, $value)
    {
        $pass = true && self::fillProductOptions($id_product, $id_lang);

        if (is_numeric($value))
            $sql_value = $value;
        elseif (empty($value))
            $sql_value = 'NULL';
        elseif (is_null($value))
            $sql_value = 'NULL';
        else
            $sql_value = '"' . $value . '"';

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'marketplace_product_option` mpo, `' . _DB_PREFIX_ . 'product` p SET
                    mpo.`' . pSQL($field) . '` = ' . $sql_value . '
                    WHERE p.id_product = mpo.`id_product` AND p.`id_category_default` = ' . intval($id_category) . ' AND mpo.`id_lang` = ' . intval($id_lang);

        $pass = $pass && Db::getInstance()->Execute($sql);

        return($pass);
    }

    static public function propagateProductOptionToShop($id_product, $id_lang, $field, $value)
    {
        $pass = true && self::fillProductOptions($id_product, $id_lang);

        if (is_numeric($value))
            $sql_value = $value;
        elseif (empty($value))
            $sql_value = 'NULL';
        elseif (is_null($value))
            $sql_value = 'NULL';
        else
            $sql_value = '"' . $value . '"';

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'marketplace_product_option` mpo, `' . _DB_PREFIX_ . 'product` p SET
                    mpo.`' . pSQL($field) . '` = ' . $sql_value . '
                    WHERE p.`id_product` = mpo.`id_product` AND mpo.`id_lang` = ' . intval($id_lang);

        $pass = $pass && Db::getInstance()->Execute($sql);


        return($pass);
    }

    static public function propagateProductOptionToManufacturer($id_product, $id_lang, $id_manufacturer, $field, $value)
    {
        $pass = true && self::fillProductOptions($id_product, $id_lang);

        if (is_numeric($value))
            $sql_value = $value;
        elseif (empty($value))
            $sql_value = 'NULL';
        elseif (is_null($value))
            $sql_value = 'NULL';
        else
            $sql_value = '"' . $value . '"';

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'marketplace_product_option` mpo, `' . _DB_PREFIX_ . 'product` p SET
                    mpo.`' . pSQL($field) . '` = ' . $sql_value . '
                    WHERE p.`id_product` = mpo.`id_product` AND mpo.`id_lang` = ' . intval($id_lang) . ' AND p.`id_manufacturer` = ' . (int) $id_manufacturer;

        $pass = $pass && Db::getInstance()->Execute($sql);


        return($pass);
    }

    static public function propagateProductOptionToSupplier($id_product, $id_lang, $id_supplier, $field, $value)
    {
        $pass = true && self::fillProductOptions($id_product, $id_lang);

        if (is_numeric($value))
            $sql_value = $value;
        elseif (empty($value))
            $sql_value = 'NULL';
        elseif (is_null($value))
            $sql_value = 'NULL';
        else
            $sql_value = '"' . $value . '"';

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'marketplace_product_option` mpo, `' . _DB_PREFIX_ . 'product` p SET
                    mpo.`' . pSQL($field) . '` = ' . $sql_value . '
                    WHERE p.`id_product` = mpo.`id_product` AND mpo.`id_lang` = ' . intval($id_lang) . ' AND p.`id_supplier` = ' . (int) $id_supplier;

        $pass = $pass && Db::getInstance()->Execute($sql);

        return($pass);
    }

    static public function getAllProducts($id_lang, $id_category = false, $only_active = false)
    {
        $sql = 'SELECT p.id_product
                  FROM `' . _DB_PREFIX_ . 'product` p ' .
                ($id_category ? 'LEFT JOIN `' . _DB_PREFIX_ . 'category_product` c ON (c.`id_product` = p.`id_product`)' : '') . '
                  LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl ON (p.`id_product` = pl.`id_product`)
                  WHERE pl.`id_lang` = ' . intval($id_lang) .
                ($id_category ? ' AND c.`id_category` = ' . intval($id_category) : '') .
                ($only_active ? ' AND p.`active` = 1' : '') . '
                  GROUP by p.id_product ORDER BY p.date_add desc ';

        $rq = Db::getInstance()->ExecuteS($sql);

        return ($rq);
    }

    static public function oldest()
    {
        $sql = '
                  SELECT MIN(date_add) as date_min FROM `' . _DB_PREFIX_ . 'product`;';
        if (($rq = Db::getInstance()->ExecuteS($sql)) && is_array($rq))
        {
            $result = array_shift($rq);
            return(str_replace('-', '/', $result['date_min']));
        }
        else
            return(false);
    }

    static public function marketplaceActionGet($id_product, $id_lang)
    {
        if ($id_product && !self::marketplaceInCategories($id_product))
            return(false);

        $sql = '
                SELECT `action` FROM `' . _DB_PREFIX_ . 'marketplace_product_action` 
                    WHERE `marketplace` = "' . Amazon::marketplace . '" AND `id_lang` = ' . intval($id_lang) . ' AND `id_product`=' . intval($id_product) . '
                    AND (`date_upd` = "" OR `date_upd` = NULL OR `date_upd` IS NULL) 
                    ORDER by `action` LIMIT 1 ';

        if (!($rq = Db::getInstance()->ExecuteS($sql)))
            return(false);

        return( (isset($rq[0]['action']) ? $rq[0]['action'] : false) );
    }

    static public function marketplaceActionDelete($id_product)
    {
        $sql = '
                DELETE FROM `' . _DB_PREFIX_ . 'marketplace_product_action` 
                    WHERE `marketplace` = "' . Amazon::marketplace . '" AND `id_product`=' . intval($id_product) . '
                    AND (`date_upd` = "" OR `date_upd` = NULL OR `date_upd` IS NULL) ';

        if (!($rq = Db::getInstance()->Execute($sql)))
            return(false);

        return(true);
    }

    static public function marketplaceActionList($id_lang, $action = null, $limiter = false)
    {
        if ($action)
            $restrict = ' AND `action`="' . $action . '"';
        else
            $restrict = ' AND `action`!="' . Amazon::Add . '"';
        
        if ( (int)$limiter )
            $limit = ' LIMIT ' . (int)$limiter ;
        else
            $limit = null ;
        
        $sql = '
                SELECT `id_product`, `action`, `sku`, min(`date_add`) as date_start, max(`date_add`) as date_stop FROM `' . _DB_PREFIX_ . 'marketplace_product_action` 
                    WHERE `marketplace` = "' . Amazon::marketplace . '" AND id_lang = ' . intval($id_lang) . '
                    AND (`date_upd` = "" OR `date_upd` = NULL OR `date_upd` IS NULL)' .
                $restrict . '
                    GROUP by `id_product`
                    ORDER by `date_add` ASC' . $limit ;

        if (!($rq = Db::getInstance()->ExecuteS($sql)))
            return(false);

        return($rq);
    }

    static public function marketplaceActionSet($action, $id_product, $id_product_attribute = null, $sku = null, $id_lang = null)
    {
        // In Marketplace Categories
        //
        if ($id_product && !self::marketplaceInCategories($id_product))
            return(false);

        // Get Actives Platforms
        //
        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));

        if (!is_array($actives))
            return(false);

        if ( $id_lang )
        {
            $actives = array($id_lang => $id_lang) ;
        }
        
        // On ne traite pas les attribute sur les updates !
        // 
        if ($action == Amazon::Update)
            $id_product_attribute = null;

        $pass = true;

        foreach (array_keys($actives) as $id_lang)
        {
            $sql = 'REPLACE INTO `' . _DB_PREFIX_ . 'marketplace_product_action` 
                        (`id_product`, `id_product_attribute`, `id_lang`, `sku`, `marketplace`, `action`, `date_add`, `date_upd`) values(' .
                    intval($id_product) . ', ' .
                    (!$id_product_attribute ? 'NULL' : $id_product_attribute) . ', ' .
                    intval($id_lang) . ', "' .
                    pSQL($sku) . '", "' .
                    pSQL(Amazon::marketplace) . '", "' .
                    pSQL($action) . '", "' .
                    date('Y-m-d H:i:s') . '", NULL) ';

            Db::getInstance()->Execute($sql) || $pass = true;
        }

        return($pass);
    }

    static public function marketplaceActionUpdateCombination($id_product_attribute)
    {
        if (version_compare(_PS_VERSION_, '1.4', '<'))
            $upc = false;
        else
            $upc = true;

        $sql = '
                        SELECT id_product
                        FROM `' . _DB_PREFIX_ . 'product_attribute` pa
                        WHERE pa.`id_product_attribute` = ' . intval($id_product_attribute) . ' AND pa.`reference` > "" AND (pa.`ean13` > "" ' . ($upc ? 'OR pa.`upc` > ""' : '') . ')
                        GROUP by pa.`id_product` ';

        if (!($rq = Db::getInstance()->getRow($sql)))
            return(false);

        self::marketplaceActionSet(Amazon::Update, $rq['id_product']) || $pass = false;

        return($pass);
    }

    static public function marketplaceActionRemoveAllCombinations($action, $id_product)
    {
        $pass = true ;
        
        if (version_compare(_PS_VERSION_, '1.4', '<'))
            $upc = false;
        else
            $upc = true;

        $sql = '
                        SELECT reference, id_product_attribute
                        FROM `' . _DB_PREFIX_ . 'product_attribute` pa
                        WHERE pa.`id_product` = ' . intval($id_product) . ' AND pa.`reference` > "" AND (pa.`ean13` > "" ' . ($upc ? 'OR pa.`upc` > ""' : '') . ')
                        GROUP by pa.`id_product`, pa.`id_product_attribute`, pa.`reference` ';

        if (!($rq = Db::getInstance()->ExecuteS($sql)))
            return(false);

        foreach ($rq as $combination)
            self::marketplaceActionSet(Amazon::Remove, $id_product, $combination['id_product_attribute'], $combination['reference']) || $pass = false;

        return($pass);
    }

    static public function marketplaceInCategories($id_product)
    {
        // Categories Lookup
        //
              $categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES')));

        if (!$categories || !count($categories))
            return(false);

        $list = rtrim(implode(',', $categories), ',') ;

        $sql =
                'SELECT `id_product` FROM `' . _DB_PREFIX_ . 'category_product` WHERE `id_product` = ' . intval($id_product) . ' AND `id_category` IN(' . $list . ')';

        if (!$rq = Db::getInstance()->getRow($sql))
            return(false);

        return(true);
    }

    static public function marketplaceGetCategory($id_product)
    {
        // Categories Lookup
        //
              $categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES')));

        if (!$categories || !count($categories))
            return(false);

        $list = implode(',', $categories);

        $sql =
                'SELECT `id_category` FROM `' . _DB_PREFIX_ . 'category_product` WHERE `id_product` = ' . intval($id_product) . ' AND `id_category` IN(' . $list . ')';

        if (!$rq = Db::getInstance()->getRow($sql))
            return(false);

        return($rq['id_category']);
    }

    static public function marketplaceActionGetSku($id_product)
    {
        if (version_compare(_PS_VERSION_, '1.4', '<'))
            $upc = false;
        else
            $upc = true;

        $sql = '
                        SELECT `reference`
                        FROM `' . _DB_PREFIX_ . 'product` p
                        WHERE p.`id_product` = ' . intval($id_product) . ' AND p.`reference` > "" AND (p.`ean13` > "" ' . ($upc ? 'OR p.`upc` > ""' : '') . ')';

        $rq = Db::getInstance()->getRow($sql);

        if (isset($rq['reference']) && !empty($rq['reference']))
            return($rq['reference']);

        return(false);
    }

    static public function marketplaceActionGetCombinationSku($id_product)
    {
        $sql = '
                        SELECT reference, id_product_attribute
                        FROM `' . _DB_PREFIX_ . 'product_attribute` pa
                        WHERE pa.`id_product` = ' . intval($id_product) . ' AND pa.`reference` > "" AND (pa.`ean13` > "" OR pa.`upc` > "")
                        GROUP by pa.`id_product`, pa.`id_product_attribute` ';

        $rq = Db::getInstance()->getRow($sql);

        if (isset($rq['reference']) && !empty($rq['reference']))
            return($rq['reference']);

        return(false);
    }

    static public function marketplaceGetAllProducts($id_lang, $only_active = false, $since = false)
    {
        // Categories Lookup
        //
        $categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES')));

        if (!$categories || !count($categories))
            return(false);

        $list = implode(',', $categories);

        if ($since)
            $dateRange = ' AND (p.`date_add` >= "' . pSQL($since) . '" OR p.`date_upd` >= "' . pSQL($since) . '") ';
        else
            $dateRange = '';

        $sql = 'SELECT p.`id_product` FROM `' . _DB_PREFIX_ . 'product` p 
                        LEFT JOIN `' . _DB_PREFIX_ . 'category_product` c ON (c.`id_product` = p.`id_product`)                    
                        LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl ON (p.`id_product` = pl.`id_product`)
                        WHERE pl.`id_lang` = ' . intval($id_lang) .
                $dateRange .
                ($only_active ? ' AND p.`active` = 1' : '') . '
                        AND c.id_category IN (' . $list . ')
                        GROUP by p.id_product ORDER BY p.date_add desc ';

        $rq = Db::getInstance()->ExecuteS($sql);

        return ($rq);
    }

    static public function marketplaceCountProducts()
    {
        if (version_compare(_PS_VERSION_, '1.4', '<'))
            $upc = false;
        else
            $upc = true;

        // Categories Lookup
        //
                $categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES')));

        if (!$categories || !count($categories))
            return(false);

        $list = implode(',', $categories);

        $sql = '
                        SELECT count(p.id_product) as products FROM `' . _DB_PREFIX_ . 'product` p
                            LEFT JOIN `' . _DB_PREFIX_ . 'category_product` c ON (c.`id_product` = p.`id_product`)
                            WHERE p.`active` = 1
                            AND p.`reference` > "" AND (p.`ean13` > "" ' . ($upc ? 'OR p.`upc` > ""' : '') . ')
                            AND c.id_category IN (' . $list . ')';

        $rq1 = Db::getInstance()->ExecuteS($sql);

        $sql = '
                        SELECT count(pa.id_product) as attributes FROM `' . _DB_PREFIX_ . 'product_attribute` pa
                            LEFT JOIN `' . _DB_PREFIX_ . 'category_product` c ON (c.`id_product` = pa.`id_product`)
                            WHERE 
                              pa.`reference` > "" AND (pa.`ean13` > "" ' . ($upc ? 'OR pa.`upc` > ""' : '') . ')
                              AND c.id_category IN (' . $list . ')
                            ';

        $rq2 = Db::getInstance()->ExecuteS($sql);

        if (empty($rq1) or !is_array($rq1))
        {
            $rq1 = array();
            $rq1[0] = array('products' => 0, 'attributes' => 0);
        }
        if (empty($rq2) or !is_array($rq2))
        {
            $rq2 = array();
            $rq2[0] = array('products' => 0, 'attributes' => 0);
        }

        return( array_merge(array_shift($rq1), array_shift($rq2)) );
    }

    static public function marketplaceActionReset($id_lang, $action = null) 
    {
        if ( $action )
            $and_action = ' AND `action` = "' . trim($action) . '"' ;
        else
            $and_action = '' ;
        
        $sql = '
                        DELETE FROM `' . _DB_PREFIX_ . 'marketplace_product_action` WHERE `id_lang`=' . intval($id_lang) . $and_action;

        return( Db::getInstance()->Execute($sql) );
    }

    static public function marketplaceActionAcknowledgde($action, $id_lang, $productList, $dateAcknowledgde, $revert = false)
    {
        switch ($action)
        {
            case Amazon::Add :
                $restrict = ' AND `action` = "' . Amazon::Add . '" ';
                break;
            case Amazon::Remove :
                $restrict = ' AND `action` = "' . Amazon::Remove . '" ';
                break;
            default:
                $restrict = ' AND `action` = "' . Amazon::Update . '" ';
                break;
        }

        if ( ! is_array($productList) || ! count($productList) )
            return(false) ;

        $list = implode(',', $productList);

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'marketplace_product_action` SET `date_upd`="' . pSQL($dateAcknowledgde) . '" WHERE `id_product` IN (' . $list . ') AND `id_lang`=' . intval($id_lang) . $restrict;

        Db::getInstance()->Execute($sql);

        // Cleaning old entries
        //
                 if (in_array($action, array(Amazon::Add, Amazon::Remove, Amazon::Update)))
        {
            $sql = 'DELETE FROM `' . _DB_PREFIX_ . 'marketplace_product_action` WHERE `date_upd` < DATE_ADD(NOW(), INTERVAL -7 DAY) AND `action`="' . $action . '"';

            Db::getInstance()->Execute($sql);
        }
        return(true);
    }

    // Only for PS < 1.5
    static public function updateProductQuantity($id_product, $id_product_attribute, $quantity)
    {
        $pass = true;

        if ($id_product_attribute)
        {
            $sql = '
                      UPDATE `' . _DB_PREFIX_ . 'product_attribute` set quantity = ' . intval($quantity) . ' where id_product=' . intval($id_product) . ' and id_product_attribute = ' . intval($id_product_attribute);

            if (!$rq = Db::getInstance()->Execute($sql))
                $pass = $pass && false;

            $sql = '
                      UPDATE `' . _DB_PREFIX_ . 'product` set quantity = ' . intval($quantity) . ' where id_product=' . intval($id_product);

            if (!$rq = Db::getInstance()->Execute($sql))
                $pass = $pass && false;
        }
        else
        {
            $sql = '
                      UPDATE `' . _DB_PREFIX_ . 'product` set quantity = "' . intval($quantity) . '" where id_product=' . intval($id_product);

            if (!$rq = Db::getInstance()->Execute($sql))
                $pass = $pass && false;
        }
        return($pass);
    }
    
    const FILEFORMAT_REFERENCE = 1 ;
    const FILEFORMAT_ID = 2 ;
    
    static public function getProductCode($type = self::FILEFORMAT_REFERENCE, $code = 'ean13')
    {
        $categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES')));

        if (!$categories || !count($categories))
            return(false);
        
        $category_list = implode(',', $categories);
        
        $code_string = sprintf('if (pa.id_product_attribute, pa.`%s`, p.`%s`) AS `%s`', $code, $code, $code) ;

        if ( $type == self::FILEFORMAT_REFERENCE)
            $type_string = 'p.`id_product`, pa.`id_product_attribute`' ;
        elseif ( $type == self::FILEFORMAT_ID)
            $type_string = 'if (pa.id_product_attribute, pa.`reference`, p.`reference`) AS `reference`' ;
        

        $sql = 'SELECT ' . $type_string . ', ' . $code_string . ', pl.`name`
                         FROM `' . _DB_PREFIX_ . 'product` p
                             LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl ON (p.id_product = pl.id_product)
                             LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute` pa ON (p.id_product = pa.id_product)						
                             LEFT JOIN `' . _DB_PREFIX_ . 'category_product` cp on (p.id_product = cp.id_product)
                         WHERE p.active = 1 AND cp.id_category IN (' . $category_list . ') 
                             GROUP BY p.id_product, pa.id_product_attribute' ;

        return( Db::getInstance()->ExecuteS($sql) );
    }
    
    static public function getCurrentQueue()
    {
        $result = array() ;
        
        // Check if exists
        //
        $tables = Db::getInstance()->ExecuteS('SHOW tables LIKE "%marketplace_product_action%"');

        if ( is_array($tables) && count($tables) )
        {
            $sql = '
                SELECT COUNT(id_product) as count, id_lang, action, MIN(date_add) as date_min, MAX(date_add) as date_max FROM `' . _DB_PREFIX_ . 'marketplace_product_action` 
                 WHERE `marketplace` = "' . Amazon::marketplace . '" 
                 GROUP by id_lang, action' ;

            $result = Db::getInstance()->ExecuteS($sql) ;
        }
        return( $result ? $result : array() );
    }
    
    
    static public function getProductsToCreate($id_lang)
    {
        // Categories Lookup
        //
        $categories = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CATEGORIES')));

        if (!$categories || !count($categories))
            return(false);

        $list = rtrim(implode(',', $categories), ',') ;
        
        $sql = 'SELECT p.`id_product`, pa.`id_product_attribute`, IF (pa.`ean13`, pa.`ean13`, p.`ean13`) as ean13, po.`asin1`, IF (pa.reference > "", pa.reference, p.reference) as reference FROM `' . _DB_PREFIX_ . 'product` p
                    LEFT JOIN `' . _DB_PREFIX_ . 'product_attribute` pa on (p.id_product = pa.id_product)
                    LEFT JOIN `' . _DB_PREFIX_ . 'category_product` cp on (p.id_product = cp.id_product)
                    LEFT JOIN `' . _DB_PREFIX_ . 'marketplace_product_action` mpa on (mpa.`id_product` = p.`id_product`)                        
                    LEFT JOIN `' . _DB_PREFIX_ . 'marketplace_product_option` po on (po.`id_product` = p.`id_product` AND po.`id_lang` = ' . (int)$id_lang . ')
                    WHERE   p.`active` = 1
                            AND NOT `asin1` IS NOT NULL AND (p.`ean13` or p.`upc` or pa.`ean13` or pa.`upc`) IS NOT NULL
                            AND cp.`id_category` IN (' . $list . ')
                            AND NOT mpa.`action` IS NOT NULL AND (mpa.`date_upd` = "" OR mpa.`date_upd` = NULL OR mpa.`date_upd` IS NULL)
                    GROUP  BY p.`id_product`
                    HAVING reference > ""' ;

        return( Db::getInstance()->ExecuteS($sql) ) ;
    }

}

?>