<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2014 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2014 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 */

class Amazon_Preconfiguration
{
    static $preconfiguration = array(
        'de' => array(
            'region' => 'de',
            'currency' => 'EUR',
            '_amazon_incoming_carrier' => 'Std DE Dom',
            '_amazon_outgoing_carrier' => 'Deutsche Post',
            'synchronization_field' => 'ean13'
        ),
        'es' => array(
            'region' => 'es',
            'currency' => 'EUR',
            '_amazon_incoming_carrier' => 'Std ES Dom',
            '_amazon_outgoing_carrier' => 'Other',
            'synchronization_field' => 'ean13'
        ),
        'fr' => array(
            'region' => 'fr',
            'currency' => 'EUR',
            '_amazon_incoming_carrier' => 'Std FR Dom',
            '_amazon_outgoing_carrier' => 'La Poste',
            'synchronization_field' => 'ean13'
        ),
        'it' => array(
            'region' => 'it',
            'currency' => 'EUR',
            '_amazon_incoming_carrier' => 'Std IT Dom',
            '_amazon_outgoing_carrier' => 'Poste Italiane',
            'synchronization_field' => 'ean13'
        ),        
        'gb' => array(
            'region' => 'uk',
            'currency' => 'GBP',
            '_amazon_incoming_carrier' => 'Std UK Dom',
            '_amazon_outgoing_carrier' => 'Royal Mail',
            'synchronization_field' => 'ean13'
        ),        
        'us' => array(
            'region' => 'us',
            'currency' => 'USD',
            '_amazon_incoming_carrier' => 'Std US Dom',
            '_amazon_outgoing_carrier' => 'USPS',
            'synchronization_field' => 'upc'
        ),        
        'ca' => array(
            'region' => 'ca',
            'currency' => 'CAD',
            '_amazon_incoming_carrier' => 'Std CA Dom',
            '_amazon_outgoing_carrier' => 'Canada Post',
            'synchronization_field' => 'upc'
        )
    ) ;
    static function data($id_lang)
    {
        if ( ! $id_lang )
            return(null) ;
        
        $country_iso_code = Configuration::get('PS_LOCALE_COUNTRY') ;
        
        if ( ! $country_iso_code )  
            return(null) ;
        
        if ( ! isset(self::$preconfiguration[$country_iso_code]) )
            return(null) ;

        $language = null ;
        
        switch($country_iso_code)
        {
            case 'fr' :
                $language = 'fr' ;
                break ;
        }
        if ( ! $language )
            return(null) ;
        
        $_target_id_lang = Language::getIdByIso($language) ;
        
        if ( $_target_id_lang != $id_lang )
            return(null) ;
        
        $preconfiguration_data = self::$preconfiguration[$country_iso_code] ;        
        $preconfiguration_data['_carrier'] = Configuration::get('PS_CARRIER_DEFAULT') ;
        
        $preconfiguration_data['amazon_incoming_carrier'] = array(0 => md5($preconfiguration_data['_amazon_incoming_carrier'])) ;
        $preconfiguration_data['prestashop_incoming_carrier'] = array(0 => $preconfiguration_data['_carrier']) ;
        $preconfiguration_data['outgoing_carriers'] = 
                            array(
                                    'amazon' => array(0 => $preconfiguration_data['_amazon_outgoing_carrier']), 
                                    'prestashop' => array(0 => $preconfiguration_data['_carrier']) 
                                ) ;
        return($preconfiguration_data) ;
    }
}   