<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

require_once(dirname(__FILE__) . '/../classes/amazon.orderhistory.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.order.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.tools.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.product.class.php');
require_once(dirname(__FILE__) . '/../classes/amazon.webservice.class.php');

class Amazon_MultiChannel extends Amazon_Order
{
    public $marketPlaceChannelStatus = null ;
    
    const AMAZON_FBA_MULTICHANNEL                   = 'MAFN' ;
    const AMAZON_FBA_AMAZON                         = 'AFN' ;
    const AMAZON_FBA_MERCHANT                       = 'MFN' ;

    const AMAZON_FBA_STATUS_SUBMITED                = 'submited' ;
    const AMAZON_FBA_STATUS_RECEIVED                = 'received' ;
    const AMAZON_FBA_STATUS_INVALID                 = 'invalid' ;
    const AMAZON_FBA_STATUS_PLANNING                = 'planning' ;
    const AMAZON_FBA_STATUS_PROCESSING              = 'processing' ;
    const AMAZON_FBA_STATUS_CANCELLED               = 'cancelled' ;
    const AMAZON_FBA_STATUS_COMPLETE                = 'complete' ;
    const AMAZON_FBA_STATUS_COMPLETEPARTIALLED      = 'completepartialled' ;
    const AMAZON_FBA_STATUS_UNFULFILLABLE           = 'unfulfillable' ;
    
    public function __construct($id = NULL, $id_lang = NULL)
    {
      parent::__construct($id, $id_lang) ;

      if ( $id )
            $this->_getMpStatus() ;
    }
    
    private function _getMpStatus()
    {
        $sql = 'SELECT `mp_channel_status` FROM `' . _DB_PREFIX_ . 'orders`
                    WHERE `id_order` = "' . (int)$this->id . '"' ;

        if ( $result = Db::getInstance()->getRow($sql) )
        {
          $this->marketPlaceChannelStatus = $result['mp_channel_status'] ;
          return(true) ;
        }
        return(false) ;
    }
    
    public function updateMpChannelStatus($status)
    {
        $this->marketPlaceChannelStatus = $status ;

        $sql = 'UPDATE  `' . _DB_PREFIX_ . 'orders`
                      SET `mp_channel_status` = "' . pSQL($this->marketPlaceChannelStatus) .'"
                      WHERE `id_order` = ' . (int)$this->id ;

        if( ! Db::getInstance()->Execute($sql) )
              return(false);
        return(true) ;
    }

    public static function ordersByStatus($ps_status)
    {
        $sql = 'SELECT `id_order`, `mp_channel_status`, `shipping_number`, `date_add` FROM `' . _DB_PREFIX_ . 'orders` o WHERE 
            `mp_channel` = "' . pSQL(self::AMAZON_FBA_MULTICHANNEL) . '" 
            AND (SELECT oh.id_order_state FROM `'._DB_PREFIX_.'order_history` oh WHERE o.id_order = oh.id_order ORDER BY oh.date_add DESC, oh.id_order_history DESC LIMIT 1) = ' . (int)$ps_status . ' 
            AND `date_add` > DATE_ADD(NOW(), INTERVAL -30 DAY)    
            ORDER by `date_add` ASC' ;
         
        if( ! ($result = Db::getInstance()->ExecuteS($sql)) )
              return false;
        
        return($result) ;        
    }
    public static function isEligible($id_order)
    {
        $order = new Order($id_order) ;
        
        if ( ! Validate::isLoadedObject($order) )
        {
            return(false) ;
        }
        
        // Check FBA-MultiChannel Eligibility
        $products = $order->getProducts() ;
                
        if ( ! $products || ! is_array($products) || ! count($products) )
        {
            return(false) ;              
        }
        
        // Require all the ordered products are FBA
        //
        foreach($products as $product)
        {
            if ( ! Amazon_Tools::ValidateSKU($product['product_reference']) )
            {
                return(false) ;
            }
            
            if ( ! ($options = Amazon_Product::getProductOptions($product['product_id'], $order->id_lang)) )
            {
                return(false) ;
            }
            
            if ( ! isset($options['fba']) || ! (bool)$options['fba'] )
            {
                return(false) ;
            }
        }
        return($order) ;
    }
    public function CancelFulfillmentOrder($order_id, $id_lang, $debug = false)
    {
        // Init
        //
        $amazon = Amazon_Tools::selectPlatforms($id_lang, $debug);

        if ($debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        $pass = true ;

        if (!($amazonAPI = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $debug)))
        {
            $error = 'Unable to login';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        }   
        
        $result = $amazonAPI->CancelFulfillmentOrder($order_id) ;
        
        if ( ! $result )
        {
            $error = 'Impossible to retrieve the order from Amazon';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        } 

        $this->updateMpChannelStatus(self::AMAZON_FBA_STATUS_CANCELLED) ;
        
        return($result) ;
    }    

    public function GetPackageTrackingDetails($PackageNumber, $id_lang, $debug = false)
    {
        // Init
        //
        $amazon = Amazon_Tools::selectPlatforms($id_lang, $debug);

        if ($debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        $pass = true ;

        if (!($amazonAPI = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $debug)))
        {
            $error = 'Unable to login';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        }   
        
        $result = $amazonAPI->GetPackageTrackingDetails($PackageNumber) ;
        
        if ( ! $result )
        {
            $error = 'Impossible to retrieve the order from Amazon';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        } 
        return($result) ;
    }
    
    public function GetFulfillmentOrder($order_id, $id_lang, $debug = false)
    {
        // Init
        //
        $amazon = Amazon_Tools::selectPlatforms($id_lang, $debug);

        if ($debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        $pass = true ;

        if (!($amazonAPI = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $debug)))
        {
            $error = 'Unable to login';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        }   
        
        $result = $amazonAPI->GetFulfillmentOrder($order_id) ;
        
        if ( ! $result )
        {
            $error = 'Impossible to retrieve the order from Amazon';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        } 
        return($result) ;
    }
    public function CreateFulfillmentOrder($debug = false)
    {
        $mailtemplate = array() ;
        
        $carriers_multichannel = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CARRIER_MULTICHANNEL')));
        $useTax     = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_TAXES')))) ? true : false;
        $specials   = intval(unserialize(base64_decode(Amazon::configurationGet('AMAZON_SPECIALS')))) ? true : false;
        $id_order_state = Amazon::configurationGet('AMAZON_FBA_MULTICHANNEL_STATE') ;
        $id_employee = Amazon::configurationGet('AMAZON_EMPLOYEE') ;
        
        if ( ! Validate::isLoadedObject($this) )
        {
            $error = sprintf('Unable to load order') ;
            if ( $debug )
                print $error . "<br />\n" ;
            return(false) ;    
        }
        $id_order = $this->id ;
        
        if ( ! $id_order_state )
        {
            $error = 'Order state for FBA is not yet configured';
            if ( $debug )
                print $error . "<br />\n" ;
            return(false) ;              
        }
        
        if ( ! isset($carriers_multichannel[$this->id_lang]) || ! is_array($carriers_multichannel[$this->id_lang]) || ! count($carriers_multichannel[$this->id_lang]['amazon']) )
        {
            $error = 'FBA Multi-Channel Carrier Mapping is not or not correctly configured';
            if ( $debug )
                print $error . "<br />\n" ;
            return(false) ;                          
        }
        $pass = false ;
        foreach($carriers_multichannel[$this->id_lang]['prestashop'] as $key => $prestashop_id_carrier)
            if ( $prestashop_id_carrier == $this->id_carrier )
            {
                $ShippingSpeedCategory = $carriers_multichannel[$this->id_lang]['amazon'][$key] ;
                $pass = true ;
                break ;
            }
        if ( ! $pass )  
        {
            $error = sprintf('Carrier Mapping not found for this entry - id_order: %d - id_lang: %d - id_carrier: %d', $this->id, $this->id_lang, $this->id_carrier) ;
            if ( $debug )
                print $error . "<br />\n" ;
            return(false) ;             
        }
        
        $currency = new Currency((int)Configuration::get('PS_CURRENCY_DEFAULT'));
        $shop_name = Configuration::get('PS_SHOP_NAME') ;
        $id_lang = $this->id_lang ;        
        $id_customer = (int)$this->id_customer ;
        
        // Init
        //
        if ( version_compare(_PS_VERSION_,'1.5','>=') )
        {
            $controller = new FrontController();
            $controller->init();            
        }
        
        $amazon = Amazon_Tools::selectPlatforms($id_lang, $debug);

        if ($debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        $pass = true ;

        if (!($amazonAPI = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $debug)))
        {
            $error = 'Unable to login';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        }
        
        $customer = new Customer($id_customer) ;
        
        if ( ! Validate::isLoadedObject($customer) )
        {
            $error = sprintf('%s - %d', 'Unable to find customer', $id_customer)  ;
            if ( $debug )
                print $error . "<br />\n" ;
            return(false) ;
        }
        
        $address = new Address($this->id_address_delivery) ;
        
        if ( ! Validate::isLoadedObject($address) )
        {
            $error = sprintf('%s - %d', 'Unable to find address - 2', $id_customer) ;
            if ( $debug )
                print $error . "<br />\n" ;
            return(false) ;    
        }
        
        $AmazonOrder = array() ;
        $AmazonOrder['SellerFulfillmentOrderId']            = $id_order ;
        $AmazonOrder['DisplayableOrderId']                  = $id_order ;
        $AmazonOrder['DisplayableOrderDateTime']            = gmdate("Y-m-d\TH:i:s\Z", time()) ;
        $AmazonOrder['DisplayableOrderComment']             = sprintf('Order #%s from %s', $id_order, $shop_name) ;
        $AmazonOrder['ShippingSpeedCategory']               = $ShippingSpeedCategory ;

        $AmazonOrder['NotificationEmailList']               = array() ;
        $AmazonOrder['NotificationEmailList'][]             = $customer->email ;
        
        if ( Amazon::configurationGet('AMAZON_EMAIL') )
            $AmazonOrder['NotificationEmailList'][]         = Configuration::get('PS_SHOP_EMAIL') ;
        
        $AmazonOrder['DestinationAddress']                  = array() ;
        $AmazonOrder['DestinationAddress']['Name']          = sprintf('%s %s', $address->firstname, $address->lastname) ;
        
        if ( $address->company )
        {
            $AmazonOrder['DestinationAddress']['Line1']         = $address->company ;
            $AmazonOrder['DestinationAddress']['Line2']         = $address->address1 ;
            $AmazonOrder['DestinationAddress']['Line3']         = $address->address2 ;
        }
        else
        {
            $AmazonOrder['DestinationAddress']['Line1']         = $address->address1 ;
            $AmazonOrder['DestinationAddress']['Line2']         = $address->address2 ;
            $AmazonOrder['DestinationAddress']['Line3']         = null ;
        }
        
        $AmazonOrder['DestinationAddress']['City']          = $address->city ;
        $AmazonOrder['DestinationAddress']['PostalCode']    = $address->postcode ;
        $AmazonOrder['DestinationAddress']['CountryCode']   = Country::getIsoById($address->id_country) ;
        $AmazonOrder['DestinationAddress']['PhoneNumber']   = $address->phone ;

        // Mandatory: Required by Amazon
        if ( $address->id_state )
            $AmazonOrder['DestinationAddress']['StateOrProvinceCode'] = State::getNameById($address->id_state) ;
        else
            $AmazonOrder['DestinationAddress']['StateOrProvinceCode'] = Country::getNameById($id_lang, $address->id_country) ;
        
        foreach($AmazonOrder['DestinationAddress'] as $key => $val)
        {
            if ( function_exists('filter_var') )
                $sanitized = filter_var($val, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
            else  
                $sanitized = $val ;
            
            $AmazonOrder['DestinationAddress'][$key] = $sanitized ;
        }
        
  
        $AmazonOrder['Items'] = array() ;

        $products = $this->getProducts() ;
        
        if ( ! $products || ! is_array($products) || ! count($products) )
        {
            $error = sprintf('%s - %d', 'Empty or wrong cart for order:', $id_order) ;
            if ( $debug )
                print $error . "<br />\n" ;
            return(false) ;              
        }

        $SKUCheck = array() ;
        $index = 0; 
        foreach($products as $ordered_product)
        {
                $SKU = $ordered_product['product_reference'] ;
                
                if ( empty($SKU) )
                {
                    $error = sprintf('Missing Reference(SKU) for product: %d/%d', $ordered_product['product_id'], $ordered_product['product_attribute_id']) ;
                    if ( $debug )
                        print $error . "<br />\n" ;
                    continue ;                       
                }

                $product = new Amazon_Product($SKU, false, $id_lang) ;
                
                if ( ! Validate::isLoadedObject($product) )
                {
                    $error = print(sprintf('%s - %s', 'Unable to find product', $SKU)) ;
                    
                    if ( $debug )
                        print $error . "<br />\n" ;
                    
                    continue ;
                }    
                
                if ( ! ($options = Amazon_Product::getProductOptions((int)$product->id, $id_lang)) )
                {
                    $error = sprintf('%s - %d', 'Uneligible product: %d/%d', $ordered_product['product_id'], $ordered_product['product_attribute_id']) ;
                    if ( $debug )
                        print $error . "<br />\n" ;                    
                    continue ;
                }

                if ( ! isset($options['fba']) || ! (bool)$options['fba'] )
                {
                    $error = sprintf('%s - %d', 'Not FBA product: %d/%d', $ordered_product['product_id'], $ordered_product['product_attribute_id']) ;
                    if ( $debug )
                        print $error . "<br />\n" ;                     
                    continue ;
                }                
                $SellerID = sprintf('%d_%d_%d', (int)$id_order, (int)$product->id, (int)$product->id_product_attribute) ;
                $Price = $product->getPrice($useTax, $product->id_product_attribute, 6, NULL, false, ! $product->on_sale && $specials) ;
                $Quantity = isset($ordered_product['product_quantity']) ? (int)$ordered_product['product_quantity'] : 1 ;
                
                $SKUCheck[$index] = $SKU ;
                $AmazonOrder['Items'][$index]['SKU'] = $SKU ;
                $AmazonOrder['Items'][$index]['SellerSKU'] = $SKU ;
                $AmazonOrder['Items'][$index]['SellerFulfillmentOrderItemId'] = $SellerID ;
                $AmazonOrder['Items'][$index]['Quantity'] = $Quantity ;
                $AmazonOrder['Items'][$index]['PerUnitDeclaredValue.CurrencyCode'] = $currency->iso_code ;
                $AmazonOrder['Items'][$index]['PerUnitDeclaredValue.Value'] = $Price ;
                $AmazonOrder['Items'][$index]['DisplayableComment'] = $product->name ;
                
                $index++ ;
        }

        // Check availability of products
        //
        $result = $amazonAPI->ListInventoryBySKU($SKUCheck) ;
        
        if ( ! $result || ! is_array($result) )
        {
                $error = sprintf('Product availability check failed for order id: %s', $id_order) ;
                
                if ( $debug )
                    print $error . "<br/>\n" ;
                return(false) ;
        }
        if ( ! count($result) )
        {
                $error = sprintf('Product availability, no items available for order id: %s', $id_order) ;
                
                if ( $debug )
                    print $error . "<br />\n" ;
                return(false) ;                 
        }
        $indexes = array_flip($SKUCheck) ;
       
        // Verify Quantities
        foreach($result as $Item)
        {
            if ( ! isset($indexes[ $Item['SKU'] ]) )    continue ;
            
            $index = $indexes[ $Item['SKU'] ] ;
            if ( isset($Item['InStockSupplyQuantity']) && $Item['InStockSupplyQuantity'] >= $AmazonOrder['Items'][$index]['Quantity'] )
            {
                if ( $debug )
                   printf('Availability Check: %s - Quantity: %s' . "\n<br />", $Item['SKU'], $Item['InStockSupplyQuantity']) ; 
                unset($SKUCheck[$index]) ;
            }
        }
        
        // Remaining products in SKUCheck: unavailable products or not enough stock
        if ( count($SKUCheck) )
        {
                $error = sprintf('Product availability, not enough stock to fulfill the order: %s', $id_order) ;
                if ( $debug )
                    print $error . "<br/>\n" ;
                return(false) ;                        
        }
        
        $result = $amazonAPI->CreateFulfillmentOrder($AmazonOrder) ;
        // ie: result = 'bf4a916e-013a-431b-b6f1-5ad90b4be6bf' ;
        
        if ( ! preg_match('/([0-9A-Fa-f]{4,16}[\-]{0,}){5}/', $result) )
        {
                $error = sprintf('CreateFulfillmentOrder(), failed for order: %s', $id_order) ;
                if ( $debug )
                    print $error . "<br/>\n" ;
                return(false) ;
        }

        $AmazonOrder['Response'] = (string)$result ;
        
        // Restock Product
        //
        foreach($products as $ordered_product)
        {
            $id_product = (int)$ordered_product['product_id'] ;
            $id_product_attribute = (int)$ordered_product['product_attribute_id'] ? (int)$ordered_product['product_attribute_id'] : null ;
            
            $SellerID = sprintf('%d_%d_%d', (int)$id_order, (int)$id_product, (int)$id_product_attribute) ;
            
            foreach( $AmazonOrder['Items'] as $key => $Item )
                if ( $Item['SellerFulfillmentOrderItemId'] == $SellerID)    break ;
                
            if (version_compare(_PS_VERSION_, '1.5', '>='))
            {
                StockAvailable::updateQuantity($id_product, $id_product_attribute ? $id_product_attribute : null, (int)$Item['Quantity']);
            }
            else
            {
                $productQuantity = Product::getQuantity(intval($id_product), $id_product_attribute ? $id_product_attribute : null);
                Amazon_Product::updateProductQuantity($id_product, $id_product_attribute ? $id_product_attribute : null, $productQuantity + (int)$Item['Quantity']);
            }
        }     
        
        // New Order History
        $this->addToHistory($id_employee, $id_order_state) ;
        $this->updateMpChannel(self::AMAZON_FBA_MULTICHANNEL) ;
        $this->updateMpChannelStatus(self::AMAZON_FBA_STATUS_SUBMITED) ;
        
        return($AmazonOrder) ;
    }
   
    public function ListAllFulfillmentOrders($date, $id_lang, $debug = false)
    {
        // Init
        //
        $amazon = Amazon_Tools::selectPlatforms($id_lang, $debug);

        if ($debug)
            echo nl2br(print_r($amazon['auth'], true) . print_r($amazon['params'], true) . print_r($amazon['platforms'], true));

        $pass = true ;

        if (!($amazonAPI = new Amazon_WebService($amazon['auth'], $amazon['params'], $amazon['platforms'], $debug)))
        {
            $error = 'Unable to login';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        }   
        
        $result = $amazonAPI->ListAllFulfillmentOrders($date) ;
        
        if ( ! $result )
        {
            $error = 'Impossible to retrieve the order from Amazon';
            if ( $debug )
                print $error . "<br />\n" ;            
            return(false) ;
        } 
        
        return($result) ;
    }     
    private function addToHistory($id_employee, $id_order_state)
    {
        // Add History
        $new_history = new Amazon_OrderHistory();
        $new_history->id_order = intval($this->id);
        $new_history->id_employee = intval($id_employee);
        $new_history->changeIdOrderState($id_order_state, $this->id, true);
        $new_history->addWithOutEmail(true);
        return ;
    }    

}

?>
