<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Common Services Co Ltd - 90/25 Sukhumvit 81 - 10260 Bangkok - Thailand
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */
class Amazon_Lookup
{
    //construct
    function __construct($marketplace, $key, $secret){
            $this->marketplace = str_replace('_', '.', $marketplace);
            $this->key = $key ;
            $this->secret = $secret ;
    }
    //query
    function query($params){
        return aws_signed_request($this->marketplace,$params,$this->key,$this->secret);
    }

    //fetch item
    function getASIN($val){

        $operation = array() ;
        $operation['Operation'] = 'ItemLookup' ;
        $operation['ItemId'] = $val ;
        $operation['IdType'] = 'EAN' ;
        $operation['ResponseGroup'] = 'ItemAttributes' ;
        $operation['SearchIndex'] = 'All' ;

        if ( ! ($response = $this->query($operation)) )
        {
            #echo nl2br(print_r($response, true));
            return(false) ;
        }
        return($response) ;
    }

    //fetch item
    function fetch($mode,$val){
        //validate mode
        $modes = array("EAN","UPC","ASIN","ISBN");
        if(!in_array($mode,$modes))
        {
            return(false) ;
        }
        $operation = array() ;
        $operation['Operation'] = 'ItemLookup' ;
        $operation['ItemId'] = $val ;
        $operation['IdType'] = $mode ;
        $operation['ResponseGroup'] = 'Large,BrowseNodes' ;

        if ( $mode != 'ASIN' )
            $operation['SearchIndex'] = 'All' ;

        if ( ! ($response = $this->query($operation)) )
        {
            return(false) ;
        }

        return($response) ;
    }


    //parse response
    function parse($response, $mode, $val)
    {
        $data = array() ;
        $data[$mode] = $val ;

        //validate $Request
        $Request = $response['Items']['Request'];
        $error_message = $this->error_message($Request);
        if( ! empty($error_message) )
        {
              echo "Invalid request. " . $error_message ;
              return(false);
        }


        //item data
        $Item = $response['Items']['Item'];

        //Atributes
        $ItemAtributes = $Item['ItemAttributes'];
        //Assign atributes
        foreach($ItemAtributes as $key=>$val)
            $data[$key] = $val;
        //Photos
        $ItemImages = isset($Item['ImageSets']['ImageSet'])?$Item['ImageSets']['ImageSet']:"";
        //if(isset($ItemImages[0]) && is_array($ItemImages[0]))
       //     $ItemImages = $ItemImages[0];
        //Assign photos
        $data['pictures'] = array() ;

        foreach($Item['ImageSets']['ImageSet'] as $ItemImage)
        {
          if(!empty($ItemImage['LargeImage'])){
              $data['pictures'][] = $ItemImage['LargeImage'];
            }
          elseif(!empty($ItemImage['SwatchImage'])){
             $data['pictures'][] = $ItemImage['SwatchImage'];
            }
        }

        if ( ! count($data['pictures']) )
        {
           $data['pictures'] = array() ;
           $data['pictures'][] = $Item['LargeImage'] ;
        }

        //Assign description
        if(isset($Item['EditorialReviews'])){
            $itemReview = $Item['EditorialReviews']['EditorialReview'];
            $data['review'] = $itemReview['Content'];
            $data['review_short'] = $data['review'];
        }
        // Assign Nodes
        if(isset($Item['BrowseNodes']))
        {
            $browseNode = $Item['BrowseNodes']['BrowseNode'];
            $data['nodes'] = $browseNode ;
        }

        return $data;
    }

   //truncate
      function truncate($text,$length,$ending="..."){
          if(strlen($text)>$length)
              $text = substr($text,0,strpos($text,' ',TRUNCATE_FROM)).$ending;
          return $text;
      }
    //returns error message
    function error_message($param){
        return isset($param['Errors']['Error']['Message'])?$param['Errors']['Error']['Message']:"";
    }
}
?>