<?php 

/***************************************
*  Author : KBUG / Olivier
***************************************/
require_once(dirname(__FILE__) . '/amazon.csv.base.class.php');
require_once(dirname(__FILE__) . '/amazon.tools.class.php');


class Amazon_CSV_Reference  extends Amazon_CSV_Base
{
    
    public $id_product = null ;
    public $id_product_attribute = null ;      

    public $reference = null;
    
    public $upc    = null;    
    public $ean13    = null;
    
    public $comment = null;
}

class Amazon_CSV_References
{
  #fetch mode
  const FM_ARRAY = '1';//array mode
  const FM_OBJECT = '2';//object mode

  const FIELD_ID          = 0 ;
  const FIELD_REFERENCE   = 1 ;
  const FIELD_UPC         = 2 ;
  const FIELD_EAN         = 3 ;

  const SEP_COMMA = ',' ;
  const SEP_SEMI = ';' ;
  const SEP_TAB = "\t" ;
    
  #Data
  public $csvfile = null;
  public $loadflag = false;
  public $datalist = null;
  
  public function __construct($filepath) {
    $this->csvfile = $filepath;
  }
  
  public function loadData()
  {
    if(!file_exists($this->csvfile))
      throw new Exception('Invalid file');
    
    $linenum = 0;
    $this->datalist = array();
    $fileSize = 10000;

    $fp = fopen($this->csvfile, 'r');
    $buf = fread($fp, 1000);
    fseek($fp, 0);

    // Identifying delimiter
    $best_delimiter = null ;
    $previous = 0 ;
    foreach( array(self::SEP_SEMI, self::SEP_COMMA, self::SEP_TAB) as $delimiter)
    {
        if ( ($c = count(fgetcsv($fp, 10000, $delimiter))) > $previous ) 
                $best_delimiter = $delimiter ;
        $previous = $c ;
        fseek($fp, 0);
    }

    $delimiter = $best_delimiter ; 
    $headerok = false ;

    while ($data = fgetcsv($fp, $fileSize, $delimiter)) {
      #  ignore header data
      if( ! $headerok ) 
      {
          if ( ! isset($data[Amazon_CSV_References::FIELD_EAN]) || ! isset($data[Amazon_CSV_References::FIELD_EAN]) )   continue ;
          
          if ( strtoupper($data[Amazon_CSV_References::FIELD_EAN]) == 'EAN' && strtoupper($data[Amazon_CSV_References::FIELD_UPC]) == 'UPC' )
            $headerok = true ;
          
          continue; 
      }

      if(!is_array($data) ) continue;
      $szTemp = implode($data,'');
      if(!trim($szTemp)) continue;

      $item = $this->parse($data);

      if($item)
        $this->datalist[] = $item;
    }
    fclose ($fp);
    
    if( $headerok )
        $this->loadflag = true;
    
    return true;
  }
  
  public function getData()
  {
    if(!$this->csvfile) return array();
    if($this->loadflag) return $this->datalist;
    
    if($this->loadData())
      return $this->datalist;
    return array();
  }
 
  public function parse($data)
  {
    if(!is_array($data))
      return null;
    $data = array_map('trim', $data);

    $obj = new Amazon_CSV_Reference();

    if ( isset($data[ Amazon_CSV_References::FIELD_ID]) )
    {
      
        $item = $data[ Amazon_CSV_References::FIELD_ID ] ;

        if ( stristr($item, '_') !== false )
        {
            $split_combination = explode('_', $item);

            if ( !(int)$split_combination[0] )   return(false) ;

            $obj->set_id_product((int)$split_combination[0]);
            $obj->set_id_product_attribute((int)$split_combination[1]);  
        }    
        else
        {
            if ( ! (int)$item ) return(false) ;
            
            $obj->set_id_product((int)$item);
            $obj->set_id_product_attribute(false);
        }        
    }
    else
    {
        return(false) ;
    }
    
    if ( isset($data[ Amazon_CSV_References::FIELD_REFERENCE ]) )
    {
        $item = ltrim($data[ Amazon_CSV_References::FIELD_REFERENCE ], "'") ;

        if ( Amazon_Tools::ValidateSKU($item) )
            $obj->set_reference((string)$item);
    }
    else
    {
        return(false) ;
    }
    
    if ( isset($data[ Amazon_CSV_References::FIELD_EAN ]) )
    {
        $item = ltrim($data[ Amazon_CSV_References::FIELD_EAN ], "'") ;
        
        if ( Amazon_Tools::EAN_UPC_Check($item) && ! Amazon_Tools::EAN_UPC_isPrivate($item) )
            $obj->set_ean13((string)$item);
    }
    else
    {
        return(false) ;
    }

    if ( isset($data[ Amazon_CSV_References::FIELD_UPC ]) )
    {
        $item = ltrim($data[ Amazon_CSV_References::FIELD_UPC ], "'") ;
        
        if ( Amazon_Tools::EAN_UPC_Check($item) && ! Amazon_Tools::EAN_UPC_isPrivate($item) )
            $obj->set_upc((string)$item);
    }
    else
    {
        return(false) ;
    }
    
    return $obj;
  }
  
}
?>