<?php
  class Amazon_Address extends Address
  {
      // Genere un cle qui sera le nom d'alias dans la table
      //
      public function hash($obj)
      {
        $str = $obj->Name . $obj->AddressLine1 . $obj->AddressLine2 . $obj->City . $obj->PostalCode . $obj->CountryCode ;

        return( md5($str) ) ;
      }

      /**
      * Specify if an address is already in base
      *
      * @param $alias
      * @return id_address
      */
      static public function addressExistsByAlias($alias)
      {
             $row = Db::getInstance()->getRow('
             SELECT `id_address`
             FROM '._DB_PREFIX_.'address a
             WHERE a.`alias` = "'. strval($alias) . '"');

             return($row['id_address']);
      }

      public static function _filter($text)
      {
         
          $text = mb_convert_encoding($text,'HTML-ENTITIES','UTF-8');
          $text = preg_replace( array('/&szlig;/','/&(..)lig;/','/&([aouAOU])uml;/','/&(.)[^;]*;/'),array('ss',"$1","$1".'e',"$1"),  $text);
          $text = str_replace('_', '/', $text) ;
          $text = preg_replace('/[\x00-\x1F\x21-\x2E\x3A-\x3F\x5B-\x60\x7B-\x7F]/', '', $text); // remove non printable
          
          $text = preg_replace('/[!<>?=+@{}_$%]*$/u', '', $text); // remove non printable
          return $text;
      }

      public static function getAmazonName($fullname)
      {
          $result = array() ;

          // on d�colle le nom du pr�nom
          // et on filtre les parasites !

          $result['company'] = '' ;

          if ( preg_match('/,|\//', $fullname) )
          {
            // Cas ou le client mets Nom Prenom, Company
            //
            $parts = preg_split('/,|\//', $fullname) ;
            $var = trim(mb_substr($parts[0], 0, 32)) ;
            $result['company'] = trim(mb_substr($parts[1], 0, 32)) ;
          }
          else  $var = mb_substr($fullname, 0, 32) ;

          $var = preg_replace('/[0-9!<>,;?=+()@#"{}_$%:]/', '', $var) ;
          
          $var = trim($var) ;
          $var = mb_substr($var, 0, 32) ;
          $var1 =  explode(' ', $var) ;
          $sz = sizeof($var1) - 1 ;

          $firstname = $var1[$sz] ;
          unset($var1[$sz]) ;
          $lastname = implode(' ', $var1) ;


          $firstname = empty($firstname) ? 'unknown' : $firstname ;
          $lastname = empty($lastname) ? 'unknown' : $lastname ;

          $result['firstname'] = ucfirst($firstname) ;
          $result['lastname'] = ucfirst($lastname) ;

          return($result) ;
      }

      public function lookupOrCreateamazonAddress($amazonAddress, $amazonTemporaryAddress)
      {
        global $cookie ;
        // Cl� MD qui est l'alias dans la DB
        //

        $alias = $this->hash($amazonAddress) ;

        // !! DELIVERY
        // On recherche si le client existe d�ja, sinon on cr�e son entr�e dans le carnet d'adresse
        //
        if ( ! ($id_address = $this->addressExistsByAlias($alias)) )
        {
          // L'adresse n'existe pas on la cr�e
          //
          $this->id_country  = Country::getByIso( strval($amazonAddress->CountryCode) ) ;
          $this->country     = Country::getNameById($cookie->id_lang, $this->id_country) ;
          $this->alias       = $alias ;

          $name = self::getAmazonName($amazonAddress->Name) ;

          $this->lastname    = $name['lastname'] ;
          $this->firstname   = $name['firstname'] ;
          $this->company     = preg_replace('/[!<>?;=#{}_$%]+/', '', $name['company'] );
          
          if ( empty($amazonAddress->AddressLine1) )
          {
            $this->address1    = preg_replace('/[!<>?=+@{}_$%]+/', '', strval(trim($amazonAddress->AddressLine2))) ;
            $this->address2    = strval($this->_filter($amazonAddress->StateOrRegion)) ;
          }
          else
          {
            $this->address1    = preg_replace('/[!<>?=+@{}_$%]+/', '', strval(trim($amazonAddress->AddressLine1))) ;
            $this->address2    = preg_replace('/[!<>?=+@{}_$%]+/', '', strval(trim($amazonAddress->AddressLine2))) ;
          }

          /*
          if ( strlen($this->address2) > $this->address1 )
          {
            $tmp            = $this->address1 ;
            $this->address1 = $this->address2 ;
            $this->address2 = $tmp ;
          }
          */
          
          if ( ! strlen($this->address1) && strlen($this->address2) )
            $this->address1 = $this->address2 ;
        
          
          if ( ! strlen($this->address1) )
              $this->address1 = 'Unknown' ;
          
          
          $this->postcode = preg_replace('/[,\/]/', '-', $amazonAddress->PostalCode);          
          $this->postcode = preg_replace('/[^a-zA-Z 0-9-]/', '', $this->postcode);

          $this->city = strtoupper($this->_filter(strval(trim($amazonAddress->City)))) ;

          if ( empty($this->postcode) )
              $this->postcode = 'NA' ;
          if ( empty($this->city) )
              $this->city = 'NA' ;
          if ( empty($this->address1) )
              $this->address1 = 'Unknown' ;          
          
          $this->phone = preg_replace('/,/', '-', $amazonAddress->Phone);          
          $this->phone = preg_replace('/[^+0-9. ()-]/', '', $this->phone) ;

          // 2013-01-05 Olivier - getStatesByIdCountry is not supported by PS < 1.4
          if ( version_compare(_PS_VERSION_, '1.4', '>=') )
          {
            /* Modif YB du 17/12/2012 - Mappage de l'etat pour les adresses US */
            if(isset($amazonAddress->StateOrRegion) && $amazonAddress->StateOrRegion!="")
            {
                    if($this->id_country)
                    {
                            $statesList = State::getStatesByIdCountry($this->id_country);
                            if( is_array($statesList) && count($statesList) )
                            {
                                    foreach($statesList as $curstate)
                                    {
                                            $state_or_region = preg_replace('/[^A-Za-z0-9 -]/', '', strtolower($amazonAddress->StateOrRegion)) ;

                                            if ( strtolower($curstate["iso_code"]) == $state_or_region || preg_replace('/[^A-Za-z0-9 -]/', '', strtolower($curstate["name"])) == $state_or_region )
                                            {
                                                    $this->id_state=$curstate["id_state"];
                                                    break;
                                            }
                                    }
                            }
                    }
            }
            /* Modif YB du 17/12/2012 - Mappage de l'etat pour les adresses US */
          }
          
          //  fields sizes must match with parent Address class
          //
          foreach( array('company', 'firstname', 'lastname', 'address1', 'address2', 'postcode', 'city', 'phone', 'phone_mobile') as $field )
                  $this->{$field} = substr($this->{$field}, 0, $this->fieldsSize[$field]) ;

          $this->add() ;

          return($this->id) ;
        }
        else
        {
          return($id_address) ;
        }
      }

  }
?>