<?php

/* NOTICE OF LICENSE
 *
 * This source file is subject to a commercial license from SARL SMC
 * Use, copy, modification or distribution of this source file without written
 * license agreement from the SARL SMC is strictly forbidden.
 * In order to obtain a license, please contact us: olivier@common-services.com
 * ...........................................................................
 * INFORMATION SUR LA LICENCE D'UTILISATION
 *
 * L'utilisation de ce fichier source est soumise a une licence commerciale
 * concedee par la societe SMC
 * Toute utilisation, reproduction, modification ou distribution du present
 * fichier source sans contrat de licence ecrit de la part de la SARL SMC est
 * expressement interdite.
 * Pour obtenir une licence, veuillez contacter la SARL SMC a l'adresse: olivier@common-services.com
 * ...........................................................................
 * @package    Amazon Market Place
 * @copyright  Copyright (c) 2011-2013 S.A.R.L SMC (http://www.common-services.com)
 * @copyright  Copyright (c) 2011-2013 Olivier B.
 * @author     Olivier B.
 * @license    Commercial license
 * Support by mail  :  contact@common-services.com
 * Support on forum :  delete
 * Skype : delete13_fr
 * Phone : +33.970465505
 */

if ( version_compare(_PS_VERSION_, '1.5', '<') && defined('PS_ADMIN_DIR') && file_exists(PS_ADMIN_DIR . '/../classes/AdminTab.php'))
    include_once(PS_ADMIN_DIR . '/../classes/AdminTab.php');

require_once(dirname(__FILE__) . '/amazon.php');

class OrdersAmazon extends AdminTab
{
    public $name = 'amazon';
    private $_amazon;

    public $id_lang ;
    
    public function __construct()
    {
        global $cookie ;

        $this->id_lang = (int)$cookie->id_lang ;
        
        $this->url = __PS_BASE_URI__ . basename(_PS_MODULE_DIR_) . '/' . $this->name . '/' ;
        $this->images = $this->url . 'images/';

        $this->path = str_replace('\\', '/', dirname(__FILE__)) . '/' ;
        $this->_amazon = new Amazon();
        
        parent::__construct();
    }
    
    public function l($string, $class = false, $addslashes = FALSE, $htmlentities = TRUE)
    {
        return( parent::l($string, __CLASS__, $addslashes = FALSE, $htmlentities = TRUE) );
    }
    
    public function display()
    {
        global $smarty ;

        $smarty->assign('path', $this->url) ;
        $smarty->assign('images', $this->images) ;
        $smarty->assign('selected_tab', 'import') ;

        $this->addCSS($this->url.'css/OrdersAmazon.css', 'screen');
        $this->addCSS($this->url.'css/OrdersAmazon.compat.css', 'screen');    
        
        $this->addJS($this->url . 'js/orders.js') ;
        
        $html   = null ;
        $html  .= $this->tabHeader() ;
        $html  .= $this->languageSelector() ;
        $html  .= $smarty->fetch($this->path . 'views/AdminOrdersAmazon.tpl');        
        
        echo $html ;
        return ;
    }
    
    public function tabHeader() 
    {
        global $smarty, $cookie ;
        
        $smarty->assign('images', $this->images) ;

        $amazonTokens = unserialize(base64_decode(Amazon::configurationGet('AMAZON_CRON_TOKEN')));

        $tokenOrders = Tools::getAdminToken('AdminOrders' . (int) Tab::getIdFromClassName('AdminOrders') . (int) $cookie->id_employee);

        $day            = 86400;
        $days           = 7;
        $startDate      = date('Y-m-d', time() - ($day * $days));
        $currentDate    = date('Y-m-d');

        includeDatepicker('nothing') ;

        $smarty->assign('tokens', $amazonTokens) ;    
        $smarty->assign('token_order', $tokenOrders) ;    
        $smarty->assign('orders_url', $this->url . 'functions/orders.php') ;    
        $smarty->assign('import_url', $this->url . 'functions/import.php') ;    
        $smarty->assign('img_loader', $this->images . 'loading.gif') ;    
        $smarty->assign('img_loader_small', $this->images . 'small-loader.gif') ;    
        $smarty->assign('current_date', $currentDate) ;    
        $smarty->assign('start_date', $startDate) ;    

        $smarty->assign('id_lang', $this->id_lang) ;           

        $documentation = Amazon_Tools::documentation($this->id_lang) ;
        $faq = Amazon_Tools::documentation($this->id_lang, 'faq') ;              
        
        $smarty->assign('documentation', $documentation) ;
        $smarty->assign('faq', $faq) ;            

       return( $smarty->fetch( $this->path . 'views/items/orders_header.tpl') ) ;
    }
    public function languageSelector()
    {
        global $smarty ;

        $html = null ;

        $europe  = unserialize(base64_decode(Amazon::configurationGet('AMAZON_EUROPE')));
        $actives = unserialize(base64_decode(Amazon::configurationGet('AMAZON_ACTIVE')));
        $regions = unserialize(base64_decode(Amazon::configurationGet('AMAZON_REGION')));
        $marketPlaceIds = unserialize(base64_decode(Amazon::configurationGet('AMAZON_MARKETPLACE_ID')));

        $this->addCSS($this->url.'/css/country_selector.css', 'screen');


        $marketplaces = array() ;

        if ( $europe )
        {
            $marketplacesEuro = array() ;

            if ( is_array($actives) )
                foreach (Amazon_Tools::languages() as $language)
                {
                    $id_lang = $language['id_lang'];

                    if ( ! isset($actives[$id_lang]) || ! $actives[$id_lang] )          continue ;

                    if ( ! isset($regions[$id_lang]) || empty($regions[$id_lang]) )     continue ;

                    if ( ! isset($marketPlaceIds[$id_lang]) ) continue ;

                    if ( Amazon_Tools::isEuropeMarketplaceId($marketPlaceIds[$id_lang]) && Amazon_Tools::isEuroMarketplaceId($marketPlaceIds[$id_lang]) )
                    {
                        // Euro Zone Area
                        //
                        $marketplacesEuro[$id_lang] = array() ;
                        $marketplacesEuro[$id_lang]['name'] = sprintf('www.amazon.%s', Amazon_Tools::idToDomain($id_lang)) ;
                        $marketplacesEuro[$id_lang]['region'] = $regions[$id_lang] ;
                        $marketplacesEuro[$id_lang]['id_lang'] = $id_lang ;
                        $marketplacesEuro[$id_lang]['lang'] = $language['iso_code'] ;
                        $marketplacesEuro[$id_lang]['image'] = $this->images . 'geo_flags_web2/flag_' . $regions[$id_lang] . '_64px.png' ;
                    }   
                    else
                    {
                        // Outside Euro Zone Area
                        //
                        $marketplacesNotEuro[$id_lang] = array() ;
                        $marketplacesNotEuro[$id_lang]['name'] = sprintf('www.amazon.%s', Amazon_Tools::idToDomain($id_lang)) ;
                        $marketplacesNotEuro[$id_lang]['region'] = $regions[$id_lang] ;
                        $marketplacesNotEuro[$id_lang]['id_lang'] = $id_lang ;
                        $marketplacesNotEuro[$id_lang]['lang'] = $language['iso_code'] ;
                        $marketplacesNotEuro[$id_lang]['image'] = $this->images . 'geo_flags_web2/flag_' . $regions[$id_lang] . '_64px.png' ;                            
                    }
                }

                if ( count($marketplacesEuro) )
                    $europeEuroArea = true  ;
                else
                    $europeEuroArea = false  ;

                if ( count($marketplacesNotEuro) )
                    $europeNotEuroArea = true  ;
                else
                    $europeNotEuroArea = false  ;                    

                $smarty->assign('images', $this->images) ;
                $smarty->assign('europeEuroArea', $europeEuroArea) ;
                $smarty->assign('europeNotEuroArea', $europeEuroArea) ;
                $smarty->assign('europe_flag', $this->images . 'geo_flags_web2/flag_eu_64px.png') ;
                $smarty->assign('marketplacesEuro', $marketplacesEuro) ;
                $smarty->assign('marketplacesNotEuro', $marketplacesNotEuro) ;

                return( $smarty->fetch( $this->path . 'views/items/europe_selector.tpl') ) ;                
        }
        else
        {
            if ( is_array($actives) )
                foreach (Amazon_Tools::languages() as $language)
                {
                    $id_lang = $language['id_lang'];

                    if ( ! isset($actives[$id_lang]) || ! $actives[$id_lang] )          continue ;

                    if ( ! isset($regions[$id_lang]) || empty($regions[$id_lang]) )     continue ;

                    $marketplaces[$id_lang] = array() ;
                    $marketplaces[$id_lang]['name'] = sprintf('www.amazon.%s', Amazon_Tools::idToDomain($id_lang)) ;
                    $marketplaces[$id_lang]['region'] = $regions[$id_lang] ;
                    $marketplaces[$id_lang]['id_lang'] = $id_lang ;
                    $marketplaces[$id_lang]['lang'] = $language['iso_code'] ;
                    $marketplaces[$id_lang]['image'] = $this->images . 'geo_flags_web2/flag_' . $regions[$id_lang] . '_64px.png' ;
                }
                $smarty->assign('images', $this->images) ;
                $smarty->assign('marketplaces', $marketplaces) ;
                $smarty->assign('psIs16', false);
                
                return( $smarty->fetch( $this->path . 'views/items/country_selector.tpl') ) ;
        }
    }   
    function addCSS($css)
    {
        echo '<link type="text/css" rel="stylesheet" href="' . $css . '" />' . "\n" ;
        return ;
    }
    function addJS($js)
    {
        echo '<script type="text/javascript" src="' . $js . '"></script>' . "\n";
        
        return ;
    }    
}

?>