{*
 *  2013 Neovis : Michael Jegou & Vasseur Alexandre
 *
 *  @author VASSEUR ALEXANDRE <tech@neovis.fr>
 *  @author MJ <tech@neovis.fr>
 *  @copyright  2013 Neovis
 *  @license    not free
 *  International Registered Trademark & Property of Neovis
 *}

{extends file="helpers/form/form.tpl"}

{block name="input" prepend}
	{if $input.type == 'tax'}
		{assign var=taxes value=$input.values}
		{if count($taxes) && isset($taxes)}
		<table cellspacing="0" cellpadding="0" class="table" style="width:90em;">
			<tr>
				<th>{l s='ID' mod='neotaxesupdater'}</th>
				<th>{l s='Taxes name' mod='neotaxesupdater'}</th>
				<th>{l s='Taxes usage' mod='neotaxesupdater'}</th>
				<th>{l s='Current taxes rate' mod='neotaxesupdater'}</th>
				<th>{l s='New taxes rate' mod='neotaxesupdater'}</th>
			</tr>
			{foreach $taxes as $key => $tax}
				<tr class="{if $key %2}alt_row{/if}{if $tax.deleted} tax-deleted{elseif !$tax.active} tax-disabled{/if}">
					<td>
						{assign var=id_box value=taxBox|cat:'_'|cat:$tax.id_tax}
						{assign var=name_box value=taxBox|cat:'['|cat:$tax.id_tax|cat:']'}
						{$tax.id_tax|escape:'htmlall':'UTF-8'}
					</td>
					<td><label for="{$id_box|escape:'htmlall':'UTF-8'}" class="t">{$tax.name|escape:'htmlall':'UTF-8'}</label></td>
					<td><label class="t">
						{l s='Used by' mod='neotaxesupdater'} <strong>{$tax.nb_use_product|escape:'htmlall':'UTF-8'}</strong> {if $tax.nb_use_product > 1}{l s='products' mod='neotaxesupdater'}{else}{l s='product' mod='neotaxesupdater'}{/if}
						{l s='and' mod='neotaxesupdater'} <strong>{$tax.nb_use_carrier|escape:'htmlall':'UTF-8'}</strong> {if $tax.nb_use_carrier > 1}{l s='carriers' mod='neotaxesupdater'}{else}{l s='carrier' mod='neotaxesupdater'}{/if}
						{l s='and' mod='neotaxesupdater'} <strong>{$tax.nb_use_taxrule|escape:'htmlall':'UTF-8'}</strong> {if $tax.nb_use_taxrule > 1}{l s='taxes rules' mod='neotaxesupdater'}{else}{l s='tax rule' mod='neotaxesupdater'}{/if}
						{l s='and' mod='neotaxesupdater'} <strong>{$tax.nb_use_order|escape:'htmlall':'UTF-8'}</strong> {if $tax.nb_use_order > 1}{l s='orders' mod='neotaxesupdater'}{else}{l s='order' mod='neotaxesupdater'}{/if}
						</label></td>
					<td><label class="t">{$tax.rate|escape:'htmlall':'UTF-8'} %</label></td>
					<td>
						{if $tax.deleted}
							{l s='This tax is archived' mod='neotaxesupdater'}
						{elseif !$tax.active}
							{l s='This tax is disabled' mod='neotaxesupdater'}
						{else}
						<input type="text" name="taxBox[{$tax.id_tax|escape:'htmlall':'UTF-8'}]" class="taxBox" id="{$id_box|escape:'htmlall':'UTF-8'}" value="{if isset($fields_value[$name_box])}{$fields_value[$name_box]|escape:'htmlall':'UTF-8'}{/if}"/>
						{/if}
					</td>
				</tr>
			{/foreach}
		</table>
		{else}
		<p>{l s='No tax created' mod='neotaxesupdater'}</p>
		{/if}
    {/if}

{/block}

{block name="after"}
	<script type="text/javascript">
	function runClock(stime) {
		
		today = new Date(stime);
		years = today.getFullYear();
		months = today.getMonth()+1;
		days = today.getDate();
		hours = today.getHours();
		minutes = today.getMinutes();
		seconds = today.getSeconds();
		timeValue = years;
		timeValue += ((months < 10) ? "-0" : "-") + months;
		timeValue += ((days < 10) ? "-0" : "-") + days;
		timeValue += ' '+hours;
		timeValue += ((minutes < 10) ? ":0" : ":") + minutes;
		timeValue += ((seconds < 10) ? ":0" : ":") + seconds;
		$('#serverTime').val(timeValue);
		stime+=1000;
		timerID = setTimeout(function(){
					runClock(stime);
		},1000);
		timerRunning = true;
	}
	runClock({$serverDateTime|escape:'htmlall':'UTF-8'});
	
	function updateCronMethod(ob) {
	
		var radoption = ob.parent().find(":checked").val();

		if(radoption==1) {
			$('#fieldset_1').slideUp();
			$('#fieldset_2').slideDown();
		}
		else {
			$('#fieldset_1').slideDown();
			$('#fieldset_2').slideUp();
		}
	
	}

	function updateTaxBehavior(ob) {

		var slowarn = ob.parent().find(":checked").val();

		if(slowarn==1 && $('#slow-server-warning').text()!='' ) {
			$('#slow-server-warning').css({
				'visibility':'visible',
				'position':'static'
				}).slideDown();
		}
		else {
			$('#slow-server-warning').slideUp();
		}

	}

	$(document).ready(function() {
		if ($(".datepicker").length > 0)
			$('.datepicker').datepicker({
				prevText: '',
				nextText: '',
				dateFormat: 'yy-mm-dd 00:00:00'
			});

		$('INPUT[name=cronmethod]').change(function(){
			updateCronMethod($(this));
		});
		
		$('INPUT[name=taxbehavior]').change(function(){
			updateTaxBehavior($(this));
		});
		
		updateCronMethod($('INPUT[name=cronmethod]'));
		updateTaxBehavior($('INPUT[name=taxbehavior]'));
	});
	</script>
{/block}
