<?php

include_once(dirname(__FILE__).'/../../../config/config.inc.php');

/*
*  2013 Neovis : Michael Jegou & Vasseur Alexandre
*
*  @author VASSEUR ALEXANDRE <tech@neovis.fr>
*  @author MJ <tech@neovis.fr>
*  @copyright  2013 Neovis
*  @license    not free
*  International Registered Trademark & Property of Neovis
*/


if (!in_array('HelperForm', get_declared_classes()))
{	/* for security reasons */

	class HelperForm
	{ /* Version light du helperForm pour version 1.4 */

		public $tpl_vars = null;
		public $title = null;
		public $currentIndex = null;
		public $token = null;
		public $toolbar_scroll = null;
		public $default_form_language = null;
		public $allow_employee_form_lang = null;
		public $fields_value = null;
		public $toolbar_btn = null;
		public $submit_action = null;
		public $base_folder = null;

		public $module_object = null;

		public function includeDatepickerHeaders()
		{	// id can be a identifier or an array of identifiers
			$return = '<script type="text/javascript" src="'.__PS_BASE_URI__.'js/jquery/jquery-ui-1.8.10.custom.min.js"></script>';
			$iso = Db::getInstance()->getValue('SELECT iso_code FROM '._DB_PREFIX_.'lang WHERE `id_lang` = '.(int)Context::getContext()->language->id);
			if ($iso != 'en')
				$return .= '<script type="text/javascript"';
				$return .= ' src="'.__PS_BASE_URI__.'js/jquery/datepicker/ui/i18n/ui.datepicker-'.Tools::htmlentitiesUTF8($iso).'.js"></script>';
			return $return;
		}

		public function setModuleObject(&$module_object)
		{
			$this->module_object = $module_object;
		}

		public function l($text)
		{
			return $this->module_object->l($text, 'form');
		}

		public function getModuleUrl()
		{
			return AdminController::$currentIndex.'&configure='.$this->module_object->name.'&token='.TVAUpdater::getAdminTokenLite('AdminModules');
		}

		public function addCss($file)
		{
			return '<link rel="stylesheet" type="text/css" href="'.$file.'" />';
		}

		public function generateForm($fields_forms)
		{
			$output = $this->addCss(_MODULE_DIR_.'neotaxesupdater/css/admin.css');

			$output .= '
			<form action="'.Tools::safeOutput($this->getModuleUrl()).'" method="post" id="neotaxesupdaterfromconfig">';

			$output .= '<fieldset><legend><img src="'.$fields_forms[0]['form']['legend']['image'].'" alt="" title="" />';
			$output .= $fields_forms[0]['form']['legend']['title'].'</legend>';

			foreach ($fields_forms as $fieldid => $fields_form)
			{
				$output .= '<div id="fieldset_choice_'.$fieldid.'">';

				foreach ($fields_form['form']['input'] as $fields_form_inputs)
				{
					if (isset($fields_form_inputs['label']))
						$output .= '<label>'.$fields_form_inputs['label'].'</label>';

					$output .= '<div class="margin-form">';

					switch ($fields_form_inputs['type'])
					{
						case 'date' :	$fields_form_inputs['class'] = (isset($fields_form_inputs['class'])?$fields_form_inputs['class']:'').' datepicker';

						case 'text' :
						$output .= '<input type="text" name="'.$fields_form_inputs['name'].'"'.
									(isset($this->fields_value[$fields_form_inputs['name']])?' value="'.$this->fields_value[$fields_form_inputs['name']].'"':'').
									(isset($fields_form_inputs['disabled'])?' disabled="disabled"':'').
									(isset($fields_form_inputs['id'])?' id="'.$fields_form_inputs['id'].'"':'').
									(isset($fields_form_inputs['class'])?' class="'.$fields_form_inputs['class'].'"':'').
									(isset($fields_form_inputs['size'])?' size="'.($fields_form_inputs['size'] > 90?90:$fields_form_inputs['size']).'"':'').
									' />';
						break;

						case 'radio' :
						foreach ($fields_form_inputs['values'] as $radiovalue)
						{
							$output .= '<input type="radio" name="'.$fields_form_inputs['name'].'"'.
											(isset($radiovalue['id'])?' id="'.$radiovalue['id'].'"':'').
											(isset($fields_form_inputs['class'])?' class="'.$fields_form_inputs['class'].'"':'').
											((isset($this->fields_value[$fields_form_inputs['name']])
											&& $this->fields_value[$fields_form_inputs['name']] == $radiovalue['value'])?' checked="checked"':'').
											' value="'.$radiovalue['value'].'"> '.$radiovalue['label'].' </input> &nbsp; ';
						}
						break;

						case 'tax' :
						if (isset($fields_form_inputs['values']) && count($fields_form_inputs['values']))
						{
							$output .= '<table cellspacing="0" cellpadding="0" class="table" style="width:100%;">
										<tr>
											<th>'.$this->l('ID').'</th>
											<th>'.$this->l('Taxes name').'</th>
											<th>'.$this->l('Taxes usage').'</th>
											<th>'.$this->l('Current taxes rate').'</th>
											<th>'.$this->l('New taxes rate').'</th>
										</tr>';

							foreach ($fields_form_inputs['values'] as $key => $tax)
							{
								$output .= '<tr class="'.($key % 2?'alt_row':'').($tax['deleted'] == 1?' tax-deleted':'').($tax['active'] == 0?' tax-disabled':'').'">';
								$output .= '	<td>
										'.$tax['id_tax'].'
									</td>
									<td><label'.(isset($fields_form_inputs['class'])?' class="'.$fields_form_inputs['class'].'"':'').'>'.$tax['name'].'</label></td>
									<td><label'.(isset($fields_form_inputs['class'])?' class="'.$fields_form_inputs['class'].'"':'').'>'.
										$this->l('Used by').' <strong>'.$tax['nb_use_product'].'</strong> '.
										($tax['nb_use_product'] > 1?$this->l('products'):$this->l('product')).'<br/>'.
										$this->l('and').' <strong>'.$tax['nb_use_carrier'].'</strong> '.
										($tax['nb_use_carrier'] > 1?$this->l('carriers'):$this->l('carrier')).'<br/>'.
										$this->l('and').' <strong>'.$tax['nb_use_taxrule'].'</strong> '.
										($tax['nb_use_taxrule'] > 1?$this->l('taxes rules'):$this->l('tax rule')).'<br/>'.
										$this->l('and').' <strong>'.($tax['nb_use_order'] > 1?'~ ':'').$tax['nb_use_order'].'</strong> '.
										($tax['nb_use_order'] > 1?$this->l('orders'):$this->l('order')).
										'</label></td>
									<td><label'.(isset($fields_form_inputs['class'])?' class="'.$fields_form_inputs['class'].'"':'').'>'.$tax['rate'].' %</label></td>
									<td>';

								if ($tax['deleted'] == 1)
									$output .= ''.$this->l('This tax is archived').'';

								elseif ($tax['active'] == 0)
									$output .= ''.$this->l('This tax is disabled').'';

								else {
									$output .= '<input type="text" name="taxBox['.$tax['id_tax'].']" class="taxBox" id="taxBox_'.$tax['id_tax'].'" ';
									$output .= (isset($this->fields_value['taxBox['.$tax['id_tax'].']'])?' value="'.$this->fields_value['taxBox['.$tax['id_tax'].']'].'"':'');
									$output .= '/>';
								}
								$output .= '
									</td>
								</tr>';
							}
							$output .= '</table>';

						}
						else
							$output .= '<p>'.$this->l('No tax created').'</p>';
						break;
					}

					if (isset($fields_form_inputs['desc']))
						$output .= '<p class="clear">'.$fields_form_inputs['desc'].'</p>';

					$output .= '</div>';

				}

				$output .= '</div>';

			}

			if (isset($fields_forms[0]['form']['submit']))
				$output .= '<center><input type="submit"
									value="'.$fields_forms[0]['form']['submit']['title'].'"
									name="'.$fields_forms[0]['form']['submit']['name'].'"
									class="button" /></center>';

			$output .= '</fieldset><br/>';

			$output .= $this->includeDatepickerHeaders();

			// Add action bar here!
			if (is_array($this->toolbar_btn) && $this->toolbar_btn > 0)
			{

				$output .= '<fieldset class="neoadm-toolbar-v14"><div class="toolbarBox"><ul>';

				foreach ($this->toolbar_btn as $button_name => $button_infos)
				{
					if ($button_name != 'save') // hide save button
					$output .= '<li>
							<a title="'.$button_infos['desc'].'"
							 href="'.$button_infos['href'].'"'.
							(isset($button_infos['target'])?' target="'.$button_infos['target'].'"':'').
							(isset($button_infos['js'])?' onclick="'.$button_infos['js'].'"':'').
							' class="toolbar_btn" id="desc--'.$button_infos['imgclass'].'">
								<span class="process-icon-'.$button_infos['imgclass'].' "></span>
								<div>'.$button_infos['desc'].'</div>
							</a>
							</li>';
				}

				$output .= '
						</ul></div></fieldset><br/>';
			}

			$output .= '
			</form>
		<script type="text/javascript">
		function runClock(stime) {

			today = new Date(stime);
			years = today.getFullYear();
			months = today.getMonth()+1;
			days = today.getDate();
			hours = today.getHours();
			minutes = today.getMinutes();
			seconds = today.getSeconds();
			timeValue = years;
			timeValue += ((months < 10) ? "-0" : "-") + months;
			timeValue += ((days < 10) ? "-0" : "-") + days;
			timeValue += \' \'+hours;
			timeValue += ((minutes < 10) ? ":0" : ":") + minutes;
			timeValue += ((seconds < 10) ? ":0" : ":") + seconds;
			$(\'#serverTime\').val(timeValue);
			stime+=1000;
			timerID = setTimeout(function(){
						runClock(stime);
			},1000);
			timerRunning = true;
		}
		runClock('.$this->tpl_vars['serverDateTime'].');

		function updateCronMethod(ob) {

			var radoption = ob.parent().find(":checked").val();

			if (radoption == 1) {
				$(\'#fieldset_choice_1\').slideUp();
				$(\'#fieldset_choice_2\').slideDown();
			}
			else {
				$(\'#fieldset_choice_1\').slideDown();
				$(\'#fieldset_choice_2\').slideUp();
			}

		}

		function updateTaxBehavior(ob) {

			var slowarn = ob.parent().find(":checked").val();

			if (slowarn == 1 && $("#slow-server-warning").text() != "" ) {
				$("#slow-server-warning").css({
					"visibility":"visible",
					"position":"static"
					}).slideDown();
			}
			else {
				$("#slow-server-warning").slideUp();
			}

		}

		$(document).ready(function() {
			if ($(".datepicker").length > 0)
				$(".datepicker").datepicker({
					prevText: "",
					nextText: "",
					dateFormat: "yy-mm-dd 00:00:00"
				});

			$("INPUT[name=cronmethod]").change(function(){
				updateCronMethod($(this));
			});

			$("INPUT[name=taxbehavior]").change(function(){
				updateTaxBehavior($(this));
			});

			updateCronMethod($("INPUT[name=cronmethod]"));
			updateTaxBehavior($("INPUT[name=taxbehavior]"));

			$(".toolbarBox").find(".neo-bt-saverun").parent().click(function(e){
					e.preventDefault();
					$("#neotaxesupdaterfromconfig").append("<input type=\"hidden\" name=\"saveConfig\" value=\"1\"/>"+
					"<input type=\"hidden\" name=\"saveConfigAndStay\" value=\"1\"/>")
					$("#neotaxesupdaterfromconfig").submit();
				});

		});
		</script>
			';

			return $output;
		}
	}
}

if (!in_array('AdminController', get_declared_classes()))
{
	class AdminController
	{
		static public $currentIndex = 'index.php?tab=AdminModules';
	}
}
