<?php

/*
 * Réalisé par Webbax
 * http://www.webbax.ch
 * contact@webbax.ch
 * Gestion inventaire export/import
 */

/* Correctifs
 * V0.2 | 05.04.11 - Correction de la sélection des produits via les catégories
 */

class Inventory extends Module{

    private $_html = '';
    private $_postErrors = array();

    private $line = array();
    private $line_combinaison = array();
    private $file = array();

    public function __construct(){
        $this->name = 'inventory';
        $this->tab = 'Webbax';
        $this->version = '0.2';
        parent::__construct();

        $this->displayName = $this->l('Inventory');
        $this->description = $this->l('Permet de mettre à jour l\'ensemble de votre stock de manière optimale');
        $this->description .= '<br/><span style="font-weight:bold;">'.$this->l('Module réalisé par').'&nbsp;<a href="http://www.webbax.ch/" class="action_module" target="_blank">'.$this->l('www.webbax.ch').'</span></a>';
        $this->confirmUninstall = $this->l('Etes-vous sûr ?');
    }

    /*
     * Installe le module
     * @param   -
     * @return  -
    */
    public function install(){
        if(!parent::install())
            return false;
        return $this->registerHook('home');
    }

    /*
     * Désinstalle le module
     * @param   -
     * @return  -
    */
    public function uninstall(){
        if(!parent::uninstall())
            return false;
        return true;
    }

    /*
     * Valide le formulaire
     * @param   -
     * @return  -
    */
    private function _postValidation(){}

    /*
     * Export les articles
     * @param   -
     * @return  -
    */
    private function _postProcess(){
        if(isset($_POST['btnSubmit'])){
            if($_POST['form_mode']=='export_csv'){

                $filename = 'inventory';
                $secondhand = 0;

                $link_file = $this->getHttpHost().__PS_BASE_URI__.'modules/'.$this->name.'/downloads/'.$filename.'.csv';
                $message =  $this->l('Opération effectuée').'<br/>'.
                            '<br/>'.$this->l('Lien vers le fichier catalogue').' : <br/>
                            <a href="'.$link_file.'" target="_blank"><img src="../modules/'.$this->name.'/link_file.png"/> '.$link_file.'</a><br/>
                            <a href="../modules/'.$this->name.'/downloads/download.php?file='.$filename.'"><img src="../modules/'.$this->name.'/save.png"/> '.$this->l('Télécharger le fichier').'</a>';

                $file = array();
                $export_combination = $_POST['export_combination'];
                $categories_selected = @$_POST['categories'];
                if(!is_array($categories_selected)){$categories_selected=array();}
                $languages = $_POST['languages'];
            
                $rewriting_settings = Configuration::get('PS_REWRITING_SETTINGS');
                $id_currency = Configuration::get('PS_CURRENCY_DEFAULT');

                // récupère l'id de la monnaie EUR
                $currencies = Currency::getCurrencies();
                foreach($currencies as $currency){
                    if($currency['iso_code']=='EUR'){
                        $id_currency = $currency['id_currency'];
                    }
                }
                global $cookie;
                $cookie->id_currency = $id_currency;
                // Code iso monnaie
                $Currency = new Currency($id_currency);
                $currency = $Currency->getFields();
                $currency_iso_code = $currency['iso_code'];

                // Sélectionne la liste des catégories produit
                $sql = 'SELECT id_category FROM '._DB_PREFIX_.'category c
                        WHERE c.`id_parent` != "0"';
                $categories = Db::getInstance()->ExecuteS($sql);

                // Crée l'entête du fichier
                $this->line = array(); // vide la ligne
                $this->build_line(0,'');
                $this->build_line(1,'categorie');
                $this->build_line(2,'id_product');
                $this->build_line(3,'supplier_reference');
                $this->build_line(4,'nom');
                $this->build_line(5,'qte_en_stock');
                $this->build_line(6,'prix');
                $this->build_line(7,'ean13');
                $this->build_line(8,'id_product_attribute');
                $this->file[] = $this->line;

                // Parcourt la langue
                foreach($languages as $id_lang){

                    // Parcourt les catégorie
                    foreach($categories as $id_cat){

                        $id_cat = $id_cat['id_category'];
                        if(in_array($id_cat,$categories_selected)){ // si la catégorie est sélectionnée

                            $Category = new Category($id_cat,$id_lang);
                            $sql = 'SELECT * FROM '._DB_PREFIX_.'product p
                                    LEFT JOIN `'._DB_PREFIX_.'product_lang` pl
                                    ON p.`id_product` = pl.`id_product`
                                    LEFT JOIN `'._DB_PREFIX_.'category_product` cp
                                    ON p.`id_product` = cp.`id_product`
                                    WHERE cp.`id_category` = '.$id_cat.'
                                    AND pl.`id_lang` = '.$id_lang.'
                                    AND active = 1';
                            $products = Db::getInstance()->ExecuteS($sql);

                            foreach($products as $product){

                                // lignes de produits
                                $Product = new Product($product['id_product']);
                                $this->line = array(); // vide la ligne
                                $this->build_line(0,'');
                                    $category_name_and_sub_category = $this->sanitize(Tools::getPath(intval($Category->id),$Category->name));
                                $this->build_line(1,$category_name_and_sub_category);
                                $this->build_line(2,$product['id_product']);
                                $this->build_line(3,$product['supplier_reference']);
                                $this->build_line(4,str_replace(',',' ',$product['name']));
                                   $price = round($Product->getPrice(),2);
                                $this->build_line(5,$product['quantity']);
                                $this->build_line(6,$price);
                                $this->build_line(7,$product['ean13']);
                                $this->build_line(8,'');

                                // si on ne veut pas des combinaisons
                                if(!$export_combination){$product_has_attributes = 0;}else{$product_has_attributes = $Product->hasAttributes();}
                                // lignes de déclinaison
                                $combArray = array(); // création d'un array avec les combinaisons
                                if($product_has_attributes>0){
                                    $combinaisons = $Product->getAttributeCombinaisons($id_lang);
                                    if(is_array($combinaisons)){
                                        foreach($combinaisons AS $k => $combinaison){
                                            $combArray[$combinaison['id_product_attribute']]['id_product_attribute'] = $combinaison['id_product_attribute'];
                                            $combArray[$combinaison['id_product_attribute']]['price'] = $combinaison['price'];
                                            $combArray[$combinaison['id_product_attribute']]['weight'] = $combinaison['weight'];
                                            $combArray[$combinaison['id_product_attribute']]['quantity'] = $combinaison['quantity'];
                                            $combArray[$combinaison['id_product_attribute']]['reference'] = $combinaison['reference'];
                                            $combArray[$combinaison['id_product_attribute']]['supplier_reference'] = $combinaison['supplier_reference'];
                                            $combArray[$combinaison['id_product_attribute']]['ean13'] = $combinaison['ean13'];
                                            $combArray[$combinaison['id_product_attribute']]['id_image'] = isset($combinationImages[$combinaison['id_product_attribute']][0]['id_image']) ? $combinationImages[$combinaison['id_product_attribute']][0]['id_image'] : 0;
                                            $combArray[$combinaison['id_product_attribute']]['ecotax'] = $combinaison['ecotax'];
                                            $combArray[$combinaison['id_product_attribute']]['price'] = $combinaison['price'];
                                            $combArray[$combinaison['id_product_attribute']]['attributes'][] = array($combinaison['group_name'], $combinaison['attribute_name'], $combinaison['id_attribute']);
                                        }
                                    }
                                    if(isset($combArray)){

                                        // Crée la description de la déclinaison
                                        foreach($combArray AS $id_product_attribute => $product_attribute){
                                            $list = '';
                                            foreach($product_attribute['attributes'] AS $attribute){
                                                $list .= addslashes(htmlspecialchars($attribute[0])).' - '.addslashes(htmlspecialchars($attribute[1])).', ';
                                            }
                                            $list = rtrim($list,', '); // description
                                            $this->line_combination = array(); // vide la ligne

                                            $this->build_line_combination(0,'');
                                            $this->build_line_combination(1,$category_name_and_sub_category);
                                            $this->build_line_combination(2,$product['id_product'].'-'.$product_attribute['id_product_attribute']);
                                            $this->build_line_combination(3,$product_attribute['reference']);
                                            $this->build_line_combination(4,str_replace(',',' ',$product['name'].' '.stripslashes($list)));
                                                $price = round($Product->getPrice(true,$product_attribute['id_product_attribute']),2);
                                            $this->build_line_combination(5,$product_attribute['quantity']);
                                            $this->build_line_combination(6,$price);
                                            $this->build_line_combination(7,$product_attribute['ean13']);
                                            $this->build_line_combination(8,$product_attribute['id_product_attribute']);

                                            ksort($this->line_combination); // trie l'array
                                            $this->file[] = $this->line_combination;
                                        }
                                    }
                                }else{
                                    ksort($this->line); // trie l'array
                                    $this->file[] = $this->line; // ajoute une nouvelle ligne au fichier
                                }
                                
                         } // end foreach products
                    } // end if category selected
                  } // end foreach categories
                } // end foreach languages
                $this->create_file($filename,8);
            } // end $_POST
            $this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" />'.$message.'</div>';
        
        }elseif($_POST['form_mode']=='import_csv'){
            $file = false;
            if(isset($_FILES['file']) AND isset($_FILES['file']['tmp_name']) AND !empty($_FILES['file']['tmp_name'])){
                if(!move_uploaded_file($_FILES['file']['tmp_name'], dirname(__FILE__).'/uploads/inventory.csv')){
                    $errors .= $this->l('Error move uploaded file');
                    $this->_html .= '<div class="alert error">'.$this->l('Le fichier n\'a pu être transféré, vérifiez le CHMOD 777 sur le répertoire /modules/'.$this->name.'/upload').'</div>';
                }else{
                    if($_POST['import_csv_mode']==1){ // importation selon structure du .csv exporté
                        // lit le fichier uploadé
                        $row = 1;
                        if(($handle = fopen('../modules/'.$this->name.'/uploads/inventory.csv','r')) !== FALSE){
                            while(($data = fgetcsv($handle, 1000, ",")) !== FALSE){
                                $num = count($data);
                                $row++;
                                for($c=0;$c<$num;$c++){
                                   $fields = explode(';',$data[$c++]);
                                   if($row!=2){ // sauf la ligne de header
                                       @$id_product = $fields[1];
                                       @$quantity = $fields[4];
                                       @$id_product_attribute = $fields[7];
                                       if(empty($id_product_attribute)){ // si c'est un produit standard
                                           Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'product` SET `quantity`="'.$quantity.'" WHERE `id_product`="'.$id_product.'"');
                                       }else{ // si c'est une déclinaison
                                           Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'product_attribute` SET `quantity`="'.$quantity.'" WHERE `id_product_attribute`="'.$id_product_attribute.'"');
                                       }
                                   }else{
                                       // vérifie le bon format de fichier
                                       $err = 0; 
                                       if(@$fields[4]!='qte_en_stock'){
                                          $this->_html .= '<div class="alert error">'.$this->l('Ce fichier n\'est pas structuré correctement').'</div>';
                                          $err = 1;
                                       }
                                   }
                                }
                            }      
                           fclose($handle);
                           if($err==0){
                                $this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" /> '.$this->l('La mise à jour du stock a été effectuée pour').' '.$row.' '.$this->l('produits').'</div>';
                           }
                        }
                    }elseif($_POST['import_csv_mode']==2){ // importation sur 1 colonne avec retours chariots

                        // lit le fichier uploadé
                        $products = array();
                        $f = '../modules/'.$this->name.'/uploads/inventory.csv';
                        $fp = fopen($f,'r');
                        while(!feof($fp)){
                            $prod_key = trim(str_replace(';','',fgets($fp, 1024)));
                            if(!key_exists($prod_key,$products)){
                                $products[$prod_key] = 1; // ajoute le 1er produit
                            }else{
                                $products[$prod_key] = $products[$prod_key]+1; // ajoute un produit de plus pour ce code article
                            }
                        }
                        fclose($fp);
                        
                        // met à jour le stock
                        $p_maj = 0;
                        $import_csv_key = $_POST['import_csv_key'];
                        foreach($products as $prod_key=>$quantity){
                            if($prod_key!='' && $prod_key!=0)
                                if($import_csv_key=='reference'){
                                    Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'product` SET `quantity`="'.$quantity.'" WHERE `reference`="'.$prod_key.'"');
                                    Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'product_attribute` SET `quantity`="'.$quantity.'" WHERE `reference`="'.$prod_key.'"');
                                }elseif($import_csv_key=='ean13'){{
                                    Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'product` SET `quantity`="'.$quantity.'" WHERE `ean13`="'.$prod_key.'"');
                                    Db::getInstance()->Execute('UPDATE `'._DB_PREFIX_.'product_attribute` SET `quantity`="'.$quantity.'" WHERE `ean13`="'.$prod_key.'"');
                                }
                            }
                            $p_maj++;
                        }
                        $this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" /> '.$this->l('La mise à jour du stock a été effectuée pour').' '.$p_maj.' '.$this->l('produits').'</div>';
                    }
                }
            }
        }
    }

    /*
     * Affiche une description du module
     * @param   -
     * @return  -
    */
    private function _displayInventory(){

    }

    /*
     * Affiche le formulaire
     * @param   -
     * @return  -
    */
    private function _displayForm(){

        global $cookie;

        // Crée l'arbre des catégories
        $depth = 0;
        $categTree = Category::getRootCategory()->recurseLiteCategTree($depth);
        function constructTreeNode($node){
            $ret = '<li>'."\n";
            $ret .= '<input type="checkbox" name="categories[]" value="'.$node['id'].'" /> '.$node['name']."\n";
            if(!empty($node['children']))
            {
                $ret .= '<ul style="padding-left:20px">'."\n";
                foreach ($node['children'] AS $child)
                        $ret .= constructTreeNode($child);
                $ret .= '</ul>'."\n";
            }
            $ret .= '</li>'."\n";
            return $ret;
        }

        $ulTree = '<br/><input type="checkbox" class="notchText"/> <i><span class="notchText">Cocher tout</span></i><br/><br/>';
        $ulTree .= '<div class="tree-top">' . $categTree['name'] . '</div>'."\n";
        $ulTree .=  '<ul class="tree">'."\n";
        foreach ($categTree['children'] AS $child)
                $ulTree .= constructTreeNode($child);
        $ulTree .=  '</ul>'."\n";

        // Liste les languages
        $id_lang_default = Configuration::get('PS_LANG_DEFAULT');
        $languages = Language::getLanguages();
        $form_languages = '';
        foreach($languages as $language){
            if($id_lang_default==$language['id_lang']){$checked='checked';}else{$checked='';}
            $form_languages .= ' <img src="../img/l/'.$language['id_lang'].'.jpg"/> <input type="checkbox" name="languages[]" value="'.$language['id_lang'].'" '.$checked.' />';
        }

        $form_combination = '
        <select name="export_combination">
            <option value="1">'.$this->l('Oui').'
            <option value="0" selected>'.$this->l('Non').'
        </select>';

        $this->_html .= '
        <!-- Checkboxtree -->
        <script type="text/javascript" src="../modules/'.$this->name.'/checkboxtree/jquery.min.js"></script>
        <script type="text/javascript" src="../modules/'.$this->name.'/checkboxtree/jquery-ui.min.js"></script>
        <link rel="stylesheet" type="text/css" href="../modules/'.$this->name.'/checkboxtree/jquery-ui-lightness.css">
        <link rel="stylesheet" type="text/css" href="../modules/'.$this->name.'/checkboxtree/jquery.checkboxtree.min.css">
        <script type="text/javascript" src="../modules/'.$this->name.'/checkboxtree/jquery.checkboxtree.min.js"></script>

        <script type="text/javascript">
            $(document).ready(function(){
                // lors du clique sur le guide on affiche le formulaire
                $("input:radio").click(function(){
                    var form_mode;
                    form_mode = $("input[name=form_mode]:checked").val();
                    $(".form_mode").hide();
                    $("#"+form_mode).show();
                });

                // affiche l\'input avancé pour la clé si le choix 2
                $("#import_csv_mode").change(function(){
                    var csv_mode = $("#import_csv_mode").val();
                    if(csv_mode==2){
                        $("#import_csv_key").show();
                    }else{
                        $("#import_csv_key").hide();
                    }
                });
                
                // tree dynamique
                $(".tree").checkboxTree({
                    collapseImage: "../modules/'.$this->name.'/checkboxtree/images/minus.png",
                    expandImage: "../modules/'.$this->name.'/checkboxtree/images/plus.png",
                });
                // cocher/décocher
                $(document).ready(function() {
                $(".notchText").click(function() { // clic sur la case cocher/decocher
                    var cases = $(".tree").find(":checkbox"); // on cherche les checkbox
                    if(this.checked){ // si "notchText" est coché
                        cases.attr("checked", true); // on coche les cases
                         $(".notchText").html("Tout décocher"); // mise à jour du texte de notchText
                    }else{ // si on décoche "notchText"
                        cases.attr("checked", false);// on coche les cases
                    $(".notchText").html("Cocher tout");// mise à jour du texte de notchText
                    }
                });
             });
           });
        </script>

        <fieldset>
            <legend><img src="../img/admin/contact.gif" />'.$this->l('Informations').'</legend>
            <u>'.$this->l('Processus standard').'</u><br/>
            <b>1.</b> '.$this->l('exportez le fichier csv').'<br/>
            <b>2.</b> '.$this->l('modifiez les quantités').'<br/>
            <b>3.</b> '.$this->l('importez le fichier pour mettre à jour le stock').'<br/>
            <br/>
            <u>'.$this->l('Processus industriel').'</u><br/>
            <b>1.</b> '.$this->l('ouvrez un fichier texte').'<br/>
            <b>2.</b> '.$this->l('scannez tous vos produits (référence int. ou ean13) avec votre douchette (avec configuration retour chariot)').'<br/>
            <br/>
            <b>ex :</b> '.$this->l('Un fichier avec ce contenu donnerait 3 produits en stock pour le produit avec le code "1111111" et 2 en stock pour "5555"').'.<br/>
            1111111<br/>
            1111111<br/>
            1111111<br/>
            5555<br/>
            5555<br/>
            <br/>
            <b>3.</b> '.$this->l('importez le fichier texte').'<br/>
        </fieldset>
        <br/>
        <fieldset>
            <legend><img src="../img/admin/contact.gif" />'.$this->l('Détail').'</legend>
            <table border="0" cellpadding="0" cellspacing="0" id="form">
                <tr>
                    <td>'
                        .$this->l('Export CSV').'&nbsp;</td><td><input type="radio" name="form_mode" value="export_csv"/>        
                    </td>
                </tr>
                <tr>
                    <td>'.$this->l('Import CSV/TXT').'&nbsp;</td><td><input type="radio" name="form_mode" value="import_csv"/></td>
                </tr>
            </table>
            
            <hr/>

            <div id="export_csv" class="form_mode" style="display:none;">

                <form action="'.$_SERVER['REQUEST_URI'].'" method="post">
                    <input type="hidden" name="form_mode" value="export_csv"/>
                    <h2>'.$this->l('Export CSV').'</h2>
                    <hr/>
                    '.$this->l('Exporter en').' '.$form_languages.'
                    <hr/>
                    <table>
                        <tr><td>'.$this->l('Exporter les déclinaisons').'</td><td>'.$form_combination.'</td></tr>
                    </table>
                    <hr/>
                    <b>'.$this->l('Catégories').'</b><br/>
                    '.$ulTree.'
                    <hr/>
                    <input class="button" name="btnSubmit" value="'.$this->l('Exporter').'" type="submit" />
                </form>
           </div>

           <div id="import_csv" class="form_mode" style="display:none;">
                <form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
                <input type="hidden" name="form_mode" value="import_csv"/>
                <table>
                    <tr>
                        <td>'.$this->l('Mode d\'importation').'</td><td>
                            <select id="import_csv_mode" name="import_csv_mode">
                                <option value="1">'.$this->l('Basé sur le fichier exporté (csv)').'
                                <option value="2">'.$this->l('Basé sur 1 colonne avec retour chariot (txt)').'
                            </select>
                            <div id="import_csv_key" style="display:none;">'
                                .$this->l('Colonne').' =
                                <select name="import_csv_key">
                                    <option value="reference">'.$this->l('Code "reference"').'
                                    <option value="ean13">'.$this->l('Code "ean13"').'
                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td>'.$this->l('Sélectionnez le fichier').'</td><td><input id="file" type="file" name="file" /></td>
                    </tr>
                    <tr>
                        <td></td><td><input class="button" type="submit" name="submitAdd" value="'.$this->l('Mettre à jour le stock').'"/></td>
                    </tr>
                </table>
            </form>
          </div>
          </fieldset>';
    }

    /*
     * Lance l'affichage du module
     * @param   -
     * @return  -
    */
    public function getContent(){
        $this->_html = '<h2>'.$this->displayName.'</h2>';
        if(!empty($_POST)){
            $this->_postValidation();
            if(!sizeof($this->_postErrors))
                $this->_postProcess();
            else
                foreach ($this->_postErrors AS $err)
                $this->_html .= '<div class="alert error">'. $err .'</div>';
        }
        else
            $this->_html .= '';

        $this->_displayInventory();
        $this->_displayForm();
        return $this->_html;
    }

    /*
     * Ajoute une ligne d'article
     * @param int (position du champ sur la ligne)
     * @param string (valeur)
     * @return -
     */
    private function build_line($pos,$val){
        if($pos!=0 && !empty($pos)){
            $this->line[$pos] = $val;
        }
    }

    /*
     * Ajoute une ligne  de combinaison
     * @param int (position du champ sur la ligne)
     * @param string (valeur)
     * @return -
     */
    private function build_line_combination($pos,$val){
        if($pos!=0 && !empty($pos)){
            $this->line_combination[$pos] = $val;
        }
    }

    /*
     * Crée le fichier avec le contenu
     * @param string (nom du fichier)
     * @param int (no du dernier champ)
     * @return -
     */
    private function create_file($filename,$last_field){

      $file_content = '';
      $separator = ';';
      
      foreach($this->file as $line){
            foreach($line as $key=>$field){

              if($last_field==$key){
                 //$field = substr(chr(255).chr(254).mb_convert_encoding($field, "UTF-16LE", "UTF-8"),2); // encodage pour le csv
                 $file_content.=$field."\r\n";
              }else{
                 //$field = substr(chr(255).chr(254).mb_convert_encoding($field, "UTF-16LE", "UTF-8"),2); // encodage pour le csv
                 $file_content.=$field.$separator;
              }
            }

            $f_csv= fopen(dirname(__FILE__).'/downloads/'.$filename.'.csv','w+');
            fwrite($f_csv,$file_content);
            
            if(!$f_csv){
                $this->_html = '<div class="alert error">'.$this->l('Erreur de création du fichier. Vérifiez que le répertoire "/modules/'.$this->name.'/downloads/" est bien en CHMOD 777').'</div>';
            }
        }
    }

    /*
     * Nettoie la chaine
     * @param string (chaine)
     * @return string
     */
    public function sanitize($string){
        $string = Tools::htmlentitiesDecodeUTF8($string);
        $string = strip_tags($string);
        $string = str_replace(CHR(13).CHR(10),"",$string); // enlève les retours chariot
        $string = preg_replace('/<br\\s*?\/??>/i','', $string);
        return $string;
    }

    /*
     * Trouve l'Host ! // http pour tous les cas
     * @return string (host)
     */
    private function getHttpHost(){
        $host = $_SERVER['HTTP_HOST'];
        $host = 'http://'.$host;
        return $host;
    }

    /*
     * Pour debug var/array
     * @param var/array
     * @return -
     */
    public function debug($var){
        echo '<pre>';
        print_r($var);
        echo '</pre>';
    }

}
