<?php
/*
* 2007-2013 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2013 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class HomeFeatured2 extends Module
{
	private $_html = '';
	private $_postErrors = array();

	function __construct()
	{
		$this->name = 'homefeatured2';
		$this->tab = version_compare(_PS_VERSION_, '1.4.0.0', '<') ? 'Mediacom87' : 'front_office_features';
		$this->version = '1.0.3';
		$this->author = 'Mediacom87';
		$this->need_instance = 0;

		parent::__construct();

		$this->displayName = $this->l('Random Featured products on the homepage.');
		$this->description = $this->l('Displays featured products in the middle of your homepage and choose to random it');
	}

	function install()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
		{
			if (!Configuration::updateValue('HOME_FEATURED_NBR2', 8)
				|| !Configuration::updateValue('HOME_FEATURED_RANDOM', 0)
				|| !parent::install()
				|| !$this->registerHook('displayHome')
				|| !$this->registerHook('header')
			)
				return false;
		} else {
			if (!Configuration::updateValue('HOME_FEATURED_NBR2', 8)
				|| !Configuration::updateValue('HOME_FEATURED_RANDOM', 0)
				|| !parent::install()
				|| !$this->registerHook('home')
			)
				return false;
		}
		return true;
	}

	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitHomeFeatured'))
		{
			$nbr = (int)(Tools::getValue('nbr'));
			if (!$nbr OR $nbr <= 0 OR !Validate::isInt($nbr))
				$errors[] = $this->l('An invalid number of products has been specified.');
			else
				Configuration::updateValue('HOME_FEATURED_NBR2', (int)($nbr));
				
			Configuration::updateValue('HOME_FEATURED_RANDOM', (bool)Tools::getValue('HOME_FEATURED_RANDOM'));
			
			if (isset($errors) AND sizeof($errors))
				$output .= $this->displayError(implode('<br />', $errors));
			else
				$output .= $this->displayConfirmation($this->l('Your settings have been updated.'));
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		$output = '
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
				<p>'.$this->l('To add products to your homepage, simply add them to the "home" category.').'</p><br />
				<label>'.$this->l('Define the number of products to be displayed.').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="nbr" value="'.Tools::safeOutput(Tools::getValue('nbr', (int)(Configuration::get('HOME_FEATURED_NBR2')))).'" />
					<p class="clear">'.$this->l('Define the number of products that you would like to display on homepage (default: 10).').'</p>

				</div>
				<label>'.$this->l('Random ?').'</label>
				<div class="margin-form">
					'.$this->_radioButton('HOME_FEATURED_RANDOM').'
				</div>
				<center><input type="submit" name="submitHomeFeatured" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
			<fieldset class="space">
					<legend>'.$this->l('Donation').'</legend>
					<p><a href="http://www.mediacom87.fr/?utm_source=module&utm_medium=cpc&utm_campaign='.$this->name.'" target="_blank" title="'.$this->l('Mediacom87 WebAgency').'">'.$this->l('This module was developed and generously offered to the PrestaShop\'s community by Mediacom87 WebAgency specializing in supporting eCommerce.').'</a></p>
					<p><a href="http://www.mediacom87.fr/?utm_source=module&utm_medium=cpc&utm_campaign='.$this->name.'" target="_blank" title="'.$this->l('Mediacom87 WebAgency').'">'.$this->l('If you want to support the Mediacom87\'s process, you can do so by making a donation.').'</a></p>
					<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_top">
						<input type="hidden" name="cmd" value="_s-xclick">
						<input type="hidden" name="hosted_button_id" value="NVSM78UX5UZFL">
						<input type="image" src="https://www.paypalobjects.com/fr_FR/FR/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="">
						<img alt="" border="0" src="https://www.paypalobjects.com/fr_FR/i/scr/pixel.gif" width="1" height="1">
					</form>

			</fieldset>
			
			<fieldset class="space">
					<legend>'.$this->l('Ads').'</legend>
					<p><a href="http://www.mediacom87.fr/?utm_source=module&utm_medium=cpc&utm_campaign='.$this->name.'" target="_blank" title="'.$this->l('Mediacom87 WebAgency').'">'.$this->l('You can also support our agency by clicking the advertising below').'.</a></p>
					<p style="text-align:center"><script type="text/javascript"><!--
					google_ad_client = "ca-pub-1663608442612102";
					/* Gratuit - homefeatured2 728x90 */
					google_ad_slot = "3680087553";
					google_ad_width = 728;
					google_ad_height = 90;
					//-->
					</script>
					<script type="text/javascript"
					src="http://pagead2.googlesyndication.com/pagead/show_ads.js">
					</script></p>
			</fieldset>
		</form>';
		return $output;
	}

	public function hookDisplayHeader($params)
	{
		$this->hookHeader($params);
	}

	public function hookHeader($params)
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$this->context->controller->addCSS(($this->_path).'css/homefeatured15.css', 'all');
	}

	function hookHome($params)
	{
		global $smarty;
		
		if (version_compare(_PS_VERSION_, '1.4.0.0', '>='))
		{
			$category = new Category(1, (int)Configuration::get('PS_LANG_DEFAULT'));
			$nb = Configuration::get('HOME_FEATURED_NBR2');
			if (Configuration::get('HOME_FEATURED_RANDOM'))
				$random = true;
			else
				$random = false;
	
			$smarty->assign(array(
				'products' => $category->getProducts((int)$params['cookie']->id_lang, 1, ($nb ? $nb : 10),null,null,false,true,$random,($nb ? $nb : 10)),
				'add_prod_display' => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
				'homeSize' => Image::getSize('home')
			));
	
			return $this->display(__FILE__, 'views/templates/hook/14/homefeatured.tpl');
		} else{
			$category = new Category(1);
			$nb = (int)Configuration::get('HOME_FEATURED_NBR');
			if (Configuration::get('HOME_FEATURED_RANDOM'))
				$random = true;
			else
				$random = false;
			$smarty->assign(array(
				'products' => $category->getProducts((int)$params['cookie']->id_lang, 1, ($nb ? $nb : 10),null,null,false,true,$random,($nb ? $nb : 10)),
				'homeSize' => Image::getSize('home')
			));
	
			return $this->display(__FILE__, 'views/templates/hook/13/homefeatured.tpl');
		}
	}

	public function hookDisplayHome($params)
	{
		$category = new Category(Context::getContext()->shop->getCategory(), (int)Context::getContext()->language->id);
		$nb = Configuration::get('HOME_FEATURED_NBR2');
		if (Configuration::get('HOME_FEATURED_RANDOM'))
			$random = true;
		else
			$random = false;
		$products = $category->getProducts((int)Context::getContext()->language->id, 1, ($nb ? $nb : 10),null,null,false,true,$random,($nb ? $nb : 10));

		$this->smarty->assign(array(
			'products' => $products,
			'add_prod_display' => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
			'homeSize' => Image::getSize(ImageType::getFormatedName('home')),
		));

		return $this->display(__FILE__, 'homefeatured.tpl');
	}
	
	function _radioButton($sauv)
	{
		$output = '
			<input type="radio" name="'.$sauv.'" id="'.$sauv.'_on" value="1" '.(Configuration::get($sauv) ? 'checked="checked" ' : '').'/>
			<label class="t" for="'.$sauv.'_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
			<input type="radio" name="'.$sauv.'" id="'.$sauv.'_off" value="0" '.(!Configuration::get($sauv) ? 'checked="checked" ' : '').'/>
			<label class="t" for="'.$sauv.'_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
		';
		return $output;
	}
}
