<?php
require('updateTools.php');
require('updateIO.php');
require('pclzip.lib.php');

class updateStep {
	public $moduleDir;
	public $tools;

	function __construct($moduleDir) {
		$this->moduleDir = $moduleDir;
		updateTools::init($moduleDir);
	}

	// Steps


	function downloadPrestashop() {
		global $URL, $_PS_VERSION_NEW_;
		$result = array();
		updateTools::log_message("main\tDownload version ".$_PS_VERSION_NEW_);
		
		$filename = $this->moduleDir.DS.'latest.zip';
		if (file_exists($filename))
			@updateIO::unlinkFTP($filename);
		if (@updateIO::copyCurl($URL, $filename)) {
			@chmod($filename, 0777);
			$result['nextStep'] = 'extractPrestashop';
			$result['error'] = 0;
			$result['information'] = updateTools::l('Extract files...');
		} else {
			$error = error_get_last();
			$result['nextStep'] = 'error';
			$result['error'] = -1;
			$result['information'] = updateTools::l('Can not download the latest version').'<br/>'.$error['message'];
		}

		return $result;
	}

	function extractPrestashop() {
		$result = array();
		$dir = $this->moduleDir.DS.'latest';
		$filename = $this->moduleDir.DS.'latest.zip';

		if (file_exists($dir))
			updateIO::rrmdir($dir);
			
		updateTools::log_message("main\tExtract ".$filename.' to '.$dir);
        $archive = new PclZip($filename);
			
		if (!file_exists($dir)
			&& !updateIO::mkdirFTP($dir)) {
			$error = error_get_last();
            $result['nextStep'] = 'error';
            $result['error'] = 1;
            $result['information'] = $error['message'];
		}
        elseif ($archive->extract(PCLZIP_OPT_PATH, $dir, PCLZIP_OPT_REPLACE_NEWER) == 0) {
			updateTools::log_message("main\terror extracting ".$filename.' to '.$dir);
			updateTools::log_message("main\terror : ".$archive->errorInfo(true));
            $result['nextStep'] = 'error';
            $result['error'] = 1;
            $result['information'] = $archive->errorInfo(true);
        } else {
            $result['nextStep'] = 'listFilesToBackup';
            $result['error'] = 0;
            $result['information'] = updateTools::l('Find files to backup...');
        }
        return $result;
	}

	function listFilesToBackup() {
		global $_PS_ROOT_DIR_;
		$result = array();
		updateTools::log_message("main\tList files to backup");

		if (is_dir($this->moduleDir.DS.'latest'.DS.'prestashop'))
			$dir = $this->moduleDir.DS.'latest'.DS.'prestashop';
		else
			$dir = $this->moduleDir.DS.'latest';
		$filename = $this->moduleDir.DS.'filesToBackup.txt';
		if (file_exists($filename))
			@updateIO::unlinkFTP($filename);
		$errors = $this->_listFilesToBackup($dir, $filename, $dir);
		if (!$errors) {
			if (file_exists($_PS_ROOT_DIR_.DS.'config'.DS.'settings.inc.php'))
				@file_put_contents($this->moduleDir.DS.'filesToBackup.txt', $_PS_ROOT_DIR_.DS.'config'.DS.'settings.inc.php'."\n", FILE_APPEND);
			if (file_exists($_PS_ROOT_DIR_.DS.'config'.DS.'settings.php'))
				@file_put_contents($this->moduleDir.DS.'filesToBackup.txt', $_PS_ROOT_DIR_.DS.'config'.DS.'settings.php'."\n", FILE_APPEND);
				
			$result['nextStep'] = 'downloadCurrent';
			$result['error'] = 0;
			$result['information'] = updateTools::l('Download current version informations...');
		} else {
			$result['nextStep'] = 'error';
			$result['error'] = 1;
			$result['information'] = $errors;
		}
        return $result;
	}

	function downloadCurrent() {
		include_once('../../config/config.inc.php');
		include_once('../../init.php');
		global $_PS_VERSION_;
		$result = array();
		$filename = $this->moduleDir.DS.'current.zip';
		updateTools::log_message("main\tDownload current version");
		
		if (file_exists($filename))
			@updateIO::unlinkFTP($filename);
		// exceptions
		switch ($_PS_VERSION_) {
			case '0.9.7.2' :
				$version = '0.9.7';
				break;
			case '1.1.0.5' :
				$version = '1.1';
				break;
			case '1.0.0.8' :
				$version = '1.0';
				break;
			case '1.3.0.10' :
				$version = '1.3';
				break;
			case '1.3.1.1' :
				$version = '1.3.1';
				break;
			default:
				$version = $_PS_VERSION_; 
		}
		if (@updateIO::copyCurl('http://prestashop.googlecode.com/files/prestashop_'.$version.'.zip', $filename)) {
			@chmod($filename, 0777);
			$result['nextStep'] = 'listFilesToDelete';
			$result['error'] = 0;
			$result['information'] = updateTools::l('Find files to delete...');
		} else {
			$error = error_get_last();
			if (file_exists($this->moduleDir.DS.'backup'.DS.'files.zip'))
				@updateIO::unlinkFTP($this->moduleDir.DS.'backup'.DS.'files.zip');
			
			$files = file_get_contents($this->moduleDir.DS.'filesToBackup.txt');
			$files = empty($files)?array():explode("\n", trim($files, "\n"));
			$toZip = array_slice($files, 0, 20, true);
			if(Configuration::get('EC_DB_BP') == 'yes')
			{
				$result['nextStep'] = 'backupFiles';
				$result['information'] = updateTools::l('Can not download the current version (skipping)').'<br/>'.$error['message'].'<br/>';
				$result['information'] .= updateTools::l('Backup').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Backup').' ', $toZip));
			}
			else
			{
				$result['nextStep'] = 'repairDatabase';
				$result['information'] = 'No backup';
			}
			$result['error'] = 0;

		}
        return $result;
	}

	function listFilesToDelete() {
		include_once('../../config/config.inc.php');
		include_once('../../init.php');
		global $_PS_ROOT_DIR_;
		$result = array();
		updateTools::log_message("main\tFind files to delete");
		$errors = $this->_listFilesToDelete($this->moduleDir.DS.'current.zip', 
											$this->moduleDir.DS.'latest.zip', 
											$this->moduleDir.DS.'filesToDelete.txt', 
											$this->moduleDir.DS.'filesToBackup.txt', 
											$this->moduleDir.DS.'backup'.DS.'filesToDelete.txt');
        if (!$errors) {
			if (file_exists($this->moduleDir.DS.'backup'.DS.'files.zip'))
				@updateIO::unlinkFTP($this->moduleDir.DS.'backup'.DS.'files.zip');
			
			$files = file_get_contents($this->moduleDir.DS.'filesToBackup.txt');
			$files = empty($files)?array():explode("\n", trim($files, "\n"));
			$toZip = array_slice($files, 0, 20, true);

			if(Configuration::get('EC_DB_BP') == 'yes')
			{
				$result['nextStep'] = 'backupFiles';
			}
			else
			{
				$result['nextStep'] = 'repairDatabase';
			}
			$result['error'] = 0;
			$result['information'] = updateTools::l('Backup').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Backup').' ', $toZip));
        } else {
			if (file_exists($this->moduleDir.DS.'backup'.DS.'files.zip'))
				@updateIO::unlinkFTP($this->moduleDir.DS.'backup'.DS.'files.zip');
			
			$files = file_get_contents($this->moduleDir.DS.'filesToBackup.txt');
			$files = empty($files)?array():explode("\n", trim($files, "\n"));
			$toZip = array_slice($files, 0, 20, true);

			if(Configuration::get('EC_DB_BP') == 'yes')
			{
				$result['nextStep'] = 'backupFiles';
				$result['information'] = $errors.'<br/>';
				$result['information'] .= updateTools::l('Backup').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Backup').' ', $toZip));
			}
			else
			{
				$result['nextStep'] = 'repairDatabase';
				$result['information'] = 'No backup';
			}
			$result['error'] = 0;

		}
        return $result;
	}

	function backupFiles() {
		global $_PS_ROOT_DIR_;
		$result = array();
		$filename = $this->moduleDir.DS.'filesToBackup.txt';
		$files = file_get_contents($filename);
		$files = empty($files)?array():explode("\n", trim($files, "\n"));
		
		if (empty($files)) {
			updateTools::log_message("main\tAll files have been backuped");
			if (file_exists($filename))
				@updateIO::unlinkFTP($filename);
			$files = glob($this->moduleDir.DS.'database*.sql');
			if (is_array($files))
				foreach($files as $file)
					@updateIO::unlinkFTP($file);
			$result['nextStep'] = 'preBackupDatabase';
			$result['error'] = 0;
			$result['information'] = updateTools::l('Backup database...');
		} else {
			$toZip = array_slice($files, 0, 20, true);
			foreach($toZip as $file)
				updateTools::log_message("main\tBackup ".$file);
			$archive = new PclZip($this->moduleDir.DS.'backup'.DS.'files.zip');
			if ($archive->add(implode(',', $toZip), PCLZIP_OPT_REMOVE_PATH, $_PS_ROOT_DIR_) == 0) {
				updateTools::log_message("main\terror backuping");
				updateTools::log_message("main\terror : ".$archive->errorInfo(true));
				$result['nextStep'] = 'error';
				$result['error'] = 1;
				$result['information'] = $archive->errorInfo(true);
			} else {
				array_splice($files, 0, 20);
				if (empty($files)) {
					updateTools::log_message("main\tAll files have been backuped");
					@updateIO::unlinkFTP($filename);
					$result['nextStep'] = 'preBackupDatabase';
					$result['error'] = 0;
					$result['information'] = updateTools::l('Backup database...');
				} else {
					file_put_contents($filename, implode("\n", $files));
					$toZip = array_slice($files, 0, 20, true);
					$result['nextStep'] = 'backupFiles';
					$result['error'] = 0;
					$result['information'] = updateTools::l('Backup').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Backup').' ', $toZip));
				}
			}
		}

        return $result;
	}

	function preBackupDatabase() {
		global $_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_, $_DB_NAME_, $_DB_PREFIX_;
		$result = array();
		updateTools::log_message("main\tList tables to backup");
		$link = mysql_connect($_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_);
		if ($link) {
			mysql_select_db($_DB_NAME_, $link);
			$r = @mysql_query('SHOW TABLE STATUS IN `'.$_DB_NAME_.'`', $link);
			if ($r) {
				$tables = array();
				while($item = @mysql_fetch_assoc($r)) {
					if (!$_DB_PREFIX_
						|| (strpos($item['Name'], $_DB_PREFIX_) === 0)) {
						updateTools::log_message("main\tTable ".$item['Name'].' '.$item['Rows'].' row(s)');
						$tables[$item['Name']] = array('name' => $item['Name'], 'rows' => $item['Rows'], 'done' => 0);
					}
				}
			} else {
				$r = @mysql_query('SHOW TABLES'.($_DB_PREFIX_?' LIKE \''.$_DB_PREFIX_.'%\'':''), $link);
				if ($r) {
					$tables = array();
					while($item = @mysql_fetch_row($r)) {
						$r2 = @mysql_query('SELECT COUNT(*) FROM `'.$item[0].'`', $link);
						if ($r2) {
							$count = @mysql_fetch_row($r2);
							updateTools::log_message("main\tTable ".$item[0].' '.$count[0].' row(s)');
							$tables[$item[0]] = array('name' => $item[0], 'rows' => $count[0], 'done' => 0);
						} else {
							updateTools::log_message("main\tError counting row in ".$item[0]);
							updateTools::log_message("main\t".$error['message']);
							$r = false;
							break;
						}
					}
				}
			}
			
			if (!$r) {
				$error = error_get_last();
				updateTools::log_message("main\tUnable to obtain the database schema");
				updateTools::log_message("main\t".$error['message']);
				$result['nextStep'] = 'error';
				$result['error'] = 1;
				$result['information'] = updateTools::l('Unable to obtain the database schema');
			} elseif (!empty($tables)) {
				file_put_contents($this->moduleDir.DS.'databasesToBackup.txt', serialize($tables));
				$files = glob($this->moduleDir.DS.'backup'.DS.'database*.sql');
				if (is_array($files))
					foreach($files as $file)
						@updateIO::unlinkFTP($file);
				$result['nextStep'] = 'backupDatabase';
				$result['error'] = 0;
				$table = reset($tables);
				$result['information'] = updateTools::l('Backup').' '.$table['name'].' 0/'.$table['rows'];
			} else {
				updateTools::log_message("main\tDatabase not found");
				$result['nextStep'] = 'error';
				$result['error'] = 1;
				$result['information'] = updateTools::l('Database not found');
			}
		} else {
			$result['nextStep'] = 'error';
			$result['error'] = 1;
			$result['information'] = updateTools::l('Database not found');				
		}
        return $result;
	}


	function backupDatabase() {
		global $_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_, $_DB_NAME_;
		$result = array();

		$query_left = 5000;
		$backupFilename = $this->moduleDir.DS.'databasesToBackup.txt';
		$tables = @file_get_contents($backupFilename);
		if ($tables) {
			$tables = unserialize($tables);
			$table = reset($tables);
			while ($table['rows'] > 0 && ($table['done'] >= $table['rows'])) {
				unset($tables[$table['name']]);
				$table = reset($tables);
			}
			
			$file_index = 1;
			while (file_exists($this->moduleDir.DS.'backup'.DS.'database'.$file_index.'.sql')) {
				$file_index++;
			}
			$filename = $this->moduleDir.DS.'backup'.DS.'database'.$file_index.'.sql';

			$link = mysql_connect($_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_);
			mysql_select_db($_DB_NAME_, $link);
			updateTools::log_message("main\tLock table ".$table['name']);
			mysql_query('LOCK TABLES `'.$table['name'].'` WRITE', $link);
			
			if ($table['done'] == 0) {
				$rows = mysql_query('SHOW CREATE TABLE `'.$table['name'].'`');
				$row = mysql_fetch_assoc($rows);
				file_put_contents($filename, '<query>DROP TABLE IF EXISTS `'.$table['name']."`\n", FILE_APPEND);
				file_put_contents($filename, '<query>'.$row['Create Table']."\n", FILE_APPEND);
			}
			
			$rows = mysql_query('SELECT * FROM `'.$table['name'].'` LIMIT '.$table['done'].','.$query_left, $link);
			
			updateTools::log_message("main\tBackup table ".$table['name'].' rows '.$table['done'].' to '.$query_left);
			$rowsCount = 0;
			while($row = mysql_fetch_row($rows)){
				$insert = "";
				foreach($row as $data){
					$insert .="'".addslashes($data)."', ";
				}
				$insert = substr($insert, 0, -2);
				file_put_contents($filename, '<query>INSERT INTO `'.$table['name'].'` VALUES ('.$insert.')'."\n", FILE_APPEND);
				$query_left--;
				$rowsCount++;
				$table['done']++;
			}
			updateTools::log_message("main\tUnlock tables");
			mysql_query('UNLOCK TABLES');
			
			if (!$rowsCount || ($table['done'] >= $table['rows']))
				unset($tables[$table['name']]);
			else
				$tables[$table['name']] = $table;
			
			if (!empty($tables)) {
				file_put_contents($backupFilename, serialize($tables));
				$result['nextStep'] = 'backupDatabase';
				$result['error'] = 0;
				$table = reset($tables);
				$result['information'] = updateTools::l('Backup').' '.$table['name'].' '.$table['done'].'/'.$table['rows'];
			} else {
				updateTools::log_message("main\tAll tables have been backuped");
				@updateIO::unlinkFTP($backupFilename);
				$result['nextStep'] = 'repairDatabase';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Find modules to update...');
			}
		} else {
            $result['nextStep'] = 'error';
            $result['error'] = 1;
            $result['information'] = updateTools::l('Error during database backup...');
        }

        return $result;
	}

	function repairDatabase() {
		global $_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_, $_DB_NAME_, $_PS_VERSION_, $_PS_ROOT_DIR_, $_DB_PREFIX_;
		$file_name = $_PS_ROOT_DIR_.'/modules/easyupdate/db/version_'.$_PS_VERSION_.'.txt';
		$db_safe = file_get_contents($file_name);
		$db = @mysql_connect($_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_);

		if (!$db) {
			$result['nextStep'] = 'error';
			$result['error'] = 1;
			$result['information'] = 'Couldn\'t connect to the server';
		}
		else
		{
			if (!mysql_select_db($_DB_NAME_, $db)) {
				$result['nextStep'] = 'error';
				$result['error'] = 1;
				$result['information'] = 'Couldn\'t connect to database';
			}
			else
			{
				$res = mysql_query("SHOW TABLES LIKE '".$_DB_PREFIX_."%'");
				while ($row = mysql_fetch_row($res)) {
					$tables[$row[0]] = array();
				}

				foreach ($tables as $table_name => $fields) {
					$res = mysql_query("SHOW COLUMNS FROM " . $table_name, $db);
					while ($row = mysql_fetch_assoc($res)) {
						$tables[$table_name][$row['Field']] = $row;
					}

					$res = mysql_query("SHOW INDEX FROM " . $table_name, $db);
					while ($row = mysql_fetch_assoc($res)) {
						$index[$table_name][$row['Key_name']][] = $row;
					}
				}
				mysql_close();
				$db_customer = array(
					'name' => $_DB_NAME_,
					'time' => time(),
					'tables' => $tables,
					'index' => $index
				);

				$db_safe = unserialize($this->strip_nl($db_safe));
				$i =1;
				foreach(($db_safe['tables']) as $key=>$value)
				{
					$key = str_replace('prefix_',$_DB_PREFIX_,$key);
					$db_tmp[$key] = $value;
				}
				$db_safe['tables'] = $db_tmp;
				$db_tmp = null;
				foreach(($db_safe['index']) as $key=>$value)
				{
					$key = str_replace('prefix_',$_DB_PREFIX_,$key);
					$db_tmp[$key] = $value;
					$db_tmp3 = null;
					foreach($value as $key2=>$value2)
					{
						$db_tmp2 = null;
						foreach($value2 as $key3=>$value3)
						{
							$db_tmp2[$key3] = $value3;
							$db_tmp2[$key3]['Table'] = $key;
						}
						$db_tmp3[$key2] = $db_tmp2;
					}
					$db_tmp[$key]=$db_tmp3;

				}
				$db_safe['index'] = $db_tmp;

				$comparation = $this->compare($db_safe, $db_customer);

				if (count($comparation) > 0)
				{
					$db = @mysql_connect($_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_);
					foreach ($comparation as $table_name => $differences)
					{
						foreach($differences as $difference)
						{
							$error = str_replace('</br>', ' ', $difference['solve']);
							mysql_query($error,$db);
						}
					}
					mysql_close();
					$result['nextStep'] = 'listModulesToUpdate';
					$result['error'] = 0;
					$result['information'] = 'Database repaired';
				}
				else
				{
					$result['nextStep'] = 'listModulesToUpdate';
					$result['error'] = 0;
					$result['information'] = 'Database healthy';
				}

			}

		}

		return $result;
	}

	function listModulesToUpdate() {
		global $_PS_ROOT_DIR_;
		$result = array();
		updateTools::log_message("main\tFind modules to update");
		$errors = $this->_listModulesToUpdate($this->moduleDir.DS.'modulesToUpdate.txt');

		$files = file_get_contents($this->moduleDir.DS.'filesToDelete.txt');
		$files = empty($files)?array():explode("\n", trim($files, "\n"));
		$toDelete = array_slice($files, 0, 20, true);
		
		$result['nextStep'] = 'deleteFiles';
		$result['error'] = 0;
		$result['information'] = updateTools::l('Delete').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Delete').' ', $toDelete));

		if ($errors)
			$result['information'] = updateTools::l('Can not find modules to update:'.$errors).'</br>'.$result['information'];

        return $result;
	}

	function deleteFiles() {
		global $_PS_ROOT_DIR_;
		$result = array();
		$filename = $this->moduleDir.DS.'filesToDelete.txt';
		$files = file_get_contents($filename);
		$files = empty($files)?array():explode("\n", trim($files, "\n"));
		
		if (empty($files)) {
			updateTools::log_message("main\tAll files have been deleted");
			if (file_exists($filename))
				@updateIO::unlinkFTP($filename);
			$result['nextStep'] = 'removeExemples';
			$result['error'] = 0;
			$result['information'] = updateTools::l('Remove exemple files');
		} else {
			$toDelete = array_slice($files, 0, 20, true);
			foreach($toDelete as $file) {
				updateTools::log_message("main\tDelete ".$file);
				@updateIO::unlinkFTP($file);
			}
			array_splice($files, 0, 20);
			if (empty($files)) {
				updateTools::log_message("main\tAll files have been deleted");
				@updateIO::unlinkFTP($filename);

				$result['nextStep'] = 'removeExemples';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Remove exemple files');
			} else {
				file_put_contents($filename, implode("\n", $files));
				$toDelete = array_slice($files, 0, 20, true);
				$result['nextStep'] = 'deleteFiles';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Delete').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Delete').' ', $toDelete));
			}
		}
        return $result;
	}

	function removeExemples() {
		$result = array();
		// sometimes there is a prestashop folder sometime not
		if (is_dir($this->moduleDir.DS.'latest'.DS.'prestashop'))
			$dir = $this->moduleDir.DS.'latest'.DS.'prestashop'.DS;
		else
			$dir = $this->moduleDir.DS.'latest'.DS;
		// delete unwanted files
		if (file_exists($dir.'modules'.DS.'editorial'.DS.'editorial.xml'))
			@updateIO::unlinkFTP($dir.'modules'.DS.'editorial'.DS.'editorial.xml');
		if (file_exists($dir.'modules'.DS.'editorial'.DS.'homepage_logo.jpg'))
			@updateIO::unlinkFTP($dir.'modules'.DS.'editorial'.DS.'homepage_logo.jpg');
		if (file_exists($dir.'modules'.DS.'watermark'.DS.'watermark.gif'))
			@updateIO::unlinkFTP($dir.'modules'.DS.'watermark'.DS.'watermark.gif');
		if (file_exists($dir.'img'.DS.'logo.jpg'))
			@updateIO::unlinkFTP($dir.'img'.DS.'logo.jpg');
		if (file_exists($dir.'img'.DS.'logo_stores.gif'))
			@updateIO::unlinkFTP($dir.'img'.DS.'logo_stores.gif');
		if (file_exists($dir.'img'.DS.'favicon.ico'))
			@updateIO::unlinkFTP($dir.'img'.DS.'favicon.ico');
		if (is_array(glob($dir.'img'.DS.'c'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'c'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (is_array(glob($dir.'img'.DS.'m'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'m'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (is_array(glob($dir.'img'.DS.'p'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'p'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (is_array(glob($dir.'img'.DS.'p'.DS.'*'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'p'.DS.'*'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (is_array(glob($dir.'img'.DS.'scenes'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'scenes'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (is_array(glob($dir.'img'.DS.'scenes'.DS.'thumbs'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'scenes'.DS.'thumbs'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (is_array(glob($dir.'img'.DS.'st'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'st'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (is_array(glob($dir.'img'.DS.'su'.DS.'*.jpg')))
			foreach(glob($dir.'img'.DS.'su'.DS.'*.jpg') as $file)
				@updateIO::unlinkFTP($file);
		if (file_exists($dir.'install-dev'))
			updateIO::rename_dir($dir.'install-dev', $dir.'install', false);
		if (file_exists($dir.'admin-dev'))
			updateIO::rename_dir($dir.'admin-dev', $dir.'admin', false);

		$files = updateIO::filesInDir($dir);

		$result['nextStep'] = 'replaceFiles';
		$result['error'] = 0;
		$result['information'] = updateTools::l('Replace').' '.str_replace($dir, '', implode('<br/>'.updateTools::l('Replace').' ', $files));
        return $result;
	}

	function replaceFiles() {
		global $_PS_ROOT_DIR_;
		$result = array();
		updateTools::log_message("main\tReplace files");
		if (is_dir($this->moduleDir.DS.'latest'.DS.'prestashop'))
			$dir = $this->moduleDir.DS.'latest'.DS.'prestashop';
		else
			$dir = $this->moduleDir.DS.'latest';
		$tmpResult = updateIO::rename_dir($dir, $_PS_ROOT_DIR_);
        if ($tmpResult === true) {
			if (!file_exists($dir) || updateIO::isEmptyDir($dir)) {
				updateTools::log_message("main\tAll files have been replaced");
				if (file_exists($this->moduleDir.DS.'latest'))
					updateIO::rrmdir($this->moduleDir.DS.'latest');
				$result['nextStep'] = 'executeScript';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Execute installation script...');
			} else {
				$result['nextStep'] = 'replaceFiles';
				$result['error'] = 0;
				$files = updateIO::filesInDir($dir);
				$result['information'] = updateTools::l('Replace').' '.str_replace($dir, '', implode('<br/>'.updateTools::l('Replace').' ', $files));
			}
        } else {
            $result['nextStep'] = 'preRestoreFiles';
            $result['error'] = 1;
            $result['information'] = updateTools::l('Error during files replacement...').'<br/>'.$tmpResult;
        }
        return $result;
	}

	function executeScript() {
		global $__PS_BASE_URI__, $_PS_ROOT_DIR_;
		$result = array();
		updateTools::log_message("main\tExecute installation script ".$__PS_BASE_URI__.'install/model.php?method=doUpgrade');
		// sometime xml from installation script is bugged so clean it first
		$ctx = stream_context_create(array('http' => array('timeout' => 90)));
		if (file_exists($_PS_ROOT_DIR_.DS.'install'.DS.'upgrade'.DS.'upgrade.php')) // PS 1.5
			$file = $__PS_BASE_URI__.'install/upgrade/upgrade.php';
		else
			$file = $__PS_BASE_URI__.'install/model.php?method=doUpgrade';
        if ($xml = @file_get_contents($file, 0, $ctx)) {
			updateTools::log_message("main\tInstallation script result : ".$xml);
			list($feed) = explode("\n", $xml);
			$feed = @simplexml_load_string($feed.'</action>');
            if (($feed['result'] == 'ok') || ((int) $feed['error'] == 34) || !$feed['error']) {
            	if (file_exists($this->moduleDir.DS.'modulesToUpdate.txt')) {
					$modules = file_get_contents($this->moduleDir.DS.'modulesToUpdate.txt');
					$modules = empty($modules)?array():explode("\n", trim($modules, "\n"));
					$module = array_shift($modules);
					list($id_module, $module_name) = explode('|', $module);
	                $result['nextStep'] = 'updateModules';
					$result['information'] = updateTools::l('Update module').' '.$module_name;
            	} else {
	                $result['nextStep'] = 'repairNewDatabase';
	                $result['information'] = updateTools::l('Delete temporary files...');
            	}
	            $result['error'] = 0;
            } else {
				updateTools::log_message("main\tInstallation script terminates with error ".$feed['error']);
                $result['nextStep'] = 'preRestoreDatabase';
	            $result['error'] = 1;
                $result['information'] = updateTools::l('Installation script terminates with error').' '.$feed['error'];
            }
        }
        else {
            $result['nextStep'] = 0;
            $result['error'] = 2;
            $result['information'] = updateTools::l('Can not open installation script. Please execute it yourself here :').' '.$__PS_BASE_URI__.'install/';
        }
        return $result;
	}

	function updateModules() {
		$result = array();
		$filename = $this->moduleDir.DS.'modulesToUpdate.txt';
		$modules = file_get_contents($filename);
		$modules = empty($modules)?array():explode("\n", trim($modules, "\n"));
		
		if (empty($modules)) {
			updateTools::log_message("main\tAll modules have been updated");
			if (file_exists($filename))
				@updateIO::unlinkFTP($filename);
	        $result['nextStep'] = 'repairNewDatabase';
	        $result['error'] = 0;
	        $result['information'] = updateTools::l('Delete temporary files...');
		} else {
			$module = array_shift($modules);
			list($id_module, $module_name) = explode('|', $module);
			$errors = $this->_updateModule($id_module, $module_name);
			if (empty($modules)) {
				updateTools::log_message("main\tAll modules have been updated");
				if (file_exists($filename))
					@updateIO::unlinkFTP($filename);
		        $result['nextStep'] = 'repairNewDatabase';
		        $result['error'] = 0;
		        $result['information'] = updateTools::l('Delete temporary files...');
			} else {
				file_put_contents($filename, implode("\n", $modules));
				$module = array_shift($modules);
				list($id_module, $module_name) = explode('|', $module);
				$result['nextStep'] = 'updateModules';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Update module').' '.$module_name;
			}
			if ($errors)
				$result['information'] = updateTools::l('Error updating module:').$errors.'<br/>'.$result['information'];
		}
        return $result;
	}

	function repairNewDatabase() {
		global $_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_, $_DB_NAME_, $_PS_VERSION_NEW_, $_PS_ROOT_DIR_, $_DB_PREFIX_;
		$file_name = $_PS_ROOT_DIR_.'/modules/easyupdate/db/version_'.$_PS_VERSION_NEW_.'.txt';
		$db_safe = file_get_contents($file_name);
		$db = @mysql_connect($_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_);

		if (!$db) {
			$result['nextStep'] = 'error';
			$result['error'] = 1;
			$result['information'] = 'Couldn\'t connect to the server';
		}
		else
		{
			if (!mysql_select_db($_DB_NAME_, $db)) {
				$result['nextStep'] = 'error';
				$result['error'] = 1;
				$result['information'] = 'Couldn\'t connect to database';
			}
			else
			{
				$res = mysql_query("SHOW TABLES LIKE '".$_DB_PREFIX_."%'");
				while ($row = mysql_fetch_row($res)) {
					$tables[$row[0]] = array();
				}

				foreach ($tables as $table_name => $fields) {
					$res = mysql_query("SHOW COLUMNS FROM " . $table_name, $db);
					while ($row = mysql_fetch_assoc($res)) {
						$tables[$table_name][$row['Field']] = $row;
					}

					$res = mysql_query("SHOW INDEX FROM " . $table_name, $db);
					while ($row = mysql_fetch_assoc($res)) {
						$index[$table_name][$row['Key_name']][] = $row;
					}
				}
				mysql_close();
				$db_customer = array(
					'name' => $_DB_NAME_,
					'time' => time(),
					'tables' => $tables,
					'index' => $index
				);

				$db_safe = unserialize($this->strip_nl($db_safe));
				$i =1;
				foreach(($db_safe['tables']) as $key=>$value)
				{
					$key = str_replace('prefix_',$_DB_PREFIX_,$key);
					$db_tmp[$key] = $value;
				}
				$db_safe['tables'] = $db_tmp;
				$db_tmp = null;
				foreach(($db_safe['index']) as $key=>$value)
				{
					$key = str_replace('prefix_',$_DB_PREFIX_,$key);
					$db_tmp[$key] = $value;
					$db_tmp3 = null;
					foreach($value as $key2=>$value2)
					{
						$db_tmp2 = null;
						foreach($value2 as $key3=>$value3)
						{
							$db_tmp2[$key3] = $value3;
							$db_tmp2[$key3]['Table'] = $key;
						}
						$db_tmp3[$key2] = $db_tmp2;
					}
					$db_tmp[$key]=$db_tmp3;

				}
				$db_safe['index'] = $db_tmp;

				$comparation = $this->compare($db_safe, $db_customer);

				if (count($comparation) > 0)
				{
					$db = @mysql_connect($_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_);
					foreach ($comparation as $table_name => $differences)
					{
						foreach($differences as $difference)
						{
							$error = str_replace('</br>', ' ', $difference['solve']);
							mysql_query($error,$db);
						}
					}
					mysql_close();
					$result['nextStep'] = 'deleteTmp' ;
					$result['error'] = 0;
					$result['information'] = 'New Database repaired';
				}
				else
				{
					$result['nextStep'] = 'deleteTmp' ;
					$result['error'] = 0;
					$result['information'] = 'New Database healthy';
				}

			}

		}

		return $result;
	}

	function deleteTmp() {
		global $_PS_ROOT_DIR_, $_PS_ADMIN_DIR_;
		$result = array();
		updateTools::log_message("main\tDelete temporary files");
        updateIO::rename_dir($_PS_ROOT_DIR_.DIRECTORY_SEPARATOR.'admin', $_PS_ADMIN_DIR_, false);
		$this->_deleteTemporaryFiles();
        $result['nextStep'] = -1;
		$result['error'] = 0;
        $result['information'] = updateTools::l('Update completed.');
        return $result;
	}

	// error without retreive backup
	function error() {
		$result = array();
        $result['nextStep'] = 'deleteTmp2';
		$result['error'] = 0;
        $result['information'] = updateTools::l('Delete temporary files...');
        return $result;
	}

	// error with retreive backup
	function preRestoreFiles() {
		$result = array();
        $result['nextStep'] = 'restoreFiles';
		$result['error'] = 0;
        $result['information'] = updateTools::l('Restore files...');
        return $result;
	}

	function preRestoreDatabase() {
		$result = array();
		$files = glob($this->moduleDir.DS.'backup'.DS.'database*.sql');
		file_put_contents($this->moduleDir.DS.'databasesToRestore.txt', serialize($files));
        $result['nextStep'] = 'restoreDatabase';
		$result['error'] = 0;
        $result['information'] = updateTools::l('Restore database...').' '.count($files).' '.updateTools::l('files left');
        return $result;
	}

	function restoreDatabase() {
		global $_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_,$_DB_NAME_, $_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_;
		$result = array();
		$filename = $this->moduleDir.DS.'databasesToRestore.txt';
		$files = unserialize(file_get_contents($filename));
		if ($files) {
			$file = reset($files);
			$content = file_get_contents($file);
			$queries = explode("<query>", $content);
			$link = mysql_connect($_DB_SERVER_, $_DB_USER_, $_DB_PASSWD_);
			mysql_select_db($_DB_NAME_, $link);
			foreach($queries as $query)
				if ($query)
					mysql_query($query, $link);
			array_shift($files);
			if (!empty($files)) {
				file_put_contents($filename, serialize($files));
				$result['nextStep'] = 'restoreDatabase';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Restore database...').' '.count($files).' '.updateTools::l('files left');
			} else {
				@unlink($filename);
				$result['nextStep'] = 'restoreFiles';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Restore files...');
			}
		} else {
			@unlink($filename);
			$result['nextStep'] = 'restoreFiles';
			$result['error'] = 0;
			$result['information'] = updateTools::l('Restore files...');
		}
        return $result;
	}

	function restoreFiles() {
		$result = array();
    	$dir = $this->moduleDir.DS.'latest';
		updateIO::rrmdir($dir);
        $archive = new PclZip($this->moduleDir.DS.'backup'.DS.'files.zip');
        if (@mkdir($dir)
			&& $archive->extract(PCLZIP_OPT_PATH, $dir) == 0) {
            $result['nextStep'] = -1;
            $result['error'] = 1;
            $result['information'] = $archive->errorInfo(true);
        } else {
            $result['nextStep'] = 'replaceFiles2';
            $result['error'] = 0;
			$files = updateIO::filesInDir($dir);
			$result['information'] = updateTools::l('Replace').' '.str_replace($dir, '', implode('<br/>'.updateTools::l('Replace').' ', $files));
        }
        return $result;
	}

	function replaceFiles2() {
		global $_PS_ROOT_DIR_;
		$result = array();
    	$dir = $this->moduleDir.DS.'latest';
		$tmpResult = updateIO::rename_dir($dir, $_PS_ROOT_DIR_);
        if ($tmpResult === true) {
			if (!file_exists($dir) || updateIO::isEmptyDir($dir)) {
				updateIO::rrmdir($dir);
				$files = file_get_contents($this->moduleDir.DS.'backup'.DS.'filesToDelete.txt');
				$files = empty($files)?array():explode("\n", trim($files, "\n"));
				$toDelete = array_slice($files, 0, 20, true);
				
				$result['nextStep'] = 'deleteAfterRestore';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Delete').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Delete').' ', $toDelete));
			} else {
				$result['nextStep'] = 'replaceFiles2';
				$result['error'] = 0;
				$files = updateIO::filesInDir($dir);
				$result['information'] = updateTools::l('Replace').' '.str_replace($dir, '', implode('<br/>'.updateTools::l('Replace').' ', $files));
			}
        } else {
            $result['nextStep'] = -1;
            $result['error'] = -1;
            $result['information'] = updateTools::l('Error during files replacement...').'<br/>'.$tmpResult;
        }
        return $result;
	}

	function deleteAfterRestore() {
		global $_PS_ROOT_DIR_;
		$result = array();
		$filename = $this->moduleDir.DS.'backup'.DS.'filesToDelete.txt';
		$files = file_get_contents($filename);
		$files = empty($files)?array():explode("\n", trim($files, "\n"));
		
		if (empty($files)) {
			updateTools::log_message("main\tAll files have been deleted");
			if (file_exists($filename))
				@updateIO::unlinkFTP($filename);
			$result['nextStep'] = 'deleteTmp2';
			$result['error'] = 0;
			$result['information'] = updateTools::l('Delete temporary files...');
		} else {
			$toDelete = array_slice($files, 0, 20, true);
			foreach($toDelete as $file) {
				updateTools::log_message("main\tDelete ".$file);
				@updateIO::unlinkFTP($file);
			}
			array_splice($files, 0, 20);
			if (empty($files)) {
				updateTools::log_message("main\tAll files have been deleted");
				@updateIO::unlinkFTP($filename);

				$result['nextStep'] = 'deleteTmp2';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Delete temporary files...');
			} else {
				file_put_contents($filename, implode("\n", $files));
				$toDelete = array_slice($files, 0, 20, true);
				$result['nextStep'] = 'deleteAfterRestore';
				$result['error'] = 0;
				$result['information'] = updateTools::l('Delete').' '.str_replace($_PS_ROOT_DIR_, '', implode('<br/>'.updateTools::l('Delete').' ', $toDelete));
			}
		}
        return $result;		
	}

	function deleteTmp2() {
		$result = array();
		updateTools::log_message("main\tDelete temporary files");
		$this->_deleteTemporaryFiles();
        $result['nextStep'] = -1;
		$result['error'] = 0;
        $result['information'] = updateTools::l('Restoration completed.');
        return $result;
	}

	function deleteBackup() {
		$result = array();
        updateIO::rrmdir($this->moduleDir.DS.'prestashop');
		if (file_exists($this->moduleDir.DS.'config.php'))
	        @updateIO::unlinkFTP($this->moduleDir.DS.'config.php');
		if (file_exists($this->moduleDir.DS.'backup'.DS.'files.zip'))
	        @updateIO::unlinkFTP($this->moduleDir.DS.'backup'.DS.'files.zip');
		$files = glob($this->moduleDir.DS.'backup'.DS.'database*.sql');
		if (is_array($files))
			foreach($files as $file)
				@updateIO::unlinkFTP($file);
        $result['nextStep'] = -1;
		$result['error'] = 0;
        $result['information'] = updateTools::l('Delete completed.');

        return $result;
	}

	// private methods

	private function _listFilesToBackup($dir, $logFileName, $root) {
		global $_PS_ROOT_DIR_, $_PS_ADMIN_DIR_, $USE_FTP;
		updateTools::log_message("listFilesToBackup\tlist files in ".$dir.' to '.$logFileName);
		$result = '';
	    if (is_dir($dir)) { 
	        $objects = scandir($dir); 
	        foreach ($objects as $object) {
				$filename = $dir.DS.$object;
				$dest = str_replace($root, $_PS_ROOT_DIR_, $filename);
				$dest = str_replace($_PS_ROOT_DIR_.DS.'admin', $_PS_ADMIN_DIR_, $dest);
	            if ($object != "." && $object != "..") { 
	                if (filetype($filename) == "dir") {
						if (!file_exists($dest) || $USE_FTP || (is_writable($dest) && is_readable($dest)))
							$result .= $this->_listFilesToBackup($filename, $logFileName, $root);
						else if (file_exists($dest) && !$USE_FTP) {
							if (!is_writable($dest))
								$result .= str_replace($_PS_ROOT_DIR_, '', $dest).' '.updateTools::l('is not writable').'<br/>';
							else
								$result .= str_replace($_PS_ROOT_DIR_, '', $dest).' '.updateTools::l('is not readable').'<br/>';
						}
					} else {
						if (file_exists($dest) 
							&& ($USE_FTP 
								|| (is_writable($dest) 
									&& is_readable($dest)))
							) {
							updateTools::log_message("listFilesToBackup\tfound ".$dest);
							if (!file_put_contents($logFileName, $dest."\n", FILE_APPEND))
								$result .= $logFileName.' '.updateTools::l('is not writable').'<br/>';
						} else if (file_exists($dest) && !$USE_FTP) {
							if (!is_writable($dest))
								$result .= str_replace($_PS_ROOT_DIR_, '', $dest).' '.updateTools::l('is not writable').'<br/>';
							else
								$result .= str_replace($_PS_ROOT_DIR_, '', $dest).' '.updateTools::l('is not readable').'<br/>';
						}
					}
				}
				if ($result)
					break;
	        } 
	        reset($objects); 
	    }
		return $result;
	}

	private function _listFilesToDelete($currentZip, 
										$newZip, 
										$fileNameForDeleteAfterInstall, 
										$fileNameForBackup, 
										$fileNameForDeleteAfterRestore) {
		global $_PS_ROOT_DIR_, $_PS_ADMIN_DIR_;
		$result = '';

		updateTools::log_message("listFilesToDelete\tlist files from ".$currentZip);
	    $currentArchive = new PclZip($currentZip);
	    $newArchive = new PclZip($newZip);
	    $currentFiles = $currentArchive->listContent();
	    $newFiles = $newArchive->listContent();
	    if (!is_array($currentFiles) 
	    	|| empty($currentFiles)
	    	|| !is_array($newFiles) 
	    	|| empty($newFiles)) {
			updateTools::log_message("main\terror listing files (skipping)");
			updateTools::log_message("main\terror : ".$archive->errorInfo(true));
			$result .= updateTools::l('Can not list files of the current version (skipping)').'<br/>';
		} else {
			if (file_exists($fileNameForDeleteAfterInstall))
				@unlink($fileNameForDeleteAfterInstall);
			if (file_exists($fileNameForDeleteAfterRestore))
				@unlink($fileNameForDeleteAfterRestore);
			$currentList = array();
			foreach ($currentFiles as $file) {
				$filename = $file['filename'];
				if (substr($filename, 0, 11) == 'prestashop/')
					$filename = substr($filename, 11);
				if ((substr($filename, 0, 4) != 'img/')
					&& (substr($filename, 0, 7) != 'themes/'))
					$currentList[] = $filename;
			}
			$newList = array();
			foreach ($newFiles as $file) {
				$filename = $file['filename'];
				if (substr($filename, 0, 11) == 'prestashop/')
					$filename = substr($filename, 11);
				if ((substr($filename, 0, 4) != 'img/')
					&& (substr($filename, 0, 7) != 'themes/'))
					$newList[] = $filename;
			}
			$filesToDeleteAfterInstall = array_diff($currentList, $newList);
			$filesToDeleteAfterRestore = array_diff($newList, $currentList);
			foreach ($filesToDeleteAfterInstall as $filename) {
				if (substr($filename, 0, 6) == 'admin/')
					$filename = $_PS_ADMIN_DIR_.DS.substr($filename, 6);
				else
					$filename = $_PS_ROOT_DIR_.DS.$filename;

				if (file_exists($filename)) {
					updateTools::log_message("listFilesToDelete\tfound to delete after install : ".$filename);
					if (!file_put_contents($fileNameForDeleteAfterInstall, $filename."\n", FILE_APPEND)) {
						$result .= $fileNameForDeleteAfterInstall.' '.updateTools::l('is not writable').'<br/>';
						break;
					}
					if (!file_put_contents($fileNameForBackup, $filename."\n", FILE_APPEND)) {
						$result .= $fileNameForBackup.' '.updateTools::l('is not writable').'<br/>';
						break;
					}
				}
			}
			foreach ($filesToDeleteAfterRestore as $filename) {
				if (substr($filename, 0, 6) == 'admin/')
					$filename = $_PS_ADMIN_DIR_.DS.substr($filename, 6);
				else
					$filename = $_PS_ROOT_DIR_.DS.$filename;

				updateTools::log_message("listFilesToDelete\tfound to delete after restore : ".$filename);
				if (!file_put_contents($fileNameForDeleteAfterRestore, $filename."\n", FILE_APPEND)) {
					$result .= $fileNameForDeleteAfterRestore.' '.updateTools::l('is not writable').'<br/>';
					break;
				}
			}
		}
		@updateIO::unlinkFTP($newZip);
		@updateIO::unlinkFTP($currentZip);
		return $result;
	}

	private function _listModulesToUpdate($logFileName) {
		global $_PS_VERSION_, $_PS_ROOT_DIR_;
		$result = '';

		updateTools::log_message("listModulesToUpdate\tlist modules to ".$logFileName);
		$url = 'http://api.addons.prestashop.com/?version='.$_PS_VERSION_.'&method=listing&action=native&iso_code=all';
		$xml = updateIO::copyCurl($url, false, true);
		$modules = @simplexml_load_string($xml);
		@updateIO::unlinkFTP($logFileName);

		if ($modules) {
			$updatable_modules = array();
			foreach ($modules as $module)
				$updatable_modules[(string)$module->name] = (string)$module->id;

			$modules = scandir($_PS_ROOT_DIR_.DS.'modules');
			foreach ($modules as $module) {
				if (isset($updatable_modules[$module])) {
					updateTools::log_message("listModulesToUpdate\tfound ".$module.' ('.$updatable_modules[$module].')');
					if (!file_put_contents($logFileName, $updatable_modules[$module].'|'.$module."\n", FILE_APPEND)) {
						$result .= $logFileName.' '.updateTools::l('is not writable').'<br/>';
						break;
					}
				}
			}
		}
		return $result;
	}

	private function _updateModule($id_module, $module_name) {
		global $_PS_VERSION_NEW_, $_PS_ROOT_DIR_;
		updateTools::log_message("updateModule\tupdate ".$module_name.' ('.$id_module.')');
		$result = '';

		$url = 'http://api.addons.prestashop.com/?version='.$_PS_VERSION_NEW_.'&method=module&id_module='.(int)$id_module;
		$file = $this->moduleDir.DS.'module.zip';
		if (file_exists($file))
			updateIO::unlinkFTP($file);
		if (updateIO::copyCurl($url, $file, true)) {
			$archive = new PclZip($file);
			$dir = $this->moduleDir.DS.'module';

			if (!file_exists($dir)
				&& !updateIO::mkdirFTP($dir)) {
				$error = error_get_last();
	            $result = $error['message'];
			} elseif ($archive->extract(PCLZIP_OPT_PATH, $dir, PCLZIP_OPT_REPLACE_NEWER) == 0) {
				updateTools::log_message("main\terror extracting ".$file.' to '.$dir);
				updateTools::log_message("main\terror : ".$archive->errorInfo(true));
	            $result = $archive->errorInfo(true);
	        } else {
	        	@updateIO::unlinkFTP($file);
	        	$tmpResult = updateIO::rename_dir($dir, $_PS_ROOT_DIR_.DS.'modules', false);
	        	if ($tmpResult !== true) {
					updateTools::log_message("main\terror during files replacement");
					updateTools::log_message("main\terror : ".$tmpResult);
	        		$result = updateTools::l('Error during files replacement...').'<br/>'.$tmpResult;
	        	}
	        	if (file_exists($dir))
		        	updateIO::rrmdir($dir);
	        }
		}
	}

	private function _deleteTemporaryFiles() {
		global $_PS_ROOT_DIR_;
		if (file_exists($_PS_ROOT_DIR_.DS.'admin'))
	        updateIO::rrmdir($_PS_ROOT_DIR_.DS.'admin');
		if (file_exists($_PS_ROOT_DIR_.DS.'install'))
	        updateIO::rrmdir($_PS_ROOT_DIR_.DS.'install');
		if (file_exists($_PS_ROOT_DIR_.DS.'docs'))
	        updateIO::rrmdir($_PS_ROOT_DIR_.DS.'docs');
		if (file_exists($this->moduleDir.DS.'prestashop'))
	        updateIO::rrmdir($this->moduleDir.DS.'prestashop');
		if (file_exists($this->moduleDir.DS.'config.php'))
	        @updateIO::unlinkFTP($this->moduleDir.DS.'config.php');
		if (file_exists($this->moduleDir.DS.'latest.zip'))
	        @updateIO::unlinkFTP($this->moduleDir.DS.'latest.zip');
		if (file_exists($this->moduleDir.DS.'module.zip'))
	        @updateIO::unlinkFTP($this->moduleDir.DS.'module.zip');
		if (file_exists($this->moduleDir.DS.'filesToBackup.txt'))
			@updateIO::unlinkFTP($this->moduleDir.DS.'filesToBackup.txt');
		if (file_exists($this->moduleDir.DS.'databasesToBackup.txt'))
			@updateIO::unlinkFTP($this->moduleDir.DS.'databasesToBackup.txt');
		if (file_exists($this->moduleDir.DS.'databasesToRestore.txt'))
			@updateIO::unlinkFTP($this->moduleDir.DS.'databasesToRestore.txt');
		if (file_exists($this->moduleDir.DS.'module'))
	        updateIO::rrmdir($this->moduleDir.DS.'module');
		if (file_exists($_PS_ROOT_DIR_.DS.'README'))
			@updateIO::unlinkFTP($_PS_ROOT_DIR_.DS.'README');
		if (file_exists($_PS_ROOT_DIR_.DS.'readme_en.txt'))
	        @updateIO::unlinkFTP($_PS_ROOT_DIR_.DS.'readme_en.txt');
		if (file_exists($_PS_ROOT_DIR_.DS.'readme_es.txt'))
	        @updateIO::unlinkFTP($_PS_ROOT_DIR_.DS.'readme_es.txt');
		if (file_exists($_PS_ROOT_DIR_.DS.'readme_fr.txt'))
	        @updateIO::unlinkFTP($_PS_ROOT_DIR_.DS.'readme_fr.txt');
		if (file_exists($_PS_ROOT_DIR_.DS.'CHANGELOG'))
	        @updateIO::unlinkFTP($_PS_ROOT_DIR_.DS.'CHANGELOG');
	}

	function strip_nl($str) {
		return str_replace(array("\n", "\r"), '', $str);
	}

	function compare($schema1, $schema2) {

		$tables1 = array_keys($schema1['tables']);
		$tables2 = array_keys($schema2['tables']);
		$tables = array_unique(array_merge($tables1, $tables2));
		$results = array();
		$i=0;
		foreach ($tables as $table_name) {


			// Check if tables exist in both databases

			if (!isset($schema1['tables'][$table_name])) {
				continue;
			}

			if (!isset($schema2['tables'][$table_name])) {
				$i++;
				$results[$table_name][$i]['error'] = '<em>' . $schema2['name']
					. '</em> is missing table: <code>' . $table_name
					. '</code>.';
				$keys = array();
				$key = array();
				$results[$table_name][$i]['solve'] = 'CREATE TABLE `'.$table_name.'` (';
				foreach($schema1['tables'][$table_name] as $field=>$value){
					if($value['Default']!='' && $value['Default']!='CURRENT_TIMESTAMP')
					{
						$default='\''.$value['Default'].'\'';
					}
					else
					{
						$default=$value['Default'];
					}
					$results[$table_name][$i]['solve'] .= '</br>`'.$value['Field'].'` '.$value['Type'].' '.($value['Null']=='NO' ? 'NOT NULL' : '').' '.($value['Default']=='' ? '' : 'default '.$default).' '.($value['Extra']=='auto_increment'?'AUTO_INCREMENT':'').' ,';
				}
				if (isset($schema1['index'][$table_name]))
				{
					foreach ($schema1['index'][$table_name] as $key_name=>$value)
					{
						if($key_name == 'PRIMARY')
						{
							$keys[$key_name]='</br>PRIMARY KEY (';
							foreach ($value as $field=>$val)
							{
								$keys[$key_name] .= '`'.$val['Column_name'].'` ,';
							}
						}
						elseif($value[0]['Non_unique']==1)
						{
							$keys[$key_name]='</br>KEY '.$key_name.' (';
							foreach ($value as $field=>$val)
							{
								$keys[$key_name] .= '`'.$val['Column_name'].'` ,';
							}
						}
						else
						{
							$keys[$key_name]='</br>UNIQUE KEY '.$key_name.' (';
							foreach ($value as $field=>$val)
							{
								$keys[$key_name] .= '`'.$val['Column_name'].'` ,';
							}
						}
					}
				}
				foreach ($keys as $key)
				{
					$key = substr($key, 0, -1).'),';
					$results[$table_name][$i]['solve'] .= $key;
				}
				$results[$table_name][$i]['solve'] = substr($results[$table_name][$i]['solve'], 0, -1).');';
				$results[$table_name][$i]['type'] = 'CREATE';
				continue;
			}

			// Check fields exist in both tables

			$fields = array_merge($schema1['tables'][$table_name],
				$schema2['tables'][$table_name]);
			$struc = array();
			$struc2 = array();
			foreach ($schema1['tables'][$table_name] as $field_name => $field) {
				$struc[] = $field_name;
			}
			foreach ($schema2['tables'][$table_name] as $field_name => $field) {
				$struc2[] = $field_name;
			}
			$tem=0;
			foreach ($fields as $field_name => $field) {
				$err=0;
				if (!isset($schema1['tables'][$table_name][$field_name])) {

					$size_1 = count($schema1['tables'][$table_name]);
					$size_2 = count($schema2['tables'][$table_name]);
					if ($size_1 > $size_2){
						$i++;
						$results[$table_name][$i]['error'] = '<em>' . $schema1['name']
							. '</em> is missing field: <code>' . $field_name
							. '</code>.';
						$field_return = end($schema1['tables'][$table_name]);
						if($schema2['tables'][$table_name][$field_name]['Default']!='' && $schema2['tables'][$table_name][$field_name]['Default']!='CURRENT_TIMESTAMP')
						{
							$default='\''.$schema2['tables'][$table_name][$field_name]['Default'].'\'';
						}
						else
						{
							$default=$schema2['tables'][$table_name][$field_name]['Default'];
						}
						$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>MODIFY COLUMN `'.$schema2['tables'][$table_name][$field_name]['Field'].'` '.$schema2['tables'][$table_name][$field_name]['Type'].' '.($schema2['tables'][$table_name][$field_name]['Null']=='NO' ? 'NOT NULL' : '').' '.($schema2['tables'][$table_name][$field_name]['Default']=='' ? '' : 'default '.$default).' '.($schema2['tables'][$table_name][$field_name]['Extra']=='auto_increment'?'AUTO_INCREMENT':'').'</br>AFTER `'.$field_return['Field'].'` ;';
						$results[$table_name][$i]['type'] = 'MODIFY_LAST';
						$err=1;
					}
					continue;
				}
				// the field doesn't exist in the second database
				if (!isset($schema2['tables'][$table_name][$field_name])) {
					$i++;
					$results[$table_name][$i]['error'] = '<em>' . $schema2['name']
						. '</em> is missing field: <code>' . $field_name
						. '</code>';
					$field_return='';

					foreach ($schema1['tables'][$table_name] as $field_before){
						if ($field_before == $field)
						{
							break;
						}
						else
						{
							$field_return = $field_before;
						}
					}
					if($schema1['tables'][$table_name][$field_name]['Default']!='' && $schema1['tables'][$table_name][$field_name]['Default']!='CURRENT_TIMESTAMP')
					{
						$default='\''.$schema1['tables'][$table_name][$field_name]['Default'].'\'';
					}
					else
					{
						$default=$schema1['tables'][$table_name][$field_name]['Default'];
					}
					$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>ADD `'.$schema1['tables'][$table_name][$field_name]['Field'].'` '.$schema1['tables'][$table_name][$field_name]['Type'].' '.($schema1['tables'][$table_name][$field_name]['Null']=='NO' ? 'NOT NULL' : '').' '.($schema1['tables'][$table_name][$field_name]['Default']=='' ? '' : 'default '.$default).($schema1['tables'][$table_name][$field_name]['Extra']=='auto_increment'?' AUTO_INCREMENT ':'').($field_return!=''?'</br>AFTER `'.$field_return['Field'].'`':'</br>FIRST ').';';
					$results[$table_name][$i]['type'] = 'ADD';
					$err=1;
					continue;
				}
				if($err==0){



					if($struc[$tem]!=$struc2[$tem]){
						$i++;
						$results[$table_name][$i]['error'] = 'Field <code>' . $field_name
							. '</code> is not at the same position in \''
							. $table_name . '\'. <em>' . $schema1['name']
							. '</em> as <em>' . $schema2['name']
							. '</em>.';
						$field_return='';
						foreach ($struc as $field_before){
							if ($field_before == $field_name){
								break;
							}
							else
							{
								$field_return = $field_before;
							}
						}
						if($schema1['tables'][$table_name][$field_name]['Default']!='' && $schema1['tables'][$table_name][$field_name]['Default']!='CURRENT_TIMESTAMP')
						{
							$default='\''.$schema1['tables'][$table_name][$field_name]['Default'].'\'';
						}
						else
						{
							$default=$schema1['tables'][$table_name][$field_name]['Default'];
						}
						$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>MODIFY COLUMN `'.$schema1['tables'][$table_name][$field_name]['Field'].'` '.$schema1['tables'][$table_name][$field_name]['Type'].' '.($schema1['tables'][$table_name][$field_name]['Null']=='NO' ? 'NOT NULL' : '').' '.($schema1['tables'][$table_name][$field_name]['Default']=='' ? '' : 'default '.$default).' '.($schema1['tables'][$table_name][$field_name]['Extra']=='auto_increment'?'AUTO_INCREMENT':'').($field_return==''?'</br>FIRST':'</br>AFTER `'.$field_return.'`').' ;';
						$results[$table_name][$i]['type'] = 'MODIFY';
					}

				}
				$tem++;

				// Check that the specific parameters of the fields match

				$s1_params = $schema1['tables'][$table_name][$field_name];
				$s2_params = $schema2['tables'][$table_name][$field_name];
				foreach ($s1_params as $name => $details) {
					if ($s1_params[$name] != $s2_params[$name]) {
						$i++;
						if($name!='Key')
						{
							$results[$table_name][$i]['error'] = 'Field <code>' . $field_name
								. '</code> differs between databases for parameter \''
								. $name . '\'. <em>' . $schema1['name']
								. '</em> has \'' . $s1_params[$name]
								. '\' and <em>' . $schema2['name']
								. '</em> has \'' . $s2_params[$name] . '\'.';
							if($s1_params['Default']!='' && $s1_params['Default']!='CURRENT_TIMESTAMP')
							{
								$default = '\''.$s1_params['Default'].'\'';
							}
							else
							{
								$default = $s1_params['Default'];
							}
							$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>CHANGE `'.$field_name.'` `'.$field_name.'` '.$s1_params['Type'].' '.($s1_params['Null']=='NO' ? 'NOT NULL' : '').' '.($s1_params['Default']=='' ? '' : 'default '.$default).' '.($s1_params['Extra']=='auto_increment'?'AUTO_INCREMENT':'').';';
							$results[$table_name][$i]['type'] = 'CHANGE';
						}
					}
				}

			}

			if (isset($schema1['index'][$table_name]) && isset($schema2['index'][$table_name]))
			{
				$index = $schema1['index'][$table_name];
				$index2 = $schema2['index'][$table_name];
				$keys = array();
				$keys2= array();
				foreach ($index as $key=>$value)
				{
					$key_name=$key;
					foreach ($value as $val)
					{
						$keys[$key_name]['Field'][]=$val['Column_name'];
						$keys[$key_name]['Type'] = $val['Non_unique'];
					}
				}
				foreach ($index2 as $key=>$value)
				{
					$key_name=$key;
					foreach ($value as $val)
					{
						$keys2[$key_name]['Field'][]=$val['Column_name'];
						$keys2[$key_name]['Type'] = $val['Non_unique'];
					}
				}
				foreach ($keys as $key=>$value)
				{
					//The key does not exist in the second database so we add it
					if(!isset($keys2[$key]))
					{
						$i++;
						$results[$table_name][$i]['error'] = 'The key <code>' .$key
							. '</code> does not exist in \''
							. $table_name . '\' <em>' . $schema2['name']
							. '\'</em> but exist in \''
							. $table_name . '\' <em>' . $schema1['name']
							. '</em> '. '\'.';
						if ($key == 'PRIMARY')
						{
							$type = 'PRIMARY KEY';
						}
						elseif($value['Type'] == 1)
						{
							$type = 'INDEX';
						}
						else
						{
							$type = 'UNIQUE';
						}
						$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>ADD '.$type.' '.($key!='PRIMARY' ?'`'.$key.'`':'').' (';
						foreach($value['Field'] as $field)
						{
							$results[$table_name][$i]['solve'] .= ' `'.$field.'` ,';

						}
						$results[$table_name][$i]['solve'] = substr($results[$table_name][$i]['solve'], 0, -1).');';
						$results[$table_name][$i]['type'] = 'INDEX';
					}//The key exist but is different
					elseif($keys[$key]!=$keys2[$key] && $key!= 'PRIMARY'){
						$i++;
						if($value['Type'] == 1)
						{
							$type = 'INDEX';
						}
						else
						{
							$type = 'UNIQUE';
						}
						$results[$table_name][$i]['error'] = 'The key <code>' .$key
							. '</code> differs between databases.';
						$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>DROP INDEX `'.$key.'` ,</br>ADD '.$type.' `'.$key.'` (';
						foreach($value['Field'] as $field)
						{
							$results[$table_name][$i]['solve'] .= ' `'.$field.'` ,';

						}
						$results[$table_name][$i]['solve'] = substr($results[$table_name][$i]['solve'], 0, -1).');';
						$results[$table_name][$i]['type'] = 'INDEX';
					}
				}
				foreach ($keys2 as $key=>$value)
				{
					if ($key=='PRIMARY' && !isset($keys[$key]))
					{
						//The key does not exist in the second database so we add it
						$i++;
						$results[$table_name][$i]['error'] = 'The key <code>' .$key
							. '</code> does not exist in \''
							. $table_name . '\' <em>' . $schema1['name']
							. '</em> '. '\'.';
						if ($key == 'PRIMARY')
						{
							$index_to_drop = 'PRIMARY KEY ;';
						}
						else
						{
							$index_to_drop = 'INDEX `'.$key.'`;';
						}
						$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>DROP '.$index_to_drop;
						$results[$table_name][$i]['type'] = 'INDEX';
					}
				}
			}
			elseif(isset($schema1['index'][$table_name]) && !isset($schema2['index'][$table_name]))
			{
				$index = $schema1['index'][$table_name];
				$keys = array();
				foreach ($index as $key=>$value)
				{
					$key_name=$key;
					foreach ($value as $val)
					{
						$keys[$key_name]['Field'][]=$val['Column_name'];
						$keys[$key_name]['Type'] = $val['Non_unique'];
					}
				}
				foreach ($keys as $key=>$value)
				{
					//The key does not exist in the second database so we add it
					$i++;
					$results[$table_name][$i]['error'] = 'The key <code>' .$key
						. '</code> does not exist in \''
						. $table_name . '\' <em>' . $schema2['name']
						. '\'</em> but exist in \''
						. $table_name . '\' <em>' . $schema1['name']
						. '</em> '. '\'.';
					if ($key == 'PRIMARY')
					{
						$type = 'PRIMARY';
					}
					elseif($value['Type'] == 1)
					{
						$type = 'INDEX';
					}
					else
					{
						$type = 'UNIQUE';
					}
					$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>ADD '.$type.' `'.$key.'` (';
					foreach($value['Field'] as $field)
					{
						$results[$table_name][$i]['solve'] .= ' `'.$field.'` ,';
					}
					$results[$table_name][$i]['solve'] = substr($results[$table_name][$i]['solve'], 0, -1).');';
					$results[$table_name][$i]['type'] = 'INDEX';
				}
			}
			elseif(!isset($schema1['index'][$table_name]) && isset($schema2['index'][$table_name]))
			{
				$index2 = $schema2['index'][$table_name];
				$keys2 = array();
				foreach ($index2 as $key=>$value)
				{
					$key_name=$key;
					foreach ($value as $val)
					{
						$keys2[$key_name]['Field'][]=$val['Column_name'];
						$keys2[$key_name]['Type'] = $val['Non_unique'];
					}
				}
				foreach ($keys2 as $key=>$value)
				{
					//The key does not exist in the second database so we add it
					$i++;
					$results[$table_name][$i]['error'] = 'The key <code>' .$key
						. '</code> does not exist in \''
						. $table_name . '\' <em>' . $schema1['name']
						. '</em> '. '\'.';
					if ($key == 'PRIMARY')
					{
						$index_to_drop = 'PRIMARY KEY ;';
					}
					else
					{
						$index_to_drop = 'INDEX `'.$key.'`;';
					}
					$results[$table_name][$i]['solve'] = 'ALTER TABLE `'.$table_name.'`</br>DROP '.$index_to_drop;
					$results[$table_name][$i]['type'] = 'INDEX';
				}
			}
		}
		return $results;
	}
}
?>