<?php
class updateIO {

	// http://de.php.net/manual/fr/function.copy.php#91010
	public static function rename_dir($src,$dst, $stop = true) {
		static $count = 0;
		if ($stop && ($count >= 20))
			return true;
		updateTools::log_message("rename_dir\trename dir ".$src.' -> '.$dst);
	    $dir = @opendir($src);
	    if ($dir 
	    	&& (@is_dir($dst.DS) 
	    		|| @updateIO::mkdirFTP($dst))
	    	) {
	        while(false !== ( $file = readdir($dir)) ) { 
	            if (( $file != '.' ) && ( $file != '..' )) { 
	                if ( is_dir($src.DS.$file) ) {
						$result = updateIO::rename_dir($src.DS.$file,$dst.DS.$file, $stop);
	                    if ($result !== true)
	                        return $result;
	                } 
	                else { 
						updateTools::log_message("rename_dir\trename file ".$src.DS.$file.' -> '.$dst.DS.$file);
	                    if (!@updateIO::copyFTP($src.DS.$file,$dst.DS.$file)) {
							usleep(200);
		                    if (!@updateIO::copyFTP($src.DS.$file,$dst.DS.$file)) {
								if (strpos($file, '.nfs0000') === false ) { //https://bugzilla.redhat.com/show_bug.cgi?id=511901
									$error = error_get_last();
									updateTools::log_message("rename_dir\terror renaming file ".$src.DS.$file.' -> '.$dst.DS.$file);
									updateTools::log_message("rename_dir\t".$error['message']);
									return $src.DS.$file.' -> '.$dst.DS.$file.
										'<br/>'.$error['message'];
								}
							}
	                    }
	                    @updateIO::unlinkFTP($src.DS.$file);
						$count ++;
	                }
	            } 
				if ($stop && ($count >= 20))
					return true;
	        }
	        closedir($dir);
	        @updateIO::rmdirFTP($src);
			return true;
	    } else {
			$error = error_get_last();
			updateTools::log_message("rename_dir\terror renaming dir ".$src.' -> '.$dst);
			updateTools::log_message("rename_dir\t".$error['message']);
			return $src.' -> '.$dst.
				'<br/>'.$error['message'];
		}
		return false;
	}

	/**
	 * delete a directory
	 * @param  string $dir directory to delete
	 * @return void
	 */
	public static function rrmdir($dir) { 
		updateTools::log_message("rrmdir\tremove directory ".$dir);
	    if (is_dir($dir)) { 
			updateIO::emptydir($dir);
			@updateIO::rmdirFTP($dir); 
	    } else
			updateTools::log_message("rrmdir\tdirectory ".$dir.' doesn\'t exists');
	}

	/**
	 * empty a directory
	 * http://www.php.net/manual/fr/function.rmdir.php#98622
	 * 
	 * @param  string $dir directory to empty
	 * @return void
	 */
	public static function emptydir($dir) { 
		updateTools::log_message("emptydir\tempty directory ".$dir);
	    if (is_dir($dir)) { 
	        $objects = scandir($dir); 
	        foreach ($objects as $object) { 
	            if ($object != "." && $object != "..") { 
	                if (filetype($dir."/".$object) == "dir")
						updateIO::rrmdir($dir."/".$object);
					else {
						@updateIO::unlinkFTP($dir."/".$object);
					}
	            } 
	        } 
	        reset($objects); 
	    } else
			updateTools::log_message("emptydir\tdirectory ".$dir.' doesn\'t exists');
	}

	/**
	 * say if a directory is empty
	 * http://www.php.net/manual/fr/function.is-dir.php#85961
	 * 
	 * @param  string  $dir directory
	 * @return boolean      
	 */
	public static function isEmptyDir($dir){ 
	      return (($files = @scandir($dir)) && count($files) <= 2); 
	}

	/**
	 * list the $max first files in a directory and its subdirectory
	 * http://de.php.net/manual/fr/function.copy.php#91010
	 * 
	 * @param  string $src    the directory
	 * @param  int    $max    maximum results
	 * @param  array  $result private
	 * @return array          the list
	 */
	public static function filesInDir($src, $max = 20, $result = array()) {
		if (count($result) >= $max)
			return $result;
	    $dir = @opendir($src);
	    if ($dir) {
	        while((count($result) < $max)
	        	  && (false !== ( $file = readdir($dir))) ) { 
	            if (( $file != '.' ) && ( $file != '..' )) { 
	                if ( is_dir($src.DS.$file) )
						$result = updateIO::filesInDir($src.DS.$file, $max, $result);
	                else 
						$result[] = $src.DS.$file;
	            } 
	        }
	        closedir($dir);
	    }
		return $result;
	}

	private static $conn_id;
	private static function connectFTP() {
		global $USE_FTP, $FTP_HOST, $FTP_LOGIN, $FTP_PASS;
		
		if (!isset(self::$conn_id)) {
			updateTools::log_message("connectFTP\tconnect to FTP server");
			self::$conn_id = @ftp_connect($FTP_HOST);
			if (self::$conn_id) {
				if (!@ftp_login (self::$conn_id, $FTP_LOGIN?$FTP_LOGIN:'anonymous', $FTP_PASS)) {
					$error = error_get_last();
					updateTools::log_message("connectFTP\tcan not login to FTP server using ".($FTP_LOGIN?$FTP_LOGIN:'anonymous'));
					updateTools::log_message("connectFTP\t".$error['message']);
					$USE_FTP = false;
				}
			} else {
				$error = error_get_last();
				updateTools::log_message("connectFTP\tcan not connect to FTP server ".$FTP_HOST);
				updateTools::log_message("connectFTP\t".$error['message']);
				$USE_FTP = false;
			}
		}
		return self::$conn_id;
	}

	public static function closeFTP() {
		if (isset(self::$conn_id)) {
			ftp_close(self::$conn_id);
			self::$conn_id = null;
		}
	}

	/**
	 * try to copy the file,if can't, try by FTP
	 * @param string $src
	 * @param string $dest
	 * @return boolean
	 * @since 2.6.3.0
	 **/
	public static function copyFTP($src, $dest) {
		global $USE_FTP, $FTP_PATH, $_PS_ROOT_DIR_;
		
		updateTools::log_message("copyFTP\tcopy file ".$src.' to '.$dest);
		
		$result = @copy($src, $dest);
		if (!$result) {
			$error = error_get_last();
			updateTools::log_message("copyFTP\tcan not copy using copy()".($USE_FTP?'. Will try by FTP':''));
			updateTools::log_message("copyFTP\t".$error['message']);
		}
		if (!$result && $USE_FTP) {
			// let's try by FTP
			$conn_id = updateIO::connectFTP();
			
			if ($USE_FTP) {
				$dir = rtrim(str_replace($_PS_ROOT_DIR_, '/'.trim($FTP_PATH, '/').'/', dirname($dest)), '/').'/';
				$result = (@ftp_chdir($conn_id, $dir)
						   && @ftp_put($conn_id, basename($dest), $src, FTP_BINARY));
				if (!$result) {
					$error = error_get_last();
					updateTools::log_message("copyFTP\tcan not copy to ".$dir.basename($dest).' by FTP');
					updateTools::log_message("copyFTP\t".$error['message']);
				}
			}
		}
		return $result;
	}

	/**
	 * try to unlink the file,if can't try by FTP
	 * @param string $filename
	 * @return boolean
	 * @since 2.6.3.0
	 **/
	public static function unlinkFTP($filename) {
		global $USE_FTP, $FTP_PATH, $_PS_ROOT_DIR_;
		
		updateTools::log_message("unlinkFTP\tunlink file ".$filename);
		
		$result = @unlink($filename);
		if (!$result) {
			$error = error_get_last();
			updateTools::log_message("unlinkFTP\tcan not unlink using unlink()".($USE_FTP?'. Will try by FTP':''));
			updateTools::log_message("unlinkFTP\t".$error['message']);
		}
		if (!$result && $USE_FTP) {
			// let's try by FTP
			$conn_id = updateIO::connectFTP();
			
			if ($USE_FTP) {
				$dir = rtrim(str_replace($_PS_ROOT_DIR_, DS.trim($FTP_PATH, DS).DS, dirname($filename)), DS).DS;
				$result = (@ftp_delete($conn_id, $dir.basename($filename)));
				if (!$result) {
					$error = error_get_last();
					updateTools::log_message("unlinkFTP\tcan not unlink ".$dir.basename($filename).' by FTP');
					updateTools::log_message("unlinkFTP\t".$error['message']);
				}
			}
		}
		return $result;
	}

	/**
	 * try to delete the directory,if can't try by FTP
	 * @param string $dir
	 * @return boolean
	 * @since 2.6.3.0
	 **/
	public static function rmdirFTP($dir) {
		global $USE_FTP, $FTP_PATH, $_PS_ROOT_DIR_;
		
		updateTools::log_message("rmdirFTP\tremove directory ".$dir);
		
		$result = @rmdir($dir);
		if (!$result) {
			$error = error_get_last();
			updateTools::log_message("rmdirFTP\tcan not remove directory using rmdir()".($USE_FTP?'. Will try by FTP':''));
			updateTools::log_message("rmdirFTP\t".$error['message']);
		}
		if (!$result && $USE_FTP) {
			// let's try by FTP
			$conn_id = updateIO::connectFTP();
			
			if ($USE_FTP) {
				$dir = rtrim(str_replace($_PS_ROOT_DIR_, DS.trim($FTP_PATH, DS).DS, $dir), DS).DS;
				$result = @ftp_rmdir($conn_id, $dir);
				if (!$result) {
					$error = error_get_last();
					updateTools::log_message("rmdirFTP\tcan not remove directory ".$dir.' by FTP');
					updateTools::log_message("rmdirFTP\t".$error['message']);
				}
			}
		}
		return $result;
	}

	/**
	 * try to create the directory,if can't try by FTP
	 * @param string $dir
	 * @return boolean
	 * @since 2.6.3.0
	 **/
	public static function mkdirFTP($dir) {
		global $USE_FTP, $FTP_PATH, $_PS_ROOT_DIR_;
		
		updateTools::log_message("mkdirFTP\tcreate directory ".$dir);
		
		$result = @mkdir($dir);
		if (!$result) {
			$error = error_get_last();
			updateTools::log_message("mkdirFTP\tcan not create directory using mkdir()".($USE_FTP?'. Will try by FTP':''));
			updateTools::log_message("mkdirFTP\t".$error['message']);
		}
		if (!$result && $USE_FTP) {
			// let's try by FTP
			$conn_id = updateIO::connectFTP();
			
			if ($USE_FTP) {
				$dir = rtrim(str_replace($_PS_ROOT_DIR_, DS.trim($FTP_PATH, DS).DS, $dir), DS).DS;
				$result = @ftp_mkdir($conn_id, $dir);
				if (!$result) {
					$error = error_get_last();
					updateTools::log_message("mkdirFTP\tcan not create directory ".$dir.' by FTP');
					updateTools::log_message("mkdirFTP\t".$error['message']);
				}
			}
		}
		return $result;
	}

	/**
	 * try to copy the file $src to $dest
	 * if $dest == false, will return the content of $src
	 * 
	 * @param string $src 	source file URI
	 * @param boolean/string $dest 	destination filename
	 * @param boolean	$post 		use POST request or not
	 * @return boolean/string
	 * @since 2.6.3.0
	 **/
	public static function copyCurl($src, $dest = false, $post = false) {
		updateTools::log_message("copyCurl\tcopy ".$src.($dest?' to '.$dest:' buffer'));
		
		$result = false;
		if (function_exists('curl_init')) {
			updateTools::log_message("copyCurl\tuse curl");
			if ($post) {
				list($url, $query) = explode('?', $src);
				$ch = curl_init($url);
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch,CURLOPT_POSTFIELDS, $query);
			} else {
				$ch = curl_init($src);
			}

			if ($dest) {
				$fp = fopen($dest, "w");
				curl_setopt($ch, CURLOPT_FILE, $fp);
			} else
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

			curl_setopt($ch, CURLOPT_HEADER, 0);
			
			$result = @curl_exec($ch);
			if ($result === false) {
				$error = error_get_last();
				updateTools::log_message("copyCurl\tcan not copy using curl");
				updateTools::log_message("copyCurl\t".$error['message']);
			}
			curl_close($ch);
			if ($dest)
				fclose($fp);		
		} else {
			if ($dest && !$post)
				$result = @copy($src, $dest);
			else {
				if ($post) {
					list($url, $query) = explode('?', $src);
					// Make the request
					$opts = array(
						'http'=>array(
						'method'=> 'POST',
						'content' => $query,
						'header'  => 'Content-type: application/x-www-form-urlencoded',
						'timeout' => 5,
					));
					$context = stream_context_create($opts);
				} else {
					$url = $src;
					$context = null;
				}
				$result = file_get_contents($url, false, $context);
				if ($dest)
					file_put_contents($dest, $result);
			}
			if (!$result) {
				$error = error_get_last();
				updateTools::log_message("copyCurl\tcan not copy using copy()");
				updateTools::log_message("copyCurl\t".$error['message']);
			}
		}
		return $result;
	}
}
?>