function affpro_setCookie(name, value, path, expires, domain, secure) {
    var curCookie = name + "=" + escape(value) +
        ((expires) ? "; expires=" + expires.toGMTString() : "") +
        ((path) ? "; path=" + path : "; path=/") +
        ((domain) ? "; domain=" + domain : "") +
        ((secure) ? "; secure" : "");
    document.cookie = curCookie;
}

function affpro_getCookie(name) {
    var prefix = name + "=";
    var cookieStartIndex = document.cookie.indexOf(prefix);
    if(cookieStartIndex == -1) return null;
    var cookieEndIndex = document.cookie.indexOf(";", cookieStartIndex + prefix.length);
    if(cookieEndIndex == -1) cookieEndIndex = document.cookie.length;
    return unescape(document.cookie.substring(cookieStartIndex + prefix.length, cookieEndIndex));
}

function affpro_delCookie(name, path, domain) {
    if(affpro_getCookie(name)) {
        document.cookie = name + "=" + 
        ((path) ? "; path=" + path : "; path=/") +
        ((domain) ? "; domain=" + domain : "") +
        "; expires=Thu, 01-Jan-70 00:00:01 GMT";
    }
}

function affpro_setCookieEx(name, value, path, expires, domain, secure)
{
    value=Serialize(value);
    return affpro_setCookie(name, value, path, expires, domain, secure);
}


function affpro_getCookieEx(name)
{ 
    var v=affpro_getCookie(name);
    return Unserialize(v);
}