<?php
// $Id: adm_country_stats_csv.rep.php 5 2008-12-12 05:55:19Z adgar $
checkAccess('A');

/**
 * Add SQL resource
 */
global $transaction_types, $users_types, $base1, $selfname;


$def_currency = getParamByName('def_join_currency');

$sum_sales_multicurrency = $db->getAssoc("SELECT t1.country_id, sum(t1.orig_amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND t1.txn_type=? $sql_q GROUP BY t1.country_id, t1.orig_cur_index", false, array($transaction_types['credit_primary']), DB_FETCHMODE_ASSOC, true);
$sum_sales_multicurrency_chargeback = $db->getAssoc("SELECT t1.country_id, ABS(sum(t1.orig_amount)) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND t1.txn_type=? $sql_q GROUP BY t1.country_id, t1.orig_cur_index", false, array($transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);
$country_keys = $db->getCol("SELECT cnumber FROM $param[dbprefix]countries WHERE (lang_id=?)", 0, array(getLanguageId()));
$top_data0 = $top_data1 = array();

if (count($sum_sales_multicurrency) > 0) {
    //sales
    foreach ($sum_sales_multicurrency as $key_one => $transactions) {
        for($k=0, $max=count($transactions); $k<$max; $k++) {            
            if (in_array($key_one, $country_keys)) {                
                $top_data0[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], $def_currency);
                $top_data1[$key_one] = 0; // ?
            } else {
                $top_data0[0] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], $def_currency);            
                $top_data1[0] = 0; // ?
            }
        }
    }
    //chargeback
    foreach ($sum_sales_multicurrency_chargeback as $key_one => $transactions) {
        for($k=0, $max=count($transactions); $k<$max; $k++) {
            if (in_array($key_one, $country_keys)) {
                $top_data1[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], $def_currency);
            } else {
                $top_data1[0] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], $def_currency);            
            }
        }
    }    
    
    ksort($top_data0);   
    $cur_country_keys = implode(', ', array_keys($top_data0));
    $rs = $db->query("SELECT cnumber, cname FROM $param[dbprefix]countries WHERE cnumber IN ($cur_country_keys) AND (lang_id=?) ORDER BY cnumber", array(getLanguageId()));
    
} else {
    //null data
    $rs = $db->query("SELECT 1 LIMIT 0");
}


$arr1 = array();
foreach ($top_data0 as $k=>$v) {
    $top_data0[$k] = moneytextformat($v, $def_currency);      
    if (isset($top_data1[$k])) $top_data1[$k] = moneytextformat($top_data1[$k], $def_currency);      
    $arr1[] = $v;
}

$rs = $db->getAll("SELECT cnumber, cname FROM $param[dbprefix]countries WHERE cnumber IN ($cur_country_keys) AND (lang_id=?) ORDER BY cnumber", array(getLanguageId()));

$foo_csv = new CSV();
$captions = array(
0 => array(getTranslateText('TT_COUNTRY_STATS')), 
1 => array(
	getTranslateText('TT_COUNTRY'), 
	getTranslateText('TT_FLAT_SALES'), 
	getTranslateText('REP_H_CHARGEBACK')
	)
);
$foo_csv->send_headers('country_stats.csv');
$foo_csv->add($captions);

for($t = 0; $t < count($rs); $t++) {
	$csv_string = array(
	0 => array(
		$rs[$t]['cname'], 
		$top_data0[$rs[$t]['cnumber']], 
		$top_data1[$rs[$t]['cnumber']]
		)
	);
	$foo_csv->add($csv_string);
}


$foo_csv->show();
?>