<?php
// $Id: adm_country_stats.rep.php 11 2009-08-06 04:53:31Z adgar $
checkAccess('A');

/**
 * Add SQL resource
 */
global $transaction_types, $users_types, $base1, $selfname;

$sum_sales_multicurrency = $db->getAssoc("SELECT t1.country_id, sum(t1.orig_amount) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND t1.txn_type=? $sql_filter GROUP BY t1.country_id, t1.orig_cur_index", false, array($transaction_types['credit_primary']), DB_FETCHMODE_ASSOC, true);
$sum_sales_multicurrency_chargeback = $db->getAssoc("SELECT t1.country_id, ABS(sum(t1.orig_amount)) as amount, t1.orig_cur_index FROM $param[dbprefix]transactions as t1 WHERE (t1.approved=1) AND t1.txn_type=? $sql_filter GROUP BY t1.country_id, t1.orig_cur_index", false, array($transaction_types['debit_chargeback']), DB_FETCHMODE_ASSOC, true);
$country_keys = $db->getCol("SELECT cnumber FROM $param[dbprefix]countries WHERE (lang_id=?)", 0, array(getLanguageId()));
$top_data0 = $top_data1 = array();

if (count($sum_sales_multicurrency) > 0) {
    //sales
    foreach ($sum_sales_multicurrency as $key_one => $transactions) {
        for($k=0, $max=count($transactions); $k<$max; $k++) {            
            if (in_array($key_one, $country_keys)) {                
                $top_data0[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
                $top_data1[$key_one] = 0; // ?
            } else {
                $top_data0[0] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);            
                $top_data1[0] = 0; // ?
            }
        }
    }
    //chargeback
    foreach ($sum_sales_multicurrency_chargeback as $key_one => $transactions) {
        for($k=0, $max=count($transactions); $k<$max; $k++) {
            if (in_array($key_one, $country_keys)) {
                $top_data1[$key_one] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);
            } else {
                $top_data1[0] += moneyConvert($transactions[$k]['amount'], $transactions[$k]['orig_cur_index'], DEFAULT_JOIN_CURRENCY);            
            }
        }
    }    
    
    ksort($top_data0);   
    $cur_country_keys = implode(', ', array_keys($top_data0));
    $rs = $db->query("SELECT cnumber, cname FROM $param[dbprefix]countries WHERE cnumber IN ($cur_country_keys) AND (lang_id=?) ORDER BY cnumber", array(getLanguageId()));
    
} else {
    //null data
    $rs = $db->query("SELECT 1 LIMIT 0");
}

if ($pager_enable) {
    $records = array('in_page'=>PAGER_PER_PAGE);
    $records['start'] = (isset($_REQUEST['entrant']) && (intval($_REQUEST['entrant']) > 0)) ? ((int)$_REQUEST['entrant'] - 1)*$records['in_page'] : 0;
    $records['all'] = $rs->numRows();
    $this->pager_data = $records;
}

$arr1 = array();
foreach ($top_data0 as $k=>$v) {
    $top_data0[$k] = moneytextformat($v, DEFAULT_JOIN_CURRENCY);      
    if (isset($top_data1[$k])) $top_data1[$k] = moneytextformat($top_data1[$k], DEFAULT_JOIN_CURRENCY);      
    $arr1[] = $v;
}

$this->addResource('rs', $rs);
$this->addResource('top_data0', $top_data0);
$this->addResource('top_data1', $top_data1);

$this->rows_tlp_cnt = $rs->numRows();
$this->sortIndexs($arr1, SORT_NUMERIC, SORT_DESC);



/**
 * Add Report Headers
 */
$this->addColHeader(getTranslateText('TT_COUNTRY'), 'left', "width=\"70%\" nowrap=\"nowrap\""); //1
$this->addColHeader(getTranslateText('TT_FLAT_SALES'), 'right', "width=\"15%\" nowrap=\"nowrap\""); //2
$this->addColHeader(getTranslateText('REP_H_CHARGEBACK'), 'right', "width=\"15%\" nowrap=\"nowrap\""); //3

/**
 * Add row template
 */
$this->addCellTemplate("%rs::[cname]%"); //1
$this->addCellTemplate("%fn(reslink,top_data0)::rs::[cnumber]%"); //2
$this->addCellTemplate("%fn(reslink,top_data1)::rs::[cnumber]%"); //3

/**
 * Add ignor lists
 */

//$this->setPrintIgnoreCols(9);
//$this->setExcelIgnoreCols(9);

/**
 * Add text description
 */
$this->description_wordcode = getTranslateText('TT_COUNTRY_STATS');
$this->setNorecordText(getTranslateText('TT_NOTEXT11'));

?>