<?php
// $Id: useractions.inc.php 251 2008-01-21 09:45:22Z adgar $

require_once('emailsender.inc.php');
require_once('transactionbuilder.inc.php');

function approveUser($user_id, $orig_bonus_txn_id) {    
    global $db, $param;    
    $db->query("UPDATE $param[dbprefix]users SET approved=? WHERE id=?", array(1, $user_id));    
    $initial_result = transaction_credit_initial($orig_bonus_txn_id, $user_id);
    if (true === $initial_result[0])
        sendUserMailFromTemplate('approvedaccount',$user_id);
    return;
}

function declineUser($user_id) {
    global $db, $param;
    sendUserMailFromTemplate('declinedaccount',$user_id);
    removeUser($user_id);
    return;
}

function removeUser($user_id) {
    global $db, $param, $users_types;
    $rs=$db->query("SELECT id, usertype, name FROM $param[dbprefix]users WHERE id=?", array($user_id));
    list($user_key, $user_type, $user_name) = $rs->fetchRow(DB_FETCHMODE_ORDERED);
    $db->query("DELETE FROM $param[dbprefix]users WHERE id=?", array($user_key));
    $db->query("DELETE FROM $param[dbprefix]users_ids WHERE userid=?", array($user_key));
    $db->query("DELETE FROM $param[dbprefix]withdraw_users WHERE affiliateid=?", array($user_key));        
    $db->query("DELETE FROM $param[dbprefix]traffic WHERE user_id=?", array($user_key));
    $db->query("DELETE FROM $param[dbprefix]transactions WHERE user_id=?", array($user_key));
    $db->query("DELETE FROM $param[dbprefix]hotlinks WHERE affiliateid=?", array($user_key));
    //tickets
    $db->query("DELETE FROM tickets_tickets WHERE tickets_username=?", array($user_name));    
    return;
}

function createUserTextID() {
    global $db, $param;    
    $textid_cnt=1;
    $textid_primay_part = chr(rand(65,90)) . chr(rand(65,90));
    $textid_secondary_part = date('mdy');             
    while (0 != $db->getOne("SELECT count(*) FROM $param[dbprefix]users_ids WHERE UCASE(text_id)=UCASE(?)", array($textid_primay_part . $textid_cnt . $textid_secondary_part))) {
        $textid_cnt++;
    }        
    $textid = $textid_primay_part . $textid_cnt . $textid_secondary_part;          
    return $textid;
}

function loginUser($login, $passw, $verif_code=null, $usertype=array(-1), $role) {
    global $db, $param;    
    //verification image
    $verif_image = (int) getParamByName('verification_image');     
    if ((1 == $verif_image) || (2 == $verif_image)) {
        if (strtolower($verif_code) != strtolower($_SESSION['simageText'])) {
            $_SESSION['simageText'] = '';
            return AFFPRO::raiseError('ERROR_INCORRECT_VERIF_CODE');
        }                
    }    
    //login and password verification
    $sql = sql_placeholder("SELECT * FROM $param[dbprefix]users where name=? AND password=? AND usertype in (?@)", $login, $passw, $usertype);
    $rs = $db->query($sql);
    if($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        if  (1 == intval($row['approved'])) {
            $db->query("UPDATE $param[dbprefix]users SET visit_time=now(), ip=? WHERE id=?", array($_SERVER['REMOTE_ADDR'], $row['id']));
            $_SESSION['userid'] = $row['id'];
            $_SESSION['role'] = $role;
            return true;
        } else {
            return AFFPRO::raiseError('ERROR_NEED_APPROVE');
        }
    } else {
        return AFFPRO::raiseError('ERROR_INCORRRECT_LOGIN');            
    }
    //    
}

function onUserLoginSuccessfully() {
    global $db, $param, $transaction_types;
    //clear verification code
    $_SESSION['simageText'] = '';
    //create traffic transactions for user    
    $payout_level = $db->getOne("SELECT payout FROM $param[dbprefix]users WHERE id=?", array($_SESSION['userid']));
    $foo = $db->getOne("SELECT count(*) FROM $param[dbprefix]payrates WHERE ppc > 0 AND level=?", array($payout_level));
    if (0 != $foo) {
    
    $currency_id = getParamByName('def_join_currency');
$sql = "
CREATE TEMPORARY TABLE np_traffic
SELECT t1.tr_id, t1.user_id,
t1.create_date, t1.product_id,
(t1.clickcount * t2.ppc) as amount
FROM $param[dbprefix]traffic as t1
INNER JOIN $param[dbprefix]payrates as t2
ON t1.product_id=t2.group_id
WHERE t1.create_date<? AND t1.user_id=? AND t2.ppc>0 AND t2.level=?
";
$db->query($sql, array(date('Y-m-d'), $_SESSION['userid'], $payout_level));    

$sql = "
SELECT t1.*
FROM  np_traffic as t1
LEFT JOIN $param[dbprefix]transactions as t2
ON t1.tr_id=t2.key_one AND t2.txn_type=?
WHERE (t2.key_one is null) AND t1.user_id=?
";  
  
    $rs = $db->query($sql, array($transaction_types['credit_tfaffic'], $_SESSION['userid']));       
    while ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        transaction_credit_traffic($row, $currency_id);
    }
    
$sql = "
DROP TABLE np_traffic
";
$db->query($sql);
    }    
    //currency factors update
    $curfactors_lastupdate = (int) getParamByName('curfactors_lastupdate');
    if (time() >= ($curfactors_lastupdate + CURFACTORS_UPDTIME)) {
        updateAllConvertFactors();
        setParamByName('curfactors_lastupdate', time());
    }    
    return;
}



?>