<?php
// $Id: transactionbuilder.inc.php 8 2009-08-06 04:52:51Z adgar $

require_once('emailsender.inc.php');
require_once('realip.lib.php');

function getDateIntervalNumbers() {   
    
    if (0 != func_num_args()) {
        $tmp =  func_get_arg(0);
        $time = strtotime(date('Y-m-d 00:00:00', strtotime($tmp)));
    } else {
        $time = strtotime(date('Y-m-d 00:00:00', time()));
    }
    // 1 day = 86400 sec   
    $delta = $time - START_DATE_PERIOD;
    $start_date = split(' ', date('Y n d', START_DATE_PERIOD));
    $cur_date = split(' ', date('Y n d', $time));
    $day_cnt = ceil($delta / 86400);
    $return = array(
        'daily' => $day_cnt,
        'weekly' => ceil($day_cnt / 7),
        'bi_weekly' => ceil($day_cnt / 14),
        'monthly' => ($cur_date[1] - $start_date[1]) + 11*($cur_date[0] - $start_date[0]),
        'half_monthly' => 2*($cur_date[1] - $start_date[1]) + 23*($cur_date[0] - $start_date[0]) - (($cur_date[2] <= 15) ? 1 : 0)
    );   
           
    return $return;
}

function getFormatStrInterval($date_period_type, &$index_array) {  	
	global $date_period_types;
	$return = array();
	$start_day = min($index_array);
	$stop_date = max($index_array);
    $start_date = split(' ', date('Y n d m', START_DATE_PERIOD));		
	switch ($date_period_type) {
	    case $date_period_types['daily_number']:
	        $format = '%a %b %d, %Y';	        
        	for($i=$start_day; $i<=$stop_date; $i++) {
        	    $days =  86400 * $i;
        	    $return[$i] = strftime($format, mktime(0, 0, $days, $start_date[3], $start_date[2], $start_date[0]));
        	}
	    break;
	    case $date_period_types['weekly_number']:
	        $format = '%b %d, %Y';	        
        	for($i=$start_day; $i<=$stop_date; $i++) {
        	    $delta = 7;
        	    $days =  86400 * $i * $delta;
        	    $return[$i] = strftime($format, mktime(0, 0, $days, $start_date[3], $start_date[2] - $delta, $start_date[0]))  . ' - ' . strftime($format, mktime(-2, 0, $days, $start_date[3], $start_date[2], $start_date[0]));
        	}	        
	    break;
	    case $date_period_types['bi_weekly_number']:
	        $format = '%b %d, %Y';
        	for($i=$start_day; $i<=$stop_date; $i++) {
        	    $delta = 14;
        	    $days =  86400 * $i * $delta;
        	    $return[$i] = strftime($format, mktime(0, 0, $days, $start_date[3], $start_date[2] - $delta, $start_date[0]))  . ' - ' . strftime($format, mktime(-2, 0, $days, $start_date[3], $start_date[2], $start_date[0]));
        	}	        
	    break;
	    case $date_period_types['monthly_number']:
	        $format = '%b %Y';
        	for($i=$start_day; $i<=$stop_date; $i++) {
        	    $months = $start_date[3] + $i;
        	    
        	    $return[$i] = strftime($format, mktime(0, 0, 0, $months, $start_date[2], $start_date[0]));
        	}	        
	    break;
	    case $date_period_types['half_monthly_number']:
	        $format = '%b %d, %Y';	        
            for($i=$start_day; $i<=$stop_date; $i++) {
            	$months = $start_date[3] + floor($i/2);	    	    
                if ($i%2 == 0 ) {
            	    $return[$i] = strftime($format, mktime(0, 0, 0, $months, 16, $start_date[0])) . ' - ' . strftime($format, mktime(23, 59, 59, $months+1, 0, $start_date[0]));
                } else {
            	    $return[$i] = strftime($format, mktime(0, 0, 0, $months, 1, $start_date[0])) . ' - ' . strftime($format, mktime(23, 59, 59, $months, 15, $start_date[0]));
                }	
            }        
	    break;
	}
	return $return;
}

function _txn_create(&$fields) {
    global $db, $param;        
    if (!is_array($fields) || 0 == count($fields)) return false;
    if (!isset($fields['txn_type'], $fields['amount'], $fields['user_id'])) return false;
    //txn_type
    $txn['txn_type'] = $fields['txn_type'];
    //orig_order_id 
    $txn['orig_order_id'] = isset($fields['orig_order_id']) ? $fields['orig_order_id'] : transaction_create_unique_id(); 
    //orig_amount
    $txn['orig_amount'] = isset($fields['orig_amount']) ? $fields['orig_amount'] : $fields['amount'];
    //orig_cur_index
    $txn['orig_cur_index'] = isset($fields['orig_cur_index']) ? $fields['orig_cur_index'] : DEFAULT_JOIN_CURRENCY;
    //amount
    $txn['amount'] = $fields['amount'];
    //create_date 
    $txn['create_date'] = empty($fields['create_date']) ? date('Y-m-d H:i:s', time()) : $fields['create_date'];
    //user_id
    $txn['user_id'] = intval($fields['user_id']);
    //country_id
    $txn['country_id'] = isset($fields['country_id']) ? $fields['country_id'] : 0;     
    //approved
    $txn['approved'] = (isset($fields['approved']) && (true == (bool)$fields['approved'])) ? 1 : 0;
    //ip_long
    $ip = isset($fields['ip']) ? $fields['ip'] :  get_real_IP();
    $txn['ip_long'] =  ip2long($ip);   
    if (false === $txn['ip_long']) {
        $txn['ip_long'] = -1;
    }     
    //product_id
    $txn['product_id'] = isset($fields['product_id']) ? intval($fields['product_id']) : 0;
    //addition_info
    $txn['addition_info'] = isset($fields['addition_info']) ? $fields['addition_info'] : '';
    if (strlen($txn['addition_info']) > 128) {
        $txn['addition_info'] = substr($txn['addition_info'], 0, 127);
    }
    //key_one
//    $txn['key_one'] = isset($fields['key_one']) ? $fields['key_one'] : '';
    $txn['key_one'] = isset($fields['key_one']) ? $fields['key_one'] : '0';
//BEGIN TEMPORARY CODE    
    //is_recurring
    $txn['is_recurring'] = isset($fields['is_recurring']) ? 1 : 0;
//END TEMPORARY CODE    
    $txn['customer_id'] = isset($fields['customer_id']) ? $fields['customer_id'] : 0;
    // daily_number, weekly_number, bi_weekly_number, monthly_number, half_monthly_number
    $txn_create_time_period = getDateIntervalNumbers($txn['create_date']);    
    $txn['daily_number'] = $txn_create_time_period['daily'];
    $txn['weekly_number'] = $txn_create_time_period['weekly'];
    $txn['bi_weekly_number'] = $txn_create_time_period['bi_weekly'];
    $txn['monthly_number'] = $txn_create_time_period['monthly'];
    $txn['half_monthly_number'] = $txn_create_time_period['half_monthly'];
    unset($ip, $txn_create_time_period);

    $sql = sql_placeholder("INSERT INTO $param[dbprefix]transactions (txn_type, orig_order_id, orig_amount, orig_cur_index, amount, create_date, user_id, country_id, approved, ip_long, product_id, addition_info, key_one, is_recurring, customer_id, daily_number, weekly_number, bi_weekly_number, monthly_number, half_monthly_number) VALUES(?@)", $txn);
    $db->query($sql);
    return true;
}

function transaction_credit_traffic($data, $currency_id) { // +   
    global $transaction_types;          
    //transaction_amount      
    if ($data['amount'] <= 0) {
        return false;    
    }    
    //create transaction 
    $txn = array(
    'txn_type' => $transaction_types['credit_tfaffic'],
    'orig_amount' => $data['amount'],
    'amount' => $data['amount'],    
    'orig_cur_index' => $currency_id,
    'create_date' => date('Y-m-d H:i:s', strtotime($data['create_date'] . ' 00:00:00')),
    'user_id' => $data['user_id'],
    'approved' => 1,
    'product_id' => $data['product_id'],
    'key_one' => $data['tr_id']
    );
    _txn_create($txn);     
    return true;
}

function transaction_credit_initial($orig_order_id, $user_id) {
    global $db, $param, $transaction_types, $users_types;   
    $initial_balance = (float)getParamByName('initial_balance');             
    if ($initial_balance > 0) {
        $error_code = 0;
        for($i=0; $i<1; $i++) {              
            //Check on the validity of param "orig_order_id"
            $tmp = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($orig_order_id));    
            if (0 != $tmp) {
                $error_code=3010;
                break;  
            }
           
        }
        if (0 != $error_code) return array(false, $error_code);         
        $orig_cur_index = DEFAULT_JOIN_CURRENCY; // default currency index
        $txn_amount_coverted = $initial_balance;       
        //
        $txn = array(
        'txn_type' => $transaction_types['credit_initial_bonus'],
        'orig_order_id' => $orig_order_id,
        'amount' => $initial_balance,
        'user_id' => $user_id,
        'approved' => 1
        );
        _txn_create($txn);          
        $record_id = mysql_insert_id();          
        return array(true, $record_id);
    } else {
        return array(true, '');
    }

}

function transaction_manual_sale($orig_order_id, $orig_amount, $orig_cur_index, $user_id, $from_ip, $product_id, $customer_id=0, $country_id=0, $addition_info=null, $approved=0, $ignore_tnx_delay=false, $is_recurring=false, $create_data=null) { // +
    global $db, $param, $transaction_types, $users_types;   
    $error_code = 0;
    while(true) {
        //Check on the validity of param "orig_amount"
        if (!is_numeric($orig_amount)) {
            $error_code=1020;
            break;
        }
        if (empty($orig_amount)) {
            $error_code=1030;
            break;
        }        
        //Check on the validity of param "orig_order_id"
        $tmp = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($orig_order_id));    
        if (0 != $tmp) {
            $error_code=1010;
            break;  
        }  
        //Check on the validity of param "user_id" 
        $rs = $db->query("SELECT *, payout as payout_level FROM $param[dbprefix]users WHERE id=?", array($user_id));
        if (!($user_info = $rs->fetchRow(DB_FETCHMODE_ASSOC))) {
            $error_code=1040;
            break;            
        }            
        //Check on the validity of param "product_id" 
        $rs = $db->query("SELECT * FROM $param[dbprefix]payrates WHERE (group_id=?) AND (level=?)", array($product_id, $user_info['payout_level']));
        if (!($payrates_info = $rs->fetchRow(DB_FETCHMODE_ASSOC))) {
            $error_code=1050;
            break;            
        }
        break;
    }
    
    $txn = array(
    'txn_type' => $transaction_types['credit_primary'],
    'orig_order_id' => $orig_order_id,
    'orig_amount' => $orig_amount,
    'orig_cur_index' => $orig_cur_index,
    'amount' => $orig_amount,
    'create_date' => empty($create_data) ? date('Y-m-d H:i:s') : $create_data,
    'user_id' => $user_id,
    'country_id' => $country_id,
    'approved' => $approved,
    'ip' => $from_ip,
    'product_id' => $product_id,
    'customer_id' => $customer_id,
    'addition_info' => $addition_info
    );    
    if ($is_recurring) {
        $txn['is_recurring'] = 1;
    }
    _txn_create($txn);
    $record_id = mysql_insert_id();
    return array(true, $record_id, $txn_amount, $orig_cur_index);
}

function transaction_credit_primary($orig_order_id, $orig_amount, $orig_cur_index, $user_id, $from_ip, $product_id, $customer_id=0, $country_id=0, $addition_info=null, $approved=0, $ignore_tnx_delay=false, $is_recurring=false, $create_data=null) { // +
    global $db, $param, $transaction_types, $users_types;   
    $error_code = 0;
    for($i=0; $i<1; $i++) {
        //Check on the validity of param "orig_amount"
        if (!is_numeric($orig_amount)) {
            $error_code=1020;
            break;
        }
        if (empty($orig_amount)) {
            $error_code=1030;
            break;
        }        
        //Check on the validity of param "orig_order_id"
        $tmp = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($orig_order_id));    
        if (0 != $tmp) {
            $error_code=1010;
            break;  
        }  
        //Check on the validity of param "user_id" 
        $rs = $db->query("SELECT *, payout as payout_level FROM $param[dbprefix]users WHERE id=?", array($user_id));
        if (!($user_info = $rs->fetchRow(DB_FETCHMODE_ASSOC))) {
            $error_code=1040;
            break;            
        }            
        //Check on the validity of param "product_id" 
        $rs = $db->query("SELECT * FROM $param[dbprefix]payrates WHERE (group_id=?) AND (level=?)", array($product_id, $user_info['payout_level']));
        if (!($payrates_info = $rs->fetchRow(DB_FETCHMODE_ASSOC))) {
            $error_code=1050;
            break;            
        }
               
        //Transaction delay
        if (!$ignore_tnx_delay) {            
            $transaction_delay = 60*((int) getParamByName('transaction_delay_min'));
            if ($transaction_delay > 0) {
                // from ip
                $from_ip_long =  ip2long($from_ip);   
                if (false === $from_ip_long) {
                    $from_ip_long = -1;
                }                
               $repeat_transaction_cnt = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE (ip_long=?) AND ((UNIX_TIMESTAMP() - UNIX_TIMESTAMP(create_date)) < ?)", array($from_ip_long, $transaction_delay));
               if (0 != $repeat_transaction_cnt) { 
                $error_code=1060;
                break;                
               }
            }
        }

   
    }
    if (0 != $error_code) return array(false, $error_code);    
    //transaction_amount  
    if ((floatval($payrates_info['ot_flat']) > 0) || (floatval($payrates_info['ot_perc']) > 0)) {
        $onetime_transaction_cnt = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE product_id=? AND user_id=? AND customer_id=?", array($product_id, $user_id, $customer_id));
        if (0 != $onetime_transaction_cnt) {
            $error_code=1070;
            return array(false, $error_code);    
        }
        $txn_amount += floatval($payrates_info['ot_flat']);
        $txn_amount += floatval($orig_amount) * floatval($payrates_info['ot_perc']) / 100;
    } else {
        $txn_amount += floatval($payrates_info['pps_flat']);
        $txn_amount += floatval($orig_amount) * floatval($payrates_info['pps_perc']) / 100;
    }
    
    if (0 == $txn_amount){
        return array(false, 1080);
    }
    
    $txn = array(
    'txn_type' => $transaction_types['credit_primary'],
    'orig_order_id' => $orig_order_id,
    'orig_amount' => $orig_amount,
    'orig_cur_index' => $orig_cur_index,
    'amount' => $txn_amount,
    'create_date' => empty($create_data) ? date('Y-m-d H:i:s') : $create_data,
    'user_id' => $user_id,
    'country_id' => $country_id,
    'approved' => $approved,
    'ip' => $from_ip,
    'product_id' => $product_id,
    'customer_id' => $customer_id,
    'addition_info' => $addition_info
    );    
    if ($is_recurring) {
        $txn['is_recurring'] = 1;
    }
    _txn_create($txn);
    $record_id = mysql_insert_id();
    return array(true, $record_id, $txn_amount, $orig_cur_index);
}
    
function transaction_credit_secondary($primary_record_id, $addition_info=null, $credit_secondary_depth=0, $credit_secondary_level=0) { // +
    if ($credit_secondary_level < $credit_secondary_depth) {    
        global $db, $param, $transaction_types;    
        $error_code = 0;
        for($i=0; $i<1; $i++) {
            //Check on the validity of param "primary_record_id" 
            $rs = $db->query("SELECT * FROM $param[dbprefix]transactions WHERE txn_id=?", array($primary_record_id));
            if (!($primary_credit_info = $rs->fetchRow(DB_FETCHMODE_ASSOC))) {
                $error_code=2010;
                break;            
            }
            //             
        }
        if (0 != $error_code) return array(false, $error_code);    
        $user_info = $db->getRow("SELECT parent_affil, payout as payout_level FROM $param[dbprefix]users WHERE id=?", array($primary_credit_info['user_id']), DB_FETCHMODE_ASSOC);
        if ( 0 == intval($user_info['parent_affil'])) {
            return array(true, 0);
        }
        //transaction_amount        
        $credit_secondary_percentage = getParamByName('credit_secondary_percentage');
        $txn_second_amount = $primary_credit_info['amount'] * floatval($credit_secondary_percentage) / 100;
        $txn_cur_index = $primary_credit_info['orig_cur_index'];
        if (0 == $txn_second_amount){
            return array(false, 2050);
        }
        //create transaction
        $txn = array(
        'txn_type' => $transaction_types['credit_secondary'],
        'orig_order_id' => $primary_credit_info['orig_order_id'],
        'orig_amount' => $primary_credit_info['amount'],
        'orig_cur_index' => $txn_cur_index,
        'amount' => $txn_second_amount,
        'user_id' => $user_info['parent_affil'],
        'key_one' => $primary_record_id,
        'approved' => 1,
        'product_id' => $primary_credit_info['product_id'],
        'addition_info' => $addition_info        
        );        
        _txn_create($txn);
        $record_id = mysql_insert_id();        
        $mail_template_param = array(
            'TransactionAmount'=> moneytextformat($txn_second_amount, $txn_cur_index)
        );
        sendUserMailFromTemplate('transaction', intval($user_info['parent_affil']), $mail_template_param);
        $credit_result = transaction_credit_secondary($record_id, '', $credit_secondary_depth, $credit_secondary_level+1);
        if (false == $credit_result[0]) return $credit_result;
        $return = array(true, $record_id, $txn_second_amount, $txn_cur_index);
    } else {        
        $return = array(true, '');
    }
    return $return;
}

function transaction_debit_paid($orig_order_id, $orig_amount, $orig_cur_index, $user_id, $addition_info=null) { // -
    global $db, $param, $transaction_types;   
    $error_code = 0;
    for($i=0; $i<1; $i++) {
        //Check on the validity of param "orig_amount"
        if (!is_numeric($orig_amount)) {
            $error_code=2020;
            break;
        }
        if (empty($orig_amount)) {
            $error_code=2030;
            break;
        }
        //Check on the validity of param "orig_order_id"
        $tmp = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($orig_order_id));    
        if (0 != $tmp) {
            $error_code=2010;
            break;  
        }                
        //Check on the validity of param "user_id" 
        $rs = $db->query("SELECT payout as payout_level FROM $param[dbprefix]users WHERE id=?", array($user_id));
        if (!($user_info = $rs->fetchRow(DB_FETCHMODE_ASSOC))) {
            $error_code=2040;
            break;            
        }            
   
    }
    if (0 != $error_code) return array(false, $error_code);    
    //transaction_amount
    $txn_amount = (-1)*abs($orig_amount);
    //create transaction 
    $txn = array(
    'txn_type' => $transaction_types['debit_payout'],
    'orig_order_id' => $orig_order_id,
    'orig_cur_index' => $orig_cur_index,
    'amount' => $txn_amount,
    'user_id' => $user_id,
    'approved' => 1,
    'addition_info' => $addition_info
    );
    _txn_create($txn);     
    $record_id = mysql_insert_id();
    return array(true, $record_id, abs($txn_amount), $orig_cur_index);
}

function transaction_refund($ref_order_id, $orig_order_id, $orig_amount, $orig_cur_index, $user_id, $from_ip, $addition_info=null) { // +
    global $db, $param, $transaction_types;
    $error_code = 0;
    for($i=0; $i<1; $i++) {        
        //Check on the validity of param "orig_amount"
        if (!is_numeric($orig_amount)) {
            $error_code=3010;
            break;
        }
        if (empty($orig_amount)) {
            $error_code=3020;
            break;
        }        
        //Check on the validity of param "orig_order_id"
        $tmp = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($orig_order_id));
        if (0 != $tmp) {
            $error_code=3030;
            break;  
        }                
        //Check on the validity of param "ref_order_id" 
        $refund_credit_rs = $db->query("SELECT * FROM $param[dbprefix]transactions WHERE (orig_order_id=?) AND ((txn_type=?) OR (txn_type=?)) ORDER BY txn_type, amount DESC", array($ref_order_id, $transaction_types['credit_primary'], $transaction_types['credit_secondary']));
        if (0 == $refund_credit_rs->numRows()) {
            $error_code=3040;
            break;            
        }   
        $tmp = $refund_credit_rs->fetchRow(DB_FETCHMODE_ASSOC, 0);
        $key_one = $tmp['txn_id'];
        
        //Check parent transaction id
        $tmp = $db->getOne("SELECT count(*) FROM $param[dbprefix]transactions WHERE (txn_type=?) AND (key_one=?)", array($transaction_types['debit_chargeback'], $key_one));
        if (0 != $tmp) {
            $error_code=3030;
            break;  
        }        
    }
    
    if (0 != $error_code) return array(false, $error_code); 
    for ($i=0, $txn_count = $refund_credit_rs->numRows(); $i <$txn_count; $i++) {
        $refund_credit_row = $refund_credit_rs->fetchRow(DB_FETCHMODE_ASSOC, $i);
        if ($refund_credit_row['txn_type'] == $transaction_types['credit_primary']) {           
            $persentage = $refund_credit_row['amount']/$refund_credit_row['orig_amount'];
           
            $txn_amount = (-1)*abs($orig_amount)*$persentage;            
            $txn = array(
            'txn_type' => $transaction_types['debit_chargeback'],
            'orig_order_id' => $orig_order_id,
            'orig_amount' => (-1)*abs($orig_amount),
            'orig_cur_index' => $orig_cur_index,
            'amount' => (-1)*abs($txn_amount),
            'user_id' => $user_id,
            'country_id' => $refund_credit_row['country_id'],
            'approved' => 1,
            'ip' => $from_ip,
            'addition_info' => $addition_info,
            'key_one' => $key_one
            );
          
        } else { 
            $txn = array(
            'txn_type' => $transaction_types['debit_chargeback'],
            'orig_order_id' => $orig_order_id,
            'orig_amount' => (-1)*abs($refund_credit_row['orig_amount']),
            'orig_cur_index' => $refund_credit_row['orig_cur_index'],
            'amount' => (-1)*abs($refund_credit_row['amount']),
            'user_id' => $refund_credit_row['user_id'],
            'country_id' => $refund_credit_row['country_id'],
            'approved' => 1,
            'ip' => $from_ip,             
            'addition_info' => $addition_info,
            'key_one' => $refund_credit_row['txn_id'] //parent transaction id 
            );
        }
        _txn_create($txn); 
    }
    return array(true, '');  
}


function transaction_approve($txn_id){
    global $db, $param;
    $rs = $db->query("SELECT * FROM $param[dbprefix]transactions WHERE approved=0 AND txn_id=?", array($txn_id));
    if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {    
        $db->query("UPDATE $param[dbprefix]transactions SET approved=1 WHERE txn_id=?", array($txn_id));
        $mail_template_param = array(
            'TransactionAmount'=> moneytextformat($row['amount'], $row['orig_cur_index'])
        );          
        sendUserMailFromTemplate('approvetransaction', intval($row['user_id']), $mail_template_param);
        $credit_secondary_depth = (int)getParamByName('credit_secondary_depth'); 
        $credit_result = transaction_credit_secondary($txn_id, '', $credit_secondary_depth, 0);
    }
    return;
}

function transaction_decline($txn_id){
    global $db, $param;
    $rs = $db->query("SELECT * FROM $param[dbprefix]transactions  WHERE txn_id=?", array($txn_id));
    if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {     
        transaction_remove($row['txn_id']);
        $mail_template_param = array(
            'TransactionAmount'=> moneytextformat($row['amount'], $row['orig_cur_index'])
        );             
        sendUserMailFromTemplate('declinetransaction', $row['user_id'], $mail_template_param);       
    }    
    return;
}

function transaction_remove($txn_id){
    global $db, $param, $transaction_types;
    $rs = $db->query("SELECT * FROM $param[dbprefix]transactions WHERE txn_id=?", array($txn_id));
    if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        if ($row['txn_type'] == $transaction_types['credit_primary']) {
            //delete chargeback
            $chargeback_orig_order_id = $db->getOne("SELECT orig_order_id FROM $param[dbprefix]transactions WHERE key_one=?", array($row['txn_id']));
            if (!empty($chargeback_orig_order_id))
                $db->query("DELETE FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($chargeback_orig_order_id));
            //detepe primary credit            
            $db->query("DELETE FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($row['orig_order_id']));
        } 
        //delete chargeback
        else if ($row['txn_type'] == $transaction_types['debit_chargeback']) {            
            $parent_tnx = $db->getRow("SELECT txn_type, orig_order_id FROM $param[dbprefix]transactions WHERE txn_id=?", array($row['key_one']), DB_FETCHMODE_ASSOC);  
            //delete primary and all tier chargeback
            if ($parent_tnx['txn_type'] == $transaction_types['credit_primary'])
                $db->query("DELETE FROM $param[dbprefix]transactions WHERE txn_type=? AND orig_order_id=?", array($transaction_types['debit_chargeback'], $row['orig_order_id']));    
            //delete tier chargeback only                
            else 
                $db->query("DELETE FROM $param[dbprefix]transactions WHERE txn_type=? AND txn_id=?", array($transaction_types['debit_chargeback'], $row['txn_id']));
        } 
        // delete other transaction
        else {
            //delete chargeback
            $chargeback_orig_order_id = $db->getOne("SELECT orig_order_id FROM $param[dbprefix]transactions WHERE key_one=?", array($row['txn_id']));
            if (!empty($chargeback_orig_order_id))
                $db->query("DELETE FROM $param[dbprefix]transactions WHERE orig_order_id=?", array($chargeback_orig_order_id));            
            //delete transaction    
            $db->query("DELETE FROM $param[dbprefix]transactions WHERE txn_id=?", array($row['txn_id']));            
        }
    }
    return;
}

function transaction_chargeback($reftxn_id){
    global $db, $param, $transaction_types;
    $rs = $db->query("SELECT * FROM $param[dbprefix]transactions WHERE txn_id=?", array($reftxn_id));
    if ($row = $rs->fetchRow(DB_FETCHMODE_ASSOC)) {
        if ($row['txn_type'] == $transaction_types['credit_primary']) {
            $txn_id = transaction_create_unique_id();
            $refund_result = transaction_refund($row['orig_order_id'], $txn_id, $row['orig_amount'], $row['orig_cur_index'], $row['user_id'], $_SERVER['REMOTE_ADDR'], null);
        }
    }
    return;
}

function get_transaction_error ($error_code) {
    switch ($error_code) {
        //primary credit
        case 1010: $error_msg='Transaction already exists';
            break;
        case 1020: $error_msg='Incorrect value Order';
            break;
        case 1030: $error_msg='Order amount is zero';
            break;
        case 1040: $error_msg='The user is not found';
            break;
        case 1050: $error_msg='The product is not found';
            break;
        case 1060: $error_msg='Delay time period. Transaction is ignored.';
            break;            
        case 1070: $error_msg='One time amount already exists';
            break;  
        case 1080: $error_msg='Payout percentage is zero';
            break;                      
        //secondary debit          
        case 2010: $error_msg='Transaction already exists';
            break;  
        case 2020: $error_msg='Incorrect value Order';
            break;
        case 2030: $error_msg='Order amount is zero';
            break;
        case 2040: $error_msg='The user is not found';
            break;   
        case 2050: $error_msg='Payout percentage is zero';
            break;                        
        //cargback
        case 3010: $error_msg='Incorrect value Order';
            break;  
        case 3020: $error_msg='Order amount is zero';
            break;
        case 3030: $error_msg='Transaction already exists';
            break;  
        case 3040: $error_msg='Original transaction not exists';
            break;  
        //initial balance   
        case 4010: $error_msg='Transaction already exists';
            break;   
        //credit_traffic 5010, 5040, 5050, 5080
    }
    
    
    return $error_msg;    
}


function transaction_create_unique_id() {
    return mt_rand();
}

function transaction_log($orig_order_id) {
    global $db, $param;    
    $sql = sql_placeholder("INSERT INTO $param[dbprefix]transactions_log (txn_id, create_data, post_log, get_log, cookie_log) VALUES (?, now(), ?@)", $orig_order_id, array(
        var_export($_POST, true), 
        var_export($_GET, true), 
        var_export($_COOKIE, true)
    )
    );
    $db->query($sql);
    return;	
}

?>