<?php
// $Id: htmlelements.inc.php 5 2008-12-12 05:55:19Z adgar $

$yes_no_select_list = array('0'=>getTranslateText('TT_NO'), '1'=>getTranslateText('TT_YES'));

function getSelectFieldHtmlCode($name, &$listvalue, $defvalue=null, $param=null) 
{
    $select = "<select name=\"$name\" $param id=\"$name\">";
    foreach ($listvalue as $k => $v) {
        $select .= "<option value=\"$k\"";
        if ($k == $defvalue) $select .= " selected";
        $select .= ">" . htmlspecialchars($v, ENT_COMPAT, 'UTF-8') . "</option>";
    }
    $select .= "</select>";
    return $select;       
}

function getSelectUserTypesFieldHtmlCode($name, $emptyfirst = false, $defvalue=null, $param=null) {
    $listvalue = array();
    if ($emptyfirst) {
       $listvalue['0'] = getTranslateText(167);     
    }
    $listvalue['4'] = getTranslateText(142);
    $select = "<select name=\"$name\" $param id=\"$name\">";
    foreach ($listvalue as $k => $v) {
        $select .= "<option value=\"$k\"";
        if ($k == $defvalue) $select .= " selected";
        $select .= ">" . htmlspecialchars($v, ENT_COMPAT, 'UTF-8') . "</option>";
    }
    $select .= "</select>";
    return $select;    
}

function getInputFieldHtmlCode($name, $defvalue=null, $param=null) {
    $input = "<input type=\"text\" name=\"$name\" id=\"$name\" value=\"" . htmlentities($defvalue, ENT_COMPAT, 'UTF-8') . "\" $param />";
    return $input;   
}

function getPasswordFieldHtmlCode($name, $defvalue=null, $param=null) {
    $input = "<input type=\"password\" name=\"$name\" id=\"$name\" value=\"" . htmlentities($defvalue, ENT_COMPAT, 'UTF-8') . "\" $param />";
    return $input;   
}

function getTextareaFieldHtmlCode($name,  $defvalue=null, $param=null) {
    $textarea = "<textarea name=\"$name\" id=\"$name\" $param >" . htmlentities($defvalue, ENT_COMPAT, 'UTF-8') . "</textarea>";
    return $textarea;   
}

function getHiddenFieldHtmlCode($name, $defvalue=null) {
    $hidden = "<input type=\"hidden\" name=\"$name\" id=\"$name\" ";
    if (null != $defvalue) $hidden .= "value=\"" . htmlentities($defvalue, ENT_COMPAT, 'UTF-8') . "\"";
    $hidden .= " />";
    return $hidden;   
}

function getPagerHtmlCode($totalItems, $perPage, $separator=' ', $filter_exist=false) {
    require_once('Pager/Pager.php');
    $params = array(
        'totalItems' => $totalItems,
        'perPage' => $perPage, 
        'delta' => 5, // for 'Jumping'-style a lower number is better
        'append' => true,
        //separator
        'separator' => $separator,        
        'spacesBeforeSeparator' => false,
        'spacesAfterSeparator' => true,
        'curPageSpanPre' => '[',
        'curPageSpanPost' => ']',  
        //current 
        'curPageLinkClassName' => 'current',
        //
        'clearIfVoid' => false,
        'urlVar' => 'entrant',
        'useSessions' => true,
        'closeSession' => true,
        //translated
        'altFirst' => getTranslateText('TT_FIRST_PAGE'),
        'altPrev' => getTranslateText('TT_PREV_PAGE'),
        'altNext' => getTranslateText('TT_NEXT_PAGE'),
        'altLast' => getTranslateText('TT_LAST_PAGE'),        
        'altPage' => getTranslateText('TT_PAGE'),
        'prevImg' => '&laquo;&nbsp;' . getTranslateText('TT_PREV_PAGE'),
        'nextImg' => getTranslateText('TT_NEXT_PAGE') . '&nbsp;&raquo;',
        //mode
        'mode'  => 'Sliding',    //try switching modes        
        //'mode'  => 'Jumping',
    ); 
    if ($filter_exist && ('true' == $_POST['filter'])) {
        $params['extraVars'] = array_merge($_GET, $_POST);
        $params['excludeVars'] = array('Submit', 'lang_alpha2', 'afprotrackparam', 'PHPSESSID');   
    }
    $pager = & Pager::factory($params);
    $links = $pager->getLinks();    
    return $links['all'];
}


function getFileHtmlCode($name,  $param=null) {
    $input = "<input type=\"file\" name=\"$name\" $param />";
    return $input;   
}

function getCheckHtmlCode($name, $defvalue=null, $checked=false, $param=null) {
    $check = "<input type=\"checkbox\" name=\"$name\" id=\"$name\" value=\"" . htmlentities($defvalue, ENT_COMPAT, 'UTF-8') . "\"";
    if ($checked) $check .= " checked=\"checked\" ";
    $check .= " $param />";
    return $check;
}

function getRadioButtonHtmlCode($name, $defvalue=null, $checked=false, $param=null) {
    $check = "<input type=\"radio\" name=\"$name\" id=\"$name\" value=\"" . htmlentities($defvalue, ENT_COMPAT, 'UTF-8') . "\"";
    if ($checked) $check .= " checked=\"checked\" ";
    $check .= " $param />";
    return $check;
}

function getButtonHtmlCode($name, $value, $submit=false, $param=null) {    
    $input = "<input type=\"";
    $input .= $submit ? 'submit' : 'button';
    $input .= "\" name=\"$name\" id=\"$name\" value=\"" . htmlentities($value, ENT_COMPAT, 'UTF-8') . "\" $param />";
    return $input;   
}

function getUploadFileHtmlCode($name, $url=null, $param=null, $action='delete', $action_param = null) {
    if (!empty($url)) {
        $selfname = basename($_SERVER['PHP_SELF']);
        if (empty($action_param)) $action_param = $name;
        $htmlcode = "<a href=\"$url\" target=\"_blank\">";
        $htmlcode .= getTranslateText('TT_VIEW') . "</a> | <a href=\"$selfname?action=$action&p=$action_param\">";
        $htmlcode .= getTranslateText('REP_H_DELETE') . "</a>";
    } else {
         $htmlcode = "<input type=\"file\" name=\"$name\" $param />";
    }
    return $htmlcode;
}
?>