<?php
// $Id: fileuploader.inc.php 5 2008-12-12 05:55:19Z adgar $

define('AFFPRO_UPLOAD_ALL', 0);
define('AFFPRO_UPLOAD_IMAGES', 1);
define('AFFPRO_UPLOAD_IMAGES_2', 2);
define('AFFPRO_UPLOAD_SWF', 3);
define('AFFPRO_UPLOAD_TRANSLATION', 4);

class FileUploader {
    var $uploadfile;
    var $savefilename;
    var $ext_type;
    
    function FileUploader(&$uploadfile, $savefilename, $ext_type=0) {
        $this->uploadfile = $uploadfile;
        $this->savefilename = $savefilename;
        $this->ext_type = $ext_type;        
    }
    
    function upload($mode=0664) {
        if (empty($this->uploadfile) || !is_array($this->uploadfile) || empty($this->savefilename)) return false;
        switch ($this->ext_type) {
            case AFFPRO_UPLOAD_IMAGES:
            $res = $this->_upload_image(false); 
            break;
            case AFFPRO_UPLOAD_IMAGES_2:
            $res = $this->_upload_image(true);
            break;
            case AFFPRO_UPLOAD_SWF:
            $res = $this->_upload_swf();
            break;
            case AFFPRO_UPLOAD_TRANSLATION:
            $res = $this->_upload_translation();
            break;                         
            default:
            $res = $this->_upload_file();
            break;
        }
        if (file_exists($this->savefilename)) {
            @chmod($this->savefilename, $mode);
        }
        return $res;
    }
    
    function _upload_image($with_swf = false) {
        //file size 
        $max_file_size = (int) getParamByName('max_size');
        if (($this->uploadfile['size'] > $max_file_size) || (2 == $this->uploadfile['error'])) {
            return AFFPRO::raiseError('ERROR_FILE_TOO_LARGE'); // file too large
        }        
        //uplode error
        if ($this->uploadfile['error'] != 0) {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //can not load file
        }            
        //validate file information
        $foo = @getimagesize($this->uploadfile['tmp_name']);
        if (false == $foo) {
            return AFFPRO::raiseError('ERROR_INCORRECT_GRAPHFILE'); //wrong image file
        }       
        //uplode type
        $allow_image_types = array(1,2); //1 = GIF, 2 = JPG,
        if ($with_swf)  {
            $allow_image_types[] = 4;  //4=SWF
            $allow_image_types[] = 13; //13=CWS
        }
        if (!in_array($foo[2], $allow_image_types)) {
            return AFFPRO::raiseError('ERROR_INCORRECT_GRAPHFILE'); //not allow image type
        }            
        //filename
        $allow_ext = array('.jpg', '.jpeg', '.gif'); 
        if ($with_swf)  {
            $allow_ext[] = '.swf';
        }        
        $foo = strrchr($this->uploadfile['name'], '.');
        if ($foo == false || !in_array(strtolower($foo), $allow_ext)) {
            return AFFPRO::raiseError('ERROR_INCORRECT_GRAPHFILE'); //not allow extension
        }       
        //upload file
        if (!move_uploaded_file($this->uploadfile['tmp_name'], $this->savefilename))
        {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //can not move file            
        }
        return true;        
      
    }
    
    function _upload_swf() {       
        //file size 
        $max_file_size = (int) getParamByName('max_size');
        if (($this->uploadfile['size'] > $max_file_size) || (2 == $this->uploadfile['error'])) {
            return AFFPRO::raiseError('ERROR_FILE_TOO_LARGE'); // file too large
        }        
        //uplode error
        if ($this->uploadfile['error'] != 0) {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //can not load file
        }            
        //validate file information
        $foo = @getimagesize($this->uploadfile['tmp_name']);
        if (false == $foo) {
            return AFFPRO::raiseError('ERROR_INCORRECT_GRAPHFILE'); //wrong image file
        }       
        //uplode type
        if (!($foo[2] == 4 || $foo[2] == 13)) {  //4=SWF     
            return AFFPRO::raiseError('TT_BANNER_TEXT7'); //not .swf
        }            
        //filename
        $foo = strrchr($this->uploadfile['name'], '.');
        if ($foo == false || strtolower($foo) != '.swf') {
            return AFFPRO::raiseError('TT_BANNER_TEXT7'); //not .swf
        }       
        //upload file
        if (!move_uploaded_file($this->uploadfile['tmp_name'], $this->savefilename))
        {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //can not move file            
        }
        return true;        
      
    }
    
    function _upload_translation() {
        //uplode error
        if ($this->uploadfile['error'] != 0) {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //can not load file
        }   
        //validate file type    
        $foo = strrchr($this->uploadfile['name'], '.');
        if ($foo == false || !in_array(strtolower($foo), array('.xml', '.xls'))) {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //not .xml or .xls file  
        }
        //upload file
        if (!move_uploaded_file($this->uploadfile['tmp_name'], $this->savefilename))
        {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //can not move file            
        }
        return true;            
    }     
       
    function _upload_file() {
        //upload file
        if (!move_uploaded_file($this->uploadfile['tmp_name'], $this->savefilename))
        {
            return AFFPRO::raiseError('ERROR_UPLOAD_ERROR'); //can not move file
        }
        return true;
    }
    
}

?>